/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdAdditionalparams;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdAdditionalparamsDAO;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dto.SdAdditionalparamsDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.service.IMacroService;
import com.sapphireims.itsm.service.ISdAdditionalParamsService;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdAdditionalParamsService
implements ISdAdditionalParamsService {
    private static final String PROJECT_ID_CAN_T_BE_EMPTY = "Project id can't be empty";
    private static final String INVALID_PROJECT_ID = "Invalid Project id ";
    private static final String INVALID_PROJECT_ID_S = "Invalid Project id %s ";
    @Value(value="${cache.metadata}")
    private boolean cacheMetaData;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdAdditionalparamsDAO additionalparamsDAO;
    @Autowired
    private IMacroService macroService;
    @Autowired
    public ISdProjectMasterDAO projectMasterDAO;

    @Override
    @Transactional(readOnly=true)
    public List<SdAdditionalparamsDTO> getAdditionalParmsByProjectId(Integer projectId) throws DomainException, ValidationException {
        Validate.notNull((Object)projectId, (String)INVALID_PROJECT_ID_S, (Object[])new Object[]{projectId});
        if (this.cacheMetaData) {
            ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
            Validate.notNull((Object)projectId, (String)(INVALID_PROJECT_ID + projectId), (Object[])new Object[0]);
            List<SdAdditionalparamsDTO> ret = project.getAdditionalparams();
            SdAdditionalparamsDTO gridColumn = null;
            if (ret != null) {
                for (SdAdditionalparamsDTO d : ret) {
                    if (d.isGrid()) {
                        gridColumn = d;
                    }
                    if (d.isGridColumn()) {
                        if (gridColumn == null) continue;
                        gridColumn.addGridColumn(d);
                        continue;
                    }
                    gridColumn = null;
                }
            }
            return ret;
        }
        List<SdAdditionalparams> additionalparams = this.additionalparamsDAO.getSdAdditionalparamsByProjectId(projectId);
        ArrayList<SdAdditionalparamsDTO> ret = null;
        if (CollectionUtil.isNotEmpty(additionalparams)) {
            ret = new ArrayList<SdAdditionalparamsDTO>(additionalparams.size());
            SdAdditionalparamsDTO gridColumn = null;
            for (SdAdditionalparams a : additionalparams) {
                if (this.macroService.geMacromasterDTOById(a.getMacroid()) == null || a.getStatus() == 2) continue;
                SdAdditionalparamsDTO d = new SdAdditionalparamsDTO(a, this.macroService.geMacromasterDTOById(a.getMacroid()));
                if (d.isGrid()) {
                    gridColumn = d;
                }
                if (d.isGridColumn()) {
                    if (gridColumn != null) {
                        gridColumn.addGridColumn(d);
                    }
                } else {
                    gridColumn = null;
                }
                ret.add(d);
            }
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public void setAttributeName(Integer projectId) {
        List<SdProjectMaster> projects = this.projectMasterDAO.getAllProject();
        for (SdProjectMaster p : projects) {
            List<SdAdditionalparams> parms = this.additionalparamsDAO.getSdAdditionalparamsByProjectId(p.getProjectId());
            int i = 1;
            for (SdAdditionalparams add : parms) {
                add.setFieldName("attribute" + i);
                this.additionalparamsDAO.save(add);
                ++i;
            }
        }
    }

    @Override
    @Transactional
    public void setAttributeName() {
        List<SdProjectMaster> projects = this.projectMasterDAO.getAllProject();
        for (SdProjectMaster p : projects) {
            List<SdAdditionalparams> parms = this.additionalparamsDAO.getSdAdditionalparamsByProjectId(p.getProjectId());
            int i = 1;
            for (SdAdditionalparams add : parms) {
                add.setFieldName("attribute" + i);
                this.additionalparamsDAO.save(add);
                ++i;
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public SdAdditionalparamsDTO getSdAdditionalparamsByFieldId(int fieldId, Integer projectId) throws DomainException, ValidationException {
        Validate.notNull((Object)projectId, (String)PROJECT_ID_CAN_T_BE_EMPTY, (Object[])new Object[0]);
        List<SdAdditionalparamsDTO> additionalParms = this.getAdditionalParmsByProjectId(projectId);
        for (SdAdditionalparamsDTO a : additionalParms) {
            if (a.getFieldid() != fieldId) continue;
            return a;
        }
        throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, "Invalid field id for " + fieldId + " for project id " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdAdditionalparamsDTO> getGridColumnsByGridControlId(int fieldId, Integer projectId) throws DomainException, ValidationException {
        List<SdAdditionalparamsDTO> additionalParms = this.getAdditionalParmsByProjectId(projectId);
        ArrayList<SdAdditionalparamsDTO> ret = new ArrayList<SdAdditionalparamsDTO>();
        for (SdAdditionalparamsDTO a : additionalParms) {
            if (a.getGridControlFieldId() != fieldId) continue;
            ret.add(a);
        }
        Collections.sort(ret, (o1, o2) -> o1.getFieldid().compareTo(o2.getFieldid()));
        return ret;
    }
}

