/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdConfigSettingsDAO;
import com.sapphireims.itsm.dto.SdConfigSettingsDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.service.ISdConfigsettingsService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdConfigsettingsService
implements ISdConfigsettingsService {
    @Autowired
    private ISdConfigSettingsDAO sdConfigSettingsDAO;

    @Override
    @Transactional
    public String getSdSettingValue(String settingKey, Integer projectId, Integer serviceId) throws DomainException, ValidationException {
        if (settingKey.isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " settingKey is mandatory");
        }
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " projectId is mandatory");
        }
        return this.sdConfigSettingsDAO.getSdSettingValue(settingKey, projectId, serviceId);
    }

    @Override
    public SdConfigSettingsDTO getSdSettingValue(ProjectDTO p, String key) throws DomainException, ValidationException {
        Validate.notNull((Object)((Object)p), (String)"ProjectDTO cannot be null or emoty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)key, (String)"Key cannot be empty or null", (Object[])new Object[0]);
        if (CollectionUtil.isNotEmpty(p.getSdConfigSettingses())) {
            List<SdConfigSettingsDTO> settings = p.getSdConfigSettingses();
            SdConfigSettingsDTO cs = settings.stream().filter(csObj -> csObj != null).filter(csObj -> csObj.getSettingKey().equalsIgnoreCase(key)).findFirst().filter(csObj -> csObj != null).get();
            return cs;
        }
        return null;
    }
}

