/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdNotificationDetailsDAO;
import com.sapphireims.itsm.dao.ISdNotificationMasterDAO;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dto.SdMailRoutingConfigurationMasterDTO;
import com.sapphireims.itsm.dto.SdNotificationDetailsDTO;
import com.sapphireims.itsm.dto.SdNotificationMasterDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.model.SdNotificationDetails;
import com.sapphireims.itsm.model.SdNotificationMaster;
import com.sapphireims.itsm.service.ISdNotificationMasterService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdNotificationMasterService
implements ISdNotificationMasterService {
    @Autowired
    private ISdNotificationMasterDAO sdNotificationMasterDAO;
    @Autowired
    private ISdNotificationDetailsDAO sdNotificationDetailsDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;

    @Override
    @Transactional
    public Integer getIsRuleConfiguredForState(Integer stateId) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        return this.sdNotificationMasterDAO.getIsRuleConfiguredForState(stateId);
    }

    @Override
    @Transactional
    public SdNotificationMasterDTO getSdNotificationMasterDto(Integer stateId) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        return this.sdNotificationMasterDAO.getSdNotificationMasterDto(stateId);
    }

    @Override
    @Transactional
    public List<SdNotificationDetailsDTO> getSdNotificationDetailsDTO(Integer notificationId1, Integer notificationId2) throws DomainException, ValidationException {
        return this.sdNotificationDetailsDAO.getSdNotificationDetailsDTO(notificationId1, notificationId2);
    }

    @Override
    @Transactional
    public void saveSdNotificationRule(SdNotificationMasterDTO sdNotificationMasterDto) throws DomainException, ValidationException {
        if (sdNotificationMasterDto.getAction() == 2 || sdNotificationMasterDto.getAction() == 3) {
            this.sdNotificationDetailsDAO.deleteSdNotificationDetails(sdNotificationMasterDto.getForState());
            this.sdNotificationMasterDAO.deleteSdNotificationMaster(sdNotificationMasterDto.getForState(), sdNotificationMasterDto.getProjectId());
        }
        if (sdNotificationMasterDto.getAction() != 3) {
            SdNotificationMaster sdNotificationMaster = new SdNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), sdNotificationMasterDto.getForState(), sdNotificationMasterDto.getTemplateId(), 0);
            this.sdNotificationMasterDAO.save(sdNotificationMaster);
            SdNotificationMaster sdNotificationMaster2 = new SdNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), sdNotificationMasterDto.getForState(), sdNotificationMasterDto.getInfoTemplateId(), 1);
            this.sdNotificationMasterDAO.save(sdNotificationMaster2);
            if (sdNotificationMasterDto.getSdNotificationDetails() != null) {
                for (SdNotificationDetailsDTO detail : sdNotificationMasterDto.getSdNotificationDetails()) {
                    SdNotificationDetails sdNotificationDetails;
                    if (detail.getParameterType() == 6) {
                        sdNotificationDetails = new SdNotificationDetails((SdNotificationMaster)this.sdNotificationMasterDAO.get(sdNotificationMaster.getNotificationId()), 6, detail.getParameterValue());
                        this.sdNotificationDetailsDAO.save(sdNotificationDetails);
                        continue;
                    }
                    sdNotificationDetails = new SdNotificationDetails((SdNotificationMaster)this.sdNotificationMasterDAO.get(sdNotificationMaster2.getNotificationId()), detail.getParameterType(), detail.getParameterValue());
                    this.sdNotificationDetailsDAO.save(sdNotificationDetails);
                }
            }
        }
        if (sdNotificationMasterDto.getHistoryDTO() != null) {
            SdSettingoperationHistoryDTO historyDto = sdNotificationMasterDto.getHistoryDTO();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), sdNotificationMasterDto.getForState(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), 2, historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
            Integer id = history.getSlNo();
            if (sdNotificationMasterDto.getSdSettingoperationHistoryDTOList() != null && id > 0) {
                List<SdSettingoperationHistoryDTO> childHistoryList = sdNotificationMasterDto.getSdSettingoperationHistoryDTOList();
                for (SdSettingoperationHistoryDTO childHistoryDto : childHistoryList) {
                    SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(childHistoryDto.getModuleId())), 0, childHistoryDto.getProjectId(), childHistoryDto.getActivityTime(), childHistoryDto.getActionPerformedBy(), childHistoryDto.getIpAddress(), childHistoryDto.getNatureOfChange(), childHistoryDto.getParameter(), childHistoryDto.getOldValue(), childHistoryDto.getNewValue(), id, 0);
                    this.sdSettingoperationHistoryDAO.save(childHistory);
                }
            }
        }
    }

    @Override
    @Transactional
    public void saveSdNotificationRuleRouting(SdNotificationMasterDTO sdNotificationMasterDto) throws DomainException, ValidationException {
        if (sdNotificationMasterDto.getForState() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        if (sdNotificationMasterDto.getProjectId() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " projectId is mandatory");
        }
        SdMailRoutingConfigurationMasterDTO smrcmdto = this.sdNotificationMasterDAO.getSdMailRoutingConfigurationMasterDTO(sdNotificationMasterDto.getForState(), sdNotificationMasterDto.getProjectId());
        if (smrcmdto != null) {
            SdNotificationMasterDTO sdnmdto = this.sdNotificationMasterDAO.getSdNotificationMasterDto(sdNotificationMasterDto.getForState(), (SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), (byte)5);
            if (sdnmdto != null) {
                if (smrcmdto.getRuleType() == 1) {
                    this.sdNotificationDetailsDAO.deleteSdNotificationDetails(sdnmdto.getNotificationId(), "11,12");
                    sdnmdto.setTemplateId(smrcmdto.getTemplateId());
                    SdNotificationMaster sdNotificationMaster = sdnmdto.getSdNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), sdnmdto);
                    this.sdNotificationMasterDAO.saveSdNotificationMaster(sdNotificationMaster);
                } else if (smrcmdto.getRuleType() == 3) {
                    this.sdNotificationDetailsDAO.deleteSdNotificationDetails(sdnmdto.getNotificationId(), "11,12");
                    ArrayList<SdNotificationDetails> sdNotificationDetailsList = new ArrayList<SdNotificationDetails>();
                    SdNotificationMaster sdNotificationMaster = sdnmdto.getSdNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), sdnmdto);
                    SdNotificationDetails sdNotificationDetails = new SdNotificationDetails();
                    sdNotificationDetails.setSdNotificationMaster(sdNotificationMaster);
                    sdNotificationDetails.setParameterType(11);
                    sdNotificationDetails.setParameterValue(smrcmdto.getClassFile());
                    sdNotificationDetailsList.add(sdNotificationDetails);
                    sdNotificationDetails = new SdNotificationDetails();
                    sdNotificationDetails.setSdNotificationMaster(sdNotificationMaster);
                    sdNotificationDetails.setParameterType(12);
                    sdNotificationDetails.setParameterValue(smrcmdto.getPropertyFile());
                    sdNotificationDetailsList.add(sdNotificationDetails);
                    this.sdNotificationMasterDAO.saveSdNotificationDetailses(sdNotificationDetailsList);
                    sdnmdto.setTemplateId(smrcmdto.getTemplateId());
                    SdNotificationMaster sdNotificationMasterModel = sdnmdto.getSdNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), sdnmdto);
                    this.sdNotificationMasterDAO.saveSdNotificationMaster(sdNotificationMasterModel);
                }
            } else if (smrcmdto.getRuleType() == 1) {
                SdNotificationMaster sdNotificationMaster = new SdNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), sdNotificationMasterDto.getForState(), smrcmdto.getTemplateId(), 5);
                this.sdNotificationMasterDAO.saveSdNotificationMaster(sdNotificationMaster);
            } else if (smrcmdto.getRuleType() == 3) {
                ArrayList<SdNotificationDetails> sdNotificationDetailsList = new ArrayList<SdNotificationDetails>();
                SdNotificationMaster sdNotificationMaster = new SdNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(sdNotificationMasterDto.getProjectId()), sdNotificationMasterDto.getForState(), smrcmdto.getTemplateId(), 5);
                this.sdNotificationMasterDAO.saveSdNotificationMaster(sdNotificationMaster);
                SdNotificationDetails sdNotificationDetails = new SdNotificationDetails();
                sdNotificationDetails.setSdNotificationMaster(sdNotificationMaster);
                sdNotificationDetails.setParameterType(11);
                sdNotificationDetails.setParameterValue(smrcmdto.getClassFile());
                sdNotificationDetailsList.add(sdNotificationDetails);
                sdNotificationDetails = new SdNotificationDetails();
                sdNotificationDetails.setSdNotificationMaster(sdNotificationMaster);
                sdNotificationDetails.setParameterType(12);
                sdNotificationDetails.setParameterValue(smrcmdto.getPropertyFile());
                sdNotificationDetailsList.add(sdNotificationDetails);
                this.sdNotificationMasterDAO.saveSdNotificationDetailses(sdNotificationDetailsList);
            }
        }
    }

    @Override
    @Transactional
    public String getNotificationTemplateName(Integer templateId) throws DomainException, ValidationException {
        return this.sdNotificationMasterDAO.getNotificationTemplateName(templateId);
    }
}

