/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdPrePostActionsContentDAO;
import com.sapphireims.itsm.dao.ISdPrePostActionsDAO;
import com.sapphireims.itsm.dao.ISdPrePostActionsDetailsDAO;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dto.SdPrePostActionsContentDTO;
import com.sapphireims.itsm.dto.SdPrePostActionsDTO;
import com.sapphireims.itsm.dto.SdPrePostActionsDetailsDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.model.SdPrePostActions;
import com.sapphireims.itsm.model.SdPrePostActionsContent;
import com.sapphireims.itsm.model.SdPrePostActionsDetails;
import com.sapphireims.itsm.service.ISdPrePostActionsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdPrePostActionsService
implements ISdPrePostActionsService {
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdPrePostActionsDAO sdPrePostActionsDAO;
    @Autowired
    private ISdPrePostActionsDetailsDAO sdPrePostActionsDetailsDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;
    @Autowired
    private ISdPrePostActionsContentDAO prePostActionContentDao;
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog((String)"ITSM.log");

    @Override
    @Transactional
    public Integer saveSdPrePostAction(SdPrePostActionsDTO prepostActionDto) throws DomainException, ValidationException {
        prepostActionDto.validate();
        SdPrePostActions prepostAction = new SdPrePostActions((SdProjectMaster)this.projectMasterDAO.get(prepostActionDto.getProjectId()), prepostActionDto.getName(), prepostActionDto.getDescription(), prepostActionDto.getClassName(), prepostActionDto.getPrePostAction(), prepostActionDto.getPropertyFileName(), prepostActionDto.getLaunchingOrder());
        this.sdPrePostActionsDAO.save(prepostAction);
        prepostActionDto.setPrePostActionId(prepostAction.getId());
        if (prepostActionDto.getSdPrePostActionsDetailses() != null) {
            for (SdPrePostActionsDetailsDTO prepostDetailsDto : prepostActionDto.getSdPrePostActionsDetailses()) {
                SdPrePostActionsDetails prepostActionDetails = new SdPrePostActionsDetails((SdPrePostActions)this.sdPrePostActionsDAO.get(prepostAction.getId()), prepostDetailsDto.getCategoryId(), prepostDetailsDto.getCategoryValue());
                this.sdPrePostActionsDetailsDAO.save(prepostActionDetails);
            }
        }
        if (prepostActionDto.getSdSettingoperationHistoryDTO() != null) {
            SdSettingoperationHistoryDTO historyDto = prepostActionDto.getSdSettingoperationHistoryDTO();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)prepostAction.getId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
        }
        Integer masterId = prepostAction.getId();
        return masterId;
    }

    @Override
    @Transactional
    public Integer getLaunchingOrder(Integer projectId) throws DomainException, ValidationException {
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is mandatory");
        }
        return this.sdPrePostActionsDAO.getLaunchingOrder(projectId);
    }

    @Override
    @Transactional
    public List<SdPrePostActionsDTO> getPrePostActionListByState(Integer stateId, Integer pageNo, Integer pageSize) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        if (pageNo == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " pageNo is mandatory");
        }
        if (pageSize == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " pageSize is mandatory");
        }
        return this.sdPrePostActionsDAO.getPrePostActionListByState(stateId, pageNo, pageSize);
    }

    @Override
    @Transactional
    public Long getPrePostActionListByStateCount(Integer stateId) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        return this.sdPrePostActionsDAO.getPrePostActionListByStateCount(stateId);
    }

    @Override
    @Transactional
    public SdPrePostActionsDTO getPrePostActionDetails(Integer prePostActionId) throws DomainException, ValidationException {
        if (prePostActionId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " prePostActionId is mandatory");
        }
        return this.sdPrePostActionsDAO.getPrePostActionDetails(prePostActionId);
    }

    @Override
    @Transactional
    public void updateSdPrePostAction(SdPrePostActionsDTO prepostActionDto) throws DomainException, ValidationException {
        this.sdPrePostActionsDAO.updateSdPrePostAction(prepostActionDto);
        this.sdPrePostActionsDetailsDAO.deleteSdPrePostActionDetails(prepostActionDto.getPrePostActionId());
        if (prepostActionDto.getSdPrePostActionsDetailses() != null) {
            for (SdPrePostActionsDetailsDTO prepostDetailsDto : prepostActionDto.getSdPrePostActionsDetailses()) {
                SdPrePostActionsDetails prepostActionDetails = new SdPrePostActionsDetails((SdPrePostActions)this.sdPrePostActionsDAO.get(prepostActionDto.getPrePostActionId()), prepostDetailsDto.getCategoryId(), prepostDetailsDto.getCategoryValue());
                this.sdPrePostActionsDetailsDAO.save(prepostActionDetails);
            }
        }
        if (prepostActionDto.getSdSettingOperationChildHistoryList() != null) {
            List<SdSettingoperationHistoryDTO> childHistoryList = prepostActionDto.getSdSettingOperationChildHistoryList();
            for (SdSettingoperationHistoryDTO childHistoryDto : childHistoryList) {
                SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(childHistoryDto.getModuleId())), (int)prepostActionDto.getId(), childHistoryDto.getProjectId(), childHistoryDto.getActivityTime(), childHistoryDto.getActionPerformedBy(), childHistoryDto.getIpAddress(), childHistoryDto.getNatureOfChange(), childHistoryDto.getParameter(), childHistoryDto.getOldValue(), childHistoryDto.getNewValue());
                this.sdSettingoperationHistoryDAO.save(childHistory);
            }
        }
    }

    @Override
    @Transactional
    public List<SdSettingoperationHistoryDTO> getUpdatedChildHistoryDetails(SdPrePostActionsDTO newSdPrePostActionsDTO, SdPrePostActionsDTO oldSdPrePostActionsDTO, String ipAddress, Integer loggedUserId, Integer projectId) throws DomainException, ValidationException {
        ArrayList<SdSettingoperationHistoryDTO> childHistoryList = new ArrayList<SdSettingoperationHistoryDTO>();
        Integer sdPrePostActionId = newSdPrePostActionsDTO.getId();
        String oldName = "";
        String oldDescription = "";
        Object oldLaunchingOrder = "0";
        Object oldActionType = "0";
        String oldClassName = "";
        String oldPropertyFileName = "";
        String newName = "";
        String newDescription = "";
        Object newLaunchingOrder = "0";
        Object newActionType = "0";
        String newClassName = "";
        String newPropertyFileName = "";
        if (oldSdPrePostActionsDTO.getName() != null) {
            oldName = oldSdPrePostActionsDTO.getName();
        }
        if (oldSdPrePostActionsDTO.getDescription() != null) {
            oldDescription = oldSdPrePostActionsDTO.getDescription();
        }
        if (oldSdPrePostActionsDTO.getLaunchingOrder() != 0) {
            oldLaunchingOrder = "" + oldSdPrePostActionsDTO.getLaunchingOrder();
        }
        if (oldSdPrePostActionsDTO.getPrePostAction() != 0) {
            oldActionType = "" + oldSdPrePostActionsDTO.getPrePostAction();
        }
        if (oldSdPrePostActionsDTO.getClassName() != null) {
            oldClassName = oldSdPrePostActionsDTO.getClassName();
        }
        if (oldSdPrePostActionsDTO.getPropertyFileName() != null) {
            oldPropertyFileName = oldSdPrePostActionsDTO.getPropertyFileName();
        }
        if (newSdPrePostActionsDTO.getName() != null) {
            newName = newSdPrePostActionsDTO.getName();
        }
        if (newSdPrePostActionsDTO.getDescription() != null) {
            newDescription = newSdPrePostActionsDTO.getDescription();
        }
        if (newSdPrePostActionsDTO.getLaunchingOrder() != 0) {
            newLaunchingOrder = "" + newSdPrePostActionsDTO.getLaunchingOrder();
        }
        if (newSdPrePostActionsDTO.getPrePostAction() != 0) {
            newActionType = "" + newSdPrePostActionsDTO.getPrePostAction();
        }
        if (newSdPrePostActionsDTO.getClassName() != null) {
            newClassName = newSdPrePostActionsDTO.getClassName();
        }
        if (newSdPrePostActionsDTO.getPropertyFileName() != null) {
            newPropertyFileName = newSdPrePostActionsDTO.getPropertyFileName();
        }
        if (!oldName.equalsIgnoreCase(oldName)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(29, projectId, new Date(), loggedUserId, ipAddress, 2, "Name", oldName, newName));
        }
        if (!oldDescription.equalsIgnoreCase(newDescription)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(29, projectId, new Date(), loggedUserId, ipAddress, 2, "Description", oldDescription, newDescription));
        }
        if (!((String)oldLaunchingOrder).equalsIgnoreCase((String)newLaunchingOrder)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(29, projectId, new Date(), loggedUserId, ipAddress, 2, "Launch Order", (String)oldLaunchingOrder, (String)newLaunchingOrder));
        }
        if (!((String)oldActionType).equalsIgnoreCase((String)newActionType)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(29, projectId, new Date(), loggedUserId, ipAddress, 2, "Action Type", (String)oldActionType, (String)newActionType));
        }
        if (!oldClassName.equalsIgnoreCase(newClassName)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(29, projectId, new Date(), loggedUserId, ipAddress, 2, "Class Name", oldClassName, newClassName));
        }
        if (!oldPropertyFileName.equalsIgnoreCase(newPropertyFileName)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(29, projectId, new Date(), loggedUserId, ipAddress, 2, "Property File Name", oldPropertyFileName, newPropertyFileName));
        }
        return childHistoryList;
    }

    @Override
    @Transactional
    public void saveSdPrePostActionsContent(SdPrePostActionsContentDTO prepostActionsContentDto, SdPrePostActionsDTO prePostActionsDto) {
        SdPrePostActionsContent prePostActionsContent = new SdPrePostActionsContent((SdPrePostActions)this.sdPrePostActionsDAO.get(prePostActionsDto.getPrePostActionId()), prepostActionsContentDto.getContent());
        this.prePostActionContentDao.save(prePostActionsContent);
    }
}

