/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dto.TenantDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyType;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.mindto.ProjectMinDTO;
import com.sapphireims.itsm.service.IProjectExportImportService;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdProjectMasterService
implements ISdProjectMasterService {
    @Autowired
    private IProjectExportImportService projectExportImportService;
    @Autowired
    private ISdProjectMasterDAO sdProjectMasterDAO;
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    private IHibernateRepositoryOperations hibernateRepositoryOperations;

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    @Cacheable(value={"Project"})
    public ProjectDTO getProjectMetaData(int projectId) throws DomainException, ValidationException {
        ProjectCopyExportResponce res = new ProjectCopyExportResponce(0, "cache", "description", ProjectCopyType.CLOUD, new TenantDTO());
        res.setImportRpaProcess(false);
        this.projectExportImportService.exportProject(projectId, res);
        res.getTenant().prepareTenant();
        return res.getTenant().getProjects().iterator().next();
    }

    @Override
    @Transactional(readOnly=true)
    public List<ProjectMinDTO> getAllProjects() {
        ArrayList<ProjectMinDTO> ret = null;
        List<SdProjectMaster> masters = this.sdProjectMasterDAO.getAllProject();
        if (CollectionUtil.isNotEmpty(masters)) {
            ret = new ArrayList<ProjectMinDTO>(masters.size());
            for (SdProjectMaster d : masters) {
                ret.add(new ProjectMinDTO(d));
            }
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public SdProjectMaster getSdProjectMasterOnProjectId(int projectId) {
        return this.sdProjectMasterDAO.getProjectMaster(projectId);
    }

    @Override
    @Transactional
    public void updateSdProjectMaster(SdProjectMaster sdm) {
        this.hibernateRepositoryOperations.update((Object)sdm);
    }
}

