/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdProjectRoles;
import com.sapphire.itsm.mailrouting.model.SdProjectRolesAccess;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdProjectRolesAccessDAO;
import com.sapphireims.itsm.dao.ISdProjectRolesDAO;
import com.sapphireims.itsm.dao.ISdProjectRolesDetailsDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dto.SdProjectRolesAccessDTO;
import com.sapphireims.itsm.dto.SdProjectRolesDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.ISdProjectRolesService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdProjectRolesService
implements ISdProjectRolesService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdProjectRolesDetailsDAO projectRolesDetailsDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdProjectRolesDAO sdProjectRolesDAO;
    @Autowired
    private ISdProjectRolesAccessDAO sdProjectRolesAccessDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;

    @Override
    @Transactional
    public void saveSdProjectRole(SdProjectRolesDTO roleDto) throws DomainException, ValidationException {
        SdProjectRoles role = new SdProjectRoles((SdProjectMaster)this.projectMasterDAO.get(roleDto.getProjectId()), roleDto.getRoleName(), roleDto.getRoleDescription(), roleDto.getRoleDisplayName());
        this.sdProjectRolesDAO.save(role);
        roleDto.setProjectRoleId(role.getProjectRoleId());
        if (roleDto.getSdProjectRolesAccesses() != null) {
            for (SdProjectRolesAccessDTO roleAccessDto : roleDto.getSdProjectRolesAccesses()) {
                SdProjectRolesAccess roleAccess = new SdProjectRolesAccess((SdProjectRoles)this.sdProjectRolesDAO.get(role.getProjectRoleId()), roleAccessDto.getAccessValue());
                this.sdProjectRolesAccessDAO.save(roleAccess);
            }
        }
        if (roleDto.getSdSettingoperationHistoryDTO() != null) {
            SdSettingoperationHistoryDTO historyDto = roleDto.getSdSettingoperationHistoryDTO();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)role.getProjectRoleId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
        }
    }

    @Override
    public Integer checkIsDuplicateRole(String roleisplayName, Integer projectId) throws DomainException, ValidationException {
        return this.sdProjectRolesDAO.checkIsDuplicateRole(roleisplayName, projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdProjectRolesDTO> getProjectRoles(Integer projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            List<SdProjectRoles> rls = this.sdProjectRolesDAO.getSdServiceByProjectId(projectId);
            if (CollectionUtil.isNotEmpty(rls)) {
                ArrayList<SdProjectRolesDTO> ret = new ArrayList<SdProjectRolesDTO>(rls.size());
                for (SdProjectRoles r : rls) {
                    ret.add(new SdProjectRolesDTO(r, r.getSdProjectMaster()));
                }
                return ret;
            }
        } else {
            ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
            Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
            return project.getRoles();
        }
        return null;
    }

    @Override
    public List<SdProjectRolesDTO> getProjectRolesForUser(Integer userId, Integer projectId) throws DomainException, ValidationException {
        ArrayList<SdProjectRolesDTO> ret = null;
        List<Integer> roleIds = this.projectRolesDetailsDAO.getProjectRoleIdForUser(userId, projectId);
        List<SdProjectRolesDTO> projectRoles = this.getProjectRoles(projectId);
        if (CollectionUtil.isNotEmpty(roleIds)) {
            ret = new ArrayList<SdProjectRolesDTO>(roleIds.size());
            for (Integer id : roleIds) {
                for (SdProjectRolesDTO r : projectRoles) {
                    if (r.getProjectRoleId().intValue() != id.intValue()) continue;
                    ret.add(r);
                }
            }
        }
        return ret;
    }

    @Override
    public String getRoleNameForID(Integer roleId) {
        return this.sdProjectRolesDAO.getRoleNameForID(roleId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdProjectRolesDTO> getProjectRoles(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) throws DomainException, ValidationException {
        List<SdProjectRoles> rls = this.sdProjectRolesDAO.getSdServiceByProjectId(projectId, pageNo, pageSize, sortColumn, sortDir);
        if (CollectionUtil.isNotEmpty(rls)) {
            ArrayList<SdProjectRolesDTO> ret = new ArrayList<SdProjectRolesDTO>(rls.size());
            for (SdProjectRoles r : rls) {
                SdProjectRolesDTO sdProjectRolesDTO = new SdProjectRolesDTO();
                sdProjectRolesDTO.setProjectRoleId(r.getProjectRoleId());
                sdProjectRolesDTO.setRoleName(r.getRoleName());
                sdProjectRolesDTO.setRoleDescription(r.getRoleDescription());
                sdProjectRolesDTO.setRoleDisplayName(r.getRoleDisplayName());
                sdProjectRolesDTO.setProjectId(r.getSdProjectMaster().getProjectId());
                ret.add(sdProjectRolesDTO);
            }
            return ret;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer getDefaultRoleId(int projectId) throws DomainException, ValidationException {
        return this.sdProjectRolesDAO.getDefaultRoleId(projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public String getRoleNameByRoleId(int projectId) throws DomainException, ValidationException {
        return this.sdProjectRolesDAO.getRoleNameByRoleId(projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdProjectRolesDTO> getRolesByRolesNames(Integer projectId) {
        ArrayList<SdProjectRolesDTO> ret = null;
        List<SdProjectRoles> masters = this.sdProjectRolesDAO.getRolesByRolesNames(projectId);
        if (CollectionUtil.isNotEmpty(masters)) {
            ret = new ArrayList<SdProjectRolesDTO>(masters.size());
            for (SdProjectRoles d : masters) {
                ret.add(new SdProjectRolesDTO(d, d.getSdProjectMaster()));
            }
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdProjectRolesDTO> getRolesNameByWorkgroupId(int workGroupID) throws DomainException, ValidationException {
        List<SdProjectRoles> roles = this.sdProjectRolesDAO.getRolesNameByWorkgroupId(workGroupID);
        if (roles != null) {
            ArrayList<SdProjectRolesDTO> SdProjectRolesDTOList = new ArrayList<SdProjectRolesDTO>();
            for (SdProjectRoles role : roles) {
                SdProjectRolesDTOList.add(new SdProjectRolesDTO(role, role.getSdProjectMaster()));
            }
            return SdProjectRolesDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "workGroup id is not valid " + workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdProjectRolesDTO> getRoleListByRole(List<Integer> roleID) throws DomainException, ValidationException {
        List<SdProjectRoles> roles = this.sdProjectRolesDAO.getRoleListByRole(roleID);
        if (roles != null) {
            ArrayList<SdProjectRolesDTO> SdProjectRolesDTOList = new ArrayList<SdProjectRolesDTO>();
            for (SdProjectRoles role : roles) {
                SdProjectRolesDTOList.add(new SdProjectRolesDTO(role, role.getSdProjectMaster()));
            }
            return SdProjectRolesDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "role id is not valid " + String.valueOf(roleID));
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdProjectRolesDTO> getRolesNameByRoleIds(List<Integer> roleIdList, Integer projectId) throws DomainException, ValidationException {
        List<SdProjectRoles> roles = this.sdProjectRolesDAO.getRolesNameByRoleIds(roleIdList, projectId);
        if (CollectionUtil.isNotEmpty(roles)) {
            ArrayList<SdProjectRolesDTO> sdSubCategoryMasterDTOList = new ArrayList<SdProjectRolesDTO>();
            for (SdProjectRoles role : roles) {
                sdSubCategoryMasterDTOList.add(new SdProjectRolesDTO(role, role.getSdProjectMaster()));
            }
            return sdSubCategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "roleIdList id is not valid " + String.valueOf(roleIdList));
    }
}

