/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.itsm.dao.ISdQuicktemplateAttachmentdetailsDAO;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.SdQuicktemplateAttachmentdetails;
import com.sapphireims.itsm.service.ICopyAndCompressFilesService;
import com.sapphireims.itsm.service.ISdQuickTemplateAttachmentDetailsService;
import com.sapphireims.modulecopy.dto.ModuleCopyAttachmentsDTO;
import com.sapphireims.util.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SdQuickTemplateAttachmentDetailsService
implements ISdQuickTemplateAttachmentDetailsService {
    @Autowired
    protected ISdQuicktemplateAttachmentdetailsDAO sdQuicktemplateAttachmentdetailsDAO;
    @Autowired
    protected ICopyAndCompressFilesService copyAndCompressFilesService;

    @Override
    public List<SdQuicktemplateAttachmentdetails> getSdQuickTemplateAttachmentsDetailsByQuickTemplateId(Integer quickTemplateId, ProjectExportRequestDTO pDTO) {
        ModuleCopyAttachmentsDTO mcaDTO = pDTO.getMcaDTO();
        List<SdQuicktemplateAttachmentdetails> sqtadList = this.sdQuicktemplateAttachmentdetailsDAO.getSdQuicktemplateAttachmentdetailsByQuickTemplateId(quickTemplateId);
        if (CollectionUtil.isNotEmpty(sqtadList) && mcaDTO != null) {
            Object customerAliasName = "";
            if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                customerAliasName = "\\" + mcaDTO.getCustomerAliasName();
            }
            String sourcePath = mcaDTO.getWebManagementPath() + "\\SapphireUploadFiles" + (String)customerAliasName;
            String destinationPath = this.copyAndCompressFilesService.getDestinationDirectoryPath();
            sqtadList.forEach(sqtadObject -> {
                String oldUIPath = sourcePath + "\\" + sqtadObject.getAttachment();
                try {
                    File oldUIFile = new File(oldUIPath);
                    if (oldUIFile.exists() && !oldUIFile.isDirectory()) {
                        FileUtils.copyFile((File)oldUIFile, (File)FileUtils.getFile((String[])new String[]{destinationPath + "\\" + sqtadObject.getAttachment()}));
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
        }
        return sqtadList;
    }

    @Override
    public ProjectExportRequestDTO replaceAndUpdateQuickTemplateAttchmentFiles(ProjectExportRequestDTO req) {
        ModuleCopyAttachmentsDTO mcaDTO = req.getMcaDTO();
        if (mcaDTO != null) {
            Object customerAliasName = "";
            if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                customerAliasName = "\\" + mcaDTO.getCustomerAliasName();
            }
            String sourcePath = mcaDTO.getWebManagementPath() + "\\SapphireUploadFiles" + (String)customerAliasName;
            String fileLoc = mcaDTO.getModulePath();
            Map<String, SdQuicktemplateAttachmentdetails> oldIdSdQuickTemplateAttachmentDetailsMap = req.getOldIdSdQuickTemplateAttachmentDetailsMap();
            ArrayList<SdQuicktemplateAttachmentdetails> sqtadList = new ArrayList<SdQuicktemplateAttachmentdetails>();
            if (oldIdSdQuickTemplateAttachmentDetailsMap != null) {
                oldIdSdQuickTemplateAttachmentDetailsMap.entrySet().forEach(entry -> {
                    SdQuicktemplateAttachmentdetails sqtadObject = (SdQuicktemplateAttachmentdetails)((Object)((Object)entry.getValue()));
                    String oldAttachment = (String)entry.getKey();
                    String TimeInMilliSec = "" + Calendar.getInstance().getTimeInMillis();
                    File oldUIFromCopy = new File(fileLoc + "\\" + oldAttachment);
                    try {
                        if (oldUIFromCopy.exists() && !oldUIFromCopy.isDirectory()) {
                            String fileName = mcaDTO.getSessionId() + "_" + TimeInMilliSec + "_" + mcaDTO.getUserName() + "_" + sqtadObject.getAttachmentName();
                            FileUtils.copyFile((File)oldUIFromCopy, (File)FileUtils.getFile((String[])new String[]{sourcePath + "\\" + fileName}));
                            sqtadObject.setAttachment(fileName);
                            sqtadList.add(sqtadObject);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                });
                req.setSdQuicktemplateAttachmentdetailses(sqtadList);
            }
        }
        return req;
    }
}

