/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.itsm.dao.ISdRequestNumberFormatDAO;
import com.sapphireims.itsm.dao.ISdRequestTrackerDAO;
import com.sapphireims.itsm.model.SdRequestTracker;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import com.sapphireims.itsm.service.ISdRequestTrackerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdRequestTrackerService
implements ISdRequestTrackerService {
    public static final Logger logger = LoggerFactory.getLogger((String)"ims");
    @Autowired
    private ISdRequestTrackerDAO sdRequestTrackerDAO;
    @Autowired
    private ISdRequestNumberFormatDAO sdRequestNumberFormatDAO;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public SdRequestTracker getOrCreateLatestRequestForProject(int projectId, String prefix, int requestFormatLength) {
        SdRequestTracker tracker = null;
        try {
            logger.info("getOrCreateLatestRequestForProject ----- Proxy class: " + String.valueOf(this.getClass()));
            logger.info("------------Try fetching the latest entry from SdRequestTracker");
            tracker = this.sdRequestTrackerDAO.findLatestByProjectId(projectId, prefix);
            if (tracker != null) {
                logger.info("------------tracker not null ::  " + String.valueOf((Object)tracker));
            } else {
                int lastProblemId;
                String lastRequestId;
                logger.info("------------tracker is null so inserting new entries ");
                SdServiceReqMaster sdServiceReqMaster = this.sdRequestNumberFormatDAO.getSdServiceReqBasedOnRequestFormat(projectId, prefix, requestFormatLength, 0);
                if (sdServiceReqMaster != null) {
                    lastRequestId = sdServiceReqMaster.getRequestId();
                    lastProblemId = sdServiceReqMaster.getProblemId();
                } else {
                    lastRequestId = "1";
                    lastProblemId = 0;
                }
                tracker = this.sdRequestTrackerDAO.findLatestByProjectId(projectId, prefix);
                if (tracker == null) {
                    SdRequestTracker newTracker = new SdRequestTracker();
                    newTracker.setProjectId(projectId);
                    newTracker.setProblemId(lastProblemId);
                    newTracker.setLastRequestId(lastRequestId);
                    tracker = (SdRequestTracker)this.sdRequestTrackerDAO.save(newTracker);
                }
            }
            logger.info("------------tracker ::  " + String.valueOf((Object)tracker));
        }
        catch (Exception ex) {
            logger.error("SdRequestTrackerService :: (--Exception Caught- ) occured in getOrCreateLatestRequestForProject" + ex.getMessage());
            ex.printStackTrace();
        }
        return tracker;
    }

    @Override
    @Transactional
    public void saveTracker(int projectId, int problemId, String prefix, String currentProjectRequestId) {
        SdRequestTracker existingTracker = this.sdRequestTrackerDAO.findLatestByProjectId(projectId, prefix);
        if (existingTracker != null && existingTracker.getLastRequestId().equals(currentProjectRequestId)) {
            logger.info("Duplicate tracker entry detected. Skipping save.");
            return;
        }
        SdRequestTracker newTracker = new SdRequestTracker();
        newTracker.setProjectId(projectId);
        newTracker.setProblemId(problemId);
        newTracker.setLastRequestId(currentProjectRequestId);
        this.sdRequestTrackerDAO.save(newTracker);
    }
}

