/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.interceptor.TenantContext;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdServiceDAO;
import com.sapphireims.itsm.dao.ISdServiceDetailsDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dto.SdServiceDTO;
import com.sapphireims.itsm.dto.SdServiceParametersDetailsDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.model.SdProjectDetails;
import com.sapphireims.itsm.model.SdService;
import com.sapphireims.itsm.model.SdServiceDetails;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.ISdServiceService;
import com.sapphireims.service.IConfigSettingService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class SdServiceService
implements ISdServiceService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdServiceDAO sdServiceDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdServiceDetailsDAO sdServiceDetailsDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;
    @Autowired
    ServletContext application;
    @Autowired
    private IConfigSettingService configSettingService;

    @Override
    @Transactional(readOnly=true)
    public SdServiceDTO getSdServiceById(int serviceId, int projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdService service = this.sdServiceDAO.getServiceByProjectIdAndServiceId(serviceId, projectId);
            if (service != null) {
                return new SdServiceDTO(service);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Service id is not valid " + serviceId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
        SdServiceDTO s = project.getSdServiceById(serviceId);
        if (s.getStatus() == 0) {
            return s;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Servcie id is Deactivated " + serviceId);
    }

    @Override
    public SdServiceDTO getSdServiceByName(String serviceName, int projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdService service = this.sdServiceDAO.getServiceByProjectIdAndServiceName(serviceName, projectId);
            if (service != null) {
                return new SdServiceDTO(service);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Servcie name is  not valid " + serviceName);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %d", (Object[])new Object[]{projectId});
        SdServiceDTO s = project.getSdServiceByName(serviceName);
        if (s.getStatus() == 0) {
            return s;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Servcie Name is Deactivated " + serviceName);
    }

    @Override
    @Transactional
    public void saveSdService(SdServiceDTO serviceDto) throws ValidationException, DomainException {
        serviceDto.validate();
        SdService service = new SdService((SdProjectMaster)this.projectMasterDAO.get(serviceDto.getProjectId()), serviceDto.getServiceName(), serviceDto.getServiceDescription(), serviceDto.getStatus(), serviceDto.getDefaultImageName(), serviceDto.getShortName(), 0);
        this.sdServiceDAO.save(service);
        serviceDto.setId(service.getServiceId());
        if (serviceDto.getParametersDetails() != null) {
            for (SdServiceParametersDetailsDTO dto : serviceDto.getParametersDetails()) {
                SdServiceDetails details = new SdServiceDetails(service.getServiceId(), dto.getParametersMaster().getValue(), dto.getParameterValue());
                this.sdServiceDetailsDAO.save(details);
            }
        }
        if (serviceDto.getHistoryDTO() != null) {
            SdSettingoperationHistoryDTO historyDto = serviceDto.getHistoryDTO();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)service.getServiceId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateService(String serviceName, Integer projectId, Integer serviceId) throws DomainException, ValidationException {
        return this.sdServiceDAO.checkDuplicateService(serviceName, projectId, serviceId);
    }

    @Override
    @Transactional(readOnly=true)
    public Object uploadFile(MultipartHttpServletRequest request, HttpServletResponse response, MultipartFile file, int maxSize, String str_FileLocation) throws DomainException, ValidationException, IOException {
        String msg = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        String originalFileName = file.getOriginalFilename();
        Object fileAttachmentName = originalFileName;
        map.put("originalFileName", fileAttachmentName);
        StringBuilder builder = new StringBuilder();
        String tenant = TenantContext.getCurrentTenant();
        int projectId = 0;
        if (request.getParameter("projectId") != null) {
            projectId = Integer.parseInt(request.getParameter("projectId"));
        }
        String whitelistAttachment = this.configSettingService.findBySettingKey("SD_ATTACHMENT_WHITE_LIST").toLowerCase();
        String[] whitelistArray = whitelistAttachment.split(",");
        String extension = originalFileName.substring(originalFileName.lastIndexOf("."), originalFileName.length()).toLowerCase();
        if (!Arrays.asList(whitelistArray).contains(extension)) {
            builder.append("<br><p><strong>").append(extension).append("</strong> file is not permitted to be uploaded. Please contact your system administrator</p>");
            msg = builder.toString();
            map.put("status", msg);
            return map;
        }
        if (!originalFileName.matches("[a-zA-Z0-9\\s-_()]{1,200}\\.[a-zA-Z0-9]{1,10}") || originalFileName.substring(0, originalFileName.lastIndexOf(".")).trim().length() == 0) {
            builder.append("<br><p>Please check file name <strong>").append(originalFileName).append("</strong>. <BR>Only Alpha-Numeric characters. <BR>Only 1 dot as an input for the file name with extension. <BR>The maximum length of the name of a file plus its extension should be less than 255 characters.");
            msg = builder.toString();
            map.put("status", msg);
            return map;
        }
        if (file.getSize() == 0L) {
            builder.append("<br><p><strong>").append(originalFileName).append("</strong> file size is zero bytes.");
            msg = builder.toString();
            map.put("status", msg);
            return map;
        }
        if (file.getSize() >= (long)maxSize) {
            builder.append("<br><p>Document size should not be greater than <strong>").append(maxSize).append(" MB!</strong> Current size is <strong>").append(file.getSize()).append("</strong>");
            msg = builder.toString();
            map.put("status", msg);
            return map;
        }
        if (file.getSize() < (long)maxSize) {
            fileAttachmentName = new Date().getTime() + "_" + request.getSession().getId() + ".gif";
            map.put("fileAttachmentName", fileAttachmentName);
            str_FileLocation = (String)str_FileLocation + "\\cmdb_images\\servicedesk\\servicecatalog\\" + (String)(TenantContext.isIsServer() && !tenant.equals("ims") ? tenant + "\\" : "");
            File dir = new File((String)str_FileLocation);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            str_FileLocation = (String)str_FileLocation + (String)fileAttachmentName;
            byte[] bytes = file.getBytes();
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream((String)str_FileLocation));
            stream.write(bytes);
            stream.close();
            builder.append("<h3>Upload Status:</h3>").append("<p>Uploaded: <strong>").append(file.getSize()).append("</strong> out of <strong>").append(file.getSize());
            builder.append("</strong> bytes complete");
            msg = builder.toString();
            map.put("status", msg);
            map.put("tenant", TenantContext.isIsServer() && !tenant.equals("ims") ? tenant + "\\" : "");
        }
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public void downladFile(HttpServletRequest request, HttpServletResponse response, String fileLocation) throws DomainException, ValidationException {
        String mimeType;
        String fileName = "";
        if (request.getParameter("fileName") != null) {
            fileName = request.getParameter("fileName");
        }
        File fileTo = new File(".");
        if (!fileLocation.isEmpty()) {
            fileTo = new File(fileLocation + "\\cmdb_images\\servicedesk\\servicecatalog\\" + (String)(TenantContext.isIsServer() ? TenantContext.getCurrentTenant() + "\\" : "") + fileName);
        }
        if ((mimeType = URLConnection.guessContentTypeFromName(fileTo.getName())) == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        response.setContentLength((int)fileTo.length());
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(fileTo));){
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            System.out.println("SdServiceService :: FILE NOT FOUND EXCEPTION ...." + e.getMessage());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdServiceDTO> getSdServiceByProjectId(int projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            List<SdService> service = this.sdServiceDAO.getSdServiceByProjectId(projectId);
            if (service != null) {
                ArrayList<SdServiceDTO> sdServiceDTOList = new ArrayList<SdServiceDTO>();
                for (SdService sdService : service) {
                    sdServiceDTOList.add(new SdServiceDTO(sdService));
                }
                return sdServiceDTOList;
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
        List<SdServiceDTO> sdServiceDTOList = project.getServices();
        if (sdServiceDTOList != null) {
            return sdServiceDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is Deactivated " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer getDefaultServiceId(int projectId) {
        return this.sdServiceDAO.getDefaultServiceId(projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getParentServices(List<Integer> sdParent) {
        List<String> services = this.sdServiceDAO.getParentServices(sdParent);
        return services;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdServiceDTO> getSdServiceByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) throws DomainException, ValidationException {
        List<SdService> service = this.sdServiceDAO.getSdServiceByProjectId(projectId, pageNo, pageSize, sortColumn, sortDir);
        if (service != null) {
            ArrayList<SdServiceDTO> sdServiceDTOList = new ArrayList<SdServiceDTO>();
            for (SdService sdService : service) {
                sdServiceDTOList.add(new SdServiceDTO(sdService));
            }
            return sdServiceDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }

    @Override
    @Transactional
    public void setDefaultServiceId(int projectId, int serviceId) throws DomainException, ValidationException {
        SdProjectDetails sdProjectDetails = new SdProjectDetails(this.projectMasterDAO.getProjectParametersMasterById(6), this.projectMasterDAO.getProjectMaster(projectId), String.valueOf(serviceId));
        ArrayList<SdProjectDetails> sdProjectDetails1 = new ArrayList<SdProjectDetails>();
        sdProjectDetails1.add(sdProjectDetails);
        this.projectMasterDAO.saveSdProjectDetails(sdProjectDetails1);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdServiceDTO> getServiceNameByWorkgroupId(int workGroupID) throws DomainException, ValidationException {
        List<SdService> service = this.sdServiceDAO.getServiceNameByWorkgroupId(workGroupID);
        if (service != null) {
            ArrayList<SdServiceDTO> sdServiceDTOList = new ArrayList<SdServiceDTO>();
            for (SdService sdService : service) {
                sdServiceDTOList.add(new SdServiceDTO(sdService));
            }
            return sdServiceDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "workGroup id is not valid " + workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdServiceDTO> getServiceNameByserviceIds(List<Integer> serviceIdList, Integer projectId) throws DomainException, ValidationException {
        List<SdService> service = this.sdServiceDAO.getServiceNameByserviceIds(serviceIdList, projectId);
        if (CollectionUtil.isNotEmpty(service)) {
            ArrayList<SdServiceDTO> sdServiceDTOList = new ArrayList<SdServiceDTO>();
            for (SdService sdService : service) {
                sdServiceDTOList.add(new SdServiceDTO(sdService));
            }
            return sdServiceDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "serviceIdList id's is not valid " + String.valueOf(serviceIdList));
    }

    @Override
    @Transactional(readOnly=true)
    public SdService getServiceByserviceId(int serviceId, int projectId) throws DomainException, ValidationException {
        SdService service = this.sdServiceDAO.getServiceByProjectIdAndServiceId(serviceId, projectId);
        if (service != null) {
            return service;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "service id is not valid " + serviceId);
    }
}

