/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.impl.SdSlaCommentDAO;
import com.sapphireims.itsm.dto.SdSlaCommentDTO;
import com.sapphireims.itsm.model.SdSlaComment;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.ISdSlaCommentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdSlaCommentService
implements ISdSlaCommentService {
    @Value(value="true")
    private boolean cache;
    public static final Logger logger = LoggerFactory.getLogger((String)"ims");
    @Autowired
    SdSlaCommentDAO sdSlaCommentDAO;
    @Autowired
    private ISdProjectMasterService projectMasterService;

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateComment(String comment, Integer projectId, Integer id) {
        return this.sdSlaCommentDAO.checkDuplicateComment(comment, projectId, id);
    }

    @Override
    @Transactional
    public Integer saveOrUpdateSlaComment(SdSlaCommentDTO sdSlaCommentDTO) {
        int slaCommentId = 0;
        slaCommentId = sdSlaCommentDTO.getId() == null || sdSlaCommentDTO.getId() == 0 ? this.sdSlaCommentDAO.saveSlaComment(sdSlaCommentDTO) : this.sdSlaCommentDAO.updateSlaComment(sdSlaCommentDTO);
        return slaCommentId;
    }

    @Override
    @Transactional(readOnly=true)
    public SdSlaCommentDTO getSdSlaCommentByIdAndProjectId(Integer projectId, Integer commentId) throws DomainException, ValidationException {
        SdSlaComment sdSlaComment = this.sdSlaCommentDAO.getSdSlaCommentByIdAndProjectId(commentId, projectId);
        if (sdSlaComment != null) {
            SdSlaCommentDTO sdSlaCommentDto = new SdSlaCommentDTO();
            sdSlaCommentDto.setCommentId(sdSlaComment.getId());
            return sdSlaCommentDto;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "SLA comment not found for the id " + commentId);
    }

    @Override
    @Transactional(readOnly=true)
    public void deleteSdSlaComment(SdSlaCommentDTO sdSlaCommentDTO) {
        this.sdSlaCommentDAO.deleteSdSlaComment(sdSlaCommentDTO);
    }
}

