/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dao.ISdSmsNotificationDetailsDAO;
import com.sapphireims.itsm.dao.ISdSmsNotificationMasterDAO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.SdSmsNotificationDetailsDTO;
import com.sapphireims.itsm.dto.SdSmsNotificationMasterDTO;
import com.sapphireims.itsm.model.SdSmsNotificationDetails;
import com.sapphireims.itsm.model.SdSmsNotificationMaster;
import com.sapphireims.itsm.service.ISdSmsNotificationMasterService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdSmsNotificationMasterService
implements ISdSmsNotificationMasterService {
    @Autowired
    private ISdSmsNotificationMasterDAO sdSmsNotificationMasterDAO;
    @Autowired
    private ISdSmsNotificationDetailsDAO sdSmsNotificationDetailsDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;

    @Override
    @Transactional
    public Integer getIsSMSRuleConfiguredForState(Integer stateId) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        return this.sdSmsNotificationMasterDAO.getIsSMSRuleConfiguredForState(stateId);
    }

    @Override
    @Transactional
    public List<SdSmsNotificationMasterDTO> getSdSmsNotificationMasterDto(Integer stateId) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        return this.sdSmsNotificationMasterDAO.getSdSmsNotificationMasterDto(stateId);
    }

    @Override
    @Transactional
    public SdSmsNotificationDetailsDTO getSdSmsNotificationDetailsDto(Integer smsNotificationId) throws DomainException, ValidationException {
        if (smsNotificationId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " smsNotificationId is mandatory");
        }
        return this.sdSmsNotificationDetailsDAO.getSdSmsNotificationDetailsDto(smsNotificationId);
    }

    @Override
    @Transactional
    public void saveSdSmsNotificationMasterService(SdSmsNotificationMasterDTO smsDto) throws DomainException, ValidationException {
        int isUpdate = this.checkIsUpdate(smsDto.getForState());
        if (isUpdate != 0) {
            this.sdSmsNotificationDetailsDAO.deleteDetailsData(isUpdate);
            this.sdSmsNotificationMasterDAO.deleteMasterDataForState(isUpdate);
        }
        if (smsDto.getAction() != 2) {
            SdSmsNotificationMaster master = new SdSmsNotificationMaster((SdProjectMaster)this.projectMasterDAO.get(smsDto.getProjectId()), smsDto.getForState(), smsDto.getTemplateId(), 0);
            this.sdSmsNotificationMasterDAO.save(master);
            if (smsDto.getSdSmsNotificationDetailses() != null) {
                for (SdSmsNotificationDetailsDTO detail : smsDto.getSdSmsNotificationDetailses()) {
                    SdSmsNotificationDetails sdSmsNotificationDetails = new SdSmsNotificationDetails((SdSmsNotificationMaster)this.sdSmsNotificationMasterDAO.get(master.getSmsNotificationId()), detail.getParameterType(), detail.getParameterValue());
                    this.sdSmsNotificationDetailsDAO.save(sdSmsNotificationDetails);
                }
            }
            if (smsDto.getSdSettingoperationHistoryDTO() != null) {
                SdSettingoperationHistoryDTO historyDto = smsDto.getSdSettingoperationHistoryDTO();
                SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)master.getSmsNotificationId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
                this.sdSettingoperationHistoryDAO.save(history);
                Integer id = history.getSlNo();
                if (smsDto.getSdSettingoperationHistoryDTOList() != null && id > 0) {
                    List<SdSettingoperationHistoryDTO> childHistoryList = smsDto.getSdSettingoperationHistoryDTOList();
                    for (SdSettingoperationHistoryDTO childHistoryDto : childHistoryList) {
                        SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(childHistoryDto.getModuleId())), 0, childHistoryDto.getProjectId(), childHistoryDto.getActivityTime(), childHistoryDto.getActionPerformedBy(), childHistoryDto.getIpAddress(), childHistoryDto.getNatureOfChange(), childHistoryDto.getParameter(), childHistoryDto.getOldValue(), childHistoryDto.getNewValue(), id, 0);
                        this.sdSettingoperationHistoryDAO.save(childHistory);
                    }
                }
            }
        }
    }

    private Integer checkIsUpdate(Integer stateId) {
        return this.sdSmsNotificationMasterDAO.checkIsUpdate(stateId);
    }

    @Override
    @Transactional
    public String getSMSNotificationTemplateName(Integer smsNotificationId) throws DomainException, ValidationException {
        if (smsNotificationId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " smsNotificationId is mandatory");
        }
        return this.sdSmsNotificationMasterDAO.getSMSNotificationTemplateName(smsNotificationId);
    }
}

