/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdSourcefilterDAO;
import com.sapphireims.itsm.dto.SdSourcefilterDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.model.SdSourcefilter;
import com.sapphireims.itsm.model.SdSourcefilterId;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.ISdSourceService;
import com.sapphireims.util.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdSourceService
implements ISdSourceService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdSourcefilterDAO sdSourcefilterDAO;

    @Override
    public SdSourcefilterDTO getSourceById(Integer sourceId, Integer projectId) throws DomainException, ValidationException {
        if (this.cache) {
            ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
            Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
            return project.getSourceFilterById(sourceId);
        }
        return new SdSourcefilterDTO((SdSourcefilter)this.sdSourcefilterDAO.get(new SdSourcefilterId(sourceId, projectId)));
    }

    @Override
    public SdSourcefilterDTO getSourceByName(String sourceName, Integer projectId) throws DomainException, ValidationException {
        if (this.cache) {
            ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
            Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
            return project.getSourceFilterByName(sourceName);
        }
        return null;
    }

    @Override
    public SdSourcefilterDTO getDefaultSource(Integer projectId) throws DomainException, ValidationException {
        if (this.cache) {
            ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
            Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
            return project.getDefaultSourceFilter();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateSource(String serviceName, Integer sourceId, Integer projectId) throws DomainException, ValidationException {
        return this.sdSourcefilterDAO.checkDuplicateSource(serviceName, sourceId, projectId);
    }
}

