/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.SearchEntityResponce;
import com.sapphireims.dto.SearchRequestDTO;
import com.sapphireims.dto.SearchResultDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdTemplateDAO;
import com.sapphireims.itsm.dto.SdAdditionalparamsDTO;
import com.sapphireims.itsm.dto.SdTemplateDTO;
import com.sapphireims.itsm.dto.VelocityTemplate;
import com.sapphireims.itsm.dto.ticket.TickectTemplate;
import com.sapphireims.itsm.mindto.FixedFiledsMinDTO;
import com.sapphireims.itsm.model.SdTemplate;
import com.sapphireims.itsm.model.enummodel.FixedField;
import com.sapphireims.itsm.service.ISdAdditionalParamsService;
import com.sapphireims.itsm.service.ISdFixedFiledsService;
import com.sapphireims.itsm.service.ISdTemplateService;
import com.sapphireims.model.BaseModel;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.StringUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdTemplateService
implements ISdTemplateService {
    @Autowired
    private ISdTemplateDAO templateDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdFixedFiledsService fixedFiledsService;
    @Autowired
    private ISdAdditionalParamsService additionalParamsService;

    @Override
    @Transactional(readOnly=true)
    public SdTemplateDTO getSdTemplateDTO(int templateId) throws ValidationException, DomainException {
        SdTemplate template = (SdTemplate)this.templateDAO.get(Integer.valueOf(templateId));
        Validate.notNull((Object)((Object)template), (String)"Invalid tamplate id %d ", (Object[])new Object[]{templateId});
        return new SdTemplateDTO(template);
    }

    @Override
    @Transactional
    public void saveTemplate(SdTemplateDTO templateDto) throws ValidationException, DomainException {
        templateDto.validate();
        SdTemplate template = new SdTemplate(templateDto.getName(), templateDto.getTemplate(), templateDto.getType(), templateDto.getAttachmentName(), (SdProjectMaster)this.projectMasterDAO.get(templateDto.getProjectId()));
        this.templateDAO.save(template);
        templateDto.setId(template.getId());
    }

    @Override
    @Transactional
    public void updateTemplate(SdTemplateDTO templateDto) throws ValidationException, DomainException {
        SdTemplate savedTemplate = (SdTemplate)this.templateDAO.get(templateDto.getId());
        Validate.notNull((Object)((Object)savedTemplate), (String)"Invalid template id", (Object[])new Object[0]);
        savedTemplate.setTemplateForUpdtae(templateDto, (SdProjectMaster)this.projectMasterDAO.get(templateDto.getProjectId()));
        this.templateDAO.save(savedTemplate);
    }

    @Override
    @Transactional(readOnly=true)
    public SearchResultDTO getTemplate(SearchRequestDTO searchR) throws ValidationException, DomainException {
        Validate.notNull((Object)searchR);
        Validate.notNull((Object)searchR.getProjectId(), (String)"Project Id is manditory", (Object[])new Object[0]);
        SearchEntityResponce templates = this.templateDAO.getTemplates(searchR);
        ArrayList<SdTemplateDTO> ret = null;
        if (CollectionUtil.isNotEmpty(templates.getData())) {
            ret = new ArrayList<SdTemplateDTO>(templates.getData().size());
            for (BaseModel t : templates.getData()) {
                ret.add(new SdTemplateDTO((SdTemplate)t));
            }
        }
        return new SearchResultDTO(searchR, templates.getTotalCount(), ret);
    }

    @Override
    @Transactional(readOnly=true)
    public void getTickectTemplate(TickectTemplate template) throws ValidationException, DomainException {
        List<SdAdditionalparamsDTO> additionalParms;
        Validate.notNull((Object)template);
        Validate.notNull((Object)template.getProjectId());
        List<FixedFiledsMinDTO> fixedFilds = this.fixedFiledsService.geFixedFiledsMinDTOs(template.getProjectId());
        if (CollectionUtil.isNotEmpty(fixedFilds)) {
            for (FixedFiledsMinDTO m : fixedFilds) {
                if (m.getFixedField() == null) {
                    m.setFixedField(FixedField.getFixedField(m.getFieldId()));
                }
                if (!StringUtil.isEmpty((String)m.getFixedField().getTemplateForName())) {
                    template.addTemplate(new VelocityTemplate(m.getName(), m.getFixedField().getTemplateForName()));
                }
                if (StringUtil.isEmpty((String)m.getFixedField().getTemplateForId())) continue;
                template.addTemplate(new VelocityTemplate(m.getName().concat(" Id"), m.getFixedField().getTemplateForId()));
            }
        }
        if (CollectionUtil.isNotEmpty(additionalParms = this.additionalParamsService.getAdditionalParmsByProjectId(template.getProjectId()))) {
            for (SdAdditionalparamsDTO add : additionalParms) {
                template.addTemplate(new VelocityTemplate(add.getFieldDisplayname(), "${ticket.additionalParams.".concat(add.getFieldName()).concat(".data}")));
                template.addTemplate(new VelocityTemplate(add.getFieldDisplayname().concat(" -  Field Display Name"), "${ticket.additionalParams.".concat(add.getFieldName()).concat(".additionalAttribute.fieldDisplayname}")));
            }
        }
        template.addDefaultTemplates();
    }
}

