/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dao.ISdWorkFlowDetailDAO;
import com.sapphireims.itsm.dao.ISdWorkFlowMasterDAO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.SdWorkFlowBuilderDTO;
import com.sapphireims.itsm.dto.SdWorkFlowDetailDTO;
import com.sapphireims.itsm.dto.SdWorkFlowMasterDTO;
import com.sapphireims.itsm.dto.SdWorkflowFilterDTO;
import com.sapphireims.itsm.dto.SdWorkflowStatesDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.mindto.DerivedFieldMinDTO;
import com.sapphireims.itsm.mindto.ProjectRolesMinDTO;
import com.sapphireims.itsm.mindto.ServiceMinDTO;
import com.sapphireims.itsm.mindto.SubCategoryMinDTO;
import com.sapphireims.itsm.model.SdWorkFlowDetail;
import com.sapphireims.itsm.model.SdWorkFlowMaster;
import com.sapphireims.itsm.service.ISdWorkFlowMasterService;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SdWorkFlowMasterService
implements ISdWorkFlowMasterService {
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdWorkFlowMasterDAO sdWorkFlowMasterDAO;
    @Autowired
    private ISdWorkFlowDetailDAO sdWorkFlowDetailDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateDaoOperations;

    @Override
    @Transactional
    public void checkIsDuplicateWorkflow(SdWorkFlowMasterDTO workflowMasterDto) throws DomainException, ValidationException {
        Integer isDuplicateWorkflow = this.getStateMovementId(workflowMasterDto.getpState(), workflowMasterDto.getaState());
        if (isDuplicateWorkflow == 0) {
            this.saveSdWorkFlowMasterService(workflowMasterDto);
        } else {
            workflowMasterDto.setStateMovementID(isDuplicateWorkflow);
            this.updateSdWorkFlowMasterService(workflowMasterDto);
        }
    }

    @Override
    @Transactional
    public Integer getStateMovementId(Integer pstate, Integer astate) throws DomainException, ValidationException {
        return this.sdWorkFlowMasterDAO.checkIsDuplicateWorkflow(pstate, astate);
    }

    private void saveSdWorkFlowMasterService(SdWorkFlowMasterDTO workflowMasterDto) throws DomainException, ValidationException {
        workflowMasterDto.validate();
        SdWorkFlowMaster workflowmasterDto = new SdWorkFlowMaster(workflowMasterDto.getpState(), workflowMasterDto.getaState(), (SdProjectMaster)this.projectMasterDAO.get(workflowMasterDto.getProjectId()), workflowMasterDto.getScriptName(), workflowMasterDto.getScriptProperties(), workflowMasterDto.getColor());
        this.sdWorkFlowMasterDAO.save(workflowmasterDto);
        workflowMasterDto.setStateMovementID(workflowmasterDto.getStateMovementID());
        if (workflowMasterDto.getSdWorkFlowDetails() != null) {
            for (SdWorkFlowDetailDTO workflowDetailsDto : workflowMasterDto.getSdWorkFlowDetails()) {
                SdWorkFlowDetail workflowDetail = new SdWorkFlowDetail((SdWorkFlowMaster)this.sdWorkFlowMasterDAO.get(workflowmasterDto.getStateMovementID()), workflowDetailsDto.getWorkflowCategoryId(), workflowDetailsDto.getWorkflowCategoryValue());
                this.sdWorkFlowDetailDAO.save(workflowDetail);
            }
        }
        if (workflowMasterDto.getSdSettingOperationHistoryDeails() != null) {
            SdSettingoperationHistoryDTO historyDto = workflowMasterDto.getSdSettingOperationHistoryDeails();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)workflowmasterDto.getStateMovementID(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
        }
    }

    @Override
    @Transactional
    public void updateSdWorkFlowMasterService(SdWorkFlowMasterDTO workflowMasterDto) throws DomainException, ValidationException {
        if (!workflowMasterDto.getProjectName().equalsIgnoreCase("0")) {
            this.sdWorkFlowDetailDAO.deleteWorkflowDetail(workflowMasterDto.getStateMovementID());
        }
        if (workflowMasterDto.getSdWorkFlowDetails() != null) {
            for (SdWorkFlowDetailDTO workflowDetailsDto : workflowMasterDto.getSdWorkFlowDetails()) {
                SdWorkFlowDetail workflowDetail = new SdWorkFlowDetail((SdWorkFlowMaster)this.sdWorkFlowMasterDAO.get(workflowMasterDto.getStateMovementID()), workflowDetailsDto.getWorkflowCategoryId(), workflowDetailsDto.getWorkflowCategoryValue());
                this.sdWorkFlowDetailDAO.save(workflowDetail);
            }
        }
        if (workflowMasterDto.getSdSettingOperationHistoryDeails() != null) {
            SdSettingoperationHistoryDTO historyDto = workflowMasterDto.getSdSettingOperationHistoryDeails();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)workflowMasterDto.getStateMovementID(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), 2, historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
            Integer id = history.getSlNo();
            if (workflowMasterDto.getSdSettingOperationChildHistoryList() != null && id > 0) {
                List<SdSettingoperationHistoryDTO> childHistoryList = workflowMasterDto.getSdSettingOperationChildHistoryList();
                for (SdSettingoperationHistoryDTO childHistoryDto : childHistoryList) {
                    SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(childHistoryDto.getModuleId())), 0, childHistoryDto.getProjectId(), childHistoryDto.getActivityTime(), childHistoryDto.getActionPerformedBy(), childHistoryDto.getIpAddress(), childHistoryDto.getNatureOfChange(), childHistoryDto.getParameter(), childHistoryDto.getOldValue(), childHistoryDto.getNewValue(), id, 0);
                    this.sdSettingoperationHistoryDAO.save(childHistory);
                }
            }
        }
    }

    @Override
    @Transactional
    public void editSdWorkFlowMasterService(SdWorkFlowMasterDTO workflowMasterDto) throws DomainException, ValidationException {
        this.sdWorkFlowDetailDAO.deleteWorkflowRoleDetails(workflowMasterDto.getStateMovementID());
        if (workflowMasterDto.getSdWorkFlowDetails() != null) {
            for (SdWorkFlowDetailDTO workflowDetailsDto : workflowMasterDto.getSdWorkFlowDetails()) {
                SdWorkFlowDetail workflowDetail = new SdWorkFlowDetail((SdWorkFlowMaster)this.sdWorkFlowMasterDAO.get(workflowMasterDto.getStateMovementID()), workflowDetailsDto.getWorkflowCategoryId(), workflowDetailsDto.getWorkflowCategoryValue());
                this.sdWorkFlowDetailDAO.save(workflowDetail);
            }
        }
        if (workflowMasterDto.getSdSettingOperationHistoryDeails() != null) {
            SdSettingoperationHistoryDTO historyDto = workflowMasterDto.getSdSettingOperationHistoryDeails();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)workflowMasterDto.getStateMovementID(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), 2, historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
        }
    }

    @Override
    @Transactional
    public void deleteSdWorkFlowMasterService(SdWorkFlowMasterDTO workflowMasterDto) throws DomainException, ValidationException {
        if (workflowMasterDto.getStateMovementID() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " StateMovementID is mandatory");
        }
        this.sdWorkFlowMasterDAO.deleteSdWorkFlowMasterService(workflowMasterDto.getStateMovementID());
        this.sdWorkFlowDetailDAO.deleteWorkflowDetail(workflowMasterDto.getStateMovementID());
        if (workflowMasterDto.getSdSettingOperationHistoryDeails() != null) {
            SdSettingoperationHistoryDTO historyDto = workflowMasterDto.getSdSettingOperationHistoryDeails();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)workflowMasterDto.getStateMovementID(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
            Integer id = history.getSlNo();
            if (workflowMasterDto.getSdSettingOperationChildHistoryList() != null && id > 0) {
                List<SdSettingoperationHistoryDTO> childHistoryList = workflowMasterDto.getSdSettingOperationChildHistoryList();
                for (SdSettingoperationHistoryDTO childHistoryDto : childHistoryList) {
                    SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(childHistoryDto.getModuleId())), 0, childHistoryDto.getProjectId(), childHistoryDto.getActivityTime(), childHistoryDto.getActionPerformedBy(), childHistoryDto.getIpAddress(), childHistoryDto.getNatureOfChange(), childHistoryDto.getParameter(), childHistoryDto.getOldValue(), childHistoryDto.getNewValue(), id, 0);
                    this.sdSettingoperationHistoryDAO.save(childHistory);
                }
            }
        }
    }

    @Override
    @Transactional
    public List<SdWorkflowStatesDTO> getLeftStatesForWorkflow(Integer projectId) throws DomainException {
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        return this.sdWorkFlowMasterDAO.getLeftStateForWorkFlow(projectId);
    }

    @Override
    @Transactional
    public List<SdWorkFlowBuilderDTO> getWorkFlowBuilderNodes(Integer projectId) throws DomainException {
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        return this.sdWorkFlowMasterDAO.getSdWorkFlowBuilderNodes(projectId);
    }

    @Override
    @Transactional
    public List<SdWorkFlowBuilderDTO> getWorkFlowBuilderEdges(Integer projectId) throws DomainException {
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        return this.sdWorkFlowMasterDAO.getSdWorkFlowBuilderEdges(projectId);
    }

    @Override
    @Transactional
    public List<SdWorkflowStatesDTO> getLeftStatesForWorkflowByServiceParams(List<Integer> serviceList, List<Integer> subcatList, List<Integer> d1List, List<Integer> d2List, List<Integer> d3List, List<Integer> roleList, Integer projectId) throws DomainException {
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        if (subcatList == null || d3List == null || roleList == null) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Service Parameters(subcatlist,d3list,rolelist) list is manditory");
        }
        return this.sdWorkFlowMasterDAO.getLeftStateForWorkFlowByServiceParams(serviceList, subcatList, d1List, d2List, d3List, roleList, projectId);
    }

    @Override
    @Transactional
    public List<SdWorkFlowBuilderDTO> getWorkFlowBuilderNodesByServiceParams(List<Integer> serviceList, List<Integer> subcatList, List<Integer> d1List, List<Integer> d2List, List<Integer> d3List, List<Integer> roleList, Integer projectId) throws DomainException {
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        if (subcatList == null || d3List == null || roleList == null) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Service Parameters(subcatlist,d3list,rolelist) list is manditory");
        }
        return this.sdWorkFlowMasterDAO.getWorkFlowBuilderNodesByServiceParams(serviceList, subcatList, d1List, d2List, d3List, roleList, projectId);
    }

    @Override
    @Transactional
    public List<SdWorkFlowBuilderDTO> getSdWorkFlowBuilderEdgesByServiceParams(List<Integer> serviceList, List<Integer> subcatList, List<Integer> d1List, List<Integer> d2List, List<Integer> d3List, List<Integer> roleList, Integer projectId) throws DomainException {
        if (projectId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        if (subcatList == null || d3List == null || roleList == null) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Service Parameters(subcatlist,d3list,rolelist) list is manditory");
        }
        return this.sdWorkFlowMasterDAO.getSdWorkFlowBuilderEdgesByServiceParams(serviceList, subcatList, d1List, d2List, d3List, roleList, projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdWorkflowFilterDTO getAddWorkflowFieldsData(String services, String subcats, String d1, String d2, String d3, String roles) throws DomainException, ValidationException {
        if (services.isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " services is mandatory");
        }
        if (subcats.isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " subcats is mandatory");
        }
        if (d1.isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " d1 is mandatory");
        }
        if (d2.isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " d2 is mandatory");
        }
        if (d3.isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " d3 is mandatory");
        }
        if (roles.isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " roles is mandatory");
        }
        return this.sdWorkFlowMasterDAO.getAddWorkflowFieldsData(services, subcats, d1, d2, d3, roles);
    }

    @Override
    @Transactional(readOnly=true)
    public String getSelectedFieldsInWorkflow(Integer stateMovementId, Integer fieldType) throws DomainException, ValidationException {
        if (stateMovementId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateMovementId is mandatory");
        }
        String fieldValue = "0";
        switch (fieldType) {
            case 1: {
                List serviceList = this.sdWorkFlowDetailDAO.getSelectedFieldInWorkflow(stateMovementId, 1);
                if (serviceList == null) break;
                fieldValue = StringUtils.join((Iterable)serviceList, (char)',');
                break;
            }
            case 2: {
                List subcatList = this.sdWorkFlowDetailDAO.getSelectedFieldInWorkflow(stateMovementId, 2);
                if (subcatList == null) break;
                fieldValue = StringUtils.join((Iterable)subcatList, (char)',');
                break;
            }
            case 3: {
                List roleList = this.sdWorkFlowDetailDAO.getSelectedFieldInWorkflow(stateMovementId, 3);
                if (roleList == null) break;
                fieldValue = StringUtils.join((Iterable)roleList, (char)',');
                break;
            }
            case 4: {
                List d1List = this.sdWorkFlowDetailDAO.getSelectedFieldInWorkflow(stateMovementId, 4);
                if (d1List == null) break;
                fieldValue = StringUtils.join((Iterable)d1List, (char)',');
                break;
            }
            case 5: {
                List d2List = this.sdWorkFlowDetailDAO.getSelectedFieldInWorkflow(stateMovementId, 5);
                if (d2List == null) break;
                fieldValue = StringUtils.join((Iterable)d2List, (char)',');
                break;
            }
            case 6: {
                List d3List = this.sdWorkFlowDetailDAO.getSelectedFieldInWorkflow(stateMovementId, 6);
                if (d3List == null) break;
                fieldValue = StringUtils.join((Iterable)d3List, (char)',');
                break;
            }
            case 7: {
                List derivedfieldcheck = this.sdWorkFlowDetailDAO.getSelectedFieldInWorkflow(stateMovementId, 7);
                if (derivedfieldcheck == null) break;
                fieldValue = StringUtils.join((Iterable)derivedfieldcheck, (char)',');
            }
        }
        return fieldValue;
    }

    @Override
    @Transactional(readOnly=true)
    public SdWorkFlowMasterDTO getWorkFlowMasterValues(Integer stateMovementId, SdWorkFlowMasterDTO workflowMasterDto) throws DomainException {
        if (stateMovementId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateMovementId is mandatory");
        }
        workflowMasterDto = this.sdWorkFlowMasterDAO.getWorkFlowMasterValues(stateMovementId, workflowMasterDto);
        return workflowMasterDto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSettingoperationHistoryDTO> getUpdateChildHistoryList(SdWorkFlowMasterDTO workflowMasterDto, String nservices, String nsubcats, String nd1, String nd2, String nd3, String nroles, int loggedUserId, String ipAddress) throws DomainException, ValidationException {
        ArrayList<SdSettingoperationHistoryDTO> childHistoryList = new ArrayList<SdSettingoperationHistoryDTO>();
        int projectid = workflowMasterDto.getProjectId();
        Integer stateMovementId = this.getStateMovementId(workflowMasterDto.getpState(), workflowMasterDto.getaState());
        String oServices = this.getSelectedFieldsInWorkflow(stateMovementId, 1);
        String oSubcats = this.getSelectedFieldsInWorkflow(stateMovementId, 2);
        String oRoles = this.getSelectedFieldsInWorkflow(stateMovementId, 3);
        String oD1 = this.getSelectedFieldsInWorkflow(stateMovementId, 4);
        String oD2 = this.getSelectedFieldsInWorkflow(stateMovementId, 5);
        String oD3 = this.getSelectedFieldsInWorkflow(stateMovementId, 6);
        SdWorkflowFilterDTO osdWorkflowFilterDTO = this.getAddWorkflowFieldsData(oServices, oSubcats, oD1, oD2, oD3, oRoles);
        String oldServices = this.getFieldListValues(osdWorkflowFilterDTO, 1);
        String oldSubcats = this.getFieldListValues(osdWorkflowFilterDTO, 2);
        String oldRoles = this.getFieldListValues(osdWorkflowFilterDTO, 3);
        String oldD1 = this.getFieldListValues(osdWorkflowFilterDTO, 4);
        String oldD2 = this.getFieldListValues(osdWorkflowFilterDTO, 5);
        String oldD3 = this.getFieldListValues(osdWorkflowFilterDTO, 6);
        SdWorkflowFilterDTO nsdWorkflowFilterDTO = this.getAddWorkflowFieldsData(nservices, nsubcats, nd1, nd2, nd3, nroles);
        String newServices = this.getFieldListValues(nsdWorkflowFilterDTO, 1);
        String newSubCats = this.getFieldListValues(nsdWorkflowFilterDTO, 2);
        String newRoles = this.getFieldListValues(nsdWorkflowFilterDTO, 3);
        String newD1 = this.getFieldListValues(nsdWorkflowFilterDTO, 4);
        String newD2 = this.getFieldListValues(nsdWorkflowFilterDTO, 5);
        String newD3 = this.getFieldListValues(nsdWorkflowFilterDTO, 6);
        if (!oldServices.equals(newServices)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectid, new Date(), loggedUserId, ipAddress, 2, "Services", oldServices, newServices));
        }
        if (!oldSubcats.equals(newSubCats)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectid, new Date(), loggedUserId, ipAddress, 2, "Subcategory", oldSubcats, newSubCats));
        }
        if (!oldRoles.equals(newRoles)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectid, new Date(), loggedUserId, ipAddress, 2, "Group", oldRoles, newRoles));
        }
        if (!oldD1.equals(newD1)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectid, new Date(), loggedUserId, ipAddress, 2, "Derived Field1", oldD1, newD1));
        }
        if (!oldD2.equals(newD2)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectid, new Date(), loggedUserId, ipAddress, 2, "Derived Field2", oldD2, newD2));
        }
        if (!oldD3.equals(newD3)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectid, new Date(), loggedUserId, ipAddress, 2, "Derived Field3", oldD3, newD3));
        }
        return childHistoryList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSettingoperationHistoryDTO> getDeleteChildHistoryList(SdWorkFlowMasterDTO workflowMasterDto, String services, String subcats, String d1, String d2, String d3, String roles, int loggedUserId, String ipAddress) throws DomainException, ValidationException {
        ArrayList<SdSettingoperationHistoryDTO> childHistoryList = new ArrayList<SdSettingoperationHistoryDTO>();
        int projectId = workflowMasterDto.getProjectId();
        SdWorkflowFilterDTO sdWorkflowFilterDTO = this.getAddWorkflowFieldsData(services, subcats, d1, d2, d3, roles);
        String serviceValues = this.getFieldListValues(sdWorkflowFilterDTO, 1);
        String subCatsValues = this.getFieldListValues(sdWorkflowFilterDTO, 2);
        String rolesValues = this.getFieldListValues(sdWorkflowFilterDTO, 3);
        String d1Values = this.getFieldListValues(sdWorkflowFilterDTO, 4);
        String d2Values = this.getFieldListValues(sdWorkflowFilterDTO, 5);
        String d3Values = this.getFieldListValues(sdWorkflowFilterDTO, 6);
        childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectId, new Date(), loggedUserId, ipAddress, 0, "Services", "--", serviceValues));
        childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectId, new Date(), loggedUserId, ipAddress, 0, "Sub Category", "--", subCatsValues));
        childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectId, new Date(), loggedUserId, ipAddress, 0, "Derived Field1", "--", d1Values));
        childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectId, new Date(), loggedUserId, ipAddress, 0, "Derived Field2", "--", d2Values));
        childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectId, new Date(), loggedUserId, ipAddress, 0, "Derived Field3", "--", d3Values));
        childHistoryList.add(new SdSettingoperationHistoryDTO(10, projectId, new Date(), loggedUserId, ipAddress, 0, "Group", "--", rolesValues));
        return childHistoryList;
    }

    public String getFieldListValues(SdWorkflowFilterDTO sdWorkflowFilterDTO, Integer type) throws DomainException {
        Object value = "";
        switch (type) {
            case 1: {
                for (ServiceMinDTO dto : sdWorkflowFilterDTO.getServiceList()) {
                    if (((String)value).equals("")) {
                        value = dto.getServiceName();
                        continue;
                    }
                    value = (String)value + "," + dto.getServiceName();
                }
                break;
            }
            case 2: {
                for (CategoryMinDTO cat : sdWorkflowFilterDTO.getSubcatList()) {
                    for (SubCategoryMinDTO dto : cat.getSubcategoryList()) {
                        if (((String)value).equals("")) {
                            value = dto.getSubcategoryName();
                            continue;
                        }
                        value = (String)value + "," + dto.getSubcategoryName();
                    }
                }
                break;
            }
            case 3: {
                for (ProjectRolesMinDTO dto : sdWorkflowFilterDTO.getRoleList()) {
                    if (((String)value).equals("")) {
                        value = dto.getRoleDisplayName();
                        continue;
                    }
                    value = (String)value + "," + dto.getRoleDisplayName();
                }
                break;
            }
            case 4: {
                for (DerivedFieldMinDTO dto : sdWorkflowFilterDTO.getD1List()) {
                    if (((String)value).equals("")) {
                        value = dto.getDerivedFieldName();
                        continue;
                    }
                    value = (String)value + "," + dto.getDerivedFieldName();
                }
                break;
            }
            case 5: {
                for (DerivedFieldMinDTO dto : sdWorkflowFilterDTO.getD2List()) {
                    if (((String)value).equals("")) {
                        value = dto.getDerivedFieldName();
                        continue;
                    }
                    value = (String)value + "," + dto.getDerivedFieldName();
                }
                break;
            }
            case 6: {
                for (DerivedFieldMinDTO dto : sdWorkflowFilterDTO.getD3List()) {
                    if (((String)value).equals("")) {
                        value = dto.getDerivedFieldName();
                        continue;
                    }
                    value = (String)value + "," + dto.getDerivedFieldName();
                }
                break;
            }
        }
        return value;
    }

    @Override
    @Transactional(readOnly=true)
    public String getSubCategoryNameForID(Integer subCategoryId) throws DomainException {
        String sbCatName = "";
        sbCatName = subCategoryId == 0 ? "All" : this.sdWorkFlowMasterDAO.getSubCategoryNameForID(subCategoryId);
        return sbCatName;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdWorkFlowMasterDTO> getSdWorkFlowMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize) throws DomainException, ValidationException {
        List<SdWorkFlowMaster> workflowRecords = this.sdWorkFlowMasterDAO.getSdWorkFlowMasterByProjectId(projectId, pageNo, pageSize);
        if (CollectionUtil.isNotEmpty(workflowRecords)) {
            ArrayList<SdWorkFlowMasterDTO> workflowRecordsList = new ArrayList<SdWorkFlowMasterDTO>(workflowRecords.size());
            for (SdWorkFlowMaster workflow : workflowRecords) {
                workflowRecordsList.add(new SdWorkFlowMasterDTO(workflow, workflow.getSdProjectMaster()));
            }
            return workflowRecordsList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdWorkFlowMaster getSdWorkflowMasterByWorkflowID(Integer stateMovementId) throws DomainException, ValidationException {
        return this.sdWorkFlowMasterDAO.getSdWorkflowMasterByWorkflowID(stateMovementId);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer updatWorkflowAstatePState(Integer newPstate, Integer newAstate, Integer oldPstate, Integer oldAstate, Integer projectId) throws DomainException {
        return this.sdWorkFlowMasterDAO.updatWorkflowAstatePState(newPstate, newAstate, oldPstate, oldAstate, projectId);
    }
}

