/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.impl.SdStatecategoryMasterDAO;
import com.sapphireims.itsm.dto.SdStatecategoryMasterDTO;
import com.sapphireims.itsm.model.SdStatecategoryMaster;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.IStateCategoryService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StateCategoryService
implements IStateCategoryService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private SdStatecategoryMasterDAO sdStatecategoryMasterDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    protected IHibernateRepositoryOperations hibernateDaoOperations;
    @Autowired
    private ISdProjectMasterService projectMasterService;

    @Override
    @Transactional(readOnly=true)
    public List<SdStatecategoryMasterDTO> getSdStateCategoryByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String columnSort, String sortOrder) throws DomainException, ValidationException {
        List<SdStatecategoryMaster> sdStatecategoryMasterList = this.sdStatecategoryMasterDAO.getSdStatecategoryMasterByProjectId(projectId, pageNo, pageSize, columnSort, sortOrder);
        if (sdStatecategoryMasterList != null) {
            ArrayList<SdStatecategoryMasterDTO> sdStatecategoryMasterDTOList = new ArrayList<SdStatecategoryMasterDTO>();
            for (SdStatecategoryMaster sdStatecategoryMaster : sdStatecategoryMasterList) {
                sdStatecategoryMasterDTOList.add(new SdStatecategoryMasterDTO(sdStatecategoryMaster, new SdProjectMaster(projectId)));
            }
            return sdStatecategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdStatecategoryMasterDTO getStateCategoryById(Integer stateCategoryId, Integer projectId) throws DomainException, ValidationException {
        SdStatecategoryMaster sdStatecategoryMaster = (SdStatecategoryMaster)this.sdStatecategoryMasterDAO.get(stateCategoryId);
        if (sdStatecategoryMaster != null) {
            return new SdStatecategoryMasterDTO(sdStatecategoryMaster, new SdProjectMaster(projectId));
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "No State Category Exist for id " + stateCategoryId);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateStateCategoryName(String stateCategoryName, Integer projectId, Integer stateCategoryId) throws DomainException, ValidationException {
        return this.sdStatecategoryMasterDAO.checkDuplicateStateCategoryName(stateCategoryName, projectId, stateCategoryId);
    }

    @Override
    @Transactional
    public int saveStateCategoryName(SdStatecategoryMasterDTO sdStatecategoryMasterDTO) {
        SdStatecategoryMaster sdStatecategoryMaster = new SdStatecategoryMaster((SdProjectMaster)this.projectMasterDAO.get(sdStatecategoryMasterDTO.getProjectId()), sdStatecategoryMasterDTO.getStateCategoryName(), "", sdStatecategoryMasterDTO.getCategoryBarColor(), sdStatecategoryMasterDTO.getCategoryColor());
        this.sdStatecategoryMasterDAO.save(sdStatecategoryMaster);
        return sdStatecategoryMaster.getStateCategoryId();
    }

    @Override
    @Transactional
    public int updateStateCategoryName(SdStatecategoryMasterDTO sdStatecategoryMasterDTO) {
        SdStatecategoryMaster sdStatecategoryMaster = (SdStatecategoryMaster)((Object)this.hibernateDaoOperations.get(SdStatecategoryMaster.class, sdStatecategoryMasterDTO.getStateCategoryId()));
        sdStatecategoryMaster.setStateCategoryName(sdStatecategoryMasterDTO.getStateCategoryName());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdStatecategoryMaster);
        return sdStatecategoryMaster.getStateCategoryId();
    }

    @Override
    @Transactional
    public int saveStateCategoryDescription(SdStatecategoryMasterDTO sdStatecategoryMasterDTO) {
        SdStatecategoryMaster sdStatecategoryMaster = (SdStatecategoryMaster)((Object)this.hibernateDaoOperations.get(SdStatecategoryMaster.class, sdStatecategoryMasterDTO.getStateCategoryId()));
        sdStatecategoryMaster.setStateCategoryDescription(sdStatecategoryMasterDTO.getStateCategoryDescription());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdStatecategoryMaster);
        return sdStatecategoryMaster.getStateCategoryId();
    }

    @Override
    @Transactional
    public int saveStateCategoryColor(SdStatecategoryMasterDTO sdStatecategoryMasterDTO) {
        SdStatecategoryMaster sdStatecategoryMaster = (SdStatecategoryMaster)((Object)this.hibernateDaoOperations.get(SdStatecategoryMaster.class, sdStatecategoryMasterDTO.getStateCategoryId()));
        sdStatecategoryMaster.setCategoryColor(sdStatecategoryMasterDTO.getCategoryColor());
        sdStatecategoryMaster.setCategoryBarColor(sdStatecategoryMasterDTO.getCategoryBarColor());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdStatecategoryMaster);
        return sdStatecategoryMaster.getStateCategoryId();
    }

    @Override
    @Transactional(readOnly=true)
    public void deleteSdStatecategoryMaster(Integer stateCategoryId) {
        this.sdStatecategoryMasterDAO.deleteSdStatecategoryMaster(stateCategoryId);
    }
}

