/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphire.itsm.mailrouting.model.SdStatesMaster;
import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdMultiapprovalMasterDAO;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dao.ISdStateRolesDAO;
import com.sapphireims.itsm.dao.ISdStatecategoryDetailsDAO;
import com.sapphireims.itsm.dao.ISdStatesFixedfieldsDAO;
import com.sapphireims.itsm.dao.ISdStatesFixedfieldsPermissionsDAO;
import com.sapphireims.itsm.dao.ISdStatesMasterDAO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.SdStatesMasterDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.mindto.StatesMinDTO;
import com.sapphireims.itsm.model.SdStatecategoryDetails;
import com.sapphireims.itsm.model.SdStatesFixedfields;
import com.sapphireims.itsm.model.SdStatesFixedfieldsPermissions;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.IStateService;
import com.sapphireims.service.ICacheService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StateService
implements IStateService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdStatesMasterDAO statesMasterDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdStatesMasterDAO sdStatesMasterDAO;
    @Autowired
    private ISdStatecategoryDetailsDAO sdStatecategoryDetailsDAO;
    @Autowired
    private ISdStatesFixedfieldsDAO sdStatesFixedfieldsDAO;
    @Autowired
    private ISdStatesFixedfieldsPermissionsDAO sdStatesFixedfieldsPermissionsDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateDaoOperations;
    @Autowired
    private ISdMultiapprovalMasterDAO sdMultiapprovalMasterDAO;
    @Autowired
    private ISdStateRolesDAO sdStateRolesDAO;
    @Autowired
    private ICacheService cacheService;

    @Override
    @Transactional
    public SdStatesMasterDTO getStateById(Integer stateId, Integer projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdStatesMaster state = (SdStatesMaster)this.statesMasterDAO.get(stateId);
            if (state != null) {
                return new SdStatesMasterDTO(state);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "No State avilable for id " + stateId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)" Invalid Project Id %d ", (Object[])new Object[]{projectId});
        SdStatesMasterDTO state = project.getStateDTOById(stateId);
        Validate.notNull((Object)((Object)state), (String)" Invalid State Id %d ", (Object[])new Object[]{stateId});
        return state;
    }

    @Override
    @Transactional
    public void saveSdState(SdStatesMasterDTO stateDto) throws DomainException, ValidationException {
        if (stateDto.getColor().contains("hsv")) {
            stateDto.setColor("#FFFFFF");
        }
        SdStatesMaster sdStatesMaster = new SdStatesMaster((SdProjectMaster)this.projectMasterDAO.get(stateDto.getProjectId()), stateDto.getStateName(), (Byte)0, (Integer)30, stateDto.getShortName(), stateDto.getColor());
        this.sdStatesMasterDAO.save(sdStatesMaster);
        stateDto.setStateId(sdStatesMaster.getStateId());
        if (stateDto.getStateId() != null && stateDto.getStateId() != 0) {
            SdStatecategoryDetails stateCategoryDetails = new SdStatecategoryDetails((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), stateDto.getStateCategoryId(), 0);
            this.sdStatecategoryDetailsDAO.save(stateCategoryDetails);
            SdStatesFixedfields stateFixedFields = null;
            switch (stateDto.getInheritedFrom()) {
                case "User ID": {
                    stateFixedFields = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "User ID", "Select User", (byte)0);
                    this.sdStatesFixedfieldsDAO.save(stateFixedFields);
                    break;
                }
                case "App ID": {
                    stateFixedFields = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "App ID", "Select Approval Manager", (byte)1);
                    this.sdStatesFixedfieldsDAO.save(stateFixedFields);
                    break;
                }
                case "Multi App ID": {
                    stateFixedFields = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Multi App ID", "Approval Manager", (byte)1);
                    this.sdStatesFixedfieldsDAO.save(stateFixedFields);
                }
            }
            SdStatesFixedfields stateFixedFields2 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Comment", "Comment", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields2);
            SdStatesFixedfields stateFixedFields3 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Functional Escalation", "Functional Escalation", (byte)0);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields3);
            SdStatesFixedfields stateFixedFields4 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Escalate to Management", "Escalate to Management", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields4);
            SdStatesFixedfields stateFixedFields5 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Cancel Record", "Cancel Record", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields5);
            SdStatesFixedfields stateFixedFields6 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Attachments in Email Communications", "Attachments in Email Communications", (byte)0);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields6);
            SdStatesFixedfields stateFixedFields7 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Child Record Submission", "Child Record Submission", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields7);
            if (stateDto.getInheritedFrom().equalsIgnoreCase("User ID")) {
                sdStatesFixedfieldsPermissions = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Location", "Location", 1, 1);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions);
                sdStatesFixedfieldsPermissions2 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Department", "Department", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions2);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions3 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Filter By", "Filter By", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions3);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions4 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Role", "Role", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions4);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions5 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Specializations", "Specializations", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions5);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions7 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "WorkGroup Filter", "Work Group", 0, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions7);
            } else if (stateDto.getInheritedFrom().equalsIgnoreCase("App ID")) {
                sdStatesFixedfieldsPermissions = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Location", "Location", 1, 1);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions);
                sdStatesFixedfieldsPermissions2 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Department", "Department", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions2);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions3 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Filter By", "Filter By", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions3);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions4 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Role", "Role", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions4);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions5 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Specializations", "Specializations", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions5);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
                SdStatesFixedfieldsPermissions sdStatesFixedfieldsPermissions7 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "WorkGroup Filter", "Work Group", 0, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions7);
            } else if (stateDto.getInheritedFrom().equalsIgnoreCase("Multi App ID")) {
                sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
            } else {
                sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
            }
            if (stateDto.getHistoryDTO() != null) {
                SdSettingoperationHistoryDTO historyDto = stateDto.getHistoryDTO();
                SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)stateDto.getStateId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
                this.sdSettingoperationHistoryDAO.save(history);
            }
        }
        this.cacheService.updateProjectCache(stateDto.getProjectId());
    }

    @Override
    @Transactional(readOnly=true)
    public SdStatesMasterDTO getStateFields(Integer stateId) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        return this.sdStatesMasterDAO.getStateFields(stateId);
    }

    @Override
    @Transactional
    public void updateSdState(SdStatesMasterDTO stateDto) throws DomainException, ValidationException {
        if (stateDto.getColor().contains("hsv")) {
            stateDto.setColor("#FFFFFF");
        }
        this.sdStatesMasterDAO.updateState(stateDto.getStateName(), stateDto.getShortName(), stateDto.getColor(), stateDto.getStateId());
        SdStatesMaster sdStatesMaster = (SdStatesMaster)((Object)this.hibernateDaoOperations.get(SdStatesMaster.class, stateDto.getStateId()));
        sdStatesMaster.setStateName(stateDto.getStateName());
        sdStatesMaster.setShortName(stateDto.getShortName());
        sdStatesMaster.setColor(stateDto.getColor());
        this.sdStatecategoryDetailsDAO.updateStateCategory(stateDto.getStateId(), stateDto.getStateCategoryId());
        if (stateDto.getIsInheritedFromChangedForEdit() == 1) {
            this.sdStatesFixedfieldsDAO.deleteStatesFixedfields(stateDto.getStateId());
            this.sdMultiapprovalMasterDAO.deleteSdMultiapprovalMaster(stateDto.getStateId());
            this.sdStateRolesDAO.deleteSdStateRoles(stateDto.getStateId());
            SdStatesFixedfields stateFixedFields = null;
            switch (stateDto.getInheritedFrom()) {
                case "User ID": {
                    stateFixedFields = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "User ID", "Select User", (byte)0);
                    this.sdStatesFixedfieldsDAO.save(stateFixedFields);
                    break;
                }
                case "App ID": {
                    stateFixedFields = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "App ID", "Select Approval Manager", (byte)1);
                    this.sdStatesFixedfieldsDAO.save(stateFixedFields);
                    break;
                }
                case "Multi App ID": {
                    stateFixedFields = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Multi App ID", "Approval Manager", (byte)1);
                    this.sdStatesFixedfieldsDAO.save(stateFixedFields);
                }
            }
            SdStatesFixedfields stateFixedFields2 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Comment", "Comment", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields2);
            SdStatesFixedfields stateFixedFields3 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Functional Escalation", "Functional Escalation", (byte)0);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields3);
            SdStatesFixedfields stateFixedFields4 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Escalate to Management", "Escalate to Management", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields4);
            SdStatesFixedfields stateFixedFields5 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Cancel Record", "Cancel Record", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields5);
            SdStatesFixedfields stateFixedFields6 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Attachments in Email Communications", "Attachments in Email Communications", (byte)0);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields6);
            SdStatesFixedfields stateFixedFields7 = new SdStatesFixedfields((SdStatesMaster)this.sdStatesMasterDAO.get(sdStatesMaster.getStateId()), "Child Record Submission", "Child Record Submission", (byte)1);
            this.sdStatesFixedfieldsDAO.save(stateFixedFields7);
            if (stateDto.getInheritedFrom().equalsIgnoreCase("User ID")) {
                sdStatesFixedfieldsPermissions = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Location", "Location", 1, 1);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions);
                sdStatesFixedfieldsPermissions2 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Department", "Department", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions2);
                sdStatesFixedfieldsPermissions3 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Filter By", "Filter By", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions3);
                sdStatesFixedfieldsPermissions4 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Role", "Role", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions4);
                sdStatesFixedfieldsPermissions5 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Specializations", "Specializations", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions5);
                sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
                sdStatesFixedfieldsPermissions7 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "WorkGroup Filter", "Work Group", 0, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions7);
            } else if (stateDto.getInheritedFrom().equalsIgnoreCase("App ID")) {
                sdStatesFixedfieldsPermissions = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Location", "Location", 1, 1);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions);
                sdStatesFixedfieldsPermissions2 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Department", "Department", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions2);
                sdStatesFixedfieldsPermissions3 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Filter By", "Filter By", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions3);
                sdStatesFixedfieldsPermissions4 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Role", "Role", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions4);
                sdStatesFixedfieldsPermissions5 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields.getInputId()), "Specializations", "Specializations", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions5);
                sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
                sdStatesFixedfieldsPermissions7 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "WorkGroup Filter", "Work Group", 0, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions7);
            } else if (stateDto.getInheritedFrom().equalsIgnoreCase("Multi App ID")) {
                sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
            } else {
                sdStatesFixedfieldsPermissions6 = new SdStatesFixedfieldsPermissions((SdStatesFixedfields)this.sdStatesFixedfieldsDAO.get(stateFixedFields2.getInputId()), "Comment", "Comment", 1, 0);
                this.sdStatesFixedfieldsPermissionsDAO.save(sdStatesFixedfieldsPermissions6);
            }
        }
        if (stateDto.getSdSettingoperationHistoryDTOList() != null) {
            List<SdSettingoperationHistoryDTO> childHistoryList = stateDto.getSdSettingoperationHistoryDTOList();
            for (SdSettingoperationHistoryDTO childHistoryDto : childHistoryList) {
                SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(childHistoryDto.getModuleId())), (int)stateDto.getStateId(), childHistoryDto.getProjectId(), childHistoryDto.getActivityTime(), childHistoryDto.getActionPerformedBy(), childHistoryDto.getIpAddress(), childHistoryDto.getNatureOfChange(), childHistoryDto.getParameter(), childHistoryDto.getOldValue(), childHistoryDto.getNewValue());
                this.sdSettingoperationHistoryDAO.save(childHistory);
            }
        }
    }

    @Override
    @Transactional
    public void deleteSdState(Integer stateId) throws DomainException, ValidationException {
        if (stateId == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " stateId is mandatory");
        }
        this.sdStatesMasterDAO.setDeleteStatus(stateId);
        this.sdStatesFixedfieldsDAO.deleteStateFixedFieldsByState(stateId);
        this.sdMultiapprovalMasterDAO.deleteSdMultiapprovalMaster(stateId);
        this.sdStateRolesDAO.deleteSdStateRoles(stateId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdStatesMasterDTO getStartState(Integer projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            List<SdStatesMaster> sdStatesMasterList = this.sdStatesMasterDAO.getSdStatesMasterDTOForStartState(projectId);
            if (sdStatesMasterList != null) {
                SdStatesMasterDTO sdStatesMasterDTO = null;
                for (SdStatesMaster sdStatesMaster : sdStatesMasterList) {
                    sdStatesMasterDTO = new SdStatesMasterDTO(sdStatesMaster);
                }
                return sdStatesMasterDTO;
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "No State avilable for startstate=1 for projectId " + projectId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %d ", (Object[])new Object[]{projectId});
        return project.getStartStateDTOById();
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateState(String stateName, Integer projectId) throws DomainException, ValidationException {
        return this.sdStatesMasterDAO.checkDuplicateState(stateName, projectId);
    }

    @Override
    @Transactional
    public void deleteSdState(SdStatesMasterDTO stateDto) throws DomainException, ValidationException {
        Integer stateId = stateDto.getStateId();
        this.sdStatesMasterDAO.setDeleteStatus(stateId);
        this.sdStatesFixedfieldsDAO.deleteStateFixedFieldsByState(stateId);
        this.sdMultiapprovalMasterDAO.deleteSdMultiapprovalMaster(stateId);
        this.sdStateRolesDAO.deleteSdStateRoles(stateId);
        if (stateDto.getHistoryDTO() != null) {
            SdSettingoperationHistoryDTO historyDto = stateDto.getHistoryDTO();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)stateDto.getStateId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
            Integer id = history.getSlNo();
            if (stateDto.getSdSettingoperationHistoryDTOList() != null && id > 0) {
                List<SdSettingoperationHistoryDTO> childHistoryList = stateDto.getSdSettingoperationHistoryDTOList();
                for (SdSettingoperationHistoryDTO childHistoryDto : childHistoryList) {
                    SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(childHistoryDto.getModuleId())), stateDto.getStateId(), childHistoryDto.getProjectId(), childHistoryDto.getActivityTime(), childHistoryDto.getActionPerformedBy(), childHistoryDto.getIpAddress(), childHistoryDto.getNatureOfChange(), childHistoryDto.getParameter(), childHistoryDto.getOldValue(), childHistoryDto.getNewValue(), id, 0);
                    this.sdSettingoperationHistoryDAO.save(childHistory);
                }
            }
        }
    }

    @Override
    @Transactional
    public List<SdSettingoperationHistoryDTO> getUpdatedChildHistoryDetails(SdStatesMasterDTO newStateDto, SdStatesMasterDTO oldStateDto, String ipAddress, Integer loggedUserId, Integer projectId) throws DomainException, ValidationException {
        String paramName;
        ArrayList<SdSettingoperationHistoryDTO> childHistoryList = new ArrayList<SdSettingoperationHistoryDTO>();
        childHistoryList.add(new SdSettingoperationHistoryDTO(9, projectId, new Date(), loggedUserId, ipAddress, 2, "Customize Fields", "--", ""));
        String oldStateName = "";
        String oldColour = "";
        String oldStateCategory = "";
        String oldStateCategoryName = "";
        String oldShortName = "";
        String oldInheritFrom = "";
        String newStateName = "";
        String newColour = "";
        String newStateCategory = "";
        String newStateCategoryName = "";
        String newShortName = "";
        String newInheritFrom = "";
        if (oldStateDto.getStateName() != null) {
            oldStateName = oldStateDto.getStateName();
        }
        if (oldStateDto.getColor() != null) {
            oldColour = oldStateDto.getColor();
        }
        if (oldStateDto.getStateCategoryId() != null) {
            oldStateCategory = oldStateDto.getStateCategoryId().toString();
        }
        if (this.sdStatesMasterDAO.getStateCategoryName(oldStateDto.getStateCategoryId()) != null) {
            oldStateCategoryName = this.sdStatesMasterDAO.getStateCategoryName(oldStateDto.getStateCategoryId());
        }
        if (oldStateDto.getShortName() != null) {
            oldShortName = oldStateDto.getShortName();
        }
        if (oldStateDto.getInheritedFromText() != null) {
            oldInheritFrom = oldStateDto.getInheritedFromText();
        }
        if (newStateDto.getStateName() != null) {
            newStateName = newStateDto.getStateName();
        }
        if (newStateDto.getColor() != null) {
            newColour = newStateDto.getColor();
        }
        if (newStateDto.getStateCategoryId() != null) {
            newStateCategory = newStateDto.getStateCategoryId().toString();
        }
        if (this.sdStatesMasterDAO.getStateCategoryName(newStateDto.getStateCategoryId()) != null) {
            newStateCategoryName = this.sdStatesMasterDAO.getStateCategoryName(newStateDto.getStateCategoryId());
        }
        if (newStateDto.getShortName() != null) {
            newShortName = newStateDto.getShortName();
        }
        if (newStateDto.getInheritedFromText() != null) {
            newInheritFrom = newStateDto.getInheritedFromText();
        }
        if (!oldStateName.equalsIgnoreCase(newStateName)) {
            childHistoryList.add(new SdSettingoperationHistoryDTO(9, projectId, new Date(), loggedUserId, ipAddress, 2, "State Name", oldStateName, newStateName));
        }
        if (!oldColour.equalsIgnoreCase(newColour)) {
            paramName = "Color For(" + newStateName + ")";
            childHistoryList.add(new SdSettingoperationHistoryDTO(9, projectId, new Date(), loggedUserId, ipAddress, 2, paramName, oldColour, newColour));
        }
        if (!oldStateCategory.equalsIgnoreCase(newStateCategory)) {
            paramName = "State Category For(" + newStateName + ")";
            childHistoryList.add(new SdSettingoperationHistoryDTO(9, projectId, new Date(), loggedUserId, ipAddress, 2, paramName, oldStateCategoryName, newStateCategoryName));
        }
        if (!oldShortName.equalsIgnoreCase(newShortName)) {
            paramName = "Short State Name For(" + newStateName + ")";
            childHistoryList.add(new SdSettingoperationHistoryDTO(9, projectId, new Date(), loggedUserId, ipAddress, 2, paramName, oldShortName, newShortName));
        }
        if (!oldInheritFrom.equalsIgnoreCase(newInheritFrom)) {
            paramName = "Inherit From For(" + newStateName + ")";
            childHistoryList.add(new SdSettingoperationHistoryDTO(9, projectId, new Date(), loggedUserId, ipAddress, 2, paramName, oldInheritFrom, newInheritFrom));
        }
        return childHistoryList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdStatesMasterDTO> getStatesByProjectId(Integer projectId) {
        ArrayList<SdStatesMasterDTO> ret = null;
        List<SdStatesMaster> masters = this.sdStatesMasterDAO.getStatesByProjectId(projectId);
        if (CollectionUtil.isNotEmpty(masters)) {
            ret = new ArrayList<SdStatesMasterDTO>(masters.size());
            for (SdStatesMaster d : masters) {
                ret.add(new SdStatesMasterDTO(d));
            }
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdStatesMasterDTO> getStatesNameByWorkgroupId(Integer workGroupID) throws DomainException, ValidationException {
        List<SdStatesMaster> states = this.sdStatesMasterDAO.getStatesNameByWorkgroupId(workGroupID);
        if (states != null) {
            ArrayList<SdStatesMasterDTO> sdStatesMasterDTOList = new ArrayList<SdStatesMasterDTO>();
            for (SdStatesMaster state : states) {
                sdStatesMasterDTOList.add(new SdStatesMasterDTO(state));
            }
            return sdStatesMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "workGroup id is not valid " + workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdStatesMasterDTO> getStatesListByState(List<Integer> statesID) throws DomainException, ValidationException {
        List<SdStatesMaster> states = this.sdStatesMasterDAO.getStatesListByState(statesID);
        if (states != null) {
            ArrayList<SdStatesMasterDTO> sdStatesMasterDTOList = new ArrayList<SdStatesMasterDTO>();
            for (SdStatesMaster state : states) {
                sdStatesMasterDTOList.add(new SdStatesMasterDTO(state));
            }
            return sdStatesMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "states id is not valid " + String.valueOf(statesID));
    }

    @Override
    @Transactional(readOnly=true)
    public SdStatesMasterDTO getByProjectIdAndStateId(Integer projectId, Integer stateId) throws DomainException, ValidationException {
        SdStatesMaster states = this.sdStatesMasterDAO.getByProjectIdAndStateId(projectId, stateId);
        if (states != null) {
            SdStatesMasterDTO State = new SdStatesMasterDTO(states);
            return State;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "states id is not valid " + stateId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<StatesMinDTO> getSdStateMasterMinDataByProject(Integer projectId) throws DomainException, ValidationException {
        List<StatesMinDTO> states = this.sdStatesMasterDAO.getSdStateMasterMinDataByProject(projectId);
        if (CollectionUtil.isNotEmpty(states)) {
            return states;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "projectId id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdStatesMasterDTO getStateByStateName(String stateName, Integer projectId) throws DomainException, ValidationException {
        SdStatesMaster states = this.sdStatesMasterDAO.getStateByStateName(stateName, projectId);
        if (states != null) {
            SdStatesMasterDTO State = new SdStatesMasterDTO(states);
            return State;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "state Name is not valid " + stateName);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdStatesMasterDTO> getSdStateMasterListByProject(Integer projectId) {
        ArrayList<SdStatesMasterDTO> stateList = new ArrayList<SdStatesMasterDTO>();
        List<SdStatesMaster> masters = this.sdStatesMasterDAO.getSdStateMasterListByProject(projectId);
        if (CollectionUtil.isNotEmpty(masters)) {
            for (SdStatesMaster d : masters) {
                stateList.add(new SdStatesMasterDTO(d));
            }
        }
        return stateList;
    }
}

