/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdCategorymasterDAO;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdServiceParametersDetailsDAO;
import com.sapphireims.itsm.dao.ISdServiceParametersMasterDAO;
import com.sapphireims.itsm.dao.ISdServicecatalogueCategorydetailsDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dao.ISdSubcategorymasterDAO;
import com.sapphireims.itsm.dto.SdServiceParametersDetailsDTO;
import com.sapphireims.itsm.dto.SdServicecatalogueCategorydetailsDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.SdSubCategoryMasterDTO;
import com.sapphireims.itsm.mindto.SubCategoryMinDTO;
import com.sapphireims.itsm.model.SdCategorymaster;
import com.sapphireims.itsm.model.SdServiceParametersDetails;
import com.sapphireims.itsm.model.SdServiceParametersMaster;
import com.sapphireims.itsm.model.SdServicecatalogueCategorydetails;
import com.sapphireims.itsm.model.SdSubcategorymaster;
import com.sapphireims.itsm.service.ISubCategoryService;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubCategoryService
implements ISubCategoryService {
    @Autowired
    private ISdCategorymasterDAO sdCategorymasterDAO;
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;
    @Autowired
    private ISdSubcategorymasterDAO sdSubcategorymasterDAO;
    @Autowired
    private ISdServiceParametersMasterDAO sdServiceParametersMasterDAO;
    @Autowired
    private ISdServiceParametersDetailsDAO sdServiceParametersDetailsDAO;
    @Autowired
    private ISdServicecatalogueCategorydetailsDAO sdServicecatalogueCategorydetailsDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;

    @Override
    @Transactional
    public void saveSdSubcategory(SdSubCategoryMasterDTO subcategoryDto) throws ValidationException, DomainException {
        subcategoryDto.validate();
        SdSubcategorymaster subcategory = new SdSubcategorymaster((SdCategorymaster)this.sdCategorymasterDAO.get(subcategoryDto.getCategoryId()), (SdProjectMaster)this.projectMasterDAO.get(subcategoryDto.getProjectId()), subcategoryDto.getSubCategoryName(), subcategoryDto.getSubCategoryDescription(), 0, 0, subcategoryDto.getShortname());
        this.sdSubcategorymasterDAO.save(subcategory);
        subcategoryDto.setSubCategoryId(subcategory.getSubCategoryId());
        if (subcategoryDto.getParametersDetails() != null) {
            for (SdServiceParametersDetailsDTO paramDto : subcategoryDto.getParametersDetails()) {
                SdServiceParametersDetails paramDetails = new SdServiceParametersDetails((SdServiceParametersMaster)this.sdServiceParametersMasterDAO.get(Integer.valueOf(paramDto.getParametersMaster().getValue())), subcategory.getSubCategoryId(), paramDto.getServiceId());
                this.sdServiceParametersDetailsDAO.save(paramDetails);
            }
        }
        if (subcategoryDto.getServicecatalogueCategorydetails() != null) {
            for (SdServicecatalogueCategorydetailsDTO catalogueDto : subcategoryDto.getServicecatalogueCategorydetails()) {
                SdServicecatalogueCategorydetails catalogue = new SdServicecatalogueCategorydetails(catalogueDto.getServiceId(), catalogueDto.getCategoryId(), subcategory.getSubCategoryId(), "0", "0");
                this.sdServicecatalogueCategorydetailsDAO.save(catalogue);
            }
        }
        if (subcategoryDto.getSdSettingoperationHistoryDTO() != null) {
            SdSettingoperationHistoryDTO historyDto = subcategoryDto.getSdSettingoperationHistoryDTO();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)subcategory.getSubCategoryId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public SubCategoryMinDTO getMinSubcategoryById(Integer subcategoryId, Integer projectId) throws DomainException, ValidationException {
        SdSubcategorymaster subcategory = (SdSubcategorymaster)this.sdSubcategorymasterDAO.get(subcategoryId);
        if (subcategory != null) {
            return new SubCategoryMinDTO(subcategory.getSubCategoryId(), subcategory.getSubCategoryName());
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "No Subcategory Exist for Id " + subcategoryId);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateSubcategory(String subcategoryName, Integer categoryId, Integer projectId) throws DomainException, ValidationException {
        return this.sdSubcategorymasterDAO.checkDuplicateSubcategory(subcategoryName, categoryId, projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSubCategoryMasterDTO> getSdSubcategorymasterByCategoryIdAndProjectId(Integer projectId, Integer categoryId) {
        ArrayList<SdSubCategoryMasterDTO> ret = null;
        List<SdSubcategorymaster> masters = this.sdSubcategorymasterDAO.getSdSubcategorymasterByCategoryIdAndProjectId(projectId, categoryId);
        if (CollectionUtil.isNotEmpty(masters)) {
            ret = new ArrayList<SdSubCategoryMasterDTO>(masters.size());
            for (SdSubcategorymaster d : masters) {
                ret.add(new SdSubCategoryMasterDTO(d));
            }
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSubCategoryMasterDTO> getSubCategoryNameByWorkgroupId(int workGroupID) throws DomainException, ValidationException {
        List<SdSubcategorymaster> subCategoryList = this.sdSubcategorymasterDAO.getSubCategoryNameByWorkgroupId(workGroupID);
        if (subCategoryList != null) {
            ArrayList<SdSubCategoryMasterDTO> SdSubCategoryMasterDTOList = new ArrayList<SdSubCategoryMasterDTO>();
            for (SdSubcategorymaster sdSubCategory : subCategoryList) {
                SdSubCategoryMasterDTOList.add(new SdSubCategoryMasterDTO(sdSubCategory));
            }
            return SdSubCategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "workGroup id is not valid " + workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSubCategoryMasterDTO> getSubCategoryListBySubCategory(List<Integer> subCategoryIDs) throws DomainException, ValidationException {
        List<SdSubcategorymaster> subCategoryList = this.sdSubcategorymasterDAO.getSubCategoryListBySubCategory(subCategoryIDs);
        if (subCategoryList != null) {
            ArrayList<SdSubCategoryMasterDTO> SdSubCategoryMasterDTOList = new ArrayList<SdSubCategoryMasterDTO>();
            for (SdSubcategorymaster sdSubCategory : subCategoryList) {
                SdSubCategoryMasterDTOList.add(new SdSubCategoryMasterDTO(sdSubCategory));
            }
            return SdSubCategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "subCategory id is not valid " + String.valueOf(subCategoryIDs));
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSubCategoryMasterDTO> getSubCategoryNameBySubCategoryIds(List<Integer> subCategoryIdList, Integer projectId) throws DomainException, ValidationException {
        List<SdSubcategorymaster> subCategory = this.sdSubcategorymasterDAO.getSubCategoryNameBySubCategoryIds(subCategoryIdList, projectId);
        if (CollectionUtil.isNotEmpty(subCategory)) {
            ArrayList<SdSubCategoryMasterDTO> sdSubCategoryMasterDTOList = new ArrayList<SdSubCategoryMasterDTO>();
            for (SdSubcategorymaster subCat : subCategory) {
                sdSubCategoryMasterDTOList.add(new SdSubCategoryMasterDTO(subCat));
            }
            return sdSubCategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "subCategoryIdList id's is not valid " + String.valueOf(subCategoryIdList));
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSubCategoryMasterDTO> getSdSubCategoryMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String columnSort, String sortDir) throws DomainException, ValidationException {
        List<SdSubcategorymaster> subCategoryRecords = this.sdSubcategorymasterDAO.getSdSubCategoryMasterByProjectId(projectId, pageNo, pageSize, columnSort, sortDir);
        if (CollectionUtil.isNotEmpty(subCategoryRecords)) {
            ArrayList<SdSubCategoryMasterDTO> subCategoryRecordsList = new ArrayList<SdSubCategoryMasterDTO>(subCategoryRecords.size());
            for (SdSubcategorymaster subCategory : subCategoryRecords) {
                subCategoryRecordsList.add(new SdSubCategoryMasterDTO(subCategory.getSdCategorymaster(), subCategory));
            }
            return subCategoryRecordsList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdServiceParametersDetailsDTO> getSdServiceIdBySubCategory(Integer parameterId, Integer paramValue) throws DomainException, ValidationException {
        List<SdServiceParametersDetails> serviceRecords = this.sdServiceParametersDetailsDAO.getSdServiceIdBySubCategory(parameterId, paramValue);
        if (CollectionUtil.isNotEmpty(serviceRecords)) {
            ArrayList<SdServiceParametersDetailsDTO> subCategoryRecordsList = new ArrayList<SdServiceParametersDetailsDTO>(serviceRecords.size());
            for (SdServiceParametersDetails service : serviceRecords) {
                subCategoryRecordsList.add(new SdServiceParametersDetailsDTO(service));
            }
            return subCategoryRecordsList;
        }
        return new ArrayList<SdServiceParametersDetailsDTO>();
    }

    @Override
    @Transactional(readOnly=true)
    public SdSubcategorymaster getSdSubcategoryBySubCategoryIdAndProjectId(Integer projectId, Integer subCategoryId) {
        return this.sdSubcategorymasterDAO.getSdSubcategoryBySubCategoryIdAndProjectId(projectId, subCategoryId);
    }

    @Override
    @Transactional(readOnly=true)
    public void deleteSdServiceParameterDetailsForSubCategory(int projectId, Integer categoryId) throws DomainException, ValidationException {
        this.sdServiceParametersDetailsDAO.deleteSdServiceParameterDetailsForSubCategory(projectId, categoryId);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateSubcategorys(String subcategoryName, Integer categoryId, Integer projectId, Integer subCategoryId) throws DomainException, ValidationException {
        return this.sdSubcategorymasterDAO.checkDuplicateSubcategorys(subcategoryName, categoryId, projectId, subCategoryId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSubCategoryMasterDTO> getSdSubcategoryBysubCategoryIdsAndProjectId(Integer projectId, List<Integer> subCategoryIdList) throws DomainException, ValidationException {
        List<SdSubcategorymaster> subCategory = this.sdSubcategorymasterDAO.getSdSubcategoryBysubCategoryIdsAndProjectId(projectId, subCategoryIdList);
        if (CollectionUtil.isNotEmpty(subCategory)) {
            List<SdSubCategoryMasterDTO> sdSubCategoryMasterDTOList = subCategory.stream().map(SdSubCategoryMasterDTO::new).collect(Collectors.toList());
            return sdSubCategoryMasterDTOList;
        }
        return null;
    }
}

