/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdPrioritymetricsDAO;
import com.sapphireims.itsm.dao.ISdUipDetailsDAO;
import com.sapphireims.itsm.dao.ISdUipMasterDAO;
import com.sapphireims.itsm.dto.SdPrioritymetricsDTO;
import com.sapphireims.itsm.dto.SdUipMasterDTO;
import com.sapphireims.itsm.dto.UipRecordDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.model.SdPrioritymetrics;
import com.sapphireims.itsm.model.SdUipDetails;
import com.sapphireims.itsm.model.SdUipMaster;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.IUipService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UipService
implements IUipService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdUipMasterDAO sdUipMasterDAO;
    @Autowired
    private ISdUipDetailsDAO sdUipDetailsDAO;
    @Autowired
    private ISdPrioritymetricsDAO sdPrioritymetricsDAO;

    @Override
    @Transactional(readOnly=true)
    public SdUipMasterDTO getUIPById(Integer uipId, Integer projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdUipMaster master = (SdUipMaster)this.sdUipMasterDAO.get(uipId);
            if (master != null) {
                return new SdUipMasterDTO(master);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, " UIP Master not found for id " + uipId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %d", (Object[])new Object[]{projectId});
        return project.getUIPById(uipId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdUipMasterDTO getUIPByName(String uipName, Integer projectId, int type) throws DomainException, ValidationException {
        if (!this.cache) {
            SdUipMaster master = this.sdUipMasterDAO.getSdUipMasterByName(uipName, projectId);
            if (master != null) {
                return new SdUipMasterDTO(master);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, " UIP Master not found for Name " + uipName);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %d", (Object[])new Object[]{projectId});
        return project.getUIPByName(uipName, type);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdUipMasterDTO> getSdUipMasterByProjectId(Integer projectId, Integer type, Integer pageNo, Integer pageSize) throws DomainException, ValidationException {
        List<SdUipMaster> sdUipMasterList = this.sdUipMasterDAO.getSdUipMasterByProjectIdType(projectId, type, pageNo, pageSize);
        if (sdUipMasterList != null) {
            ArrayList<SdUipMasterDTO> sdCategoryMasterDTOS = new ArrayList<SdUipMasterDTO>();
            for (SdUipMaster sdUipMaster : sdUipMasterList) {
                sdCategoryMasterDTOS.add(new SdUipMasterDTO(sdUipMaster));
            }
            return sdCategoryMasterDTOS;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdUipDetails> getUipDetailsBySdUipMaster(Integer uipId) {
        return this.sdUipDetailsDAO.getUipDetailsBySdUipMaster(uipId);
    }

    @Override
    @Transactional
    public void deleteSdUIPDetails(Integer uipId) {
        List<SdUipDetails> sdUipDetailsList = this.getUipDetailsBySdUipMaster(uipId);
        for (SdUipDetails sdUipDetails : sdUipDetailsList) {
            this.sdUipDetailsDAO.deleteSdUIPDetails(sdUipDetails.getDetailsId());
        }
    }

    @Override
    @Transactional
    public void deleteSdUIPMaster(Integer uipId) {
        this.sdUipMasterDAO.deleteSdUIPmaster(uipId);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateUIPName(String uipName, Integer projectId, Integer type, Integer id) throws DomainException, ValidationException {
        return this.sdUipMasterDAO.checkDuplicateUIPName(uipName, projectId, type, id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdUipMasterDTO> getUIPbyServiceId(int type, int serviceId, Integer projectId) throws DomainException, ValidationException {
        List<SdUipMaster> sdUipMasterList = this.sdUipMasterDAO.getUIPbyServiceId(type, serviceId, projectId);
        ArrayList<SdUipMasterDTO> sdCategoryMasterDTOS = new ArrayList<SdUipMasterDTO>();
        if (CollectionUtil.isNotEmpty(sdUipMasterList)) {
            for (SdUipMaster sdUipMaster : sdUipMasterList) {
                sdCategoryMasterDTOS.add(new SdUipMasterDTO(sdUipMaster));
            }
        }
        return sdCategoryMasterDTOS;
    }

    @Override
    @Transactional(readOnly=true)
    public SdUipMaster getSdUipMasterByIdandType(int id, Integer type) {
        return this.sdUipMasterDAO.getSdUipMasterByIdandType(id, type);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdPrioritymetricsDTO> getSdPriorityMetricsForUrgencyAndImpact(Integer serviceId, Integer urgencyId, Integer impactId) throws DomainException, ValidationException {
        List<SdPrioritymetrics> sdPriorityMatrixList = this.sdPrioritymetricsDAO.getSdPriorityMetricsForUrgencyAndImpact(serviceId, urgencyId, impactId);
        ArrayList<SdPrioritymetricsDTO> sdPrioritymetricsDTO = new ArrayList<SdPrioritymetricsDTO>();
        if (CollectionUtil.isNotEmpty(sdPriorityMatrixList)) {
            for (SdPrioritymetrics priorityMatrix : sdPriorityMatrixList) {
                sdPrioritymetricsDTO.add(new SdPrioritymetricsDTO(priorityMatrix.getPriorityMetricsId(), priorityMatrix.getServiceId(), priorityMatrix.getUrgencyId(), priorityMatrix.getImpactId(), priorityMatrix.getPriorityId()));
            }
        }
        return sdPrioritymetricsDTO;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdPrioritymetricsDTO> getSdPrioritymetricsByServiceId(Integer serviceId) throws DomainException, ValidationException {
        List<SdPrioritymetrics> sdPriorityMatrixList = this.sdPrioritymetricsDAO.getSdPrioritymetricsByServiceId(serviceId);
        ArrayList<SdPrioritymetricsDTO> sdPrioritymetricsDTO = new ArrayList<SdPrioritymetricsDTO>();
        if (CollectionUtil.isNotEmpty(sdPriorityMatrixList)) {
            for (SdPrioritymetrics priorityMatrix : sdPriorityMatrixList) {
                sdPrioritymetricsDTO.add(new SdPrioritymetricsDTO(priorityMatrix.getPriorityMetricsId(), priorityMatrix.getServiceId(), priorityMatrix.getUrgencyId(), priorityMatrix.getImpactId(), priorityMatrix.getPriorityId()));
            }
        }
        return sdPrioritymetricsDTO;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdPrioritymetricsDTO> getSdPrioritymetricsByUrgencyImpact(Integer urgencyId, Integer impactId) throws DomainException, ValidationException {
        List<SdPrioritymetrics> sdPriorityMatrixList = this.sdPrioritymetricsDAO.getSdPrioritymetricsByUrgencyImpact(urgencyId, impactId);
        ArrayList<SdPrioritymetricsDTO> sdPrioritymetricsDTO = new ArrayList<SdPrioritymetricsDTO>();
        if (CollectionUtil.isNotEmpty(sdPriorityMatrixList)) {
            for (SdPrioritymetrics priorityMatrix : sdPriorityMatrixList) {
                sdPrioritymetricsDTO.add(new SdPrioritymetricsDTO(priorityMatrix.getPriorityMetricsId(), priorityMatrix.getServiceId(), priorityMatrix.getUrgencyId(), priorityMatrix.getImpactId(), priorityMatrix.getPriorityId()));
            }
            return sdPrioritymetricsDTO;
        }
        return sdPrioritymetricsDTO;
    }

    @Override
    @Transactional(readOnly=true)
    public List<UipRecordDTO> getSdUipMasterByProjectId(Integer projectId, Integer type, Integer pageNo, Integer pageSize, String columnSort, String sortDir) throws DomainException, ValidationException {
        List<UipRecordDTO> sdUipRecordDTO = this.sdUipMasterDAO.getUipRecordsSorted(projectId, type, pageNo, pageSize, columnSort, sortDir);
        if (sdUipRecordDTO != null) {
            return sdUipRecordDTO;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }
}

