/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.UserDetails;
import com.sapphire.itsm.mailrouting.model.UserMgmtMaster;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdProjectRolesDetailsDAO;
import com.sapphireims.itsm.dao.IUserDetailsDAO;
import com.sapphireims.itsm.dao.IUserMgmtMasterDAO;
import com.sapphireims.itsm.dto.SdConfigSettingsDTO;
import com.sapphireims.itsm.dto.SdProjectRolesDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.dto.user.UserDTO;
import com.sapphireims.itsm.dto.user.UserDetailsDTO;
import com.sapphireims.itsm.mindto.ProjectMinDTO;
import com.sapphireims.itsm.mindto.ProjectRolesMinDTO;
import com.sapphireims.itsm.service.IDepartmentMasterService;
import com.sapphireims.itsm.service.ILocationService;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.ISdProjectRolesService;
import com.sapphireims.itsm.service.IUserProjectService;
import com.sapphireims.itsm.service.IUserService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserProjectService
implements IUserProjectService {
    private static final String INVALID_USER_MANGMENT_MASTER_S = "Invalid User Management master %s";
    private static final String INVALID_USER_ID_S = "Invalid User id %s";
    private static final String NLP_ENABLE = "NLPEnable";
    @Autowired
    private ISdProjectMasterDAO sdProjectMasterDAO;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdProjectRolesService projectRolesService;
    @Autowired
    private ISdProjectRolesDetailsDAO sdProjectRolesDAO;
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserMgmtMasterDAO userMgmtMasterDAO;
    @Autowired
    private IDepartmentMasterService departmentService;
    @Autowired
    private ILocationService locationService;
    @Autowired
    private IUserDetailsDAO userDetailsDAO;

    @Override
    @Transactional(readOnly=true)
    public List<ProjectMinDTO> getAllUsersProjects(Integer userId) throws DomainException, ValidationException {
        List<ProjectMinDTO> projects = this.sdProjectMasterDAO.getAllUsersProjects(userId);
        if (CollectionUtil.isNotEmpty(projects)) {
            for (ProjectMinDTO md : projects) {
                ProjectDTO p = this.projectMasterService.getProjectMetaData(md.getProjectId());
                SdConfigSettingsDTO settings = p.isSettingEnbeledForProject(NLP_ENABLE);
                if (settings != null && settings.getSettingValue() != null && !settings.getSettingValue().equals("0")) {
                    md.setNlp(true);
                }
                md.setColor(p.getColor());
                md.setImage(p.getImage());
            }
            return projects;
        }
        return new ArrayList<ProjectMinDTO>();
    }

    @Override
    @Transactional(readOnly=true)
    public UserDetailsDTO getUser(Integer id, Integer projectId) throws DomainException, ValidationException {
        Validate.notNull((Object)id);
        UserDetails userDetails = (UserDetails)this.userDetailsDAO.get((Serializable)id);
        Validate.notNull((Object)userDetails, (String)INVALID_USER_ID_S, (Object[])new Object[]{id});
        UserMgmtMaster userMgmtMaster = this.userMgmtMasterDAO.getUserMgmtMasterByUserDetailsId(id);
        Validate.notNull((Object)userMgmtMaster, (String)INVALID_USER_MANGMENT_MASTER_S, (Object[])new Object[]{id});
        UserDetailsDTO userDto = new UserDetailsDTO(userDetails, userMgmtMaster);
        if (userMgmtMaster.getDepartmentId() != 0) {
            userDto.setDepartment(this.departmentService.getDepartmentById(Integer.valueOf(userMgmtMaster.getDepartmentId())));
        }
        if (userMgmtMaster.getLocationId() != 0) {
            userDto.setLocation(this.locationService.getLocationById(Integer.valueOf(userMgmtMaster.getLocationId())));
        }
        if (userMgmtMaster.getManagerId() != 0) {
            userDto.setManager(this.userService.getManager(Integer.valueOf(userMgmtMaster.getManagerId())));
        }
        List<SdProjectRolesDTO> rls = this.projectRolesService.getProjectRolesForUser(id, projectId);
        ArrayList<ProjectRolesMinDTO> roles = null;
        if (CollectionUtil.isNotEmpty(rls)) {
            roles = new ArrayList<ProjectRolesMinDTO>(rls.size());
            for (SdProjectRolesDTO r : rls) {
                roles.add(new ProjectRolesMinDTO(r));
            }
        }
        userDto.setRoles(roles);
        this.userService.setUserAdditionalField((UserDTO)userDto);
        return userDto;
    }
}

