/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.itsm.dao.IValidationScriptDetailsDAO;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.service.ICopyAndCompressFilesService;
import com.sapphireims.itsm.service.IValidationScriptService;
import com.sapphireims.modulecopy.dto.ModuleCopyAttachmentsDTO;
import com.sapphireims.validationScripting.model.ValidationscriptDetails;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ValidationScriptService
implements IValidationScriptService {
    @Autowired
    protected IValidationScriptDetailsDAO validationScriptDetailsDAO;
    @Autowired
    protected ICopyAndCompressFilesService copyAndCompressFilesService;
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateRepositoryOperations;

    private String getWarFilePath() {
        String exactpath = new String("");
        try {
            String myclassname = "SapUtil.class";
            String myClassPath = "/WEB-INF/classes/com/sapphireims/util/";
            String className = "";
            String filePath = "";
            URL url = ValidationScriptService.class.getResource(myclassname);
            className = url.getFile();
            filePath = className.substring(0, className.indexOf(myClassPath + myclassname));
            String sub_string = URLDecoder.decode(filePath, "UTF8");
            exactpath = sub_string.substring(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exactpath;
    }

    @Override
    public List<ValidationscriptDetails> getValidationScriptDetailsById(Integer scriptId, ProjectExportRequestDTO pDTO) {
        ModuleCopyAttachmentsDTO mcaDTO = pDTO.getMcaDTO();
        ArrayList<ValidationscriptDetails> validationscriptDetailsList = new ArrayList<ValidationscriptDetails>();
        ValidationscriptDetails validationscriptDetailsObj = this.validationScriptDetailsDAO.getValidationScriptDetailsById(scriptId);
        ValidationscriptDetails vsd1 = (ValidationscriptDetails)((Object)((HibernateProxy)validationscriptDetailsObj).getHibernateLazyInitializer().getImplementation());
        validationscriptDetailsList.add(vsd1);
        if (mcaDTO != null) {
            Object customerAliasName = "";
            if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                customerAliasName = mcaDTO.getCustomerAliasName() + "\\";
            }
            String sourcePath = mcaDTO.getWarFilePath() + "\\js\\CustomScripts\\" + (String)customerAliasName;
            String sourceMobileAppPath = mcaDTO.getMobileAppWar();
            String destinationPath = this.copyAndCompressFilesService.getDestinationDirectoryPath();
            for (ValidationscriptDetails vsd : validationscriptDetailsList) {
                if (vsd.getScripttype() != 1) continue;
                String oldUIPath = sourcePath + "CustomScript_" + vsd.getScriptid() + ".js";
                String newUIPath = sourcePath + "CustomScript_" + vsd.getScriptid() + "_NEWUI.js";
                String mobileAppPath = sourcePath + "CustomScript_" + vsd.getScriptid() + "_MOBILE.js";
                File oldUIFile = new File(oldUIPath);
                File newUIFile = new File(newUIPath);
                File mobileAppFile = new File(mobileAppPath);
                try {
                    if (oldUIFile.exists() && !oldUIFile.isDirectory()) {
                        FileUtils.copyFile((File)oldUIFile, (File)FileUtils.getFile((String[])new String[]{destinationPath + "\\CustomScript_" + vsd.getScriptid() + ".js"}));
                    }
                    if (newUIFile.exists() && !newUIFile.isDirectory()) {
                        FileUtils.copyFile((File)newUIFile, (File)FileUtils.getFile((String[])new String[]{destinationPath + "\\CustomScript_" + vsd.getScriptid() + "_NEWUI.js"}));
                    }
                    if (!mobileAppFile.exists() || mobileAppFile.isDirectory()) continue;
                    FileUtils.copyFile((File)mobileAppFile, (File)FileUtils.getFile((String[])new String[]{destinationPath + "\\CustomScript_" + vsd.getScriptid() + "_MOBILE.js"}));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return validationscriptDetailsList;
    }

    @Override
    public void replaceAndUpdateValidationScriptFiles(Map<Integer, ValidationscriptDetails> oldIdValidationScriptDetailsForScriptsMap, ProjectExportRequestDTO pReq) {
        ModuleCopyAttachmentsDTO mcaDTO = pReq.getMcaDTO();
        if (oldIdValidationScriptDetailsForScriptsMap != null && mcaDTO != null) {
            Object customerAliasName = "";
            if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                customerAliasName = "\\" + mcaDTO.getCustomerAliasName();
            }
            String sourcePath = mcaDTO.getWarFilePath() + "\\js\\CustomScripts" + (String)customerAliasName;
            String fileLoc = mcaDTO.getModulePath();
            for (Map.Entry<Integer, ValidationscriptDetails> entry : oldIdValidationScriptDetailsForScriptsMap.entrySet()) {
                ValidationscriptDetails vsd = entry.getValue();
                Integer oldScriptId = entry.getKey();
                File oldUIFromCopy = new File(fileLoc + "\\CustomScript_" + oldScriptId + ".js");
                File newUIFromCopy = new File(fileLoc + "\\CustomScript_" + oldScriptId + "_NEWUI.js");
                File mobileAppFromCopy = new File(fileLoc + "\\CustomScript_" + oldScriptId + "_MOBILE.js");
                try {
                    if (oldUIFromCopy.exists() && !oldUIFromCopy.isDirectory()) {
                        FileUtils.copyFile((File)oldUIFromCopy, (File)FileUtils.getFile((String[])new String[]{sourcePath + "\\CustomScript_" + vsd.getScriptid() + ".js"}));
                    }
                    if (newUIFromCopy.exists() && !newUIFromCopy.isDirectory()) {
                        FileUtils.copyFile((File)newUIFromCopy, (File)FileUtils.getFile((String[])new String[]{sourcePath + "\\CustomScript_" + vsd.getScriptid() + "_NEWUI.js"}));
                    }
                    if (!mobileAppFromCopy.exists() || mobileAppFromCopy.isDirectory()) continue;
                    FileUtils.copyFile((File)mobileAppFromCopy, (File)FileUtils.getFile((String[])new String[]{sourcePath + "\\CustomScript_" + vsd.getScriptid() + "_MOBILE.js"}));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

