/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdWorkgroupMasterDAO;
import com.sapphireims.itsm.dto.SdWorkgroupMasterDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.dto.ticket.TicketDTO;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import com.sapphireims.itsm.model.SdWorkgroupdetails;
import com.sapphireims.itsm.model.SdWorkgroupmaster;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.IWorkGroupService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkGroupService
implements IWorkGroupService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdWorkgroupMasterDAO workgroupMasterDAO;

    @Override
    @Transactional(readOnly=true)
    public SdWorkgroupMasterDTO getWorkgroupById(Integer workGroupId, Integer projectId) throws DomainException, ValidationException {
        if (this.cache) {
            ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
            Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
            return project.getWorkGroupById(workGroupId);
        }
        SdWorkgroupmaster master = (SdWorkgroupmaster)this.workgroupMasterDAO.get(workGroupId);
        Validate.notNull((Object)((Object)master), (String)"Invalid SdWorkroupmaster Id %s for Project id %s ", (Object[])new Object[]{workGroupId, projectId});
        return new SdWorkgroupMasterDTO(master);
    }

    @Override
    @Transactional(readOnly=true)
    public SdWorkgroupMasterDTO getWorkgroupByName(String workGroupName, Integer projectId) throws DomainException, ValidationException {
        if (this.cache) {
            ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
            Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
            return project.getWorkGroupByName(workGroupName);
        }
        SdWorkgroupmaster master = this.workgroupMasterDAO.getWorkgroupMasterByName(workGroupName, projectId);
        Validate.notNull((Object)((Object)master), (String)"Invalid SdWorkroupmaster name  %s  and  %s Project id ", (Object[])new Object[]{workGroupName, projectId});
        return new SdWorkgroupMasterDTO(master);
    }

    @Override
    @Transactional(readOnly=true)
    public SdWorkgroupMasterDTO getDefaultWorkGroup(TicketDTO t, boolean isUpdate, boolean isStateChange, SdServiceReqMaster req) throws DomainException, ValidationException {
        SdWorkgroupMasterDTO ret = null;
        List<SdWorkgroupmaster> listWM = this.workgroupMasterDAO.listOfWorkgroup(req.getSdProjectMaster().getProjectId());
        for (SdWorkgroupmaster wm : listWM) {
            int groupID = wm.getWorkGroupId();
            int isParameterMatched = 0;
            isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 1, req.getSdService().getServiceId());
            if (isParameterMatched == 1 && (isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 2, req.getCategory()).intValue()) == 1 && (isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 3, req.getSubCategory()).intValue()) == 1 && (isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 4, req.getLocationId()).intValue()) == 1 && (isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 5, req.getDepartmentId()).intValue()) == 1 && (isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 8, req.getDerivedField1()).intValue()) == 1 && (isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 9, req.getDerivedField2()).intValue()) == 1) {
                isParameterMatched = this.workgroupMasterDAO.getWorkGroupParameterMatched(groupID, 10, req.getDerivedField3());
            }
            if (isParameterMatched != 1) continue;
            ret = new SdWorkgroupMasterDTO(wm);
            break;
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateWorkgroupName(String workgroupName, Integer projectId) throws DomainException, ValidationException {
        Integer isDuplicate = 0;
        List<SdWorkgroupmaster> list = this.workgroupMasterDAO.checkDuplicateWorkgroupName(workgroupName, projectId);
        if (CollectionUtil.isNotEmpty(list)) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    @Transactional(readOnly=true)
    public SdWorkgroupmaster getSdWorkgroupMasterByWorkgroupID(Integer workGroupID) throws DomainException, ValidationException {
        return this.workgroupMasterDAO.getSdWorkgroupMasterByWorkgroupID(workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public SdWorkgroupdetails getWorkGroupValueByType(int workGroupType, Integer workGroupID) throws DomainException, ValidationException {
        return this.workgroupMasterDAO.getWorkGroupValueByType(workGroupType, workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdWorkgroupMasterDTO> getSdWorkgroupMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) throws DomainException, ValidationException {
        List<SdWorkgroupmaster> rls = this.workgroupMasterDAO.getSdWorkgroupMasterByProjectId(projectId, pageNo, pageSize, sortColumn, sortDir);
        if (CollectionUtil.isNotEmpty(rls)) {
            ArrayList<SdWorkgroupMasterDTO> ret = new ArrayList<SdWorkgroupMasterDTO>(rls.size());
            for (SdWorkgroupmaster r : rls) {
                ret.add(new SdWorkgroupMasterDTO(r));
            }
            return ret;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }
}

