/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.model.rpa;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.rpa.RpaEventDTO;
import com.sapphireims.itsm.model.enummodel.PostAction;
import com.sapphireims.model.BaseModel;
import com.sapphireims.model.rpa.RpaProcess;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="rpa_event")
public class RpaEvent
extends BaseModel {
    private static final long serialVersionUID = -6684436741795445253L;
    private Integer id;
    private RpaProcess rpaProcess;
    private int projectId;
    private String eventType;
    private String stateIds;
    private String description;
    private PostAction actiontype;
    private boolean asynchronous = true;
    private int assetModuleId;
    private int isCMDB;

    private RpaEvent(Builder builder) {
        this.id = builder.id;
        this.rpaProcess = builder.rpaProcess;
        this.projectId = builder.projectId;
        this.eventType = builder.eventType;
        this.stateIds = builder.stateIds;
        this.description = builder.description;
        this.actiontype = builder.actiontype;
        this.asynchronous = builder.asynchronous;
        this.assetModuleId = builder.assetModuleId;
    }

    public RpaEvent() {
    }

    public RpaEvent(RpaProcess rpaProcess, int projectId, String eventType) {
        this.rpaProcess = rpaProcess;
        this.projectId = projectId;
        this.eventType = eventType;
    }

    public RpaEvent(RpaProcess rpaProcess, int projectId, String eventType, String stateIds, String description, PostAction actiontype) {
        this.rpaProcess = rpaProcess;
        this.projectId = projectId;
        this.eventType = eventType;
        this.stateIds = stateIds;
        this.description = description;
        this.actiontype = actiontype;
    }

    public RpaEvent(RpaEventDTO e, RpaProcess rpaProcess, SdProjectMaster pr) {
        this.stateIds = e.getStateIds();
        this.projectId = pr.getProjectId();
        this.eventType = e.getEventType();
        this.description = e.getDescription();
        this.id = e.getId();
        this.rpaProcess = rpaProcess;
        this.asynchronous = e.isAsynchronous();
    }

    public void copy(RpaEventDTO e) {
        this.stateIds = e.getStateIds();
        this.projectId = e.getProjectId();
        this.eventType = e.getEventType();
        this.stateIds = e.getStateIds();
        this.description = e.getDescription();
        this.id = e.getId();
        this.asynchronous = e.isAsynchronous();
    }

    public RpaEvent(RpaProcess rpaProcess, int projectId, String eventType, String stateIds, String description, PostAction actiontype, int assetModuleId, int isCMDB) {
        this.rpaProcess = rpaProcess;
        this.projectId = projectId;
        this.eventType = eventType;
        this.stateIds = stateIds;
        this.description = description;
        this.actiontype = actiontype;
        this.assetModuleId = assetModuleId;
        this.isCMDB = isCMDB;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rpa_process_id", nullable=false)
    public RpaProcess getRpaProcess() {
        return this.rpaProcess;
    }

    public void setRpaProcess(RpaProcess rpaProcess) {
        this.rpaProcess = rpaProcess;
    }

    @Column(name="project_id", nullable=false)
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Column(name="event_type", nullable=false, length=15)
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Column(name="state_ids", length=500)
    public String getStateIds() {
        return this.stateIds;
    }

    public void setStateIds(String stateIds) {
        this.stateIds = stateIds;
    }

    @Column(name="description", length=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="action_type", nullable=false, length=5)
    @Enumerated(value=EnumType.STRING)
    public PostAction getActiontype() {
        return this.actiontype;
    }

    @Column(name="asynchronous")
    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public void setActiontype(PostAction actiontype) {
        this.actiontype = actiontype;
    }

    @Column(name="assetModuleId", nullable=false)
    public int getAssetModuleId() {
        return this.assetModuleId;
    }

    public void setAssetModuleId(int assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    @Column(name="isCMDB", nullable=false)
    public int getIsCMDB() {
        return this.isCMDB;
    }

    public void setIsCMDB(int isCMDB) {
        this.isCMDB = isCMDB;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private RpaProcess rpaProcess;
        private int projectId;
        private String eventType;
        private String stateIds;
        private String description;
        private PostAction actiontype;
        private boolean asynchronous;
        private int assetModuleId;
        private int isCMDB;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withRpaProcess(RpaProcess rpaProcess) {
            this.rpaProcess = rpaProcess;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withStateIds(String stateIds) {
            this.stateIds = stateIds;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withActiontype(PostAction actiontype) {
            this.actiontype = actiontype;
            return this;
        }

        public Builder withAsynchronous(boolean asynchronous) {
            this.asynchronous = asynchronous;
            return this;
        }

        public Builder withAssetModuleId(int assetModuleId) {
            this.assetModuleId = assetModuleId;
            return this;
        }

        public Builder withIsCMDB(int isCMDB) {
            this.isCMDB = isCMDB;
            return this;
        }

        public RpaEvent build() {
            return new RpaEvent(this);
        }
    }
}

