/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.model.rpa;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.rpa.RpaProcessDTO;
import com.sapphireims.model.BaseModel;
import com.sapphireims.model.rpa.ProcessType;
import com.sapphireims.model.rpa.RpaEvent;
import com.sapphireims.util.StringUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Set;

@Entity
@Table(name="rpa_process")
public class RpaProcess
extends BaseModel {
    private static final long serialVersionUID = 4006320536165336197L;
    private Integer id;
    private String name;
    private String description;
    private int projectId;
    private String process;
    private ProcessType type;
    private String externalRefId;
    private boolean active;
    private String processId;
    private int assetModuleId;
    private int isCMDB;
    private Set<RpaEvent> events;

    private RpaProcess(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.projectId = builder.projectId;
        this.process = builder.process;
        this.type = builder.type;
        this.externalRefId = builder.externalRefId;
        this.active = builder.active;
        this.processId = builder.processId;
        this.assetModuleId = builder.assetModuleId;
        this.isCMDB = builder.isCMDB;
    }

    public RpaProcess() {
    }

    public RpaProcess(String name, int projectId, String process, ProcessType type, String externalRefId, boolean active, String processId) {
        this.name = name;
        this.projectId = projectId;
        this.process = process;
        this.type = type;
        this.externalRefId = externalRefId;
        this.active = active;
        this.processId = processId;
    }

    public RpaProcess(RpaProcessDTO p) {
        this.name = p.getName();
        this.description = p.getDescription();
        this.projectId = p.getProjectId();
        this.process = p.getProcess();
        this.type = p.getType();
        this.externalRefId = p.getExternalRefId();
        this.active = p.isActive();
        this.processId = p.getProcessId() == null ? "" : p.getProcessId();
        this.assetModuleId = p.getAssetModuleId();
        this.isCMDB = p.getIsCMDB();
    }

    public RpaProcess(RpaProcessDTO p, SdProjectMaster sdProjectMaster) {
        this.id = p.getId();
        this.name = p.getName();
        this.description = p.getDescription();
        this.projectId = sdProjectMaster.getProjectId();
        this.process = p.getProcess();
        this.type = p.getType();
        this.externalRefId = p.getExternalRefId();
        this.active = p.isActive();
        this.processId = p.getProcessId() == null ? "" : p.getProcessId();
    }

    public void copy(RpaProcessDTO p) {
        this.name = p.getName();
        this.description = p.getDescription();
        this.projectId = p.getProjectId();
        this.process = p.getProcess();
        this.type = p.getType();
        this.externalRefId = p.getExternalRefId();
        this.active = p.isActive();
        if (StringUtil.isEmpty((String)this.processId) && !StringUtil.isEmpty((String)p.getProcessId())) {
            this.processId = p.getProcessId();
        }
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="description", length=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="project_id", nullable=false)
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Column(name="process", nullable=false)
    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    @Column(name="type", nullable=false, length=5)
    @Enumerated(value=EnumType.STRING)
    public ProcessType getType() {
        return this.type;
    }

    public void setType(ProcessType type) {
        this.type = type;
    }

    @Column(name="external_ref_id", nullable=false, length=200)
    public String getExternalRefId() {
        return this.externalRefId;
    }

    public void setExternalRefId(String externalRefId) {
        this.externalRefId = externalRefId;
    }

    @Column(name="active", nullable=false)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="processId", nullable=false)
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="rpaProcess")
    public Set<RpaEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Set<RpaEvent> events) {
        this.events = events;
    }

    @Column(name="assetModuleId", nullable=false)
    public int getAssetModuleId() {
        return this.assetModuleId;
    }

    public void setAssetModuleId(int assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    @Column(name="isCMDB", nullable=false)
    public int getIsCMDB() {
        return this.isCMDB;
    }

    public void setIsCMDB(int isCMDB) {
        this.isCMDB = isCMDB;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private String name;
        private String description;
        private int projectId;
        private String process;
        private ProcessType type;
        private String externalRefId;
        private boolean active;
        private String processId;
        private int assetModuleId;
        private int isCMDB;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProcess(String process) {
            this.process = process;
            return this;
        }

        public Builder withType(ProcessType type) {
            this.type = type;
            return this;
        }

        public Builder withExternalRefId(String externalRefId) {
            this.externalRefId = externalRefId;
            return this;
        }

        public Builder withActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder withProcessId(String processId) {
            this.processId = processId;
            return this;
        }

        public Builder withAssetModuleId(int assetModuleId) {
            this.assetModuleId = assetModuleId;
            return this;
        }

        public Builder withIsCMDB(int isCMDB) {
            this.isCMDB = isCMDB;
            return this;
        }

        public RpaProcess build() {
            return new RpaProcess(this);
        }
    }
}

