/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.dao.impl;

import com.sapphire.dashboard.model.DashboardFilters;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardFiltersDAO;
import com.sapphireims.util.CollectionUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.stereotype.Repository;

@Repository
public class DashboardFiltersDAO
extends GenericHibernateRepository<DashboardFilters, Integer>
implements IDashboardFiltersDAO {
    @Override
    public DashboardFilters getDashboardFiltersById(Integer filterId) {
        String query = "from DashboardFilters where filterId=:filterId";
        Object[] params = new Object[]{filterId};
        String[] paramNames = new String[]{"filterId"};
        return (DashboardFilters)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, params, DashboardFilters.class));
    }

    @Override
    public DashboardFilters isFilterNameExist(String filterName) {
        String query = "from DashboardFilters where filterName=:filterName";
        Object[] params = new Object[]{filterName};
        String[] paramNames = new String[]{"filterName"};
        List dfList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, params, DashboardFilters.class);
        if (CollectionUtil.isNotEmpty(dfList)) {
            return (DashboardFilters)((Object)dfList.getFirst());
        }
        return null;
    }

    @Override
    public List<DashboardFilters> getDashboardFiltersByIds(List<Integer> filterIds) {
        String query = "from DashboardFilters where filterId in (:filterId)";
        Object[] params = new Object[]{filterIds};
        String[] paramNames = new String[]{"filterId"};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, params, DashboardFilters.class);
    }

    @Override
    public List<DashboardFilters> getDashboardFiltersByIdsList(List<String> filterIds) {
        List filterIdsLilst = filterIds.stream().filter(Objects::nonNull).map(NumberUtils::toInt).collect(Collectors.toList());
        String query = "from DashboardFilters where filterId in (:filterId)";
        Object[] params = new Object[]{filterIdsLilst};
        String[] paramNames = new String[]{"filterId"};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, params, DashboardFilters.class);
    }
}

