/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.dao.impl;

import com.sapphire.dashboard.model.DashboardHistory;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardHistoryDAO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class DashboardHistoryDAO
extends GenericHibernateRepository<DashboardHistory, Integer>
implements IDashboardHistoryDAO {
    @Override
    public List<DashboardHistory> getDashboardHistoryOnRange(String fromDate, String toDate, Integer projectId, Integer dashboardId) throws DomainException, ValidationException {
        Date from = new Date();
        Date to = new Date();
        try {
            from = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(fromDate);
            to = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(toDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        String query = "from DashboardHistory where currentTime Between :fromDate and :toDate and projectId=:projectId and dashboardId=:dashboardId";
        Object[] params = new Object[]{from, to, projectId, dashboardId};
        String[] paramNames = new String[]{"fromDate", "toDate", "projectId", "dashboardId"};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, params, DashboardHistory.class);
    }
}

