/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sapphire.dashboard.model.Dashboardconfiguration;
import com.sapphire.dashboard.model.DashboardconfigurationAccessDetails;
import com.sapphire.dashboard.model.DashboardconfigurationDetails;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardconfigurationAccessDetailsDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardconfigurationDetailsDTO;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardConfigurationTypeENUM;
import com.sapphireims.util.CollectionUtil;
import java.util.LinkedList;
import java.util.List;

public class DashboardConfigDTO
extends BaseDTO {
    private Integer dashboardDetailsId;
    private int dashboardId;
    private String dashboardName;
    private byte isVisible;
    private int displayOrder;
    private DashboardConfigurationTypeENUM dashboardtype;
    private int row;
    private int columnValue;
    private int xaxis;
    private int yaxis;
    private int isCustomDashboard;
    private int projectid;
    private int userid;
    @JsonProperty(value="dashboardConfigurationDetails")
    private List<DashboardconfigurationDetailsDTO> dashboardConfigurationDetails;
    @JsonProperty(value="dashboardConfigurationAccessDetails")
    private List<DashboardconfigurationAccessDetailsDTO> dashboardConfigurationAccessDetails;

    public DashboardConfigDTO() {
    }

    public DashboardConfigDTO(Integer dashboardDetailsId, int dashboardId, String dashboardName, byte isVisible, int displayOrder, int dashboardtype, int row, int columnValue, int xaxis, int yaxis, int isCustomDashboard, int projectid, int userid, String users, String roles) {
        this.dashboardDetailsId = dashboardDetailsId;
        this.dashboardId = dashboardId;
        this.dashboardName = dashboardName;
        this.isVisible = isVisible;
        this.displayOrder = displayOrder;
        this.dashboardtype = DashboardConfigurationTypeENUM.getWidgetAccessTypeENUM(dashboardtype);
        this.row = row;
        this.columnValue = columnValue;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.isCustomDashboard = isCustomDashboard;
        this.projectid = projectid;
        this.userid = userid;
    }

    public DashboardConfigDTO(Dashboardconfiguration dc, List<DashboardconfigurationDetails> dcdList, List<DashboardconfigurationAccessDetails> dcadList) {
        this.dashboardDetailsId = dc.getDashboardDetailsId();
        this.dashboardId = dc.getDashboardId();
        this.dashboardName = dc.getDashboardName();
        this.isVisible = dc.getIsVisible();
        this.displayOrder = dc.getDisplayOrder();
        this.dashboardtype = DashboardConfigurationTypeENUM.getWidgetAccessTypeENUM(dc.getDashboardtype());
        this.columnValue = dc.getColumnValue();
        this.xaxis = dc.getXaxis();
        this.yaxis = dc.getYaxis();
        this.isCustomDashboard = dc.getIsCustomDashboard();
        this.projectid = dc.getProjectid();
        this.userid = dc.getUserid();
        if (CollectionUtil.isNotEmpty(dcdList)) {
            this.dashboardConfigurationDetails = new LinkedList<DashboardconfigurationDetailsDTO>();
            dcdList.forEach(dcd -> this.dashboardConfigurationDetails.add(new DashboardconfigurationDetailsDTO((DashboardconfigurationDetails)((Object)dcd))));
        }
        if (CollectionUtil.isNotEmpty(dcadList)) {
            this.dashboardConfigurationAccessDetails = new LinkedList<DashboardconfigurationAccessDetailsDTO>();
            dcadList.forEach(dcad -> this.dashboardConfigurationAccessDetails.add(new DashboardconfigurationAccessDetailsDTO((DashboardconfigurationAccessDetails)((Object)dcad))));
        }
    }

    @JsonIgnore
    public Dashboardconfiguration getDashboardconfiguration() {
        Dashboardconfiguration dc = new Dashboardconfiguration();
        dc.setDashboardId(this.dashboardId);
        dc.setDashboardName(this.dashboardName);
        dc.setIsVisible(this.isVisible);
        dc.setDisplayOrder(this.displayOrder);
        dc.setDashboardtype(this.dashboardtype.getValue());
        dc.setColumnValue(this.columnValue);
        dc.setXaxis(this.xaxis);
        dc.setYaxis(this.yaxis);
        dc.setIsCustomDashboard(this.isCustomDashboard);
        dc.setProjectid(this.projectid);
        dc.setUserid(0);
        return dc;
    }

    public Integer getDashboardDetailsId() {
        return this.dashboardDetailsId;
    }

    public void setDashboardDetailsId(Integer dashboardDetailsId) {
        this.dashboardDetailsId = dashboardDetailsId;
    }

    public int getDashboardId() {
        return this.dashboardId;
    }

    public void setDashboardId(int dashboardId) {
        this.dashboardId = dashboardId;
    }

    public String getDashboardName() {
        return this.dashboardName;
    }

    public void setDashboardName(String dashboardName) {
        this.dashboardName = dashboardName;
    }

    public byte getIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(byte isVisible) {
        this.isVisible = isVisible;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public DashboardConfigurationTypeENUM getDashboardtype() {
        return this.dashboardtype;
    }

    public void setDashboardtype(DashboardConfigurationTypeENUM dashboardtype) {
        this.dashboardtype = dashboardtype;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getColumnValue() {
        return this.columnValue;
    }

    public void setColumnValue(int columnValue) {
        this.columnValue = columnValue;
    }

    public int getXaxis() {
        return this.xaxis;
    }

    public void setXaxis(int xaxis) {
        this.xaxis = xaxis;
    }

    public int getYaxis() {
        return this.yaxis;
    }

    public void setYaxis(int yaxis) {
        this.yaxis = yaxis;
    }

    public int getIsCustomDashboard() {
        return this.isCustomDashboard;
    }

    public void setIsCustomDashboard(int isCustomDashboard) {
        this.isCustomDashboard = isCustomDashboard;
    }

    public int getProjectid() {
        return this.projectid;
    }

    public void setProjectid(int projectid) {
        this.projectid = projectid;
    }

    public int getUserid() {
        return this.userid;
    }

    public void setUserid(int userid) {
        this.userid = userid;
    }

    public List<DashboardconfigurationDetailsDTO> getDashboardConfigurationDetails() {
        return this.dashboardConfigurationDetails;
    }

    public void setDashboardConfigurationDetails(List<DashboardconfigurationDetailsDTO> dashboardConfigurationDetails) {
        this.dashboardConfigurationDetails = dashboardConfigurationDetails;
    }

    public List<DashboardconfigurationAccessDetailsDTO> getDashboardConfigurationAccessDetails() {
        return this.dashboardConfigurationAccessDetails;
    }

    public void setDashboardConfigurationAccessDetails(List<DashboardconfigurationAccessDetailsDTO> dashboardConfigurationAccessDetails) {
        this.dashboardConfigurationAccessDetails = dashboardConfigurationAccessDetails;
    }

    public Integer getId() {
        return this.getDashboardDetailsId();
    }

    public void setId(Integer id) {
        this.setDashboardDetailsId(id);
    }
}

