/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.service.impl;

import com.sapphire.dashboard.model.DashboardconfigurationDetails;
import com.sapphire.dashboard.model.Dashboardmaster;
import com.sapphire.dashboard.model.Dashboardwidgetmapping;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardMasterDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardWidgetMappingDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigurationDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardConfigurationService;
import com.sapphireims.util.CollectionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardConfigurationServices
implements IDashboardConfigurationService {
    @Autowired
    private IDashboardconfigDAO dashboardconfigDAO;
    @Autowired
    private IDashboardMasterDAO dashboardMasterDAO;
    @Autowired
    private IDashboardconfigurationDetailsDAO dashboardconfigurationDetailsDAO;
    @Autowired
    private IDashboardWidgetMappingDAO dashboardWidgetMappingDAO;

    @Override
    public List<Integer> getWidgetsIds(List<Integer> globalRoles, List<Integer> itsmRoles, List<Integer> assetsRoles, Integer dashboardId, Integer userId) throws DomainException, ValidationException {
        List<Dashboardwidgetmapping> dwmList;
        String accessSubQuery;
        String dashboardQuery;
        List<DashboardconfigurationDetails> dcdList;
        LinkedList<Integer> mappedWidgetIds = new LinkedList();
        Dashboardmaster dm = (Dashboardmaster)this.dashboardMasterDAO.get(dashboardId);
        String addExisting = "=:roleDashboardId";
        if (dm.getIsDefault() == 1) {
            addExisting = " in (:roleDashboardId, 0)";
        }
        String accessRoles = "0";
        if (CollectionUtil.isNotEmpty(globalRoles)) {
            accessRoles = globalRoles.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        }
        String ITSMRoles = "0";
        if (CollectionUtil.isNotEmpty(itsmRoles)) {
            ITSMRoles = itsmRoles.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        }
        String CMDBRoles = "0";
        if (CollectionUtil.isNotEmpty(assetsRoles)) {
            CMDBRoles = assetsRoles.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        }
        if (CollectionUtil.isNotEmpty(dcdList = this.dashboardconfigurationDetailsDAO.getDashboardBasedWidgets(dashboardQuery = "select dcd from DashboardconfigurationDetails dcd, DashboardconfigurationAccessDetails dcad,SdProjectMaster sdp where dcd.dashboardconfiguration.dashboardDetailsId = dcad.dashboardconfiguration.dashboardDetailsId and dcd.dashboardconfiguration.isCustomDashboard = 1 " + (accessSubQuery = " and ( ( dcad.accessType = 1 and dcad.accessValue = :userId) or ( dcad.accessType = 2 and dcad.accessValue in (" + accessRoles + ") ) or ( dcad.accessType = 4 and dcad.accessValue in (" + ITSMRoles + ") ) or ( dcad.accessType = 5 and dcad.accessValue in (" + CMDBRoles + ") ) or ( dcad.accessType = 6 and dcad.accessValue = :userId) or ( dcad.accessType = 7 and dcad.accessValue in (" + accessRoles + ") ) or ( dcad.accessType = 3 and dcad.accessValue in (" + ITSMRoles + ") ) or ( dcad.accessType = 8 and dcad.accessValue in (" + CMDBRoles + ") ) ) ") + " and dcd.dashboardconfiguration.projectid = sdp.projectId and sdp.status=0 and dcad.dashboardGroupId" + addExisting + " group by dcd.dashboardconfiguration.dashboardDetailsId order by dcd.dashboardconfiguration.dashboardName ", userId, dashboardId))) {
            mappedWidgetIds = dcdList.stream().filter(Objects::nonNull).map(details -> details.getDashboardconfiguration().getDashboardDetailsId()).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(dwmList = this.dashboardWidgetMappingDAO.getDashboardWidgetMappingList(dm.getDashboardId(), dm.getProjectId()))) {
            for (Dashboardwidgetmapping dwm : dwmList) {
                if (mappedWidgetIds.contains(dwm.getWidgetId())) continue;
                mappedWidgetIds.add(dwm.getWidgetId());
            }
        }
        return mappedWidgetIds;
    }
}

