/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.service.impl;

import com.sapphire.dashboard.model.DashboardFilters;
import com.sapphire.dashboard.model.Dashboardconfiguration;
import com.sapphire.dashboard.model.DashboardconfigurationAccessDetails;
import com.sapphire.dashboard.model.DashboardconfigurationDetails;
import com.sapphire.dashboard.model.Dashboardfiltermapping;
import com.sapphire.dashboard.model.Dashboardmaster;
import com.sapphire.dashboard.model.Dashboardrepository;
import com.sapphire.dashboard.model.DashboardtemplateMacrodetails;
import com.sapphire.dashboard.model.DashboardtemplateQuicklinks;
import com.sapphire.dashboard.model.DashboardtemplateRedirectionparamDetails;
import com.sapphire.dashboard.model.Inbuiltdashboardtemplates;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.UserMgmtMaster;
import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.IUserMgmtMasterDAO;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardFilterMappingDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardFiltersDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardMasterDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardPanelDetailsBeforePublishDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardPanelDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardPanelDetailsOnRolesDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardWidgetMappingDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigurationAccessDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigurationDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardrepositoryDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardtemplateMacrodetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardtemplateQuicklinksDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardtemplateRedirectionparamDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IInbuiltdashboardtemplatesDAO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardCopyDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardCopyRequestDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardExportRequestDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardHistoryDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardImportRequestDTO;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryFeatureWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryParameterWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardExportImportService;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardHistoryService;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardPanelsService;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardRepositoryService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardExportImportService
implements IDashboardExportImportService {
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    private IHibernateRepositoryOperations hibernateDaoOperations;
    @Autowired
    private IDashboardconfigDAO dashboardConfigurationDAO;
    @Autowired
    private IDashboardconfigurationDetailsDAO dashboardConfigurationDetailsDAO;
    @Autowired
    private IDashboardconfigurationAccessDetailsDAO dashboardConfigurationAccessDetailsDAO;
    @Autowired
    private IDashboardtemplateMacrodetailsDAO dashboardtemplateMacrodetailsDAO;
    @Autowired
    private IDashboardrepositoryDAO dashboardRepositoryDAO;
    @Autowired
    private IDashboardtemplateQuicklinksDAO dashboardTemplateQuicklinksDAO;
    @Autowired
    private IDashboardRepositoryService dashboardRepositoryService;
    @Autowired
    private IDashboardFiltersDAO dashbordFiltersDAO;
    @Autowired
    private IInbuiltdashboardtemplatesDAO inbuiltdashboardtemplatesDAO;
    @Autowired
    private IDashboardtemplateRedirectionparamDetailsDAO dashboardtemplateRedirectionparamDetailsDAO;
    @Autowired
    private IDashboardWidgetMappingDAO dashboardWidgetMappingDAO;
    @Autowired
    private IDashboardMasterDAO dashboardMasterDAO;
    @Autowired
    private IDashboardFilterMappingDAO dashboardFilterMappingDAO;
    @Autowired
    private IDashboardPanelDetailsBeforePublishDAO dashboardPanelDetailsBeforePublishDAO;
    @Autowired
    private IDashboardPanelDetailsOnRolesDAO dashboardPanelDetailsOnRolesDAO;
    @Autowired
    private IDashboardPanelDetailsDAO dashboardPanelDetailsDAO;
    @Autowired
    private IDashboardPanelsService dashboardPanelsService;
    @Autowired
    private IUserMgmtMasterDAO userMgmtMasterDAO;
    @Autowired
    private IDashboardHistoryService dashboardHistoryService;

    @Override
    @Transactional(readOnly=true)
    public DashboardCopyDTO exportDashboard(DashboardCopyRequestDTO request) throws DomainException, ValidationException {
        DashboardCopyDTO dcDTO = new DashboardCopyDTO();
        DashboardExportRequestDTO dReq = new DashboardExportRequestDTO(false, dcDTO, this.hibernateDaoOperations);
        dReq.setMcaDTO(request.getMcaDTO());
        dReq.setOnlyWidgetsCopy(request.isOnlyWidgetCopy());
        dReq.setIsDashboardCopy(request.isDashboardCopy());
        dReq.setRoleDashboardId(request.getRoleDashboardId());
        dReq.setProjectId(request.getProjectId());
        dReq.setUserId(request.getUserId());
        dReq.setIsProjectCopy(request.isProjectCopy());
        dcDTO = this.exportDashboard(dReq, request.getWidgetsId());
        return dcDTO;
    }

    private DashboardCopyDTO exportDashboard(DashboardExportRequestDTO dReq, List<Integer> widgetsIds) throws DomainException, ValidationException {
        DashboardCopyDTO dcDTO = new DashboardCopyDTO();
        LinkedList<Dashboardmaster> dmList = new LinkedList();
        List<Object> dcList = new LinkedList();
        if (dReq.getIsDashboardCopy().booleanValue()) {
            dmList = this.dashboardMasterDAO.getDashboardMaster(dReq.getRoleDashboardId());
            if (dReq.getIsProjectCopy().booleanValue()) {
                dcList = this.dashboardConfigurationDAO.getDashboardConfigurationFromMappedWidget(dReq.getRoleDashboardId());
            }
            dReq = dReq.setDashboardMaster(dmList);
        }
        dcList = this.dashboardConfigurationDAO.getDashboardconfigurationByIds(widgetsIds);
        dReq = dReq.setDashboardConfiguration(dcList);
        LinkedList<DashboardconfigurationDetails> dcDetails = new LinkedList<DashboardconfigurationDetails>();
        if (CollectionUtil.isNotEmpty(dcList)) {
            LinkedList<DashboardconfigurationAccessDetails> dcaDetails = new LinkedList<DashboardconfigurationAccessDetails>();
            for (Dashboardconfiguration dashboardconfiguration : dcList) {
                dcDetails.addAll(this.dashboardConfigurationDetailsDAO.getDashboardconfigurationDetailsById(dashboardconfiguration.getDashboardDetailsId()));
                dcaDetails.addAll(this.dashboardConfigurationAccessDetailsDAO.getDashboardconfigurationAccessDetailsById(dashboardconfiguration.getDashboardDetailsId()));
            }
            dReq = dReq.setDashbaordDetails(dcDetails, dcaDetails);
        }
        LinkedList<DashboardtemplateMacrodetails> dtmDetails = new LinkedList<DashboardtemplateMacrodetails>();
        List<Dashboardrepository> drList = new LinkedList<Dashboardrepository>();
        LinkedList<DashboardFilters> linkedList = new LinkedList<DashboardFilters>();
        if (CollectionUtil.isNotEmpty(dcDetails)) {
            for (DashboardconfigurationDetails dcd : dcDetails) {
                String[] widgetFilter;
                Dashboardrepository dr;
                Object dtmd = this.dashboardtemplateMacrodetailsDAO.getDashboardtemplateMacrodetailsByMacroId(dcd.getMacroId());
                if (dtmd != null) {
                    dtmDetails.add((DashboardtemplateMacrodetails)((Object)dtmd));
                }
                if (dcd.getRepositoryId() != 0 && (dr = this.dashboardRepositoryDAO.getDashboardrepositoryById(dcd.getRepositoryId())) != null) {
                    drList.add(dr);
                }
                if (dcd.getFilters() == null || dcd.getFilters().trim().equals("") || dcd.getFilters().trim().equals("0")) continue;
                for (String filterId : widgetFilter = dcd.getFilters().split(",")) {
                    DashboardFilters df = this.dashbordFiltersDAO.getDashboardFiltersById(Integer.parseInt(filterId));
                    if (df == null) continue;
                    linkedList.add(df);
                }
            }
            dReq = dReq.setDashboardTemplateMacroDetails(dtmDetails);
            dReq = dReq.setDashboardFilter(linkedList);
        }
        LinkedList<DashboardtemplateQuicklinks> dtqlList = new LinkedList<DashboardtemplateQuicklinks>();
        LinkedList<DashboardtemplateRedirectionparamDetails> dtrpdList = new LinkedList<DashboardtemplateRedirectionparamDetails>();
        if (CollectionUtil.isNotEmpty(dtmDetails)) {
            for (DashboardtemplateMacrodetails dtmd : dtmDetails) {
                List<DashboardtemplateQuicklinks> dtql = this.dashboardTemplateQuicklinksDAO.getDashboardtemplateQuicklinksByMacroId(dtmd.getMacroId());
                if (CollectionUtil.isNotEmpty(dtqlList) && dtql != null) {
                    dtqlList.addAll(dtql);
                }
                List<DashboardtemplateRedirectionparamDetails> dtrpd = this.dashboardtemplateRedirectionparamDetailsDAO.getDashboardtemplateRedirectionparamDetailsByMacroId(dtmd.getMacroId());
                if (!CollectionUtil.isNotEmpty(dtqlList) || dtrpd == null) continue;
                dtrpdList.addAll(dtrpd);
            }
            dReq = dReq.setDashboardTemplateQuickLinks(dtqlList);
            dReq = dReq.setDashboardtemplateRedirectionparamDetails(dtrpdList);
        }
        if (CollectionUtil.isNotEmpty(dtqlList)) {
            for (DashboardtemplateQuicklinks dtql : dtqlList) {
                Dashboardrepository dr;
                if (dtql.getRepositoryId() == 0 || (dr = this.dashboardRepositoryDAO.getDashboardrepositoryById(dtql.getRepositoryId())) == null) continue;
                drList.add(dr);
            }
        }
        drList = this.dashboardRepositoryService.getDashboardRepositoryList(drList, dReq);
        dReq = dReq.setDashboardRepository(drList);
        List<Inbuiltdashboardtemplates> idtList = this.inbuiltdashboardtemplatesDAO.getInbuiltdashboardtemplates();
        dReq = dReq.setInbuiltdashboardtemplates(idtList);
        List<DashboardFilters> dGfList = new LinkedList<DashboardFilters>();
        LinkedList dpdbpList = new LinkedList();
        if (dReq.getRoleDashboardId() != null && dReq.getRoleDashboardId() != 0) {
            List<Integer> filterIds;
            List<Dashboardfiltermapping> dfmList = this.dashboardFilterMappingDAO.getDashboardFilterMappingListBasedOnDashboardId(dReq.getRoleDashboardId());
            if (CollectionUtil.isNotEmpty(dfmList) && CollectionUtil.isNotEmpty(filterIds = dfmList.stream().filter(Objects::nonNull).map(Dashboardfiltermapping::getFilterId).collect(Collectors.toList()))) {
                dGfList = this.dashbordFiltersDAO.getDashboardFiltersByIds(filterIds);
            }
            dReq = dReq.setRoleDashboardGlobalFilter(dGfList);
            dReq = dReq.setDashboardFilterMapping(dfmList);
            dReq = this.dashboardPanelsService.getPanelsData(dReq, widgetsIds);
        }
        dcDTO.setDashboardConfiguration(dReq).setDashboardTemplateMacro(dReq).setDashboardRepository(dReq).setDashboardfilter(dReq).setInbuiltdashboardtemplate(dReq).setIsOnlyWidgetsCopy(dReq.getIsOnlyWidgetsCopy()).setIsDashboardCopy(dReq.getIsDashboardCopy());
        if (dReq.getIsDashboardCopy().booleanValue()) {
            dcDTO.setDashboardMaster(dReq);
            dcDTO.setDashboardGlobalfilter(dReq);
            dcDTO.setDashboardGlobalFilterMappings(dReq);
            dcDTO.setDashboardPanelDetailsBeforePublishDTO(dReq);
        }
        return dcDTO;
    }

    @Override
    @Transactional(rollbackFor={DomainException.class, ValidationException.class})
    public String importDashboard(DashboardImportRequestDTO requestDTO, ProjectExportRequestDTO pReq) throws DomainException, ValidationException {
        Validate.notNull((Object)((Object)requestDTO.getDashboardCopy()), (String)"Dashboard Copy Can't be empty", (Object[])new Object[0]);
        Validate.notNull((Object)requestDTO.getMcaDTO(), (String)"Attachments details Can't be empty", (Object[])new Object[0]);
        if (requestDTO.getDashboardCopy() != null) {
            DashboardCopyDTO dcdto = requestDTO.getDashboardCopy();
            requestDTO.setIsDashboardCopy(dcdto.getIsDashboardCopy());
            requestDTO.setIsWidgetCopy(dcdto.getIsOnlyWidgetsCopy());
            DashboardExportRequestDTO req = new DashboardExportRequestDTO(true, dcdto, this.hibernateDaoOperations);
            req.setMcaDTO(requestDTO.getMcaDTO());
            req.setUserId(requestDTO.getUserId());
            req.setIsProjectCopy(requestDTO.getIsProjectCopy());
            if (dcdto.getIsDashboardCopy().booleanValue()) {
                this.importDashboardMaster(req, requestDTO.getSdProjectMaster(), this.dashboardMasterDAO);
                this.importDashboardGlobalFilter(req, this.dashbordFiltersDAO);
            } else {
                req.setRoleDashboardId(requestDTO.getRoleDashboardId());
            }
            this.importDashboardConfiguration(req, requestDTO.getSdProjectMaster(), pReq);
            this.importDashboardTemplateMacroDetails(req);
            this.importDashboardRepository(req);
            this.importDashboardTemplateQuickLinks(req);
            this.importDashboardFilters(req);
            this.importDashboardConfigurationDetails(req);
            this.importInbuiltdashboardtemplates(req);
            this.importDashboardtemplateRedirectionparamDetails(req);
            this.importDashboardWidgetMapping(req, requestDTO.getSdProjectMaster());
            if (dcdto.getIsDashboardCopy().booleanValue()) {
                this.importDashboardPanelDetailsBeforePublish(req, requestDTO.getSdProjectMaster());
            }
            this.importDashboardHistory(req, requestDTO);
        }
        return "Success";
    }

    private void importDashboardConfiguration(DashboardExportRequestDTO req, SdProjectMaster spm, ProjectExportRequestDTO pReq) throws DomainException {
        req = req.getDashboardConfiguration(req, this.dashboardConfigurationDAO, spm, pReq);
    }

    private void importDashboardConfigurationDetails(DashboardExportRequestDTO req) throws DomainException {
        req = req.getDashboardConfigurationDetails(req);
        this.dashboardConfigurationDetailsDAO.batchSaveWithoutFlush(req.getDashboardConfigurationDetails());
    }

    private void importDashboardTemplateMacroDetails(DashboardExportRequestDTO req) throws DomainException {
        req = req.getDashboardTemplateMacroDetails(req, this.dashboardtemplateMacrodetailsDAO);
        this.dashboardtemplateMacrodetailsDAO.batchSaveWithoutFlush(req.getDashboardtemplateMacrodetailses());
    }

    private void importDashboardTemplateQuickLinks(DashboardExportRequestDTO req) throws DomainException {
        req = req.getDashboardTemplateQuickLinks(req);
        this.dashboardTemplateQuicklinksDAO.batchSaveWithoutFlush(req.getDashboardtemplateQuicklinkses());
    }

    private void importDashboardRepository(DashboardExportRequestDTO req) throws DomainException, ValidationException {
        req = this.dashboardRepositoryService.replaceAndUpdateDashboardRepository(req, this.dashboardRepositoryDAO);
        this.dashboardRepositoryDAO.batchSaveWithoutFlush(req.getDashboardrepositorys());
    }

    private void importDashboardFilters(DashboardExportRequestDTO req) throws DomainException, ValidationException {
        req = req.getDashboardFilters(req, this.dashbordFiltersDAO);
        this.dashbordFiltersDAO.batchSaveWithoutFlush(req.getDashboardFilterses());
    }

    private void importInbuiltdashboardtemplates(DashboardExportRequestDTO req) throws DomainException, ValidationException {
        if (CollectionUtil.isNotEmpty((req = req.getInbuiltdashboardtemplates(req, this.inbuiltdashboardtemplatesDAO)).getInbuiltdashboardtemplateses())) {
            for (Inbuiltdashboardtemplates idt : req.getInbuiltdashboardtemplateses()) {
                this.hibernateDaoOperations.update((Object)idt);
            }
        }
    }

    private void importDashboardtemplateRedirectionparamDetails(DashboardExportRequestDTO req) throws DomainException, ValidationException {
        req = req.getDashboardtemplateRedirectionparamDetails(req);
        this.dashboardtemplateRedirectionparamDetailsDAO.batchSaveWithoutFlush(req.getDashboardtemplateRedirectionparamDetailses());
    }

    private void importDashboardWidgetMapping(DashboardExportRequestDTO req, SdProjectMaster spm) throws DomainException, ValidationException {
        req = req.getDashboardWidgetMapping(req, spm);
        this.dashboardWidgetMappingDAO.batchSaveWithoutFlush(req.getDashboardwidgetmappingses());
    }

    private void importDashboardMaster(DashboardExportRequestDTO req, SdProjectMaster spm, IDashboardMasterDAO dashboardMasterDAO) throws DomainException, ValidationException {
        req = req.getDashboardMaster(req, spm, dashboardMasterDAO);
        req = req.getDashboardAccessDetails(req, this.dashboardConfigurationDAO, true);
        this.dashboardConfigurationAccessDetailsDAO.batchSaveWithoutFlush(req.getDashboardConfigurationAccessDetails());
    }

    private void importDashboardGlobalFilter(DashboardExportRequestDTO req, IDashboardFiltersDAO dashboardFiltersDAO) throws DomainException, ValidationException {
        req = req.getRoleDashboardGlobalFilterses(req, dashboardFiltersDAO);
        req = req.getGlobalFilterMapping(req);
        this.dashboardFilterMappingDAO.batchSaveWithoutFlush(req.getDashboardGlobalFilterMappingses());
    }

    private void importDashboardPanelDetailsBeforePublish(DashboardExportRequestDTO req, SdProjectMaster spm) throws DomainException, ValidationException {
        req = req.getDashboardPanelDetailsBeforePublish(req, spm);
        this.dashboardPanelDetailsBeforePublishDAO.batchSaveWithoutFlush(req.getDashboardPanelDetailsBeforePublisheses());
    }

    private void importDashboardHistory(DashboardExportRequestDTO req, DashboardImportRequestDTO requestDTO) throws DomainException, ValidationException {
        UserMgmtMaster umm = this.userMgmtMasterDAO.getUserMgmtMasterByUserDetailsId(requestDTO.getUserId());
        Dashboardmaster dm = (Dashboardmaster)this.dashboardMasterDAO.get(req.getRoleDashboardId());
        DashboardHistoryParameterWiseENUM parameter = DashboardHistoryParameterWiseENUM.ProjectDashboardCopy;
        if (requestDTO.getIsDashboardCopy().booleanValue()) {
            parameter = DashboardHistoryParameterWiseENUM.DashboardCopy;
        } else if (requestDTO.getIsWidgetCopy().booleanValue()) {
            parameter = DashboardHistoryParameterWiseENUM.OnlyWidgetsCopy;
        }
        DashboardHistoryDTO dhDTO = DashboardHistoryDTO.builder().actionPerformedBy(umm.getFullName()).childOf(0).currentTime(new Date()).natureOfChange(DashboardHistoryFeatureWiseENUM.Import).parameter(parameter).oldValue("--").newValue(dm.getDashboardName()).userid(requestDTO.getUserId()).projectId(requestDTO.getSdProjectMaster().getProjectId()).dashboardId(dm.getDashboardId()).build();
        req.getPrepareDashboardHistory(req, dhDTO);
        this.dashboardHistoryService.saveDashboardHistory(dhDTO);
    }
}

