/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.service.impl;

import com.sapphire.dashboard.model.DashboardFilters;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardFiltersDAO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardFiltersModelDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardHistoryDTO;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardFiltersENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryParameterWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardFiltersService;
import com.sapphireims.util.Validate;
import java.util.LinkedList;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardFiltersService
implements IDashboardFiltersService {
    @Autowired
    private IDashboardFiltersDAO dashboardFiltersDAO;

    @Override
    @Transactional
    public DashboardFiltersModelDTO getDashboardFiltersDTOByFilterId(Integer filterId) throws DomainException, ValidationException {
        Validate.notNull((Object)filterId, (String)"Filter Id should not be null", (Object[])new Object[0]);
        DashboardFilters df = this.dashboardFiltersDAO.getDashboardFiltersById(filterId);
        Validate.notNull((Object)((Object)df), (String)"Please check the filter id {0}", (Object[])new Object[]{filterId});
        DashboardFiltersModelDTO dfmDTO = new DashboardFiltersModelDTO(df);
        return dfmDTO;
    }

    @Override
    @Transactional
    public void formDashboardFilterHistory(DashboardFiltersModelDTO oldValue, DashboardFiltersModelDTO newValue, DashboardHistoryDTO parent) throws DomainException, ValidationException {
        switch (parent.getNatureOfChange()) {
            case NewWidgetFilter: 
            case NewGlobalFilter: 
            case UpdateGlobalFilter: 
            case UpdateWidgetFilter: {
                LinkedList<Integer> lst = new LinkedList<Integer>();
                lst.add(DashboardFiltersENUM.FilterName.getValue());
                lst.add(DashboardFiltersENUM.IsMultiSelect.getValue());
                lst.add(DashboardFiltersENUM.FilterParameterName.getValue());
                lst.add(DashboardFiltersENUM.FilterMacroName.getValue());
                lst.add(DashboardFiltersENUM.DisplayQuery.getValue());
                lst.add(DashboardFiltersENUM.DefaultValueQuery.getValue());
                lst.add(DashboardFiltersENUM.DefaultQuery.getValue());
                switch (newValue.getFilterType()) {
                    case DEFAULT: {
                        break;
                    }
                    case GlobalFilters: {
                        lst.add(DashboardFiltersENUM.WidgetAccessQuery.getValue());
                        break;
                    }
                    case WidgetLevelCustomFilters: {
                        lst.add(DashboardFiltersENUM.FilterStyle.getValue());
                    }
                }
                this.prepareDashboardFiltersHistory(oldValue, newValue, parent, lst);
                break;
            }
            case DeleteGlobalFilter: 
            case DeleteWidgetFilter: {
                Validate.notNull((Object)((Object)oldValue), (String)"Pleas check the filterId for delete history", (Object[])new Object[0]);
                parent.setParameter(DashboardHistoryParameterWiseENUM.FilterName);
                parent.setOldValue(oldValue.getFilterName());
                parent.setNewValue("--");
            }
        }
    }

    private void prepareDashboardFiltersHistory(DashboardFiltersModelDTO oldValue, DashboardFiltersModelDTO newValue, DashboardHistoryDTO parent, LinkedList<Integer> parametersList) throws DomainException, ValidationException {
        DashboardHistoryDTO child = null;
        for (Integer parameter : parametersList) {
            child = DashboardHistoryDTO.getDashboardHistoryForFiltersObject(oldValue, newValue, parent);
            child.setOldValue("--");
            child.setNewValue("--");
            child.setParameter(DashboardHistoryParameterWiseENUM.getDashboardHistoryParameterWiseENUM(parameter));
            switch (DashboardFiltersENUM.getDashboardFiltersENUM(parameter)) {
                case FilterName: {
                    parent.setParameter(DashboardHistoryParameterWiseENUM.FilterName);
                    child = null;
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getFilterName().strip().equals(newValue.getFilterName().strip())) {
                            parent.setOldValue(oldValue.getFilterName().strip().isEmpty() ? "--" : oldValue.getFilterName().strip());
                            parent.setNewValue(newValue.getFilterName().strip().isEmpty() ? "--" : newValue.getFilterName().strip());
                            break;
                        }
                        parent.setNewValue("--");
                        parent.setOldValue(oldValue.getFilterName().strip().isEmpty() ? "--" : oldValue.getFilterName().strip());
                        break;
                    }
                    parent.setOldValue("--");
                    parent.setNewValue(newValue.getFilterName().strip().isEmpty() ? "--" : newValue.getFilterName().strip());
                    break;
                }
                case IsMultiSelect: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (oldValue.getIsMultipleSelect() != newValue.getIsMultipleSelect()) {
                            child.setOldValue(oldValue.getIsMultipleSelect() == 1 ? "Not Selected" : "Selected");
                            child.setNewValue(newValue.getIsMultipleSelect() == 1 ? "Not Selected" : "Selected");
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getIsMultipleSelect() == 1 ? "Not Selected" : "Selected");
                    break;
                }
                case FilterParameterName: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getParamName().strip().equals(newValue.getParamName().strip())) {
                            child.setOldValue(oldValue.getParamName().strip().isEmpty() ? "--" : oldValue.getParamName().strip());
                            child.setNewValue(newValue.getParamName().strip().isEmpty() ? "--" : newValue.getParamName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getParamName().strip().isEmpty() ? "--" : newValue.getParamName().strip());
                    break;
                }
                case FilterMacroName: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getMacroName().strip().equals(newValue.getMacroName().strip())) {
                            child.setOldValue(oldValue.getMacroName().strip().isEmpty() ? "--" : oldValue.getMacroName().strip());
                            child.setNewValue(newValue.getMacroName().strip().isEmpty() ? "--" : newValue.getMacroName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getMacroName().strip().isEmpty() ? "--" : newValue.getMacroName().strip());
                    break;
                }
                case FilterStyle: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getFilterClass().strip().equals(newValue.getFilterClass().strip())) {
                            child.setOldValue(oldValue.getFilterClass().strip().isEmpty() ? "--" : oldValue.getFilterClass().strip());
                            child.setNewValue(newValue.getFilterClass().strip().isEmpty() ? "--" : newValue.getFilterClass().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getFilterClass().strip().isEmpty() ? "--" : newValue.getFilterClass().strip());
                    break;
                }
                case DefaultQuery: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getDefaultQuery().strip().equals(newValue.getDefaultQuery().strip())) {
                            child.setOldValue(oldValue.getDefaultQuery().strip().isEmpty() ? "--" : oldValue.getDefaultQuery().strip());
                            child.setNewValue(newValue.getDefaultQuery().strip().isEmpty() ? "--" : newValue.getDefaultQuery().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getDefaultQuery().strip().isEmpty() ? "--" : newValue.getDefaultQuery().strip());
                    break;
                }
                case DisplayQuery: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getDisplayQuery().strip().equals(newValue.getDisplayQuery().strip())) {
                            child.setOldValue(oldValue.getDisplayQuery().strip().isEmpty() ? "--" : oldValue.getDisplayQuery().strip());
                            child.setNewValue(newValue.getDisplayQuery().strip().isEmpty() ? "--" : newValue.getDisplayQuery().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getDisplayQuery().strip().isEmpty() ? "--" : newValue.getDisplayQuery().strip());
                    break;
                }
                case DefaultValueQuery: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getDefaultValueQuery().strip().equals(newValue.getDefaultValueQuery().strip())) {
                            child.setOldValue(oldValue.getDefaultValueQuery().strip().isEmpty() ? "--" : oldValue.getDefaultValueQuery().strip());
                            child.setNewValue(newValue.getDefaultValueQuery().strip().isEmpty() ? "--" : newValue.getDefaultValueQuery().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getDefaultValueQuery().strip().isEmpty() ? "--" : newValue.getDefaultValueQuery().strip());
                    break;
                }
                case WidgetAccessQuery: {
                    if (Objects.nonNull((Object)oldValue)) {
                        if (!oldValue.getWidgetAccessQuery().strip().equals(newValue.getWidgetAccessQuery().strip())) {
                            child.setOldValue(oldValue.getWidgetAccessQuery().strip().isEmpty() ? "--" : oldValue.getWidgetAccessQuery().strip());
                            child.setNewValue(newValue.getWidgetAccessQuery().strip().isEmpty() ? "--" : newValue.getWidgetAccessQuery().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setOldValue("--");
                    child.setNewValue(newValue.getWidgetAccessQuery().strip().isEmpty() ? "--" : newValue.getWidgetAccessQuery().strip());
                }
            }
            if (Objects.isNull(parent.getChildHistory())) {
                parent.setChildHistory(new LinkedList<DashboardHistoryDTO>());
            }
            if (!Objects.nonNull((Object)child)) continue;
            parent.getChildHistory().add(child);
        }
    }
}

