/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.service.impl;

import com.sapphire.dashboard.model.DashboardFilters;
import com.sapphire.dashboard.model.DashboardHistory;
import com.sapphire.dashboard.model.Dashboardconfiguration;
import com.sapphire.dashboard.model.DashboardconfigurationDetails;
import com.sapphire.dashboard.model.Dashboardmaster;
import com.sapphire.dashboard.model.Dashboardrepository;
import com.sapphire.dashboard.model.DashboardtemplateMacrodetails;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.cmdb.dao.IAssetrolesDAO;
import com.sapphireims.dao.IUserMgmtDetailsRepository;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdProjectRolesDAO;
import com.sapphireims.itsm.dao.ISdSearchProfilesMasterDAO;
import com.sapphireims.itsm.dao.IUserMgmtMasterDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardFiltersDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardHistoryDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardMasterDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigurationAccessDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigurationDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardrepositoryDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardtemplateMacrodetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dto.AllDashboardFeaturePropertiesDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardFiltersModelDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardHistoryDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardtemplateMacrodetailsDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardtemplateQuicklinksDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardtemplateRedirectionparamDetailsDTO;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardConfigurationTypeENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryFeatureWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryParameterWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.MultiChartSeriesENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.WidgetTemplateTypeENUM;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardFiltersService;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardHistoryService;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardMasterService;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardTemplateMacroDetailsService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.DashboardCollectionUtil;
import com.sapphireims.util.Validate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardHistoryService
implements IDashboardHistoryService {
    private static final Log logger = LogFactory.getLog((String)"ITSM.log");
    @Autowired
    private IDashboardHistoryDAO dashboardHistoryDAO;
    @Autowired
    private ISdProjectMasterDAO sdProjectMasterDAO;
    @Autowired
    private IDashboardconfigurationAccessDetailsDAO dashboardconfigurationAccessDetailsDAO;
    @Autowired
    private IUserMgmtDetailsRepository userMgmtDetailsRepository;
    @Autowired
    private ISdProjectRolesDAO sdProjectRolesDAO;
    @Autowired
    private IAssetrolesDAO assetrolesDAO;
    @Autowired
    private IUserMgmtMasterDAO userMgmtMasterDAO;
    @Autowired
    private IDashboardconfigDAO dashboardconfigDAO;
    @Autowired
    private IDashboardconfigurationDetailsDAO dashboardconfigurationDetailsDAO;
    @Autowired
    private IDashboardtemplateMacrodetailsDAO dashboardtemplateMacrodetailsDAO;
    @Autowired
    private IDashboardrepositoryDAO dashboardrepositoryDAO;
    @Autowired
    private IDashboardFiltersDAO dashboardFiltersDAO;
    @Autowired
    private IDashboardMasterService dashboardMasterService;
    @Autowired
    private IDashboardTemplateMacroDetailsService dashboardTemplateMacroDetailsService;
    @Autowired
    private IDashboardFiltersService dashboardFiltersService;
    @Autowired
    private IDashboardMasterDAO dashboardMasterDAO;
    @Autowired
    private ISdSearchProfilesMasterDAO sdSearchProfilesMasterDAO;

    @Override
    @Transactional
    public AllDashboardFeaturePropertiesDTO getWidgetDetails(Integer widgetId, Integer projectId, Integer dashboardId) throws DomainException, ValidationException {
        Dashboardconfiguration dc = this.dashboardconfigDAO.getDashboardConfigurationById(widgetId);
        AllDashboardFeaturePropertiesDTO wpDTO = AllDashboardFeaturePropertiesDTO.builder().widgetName(dc.getDashboardName()).widgetId(dc.getDashboardDetailsId()).dashboardtype(DashboardConfigurationTypeENUM.getWidgetAccessTypeENUM(dc.getDashboardtype())).isCustomWidget(dc.getIsCustomDashboard()).build();
        DashboardconfigurationDetails dcd = this.dashboardconfigurationDetailsDAO.getDashboardconfigurationDetailsUniqueObjectById(widgetId);
        wpDTO.setProjectid(projectId);
        wpDTO.setRoleDashboardId(dashboardId);
        wpDTO.setTemplateId(WidgetTemplateTypeENUM.getWidgetTemplateTypeENUM(dcd.getTemplateId()));
        wpDTO.setMacroId(dcd.getMacroId());
        wpDTO.setModuleId(dcd.getModuleId());
        wpDTO.setPerformanceViewId(dcd.getPerformanceViewId());
        wpDTO.setPerformanceLookUpId(dcd.getPerformanceLookUpId());
        wpDTO.setFaultViewId(dcd.getFaultViewId());
        wpDTO.setFaultViewTypeId(dcd.getFaultViewTypeId());
        wpDTO.setClickUrl(dcd.getClickUrl());
        wpDTO.setClickFuntion(dcd.getClickFuntion());
        wpDTO.setRepositoryId(dcd.getRepositoryId());
        wpDTO.setColorCode(dcd.getColorCode());
        wpDTO.setChartType(dcd.getChartType());
        wpDTO.setIsMultiSeriesChart(dcd.getIsMultiSeriesChart());
        wpDTO.setXaxisName(dcd.getXaxisName());
        wpDTO.setYaxisName(dcd.getYaxisName());
        wpDTO.setFilters(dcd.getFilters());
        wpDTO.setSummaryColNames(dcd.getSummaryColNames());
        wpDTO.setIsVertical((byte)dcd.getIsVertical());
        wpDTO.setWidgetSize(dcd.getWidgetSize());
        wpDTO.setChartColor(dcd.getChartColor());
        wpDTO.setLowerIndicatorDirection(dcd.getLowerIndicatorDirection());
        wpDTO.setLowerIndicatorColor(dcd.getLowerIndicatorColor());
        wpDTO.setHigherIndicatorDirection(dcd.getHigherIndicatorDirection());
        wpDTO.setHigherIndicatorColor(dcd.getHigherIndicatorColor());
        return wpDTO;
    }

    @Override
    @Transactional(readOnly=false)
    public void saveDashboardHistory(DashboardHistoryDTO history) throws DomainException, ValidationException {
        Validate.notNull((Object)((Object)history), (String)"Dashboard history should not be empty or null", (Object[])new Object[0]);
        try {
            DashboardHistory parent = history.getParentDashboardHistory();
            this.dashboardHistoryDAO.saveAndFlush(parent);
            if (CollectionUtil.isNotEmpty(history.getChildHistory())) {
                for (DashboardHistoryDTO dhDTO : history.getChildHistory()) {
                    DashboardHistory child = dhDTO.getChildDashboardHistory();
                    child.setChildOf(parent.getHistoryId());
                    this.dashboardHistoryDAO.save(child);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("DashboardHistoryService :: saveDashboardHistory - " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    @Transactional
    public DashboardHistoryDTO formDashboardChildHistory(DashboardHistoryDTO parent, String oldValue, String newValue, Integer parameter, List<Integer> users, List<String> roles, boolean isUpdate) throws DomainException, ValidationException {
        Validate.notNull((Object)((Object)parent), (String)"Dashboard history parent should not be empty or null", (Object[])new Object[0]);
        this.dashboardMasterService.prepareDashboardHistory(parent, oldValue, newValue, parameter, users, roles, isUpdate);
        return parent;
    }

    @Override
    @Transactional
    public void formWidgetChildHistory(AllDashboardFeaturePropertiesDTO oldValueWpDTO, AllDashboardFeaturePropertiesDTO newValueWpDTO, DashboardHistoryDTO parent) throws DomainException, ValidationException {
        LinkedList<Integer> parametersList = new LinkedList<Integer>();
        parametersList.add(DashboardHistoryParameterWiseENUM.WidgetName.getValue());
        parametersList.add(DashboardHistoryParameterWiseENUM.DataTemplateName.getValue());
        switch (newValueWpDTO.getTemplateId()) {
            case CardView: 
            case PercentageFill: 
            case IconizedView: 
            case PercentageAndValueBased: 
            case DetailedView: 
            case ThresholdMonitoring: 
            case ComparativeStatus: {
                parametersList.add(DashboardHistoryParameterWiseENUM.WidgetTemplate.getValue());
                if (newValueWpDTO.getTemplateId().getValue() != 4 && newValueWpDTO.getTemplateId().getValue() != 6) {
                    parametersList.add(DashboardHistoryParameterWiseENUM.WidgetsIcon.getValue());
                }
                parametersList.add(DashboardHistoryParameterWiseENUM.WidgetFilters.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.LinkUrl.getValue());
                if (newValueWpDTO.getTemplateId().getValue() != 5) {
                    parametersList.add(DashboardHistoryParameterWiseENUM.WidgetSize.getValue());
                }
                if (newValueWpDTO.getTemplateId().getValue() != 3 && newValueWpDTO.getTemplateId().getValue() != 10) {
                    parametersList.add(DashboardHistoryParameterWiseENUM.BackgroundColor.getValue());
                }
                if (newValueWpDTO.getTemplateId().getValue() == 6 || newValueWpDTO.getTemplateId().getValue() == 10) {
                    parametersList.add(DashboardHistoryParameterWiseENUM.LowestColor.getValue());
                    parametersList.add(DashboardHistoryParameterWiseENUM.LowestDirection.getValue());
                    parametersList.add(DashboardHistoryParameterWiseENUM.HighestColor.getValue());
                    parametersList.add(DashboardHistoryParameterWiseENUM.HighestDirection.getValue());
                }
                if (newValueWpDTO.getTemplateId().getValue() != 1) break;
                parametersList.add(DashboardHistoryParameterWiseENUM.IsProfileBased.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.ProfileProjectId.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.ProfileId.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.ProfileRedirection.getValue());
                break;
            }
            case QuickView: {
                parametersList.add(DashboardHistoryParameterWiseENUM.Vertical.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.Horizontal.getValue());
                break;
            }
            case Charts: {
                parametersList.add(DashboardHistoryParameterWiseENUM.WidgetFilters.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.Xaxis.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.Yaxis.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.SeriesType.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.Colors.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.ColorRange.getValue());
                parametersList.add(DashboardHistoryParameterWiseENUM.ChartType.getValue());
                break;
            }
        }
        this.prepareWidgetChildHistory(oldValueWpDTO, newValueWpDTO, parent, parametersList);
    }

    private void prepareWidgetChildHistory(AllDashboardFeaturePropertiesDTO oldValueWpDTO, AllDashboardFeaturePropertiesDTO newValueWpDTO, DashboardHistoryDTO parent, List<Integer> parametersList) {
        DashboardHistoryDTO child = null;
        for (Integer paramId : parametersList) {
            child = DashboardHistoryDTO.getDashboardHistoryObject(oldValueWpDTO, newValueWpDTO, parent);
            child.setOldValue("--");
            child.setNewValue("--");
            child.setParameter(DashboardHistoryParameterWiseENUM.getDashboardHistoryParameterWiseENUM(paramId));
            switch (DashboardHistoryParameterWiseENUM.getDashboardHistoryParameterWiseENUM(paramId)) {
                case WidgetName: {
                    parent.setParameter(DashboardHistoryParameterWiseENUM.WidgetName);
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getWidgetName().strip().equals(newValueWpDTO.getWidgetName().strip())) {
                            parent.setOldValue(oldValueWpDTO.getWidgetName().strip().isEmpty() ? "--" : oldValueWpDTO.getWidgetName().strip());
                            parent.setNewValue(newValueWpDTO.getWidgetName().strip().isEmpty() ? "--" : newValueWpDTO.getWidgetName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    parent.setOldValue("--");
                    parent.setNewValue(newValueWpDTO.getWidgetName().strip().isEmpty() ? "--" : newValueWpDTO.getWidgetName().strip());
                    break;
                }
                case WidgetTemplate: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getTemplateId().getValue() != newValueWpDTO.getTemplateId().getValue()) {
                            child.setOldValue(oldValueWpDTO.getTemplateId().getName().strip().isEmpty() ? "--" : oldValueWpDTO.getTemplateId().getName().strip());
                            child.setNewValue(newValueWpDTO.getTemplateId().getName().strip().isEmpty() ? "--" : newValueWpDTO.getTemplateId().getName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getTemplateId().getName().strip().isEmpty() ? "--" : newValueWpDTO.getTemplateId().getName().strip());
                    break;
                }
                case DataTemplateName: {
                    DashboardtemplateMacrodetails dtmd;
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getMacroId() != newValueWpDTO.getMacroId()) {
                            dtmd = this.dashboardtemplateMacrodetailsDAO.getDashboardtemplateMacrodetailsByMacroId(oldValueWpDTO.getMacroId());
                            if (Objects.nonNull((Object)dtmd)) {
                                child.setOldValue(dtmd.getMacroName().strip().isEmpty() ? "--" : dtmd.getMacroName().strip());
                            }
                            if (!Objects.nonNull((Object)(dtmd = this.dashboardtemplateMacrodetailsDAO.getDashboardtemplateMacrodetailsByMacroId(newValueWpDTO.getMacroId())))) break;
                            child.setNewValue(dtmd.getMacroName().strip().isEmpty() ? "--" : dtmd.getMacroName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    dtmd = this.dashboardtemplateMacrodetailsDAO.getDashboardtemplateMacrodetailsByMacroId(newValueWpDTO.getMacroId());
                    if (!Objects.nonNull((Object)dtmd)) break;
                    child.setNewValue(dtmd.getMacroName().strip().isEmpty() ? "--" : dtmd.getMacroName().strip());
                    break;
                }
                case WidgetsIcon: {
                    Dashboardrepository dr;
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getRepositoryId() != newValueWpDTO.getRepositoryId()) {
                            dr = this.dashboardrepositoryDAO.getDashboardrepositoryById(oldValueWpDTO.getRepositoryId());
                            if (Objects.nonNull((Object)dr)) {
                                child.setOldValue(dr.getAttachmentName().strip().isEmpty() ? "--" : dr.getAttachmentName().strip());
                            }
                            if (!Objects.nonNull((Object)(dr = this.dashboardrepositoryDAO.getDashboardrepositoryById(newValueWpDTO.getRepositoryId())))) break;
                            child.setNewValue(dr.getAttachmentName().strip().isEmpty() ? "--" : dr.getAttachmentName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    dr = this.dashboardrepositoryDAO.getDashboardrepositoryById(newValueWpDTO.getRepositoryId());
                    if (!Objects.nonNull((Object)dr)) break;
                    child.setNewValue(dr.getAttachmentName().strip().isEmpty() ? "--" : dr.getAttachmentName().strip());
                    break;
                }
                case WidgetFilters: {
                    String filterNames;
                    List<DashboardFilters> dfList;
                    List<String> filterIds;
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getFilters().strip().equals(newValueWpDTO.getFilters().strip())) {
                            if (oldValueWpDTO.getFilters().strip().equals("") || oldValueWpDTO.getFilters().strip().equals("0")) {
                                child.setOldValue("--");
                                break;
                            }
                            filterIds = Arrays.asList(oldValueWpDTO.getFilters().strip().split(","));
                            dfList = this.dashboardFiltersDAO.getDashboardFiltersByIdsList(filterIds);
                            filterNames = dfList.stream().filter(Objects::nonNull).map(DashboardFilters::getFilterName).collect(Collectors.joining(","));
                            child.setOldValue(filterNames.strip().isEmpty() ? "--" : filterNames.strip());
                            filterIds = Arrays.asList(newValueWpDTO.getFilters().strip().split(","));
                            dfList = this.dashboardFiltersDAO.getDashboardFiltersByIdsList(filterIds);
                            filterNames = dfList.stream().filter(Objects::nonNull).map(DashboardFilters::getFilterName).collect(Collectors.joining(","));
                            child.setNewValue(filterNames.strip().isEmpty() ? "--" : filterNames.strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    filterIds = Arrays.asList(newValueWpDTO.getFilters().strip().split(","));
                    dfList = this.dashboardFiltersDAO.getDashboardFiltersByIdsList(filterIds);
                    filterNames = dfList.stream().filter(Objects::nonNull).map(DashboardFilters::getFilterName).collect(Collectors.joining(","));
                    child.setNewValue(filterNames.strip().isEmpty() ? "--" : filterNames.strip());
                    break;
                }
                case LinkUrl: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getClickFuntion().strip().equals(newValueWpDTO.getClickFuntion().strip())) {
                            child = DashboardHistoryDTO.getDashboardHistoryObject(oldValueWpDTO, newValueWpDTO, parent);
                            child.setOldValue(oldValueWpDTO.getClickFuntion().strip().isEmpty() ? "--" : oldValueWpDTO.getClickFuntion().strip());
                            child.setNewValue(newValueWpDTO.getClickFuntion().strip().isEmpty() ? "--" : newValueWpDTO.getClickFuntion().strip());
                            child.setParameter(DashboardHistoryParameterWiseENUM.LinkFunction);
                            parent.getChildHistory().add(child);
                        } else {
                            child = null;
                        }
                        if (!oldValueWpDTO.getClickUrl().strip().equals(newValueWpDTO.getClickUrl().strip())) {
                            child = DashboardHistoryDTO.getDashboardHistoryObject(oldValueWpDTO, newValueWpDTO, parent);
                            child.setOldValue(oldValueWpDTO.getClickUrl().strip().isEmpty() ? "--" : oldValueWpDTO.getClickUrl().strip());
                            child.setNewValue(newValueWpDTO.getClickUrl().strip().isEmpty() ? "--" : newValueWpDTO.getClickUrl().strip());
                            child.setParameter(DashboardHistoryParameterWiseENUM.LinkUrl);
                            parent.getChildHistory().add(child);
                            break;
                        }
                        child = null;
                        break;
                    }
                    child = DashboardHistoryDTO.getDashboardHistoryObject(oldValueWpDTO, newValueWpDTO, parent);
                    child.setNewValue(newValueWpDTO.getClickFuntion().strip().isEmpty() ? "--" : newValueWpDTO.getClickFuntion().strip());
                    child.setParameter(DashboardHistoryParameterWiseENUM.LinkFunction);
                    parent.getChildHistory().add(child);
                    child = DashboardHistoryDTO.getDashboardHistoryObject(oldValueWpDTO, newValueWpDTO, parent);
                    child.setNewValue(newValueWpDTO.getClickUrl().strip().isEmpty() ? "--" : newValueWpDTO.getClickUrl().strip());
                    child.setParameter(DashboardHistoryParameterWiseENUM.LinkUrl);
                    parent.getChildHistory().add(child);
                    break;
                }
                case WidgetSize: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getWidgetSize().strip().equals(newValueWpDTO.getWidgetSize().strip())) {
                            child.setOldValue(oldValueWpDTO.getWidgetSize().strip().isEmpty() ? "--" : oldValueWpDTO.getWidgetSize().strip());
                            child.setNewValue(newValueWpDTO.getWidgetSize().strip().isEmpty() ? "--" : newValueWpDTO.getWidgetSize().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getWidgetSize().strip().isEmpty() ? "--" : newValueWpDTO.getWidgetSize().strip());
                    break;
                }
                case BackgroundColor: 
                case ColorRange: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getColorCode().strip().equals(newValueWpDTO.getColorCode().strip())) {
                            child.setOldValue(oldValueWpDTO.getColorCode().strip().isEmpty() ? "--" : oldValueWpDTO.getColorCode().strip());
                            child.setNewValue(newValueWpDTO.getColorCode().strip().isEmpty() ? "--" : newValueWpDTO.getColorCode().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getColorCode().strip().isEmpty() ? "--" : newValueWpDTO.getColorCode().strip());
                    break;
                }
                case LowestColor: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getLowerIndicatorColor().strip().equals(newValueWpDTO.getLowerIndicatorColor().strip())) {
                            child.setOldValue(oldValueWpDTO.getLowerIndicatorColor().strip().isEmpty() ? "--" : oldValueWpDTO.getLowerIndicatorColor().strip());
                            child.setNewValue(newValueWpDTO.getLowerIndicatorColor().strip().isEmpty() ? "--" : newValueWpDTO.getLowerIndicatorColor().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getLowerIndicatorColor().strip().isEmpty() ? "--" : newValueWpDTO.getLowerIndicatorColor().strip());
                    break;
                }
                case LowestDirection: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getLowerIndicatorDirection().strip().equals(newValueWpDTO.getLowerIndicatorDirection().strip())) {
                            child.setOldValue(oldValueWpDTO.getLowerIndicatorDirection().strip().isEmpty() ? "--" : oldValueWpDTO.getLowerIndicatorDirection().strip());
                            child.setNewValue(newValueWpDTO.getLowerIndicatorDirection().strip().isEmpty() ? "--" : newValueWpDTO.getLowerIndicatorDirection().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getLowerIndicatorDirection().strip().isEmpty() ? "--" : newValueWpDTO.getLowerIndicatorDirection().strip());
                    break;
                }
                case HighestColor: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getHigherIndicatorColor().strip().equals(newValueWpDTO.getHigherIndicatorColor().strip())) {
                            child.setOldValue(oldValueWpDTO.getHigherIndicatorColor().strip().isEmpty() ? "--" : oldValueWpDTO.getHigherIndicatorColor().strip());
                            child.setNewValue(newValueWpDTO.getHigherIndicatorColor().strip().isEmpty() ? "--" : newValueWpDTO.getHigherIndicatorColor().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getHigherIndicatorColor().strip().isEmpty() ? "--" : newValueWpDTO.getHigherIndicatorColor().strip());
                    break;
                }
                case HighestDirection: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getHigherIndicatorDirection().strip().equals(newValueWpDTO.getHigherIndicatorDirection().strip())) {
                            child.setOldValue(oldValueWpDTO.getHigherIndicatorDirection().strip().isEmpty() ? "--" : oldValueWpDTO.getHigherIndicatorDirection().strip());
                            child.setNewValue(newValueWpDTO.getHigherIndicatorDirection().strip().isEmpty() ? "--" : newValueWpDTO.getHigherIndicatorDirection().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getHigherIndicatorDirection().strip().isEmpty() ? "--" : newValueWpDTO.getHigherIndicatorDirection().strip());
                    break;
                }
                case Xaxis: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getXaxisName().strip().equals(newValueWpDTO.getXaxisName().strip())) {
                            child.setOldValue(oldValueWpDTO.getXaxisName().strip().isEmpty() ? "--" : oldValueWpDTO.getXaxisName().strip());
                            child.setNewValue(newValueWpDTO.getXaxisName().strip().isEmpty() ? "--" : newValueWpDTO.getXaxisName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getXaxisName().strip().isEmpty() ? "--" : newValueWpDTO.getXaxisName().strip());
                    break;
                }
                case Yaxis: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getYaxisName().strip().equals(newValueWpDTO.getYaxisName().strip())) {
                            child.setOldValue(oldValueWpDTO.getYaxisName().strip().isEmpty() ? "--" : oldValueWpDTO.getYaxisName().strip());
                            child.setNewValue(newValueWpDTO.getYaxisName().strip().isEmpty() ? "--" : newValueWpDTO.getYaxisName().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getYaxisName().strip().isEmpty() ? "--" : newValueWpDTO.getYaxisName().strip());
                    break;
                }
                case SeriesType: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getIsMultiSeriesChart() != newValueWpDTO.getIsMultiSeriesChart()) {
                            child.setOldValue(MultiChartSeriesENUM.getMultiChartSeriesENUM(oldValueWpDTO.getIsMultiSeriesChart()).getName());
                            child.setNewValue(MultiChartSeriesENUM.getMultiChartSeriesENUM(newValueWpDTO.getIsMultiSeriesChart()).getName());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(MultiChartSeriesENUM.getMultiChartSeriesENUM(newValueWpDTO.getIsMultiSeriesChart()).getName());
                    break;
                }
                case Colors: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getChartColor().strip().equals(newValueWpDTO.getChartColor().strip())) {
                            child.setOldValue(oldValueWpDTO.getChartColor().strip().isEmpty() ? "--" : oldValueWpDTO.getChartColor().strip());
                            child.setNewValue(newValueWpDTO.getChartColor().strip().isEmpty() ? "--" : newValueWpDTO.getChartColor().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getChartColor().strip().isEmpty() ? "--" : newValueWpDTO.getChartColor().strip());
                    break;
                }
                case ChartType: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (!oldValueWpDTO.getChartType().strip().equals(newValueWpDTO.getChartType().strip())) {
                            child.setOldValue(oldValueWpDTO.getChartType().strip().isEmpty() ? "--" : oldValueWpDTO.getChartType().strip());
                            child.setNewValue(newValueWpDTO.getChartType().strip().isEmpty() ? "--" : newValueWpDTO.getChartType().strip());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getChartType().strip().isEmpty() ? "--" : newValueWpDTO.getChartType().strip());
                    break;
                }
                case Vertical: 
                case Horizontal: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getIsVertical() != newValueWpDTO.getIsVertical()) {
                            child.setOldValue(DashboardHistoryParameterWiseENUM.getDashboardHistoryParameterWiseENUM(oldValueWpDTO.getIsVertical()).getName());
                            child.setNewValue(DashboardHistoryParameterWiseENUM.getDashboardHistoryParameterWiseENUM(newValueWpDTO.getIsVertical()).getName());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(DashboardHistoryParameterWiseENUM.getDashboardHistoryParameterWiseENUM(newValueWpDTO.getIsVertical()).getName());
                    break;
                }
                case IsProfileBased: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getIsProfileBased() != newValueWpDTO.getIsProfileBased()) {
                            child.setOldValue(oldValueWpDTO.getIsProfileBased() == 0 ? "Data Template" : "Profile Based");
                            child.setNewValue(newValueWpDTO.getIsProfileBased() == 0 ? "Data Template" : "Profile Based");
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getIsProfileBased() == 0 ? "Data Template" : "Profile Based");
                    break;
                }
                case ProfileProjectId: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getProfileProjectId() != newValueWpDTO.getProfileProjectId()) {
                            child.setOldValue(oldValueWpDTO.getProfileProjectId() == 0 ? "--" : ((SdProjectMaster)this.sdProjectMasterDAO.get(Integer.valueOf(oldValueWpDTO.getProfileProjectId()))).getProjectName());
                            child.setNewValue(newValueWpDTO.getProfileProjectId() == 0 ? "--" : ((SdProjectMaster)this.sdProjectMasterDAO.get(Integer.valueOf(newValueWpDTO.getProfileProjectId()))).getProjectName());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getProfileProjectId() == 0 ? "--" : ((SdProjectMaster)this.sdProjectMasterDAO.get(Integer.valueOf(newValueWpDTO.getProfileProjectId()))).getProjectName());
                    break;
                }
                case ProfileId: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getProfileId() != newValueWpDTO.getProfileId()) {
                            child.setOldValue(oldValueWpDTO.getProfileId() == 0 ? "--" : this.sdSearchProfilesMasterDAO.getSdSearchprofilebyProfileId(oldValueWpDTO.getProfileId()).getProfileName());
                            child.setNewValue(newValueWpDTO.getProfileId() == 0 ? "--" : this.sdSearchProfilesMasterDAO.getSdSearchprofilebyProfileId(newValueWpDTO.getProfileId()).getProfileName());
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getProfileId() == 0 ? "--" : this.sdSearchProfilesMasterDAO.getSdSearchprofilebyProfileId(newValueWpDTO.getProfileId()).getProfileName());
                    break;
                }
                case ProfileRedirection: {
                    if (Objects.nonNull((Object)oldValueWpDTO)) {
                        if (oldValueWpDTO.getProfileRedirection() != newValueWpDTO.getProfileRedirection()) {
                            child.setOldValue(oldValueWpDTO.getProfileRedirection() == 0 ? "No" : "Yes");
                            child.setNewValue(newValueWpDTO.getProfileRedirection() == 0 ? "No" : "Yes");
                            break;
                        }
                        child = null;
                        break;
                    }
                    child.setNewValue(newValueWpDTO.getProfileRedirection() == 0 ? "No" : "Yes");
                }
            }
            if (paramId == 9 || paramId == 7) continue;
            if (Objects.isNull(parent.getChildHistory())) {
                parent.setChildHistory(new LinkedList<DashboardHistoryDTO>());
            }
            if (!Objects.nonNull((Object)child)) continue;
            parent.getChildHistory().add(child);
        }
    }

    @Override
    @Transactional
    public void formDataTemplateHistory(DashboardtemplateMacrodetailsDTO oldValue, DashboardtemplateMacrodetailsDTO newValue, DashboardHistoryDTO parent) throws DomainException, ValidationException {
        if (Objects.nonNull((Object)parent.getChildDashboardHistory())) {
            parent.setChildHistory(new LinkedList<DashboardHistoryDTO>());
        }
        if (parent.getNatureOfChange().getName().equals(DashboardHistoryFeatureWiseENUM.NewDataTemplate.getName())) {
            Validate.notNull((Object)((Object)newValue), (String)"New Data Template details is empty", (Object[])new Object[0]);
        } else {
            Validate.notNull((Object)((Object)newValue), (String)"New Data Template details is empty", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)oldValue), (String)"Update Data Template details is empty", (Object[])new Object[0]);
        }
        switch (parent.getNatureOfChange()) {
            case NewDataTemplate: 
            case UpdateDataTemplate: {
                Object newVal;
                Object oldVal;
                DashboardHistoryDTO child;
                DashboardHistoryDTO child2;
                parent.setParameter(DashboardHistoryParameterWiseENUM.TemplateName);
                if (parent.getNatureOfChange().getName().equals(DashboardHistoryFeatureWiseENUM.NewDataTemplate.getName())) {
                    parent.setOldValue("--");
                    parent.setNewValue(newValue.getMacroName().strip().isEmpty() ? "--" : newValue.getMacroName().strip());
                } else if (!parent.getOldValue().strip().equalsIgnoreCase(newValue.getMacroName().strip())) {
                    parent.setOldValue(oldValue.getMacroName().strip().isEmpty() ? "--" : oldValue.getMacroName().strip());
                    parent.setNewValue(newValue.getMacroName().strip().isEmpty() ? "--" : newValue.getMacroName().strip());
                } else {
                    parent.setParameter(DashboardHistoryParameterWiseENUM.Update);
                }
                parent.setChildOf(0);
                if (DashboardCollectionUtil.getFieldsOfDataTemplateOnTemplateType(newValue.getTemplateId()).contains((Object)DashboardHistoryParameterWiseENUM.DataTemplateQuery)) {
                    child2 = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                    if (parent.getNatureOfChange().getName().equals(DashboardHistoryFeatureWiseENUM.NewDataTemplate.getName())) {
                        child2.setOldValue("--");
                    } else {
                        child2.setOldValue(oldValue.getDataQuery().strip().isEmpty() ? "--" : oldValue.getDataQuery().strip());
                    }
                    child2.setNewValue(newValue.getDataQuery().strip().isEmpty() ? "--" : newValue.getDataQuery().strip());
                    child2.setParameter(DashboardHistoryParameterWiseENUM.DataTemplateQuery);
                    if (!child2.getOldValue().strip().equals(child2.getNewValue().strip())) {
                        parent.getChildHistory().add(child2);
                    }
                }
                if (DashboardCollectionUtil.getFieldsOfDataTemplateOnTemplateType(newValue.getTemplateId()).contains((Object)DashboardHistoryParameterWiseENUM.RedirectToUrl) || DashboardCollectionUtil.getFieldsOfDataTemplateOnTemplateType(newValue.getTemplateId()).contains((Object)DashboardHistoryParameterWiseENUM.RedirectToTicketList)) {
                    child2 = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                    child2 = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                    child2.setOldValue("--");
                    child2.setNewValue("--");
                    DashboardHistoryParameterWiseENUM parameter = DashboardHistoryParameterWiseENUM.RedirectToUrl;
                    if (!newValue.getRedirectionToTicketList().strip().isEmpty() && newValue.getRedirectionToTicketList().strip().equalsIgnoreCase("yes")) {
                        parameter = DashboardHistoryParameterWiseENUM.RedirectToTicketList;
                    }
                    child2.setParameter(parameter);
                    if (parent.getNatureOfChange().getName().equals(DashboardHistoryFeatureWiseENUM.NewDataTemplate.getName())) {
                        child2.setOldValue("--");
                    } else {
                        child2.setOldValue(oldValue.getRedirectionToTicketList().strip().isEmpty() ? "--" : oldValue.getRedirectionToTicketList().strip());
                    }
                    child2.setNewValue(newValue.getRedirectionToTicketList().strip().isEmpty() ? "--" : newValue.getRedirectionToTicketList().strip());
                    if (!child2.getOldValue().strip().equalsIgnoreCase(child2.getNewValue().strip())) {
                        parent.getChildHistory().add(child2);
                    }
                }
                if (DashboardCollectionUtil.getFieldsOfDataTemplateOnTemplateType(newValue.getTemplateId()).contains((Object)DashboardHistoryParameterWiseENUM.RedirectionQuery) && !newValue.getRedirectionToTicketList().strip().isEmpty() && newValue.getRedirectionToTicketList().strip().equalsIgnoreCase("yes")) {
                    child2 = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                    child2 = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                    if (parent.getNatureOfChange().getName().equals(DashboardHistoryFeatureWiseENUM.NewDataTemplate.getName())) {
                        child2.setOldValue("--");
                    } else {
                        child2.setOldValue(oldValue.getRedirectionQuery().strip().isEmpty() ? "--" : oldValue.getRedirectionQuery().strip());
                    }
                    child2.setNewValue(newValue.getRedirectionQuery().strip().isEmpty() ? "--" : newValue.getRedirectionQuery().strip());
                    child2.setParameter(DashboardHistoryParameterWiseENUM.RedirectionQuery);
                    if (!child2.getOldValue().strip().equalsIgnoreCase(child2.getNewValue().strip())) {
                        parent.getChildHistory().add(child2);
                    }
                }
                if (DashboardCollectionUtil.getFieldsOfDataTemplateOnTemplateType(newValue.getTemplateId()).contains((Object)DashboardHistoryParameterWiseENUM.QuickLinkValue)) {
                    Dashboardrepository dr;
                    if (Objects.nonNull((Object)oldValue) && CollectionUtil.isNotEmpty(oldValue.getDashboardtemplateQuicklinks())) {
                        for (DashboardtemplateQuicklinksDTO dtmdDTO : oldValue.getDashboardtemplateQuicklinks()) {
                            child = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                            child = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                            child.setNewValue("--");
                            oldVal = "--";
                            if (!dtmdDTO.getDisplayName().strip().isEmpty() && !dtmdDTO.getClickFuncion().strip().isEmpty()) {
                                oldVal = dtmdDTO.getDisplayName().strip() + " = " + dtmdDTO.getClickFuncion().strip();
                            }
                            child.setOldValue((String)oldVal);
                            child.setParameter(DashboardHistoryParameterWiseENUM.QuickLinkValueDelete);
                            parent.getChildHistory().add(child);
                            if (dtmdDTO.getRepositoryId() == 0) continue;
                            child = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                            child.setOldValue("--");
                            dr = this.dashboardrepositoryDAO.getDashboardrepositoryById(dtmdDTO.getRepositoryId());
                            if (Objects.nonNull((Object)dr)) {
                                child.setOldValue(dr.getAttachmentName().strip().isEmpty() ? "--" : dr.getAttachmentName().strip());
                            }
                            child.setNewValue("--");
                            child.setParameter(DashboardHistoryParameterWiseENUM.QuickLinkIconDelete);
                            parent.getChildHistory().add(child);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(newValue.getDashboardtemplateQuicklinks())) {
                        for (DashboardtemplateQuicklinksDTO dtmdDTO : newValue.getDashboardtemplateQuicklinks()) {
                            child = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                            child.setOldValue("--");
                            newVal = "--";
                            if (!dtmdDTO.getDisplayName().strip().isEmpty() && !dtmdDTO.getClickFuncion().strip().isEmpty()) {
                                newVal = dtmdDTO.getDisplayName().strip() + " = " + dtmdDTO.getClickFuncion().strip();
                            }
                            child.setNewValue((String)newVal);
                            child.setParameter(DashboardHistoryParameterWiseENUM.QuickLinkValue);
                            parent.getChildHistory().add(child);
                            if (dtmdDTO.getRepositoryId() == 0) continue;
                            child = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                            dr = this.dashboardrepositoryDAO.getDashboardrepositoryById(dtmdDTO.getRepositoryId());
                            if (Objects.nonNull((Object)dr)) {
                                child.setNewValue(dr.getAttachmentName().strip().isEmpty() ? "--" : dr.getAttachmentName().strip());
                            }
                            child.setOldValue("--");
                            child.setParameter(DashboardHistoryParameterWiseENUM.QuickLinkIcon);
                            parent.getChildHistory().add(child);
                        }
                    }
                }
                if (!DashboardCollectionUtil.getFieldsOfDataTemplateOnTemplateType(newValue.getTemplateId()).contains((Object)DashboardHistoryParameterWiseENUM.MacroNameAndValues)) break;
                if (parent.getNatureOfChange().getName().equals(DashboardHistoryFeatureWiseENUM.UpdateDataTemplate.getName()) && Objects.nonNull((Object)oldValue) && CollectionUtil.isNotEmpty(oldValue.getDashboardtemplateRedirectionparamDetails())) {
                    for (DashboardtemplateRedirectionparamDetailsDTO dtrpdDTO : oldValue.getDashboardtemplateRedirectionparamDetails()) {
                        child = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                        child.setNewValue("--");
                        oldVal = "--";
                        if (!dtrpdDTO.getMacroName().strip().isEmpty() && !dtrpdDTO.getMacroName().strip().isEmpty()) {
                            oldVal = dtrpdDTO.getMacroName().strip() + " = " + dtrpdDTO.getMacroName().strip();
                        }
                        child.setOldValue((String)oldVal);
                        child.setParameter(DashboardHistoryParameterWiseENUM.MacroNameAndValuesDeleted);
                        parent.getChildHistory().add(child);
                    }
                }
                if (!CollectionUtil.isNotEmpty(newValue.getDashboardtemplateRedirectionparamDetails())) break;
                for (DashboardtemplateRedirectionparamDetailsDTO dtrpdDTO : newValue.getDashboardtemplateRedirectionparamDetails()) {
                    child = DashboardHistoryDTO.getDashboardHistoryForDataTemplateObject(oldValue, newValue, parent);
                    child.setOldValue("--");
                    newVal = "--";
                    if (!dtrpdDTO.getMacroName().strip().isEmpty() && !dtrpdDTO.getMacroName().strip().isEmpty()) {
                        newVal = dtrpdDTO.getMacroName().strip() + " = " + dtrpdDTO.getMacroName().strip();
                    }
                    child.setNewValue((String)newVal);
                    child.setParameter(DashboardHistoryParameterWiseENUM.MacroNameAndValues);
                    parent.getChildHistory().add(child);
                }
                break;
            }
        }
    }

    @Override
    public void formFiltersHistory(DashboardFiltersModelDTO oldValue, DashboardFiltersModelDTO newValue, DashboardHistoryDTO parent) throws DomainException, ValidationException {
        this.dashboardFiltersService.formDashboardFilterHistory(oldValue, newValue, parent);
    }

    @Override
    public void formExportHistory(DashboardHistoryDTO dhDTO, List<Integer> WidgetIds) throws DomainException, ValidationException {
        Validate.notNull((Object)((Object)dhDTO), (String)"History should not be null", (Object[])new Object[0]);
        switch (dhDTO.getParameter()) {
            case DashboardCopy: {
                Dashboardmaster dm = (Dashboardmaster)this.dashboardMasterDAO.get(dhDTO.getDashboardId());
                dhDTO.setNewValue(dm.getDashboardName());
                break;
            }
            case OnlyWidgetsCopy: {
                List<Dashboardconfiguration> dcList = this.dashboardconfigDAO.getDashboardconfigurationByIds(WidgetIds);
                String newValue = dcList.stream().filter(Objects::nonNull).map(Dashboardconfiguration::getDashboardName).collect(Collectors.joining(","));
                if (!Objects.nonNull(newValue)) break;
                dhDTO.setNewValue(newValue.strip().isEmpty() ? "--" : newValue);
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void prepareDashboardHistoryToEnableDisableWidgets(DashboardHistoryDTO dhDTO, boolean forOldValue, List<Integer> AllPlottedWidgets) throws DomainException, ValidationException {
        List<Dashboardconfiguration> dcList = this.dashboardconfigDAO.getDashboardconfigurationByIds(AllPlottedWidgets);
        if (forOldValue) {
            if (CollectionUtil.isNotEmpty(dcList)) {
                String oldValue = dcList.stream().filter(Objects::nonNull).distinct().map(Dashboardconfiguration::getDashboardName).collect(Collectors.joining(","));
                dhDTO.setOldValue(oldValue);
            }
        } else if (CollectionUtil.isNotEmpty(dcList)) {
            String newValue = dcList.stream().filter(Objects::nonNull).distinct().map(Dashboardconfiguration::getDashboardName).collect(Collectors.joining(","));
            dhDTO.setNewValue(newValue);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void prepareDashboardHistoryForCloseWidgets(DashboardHistoryDTO dhDTO, Integer widgetId) throws DomainException, ValidationException {
        Dashboardconfiguration dc = this.dashboardconfigDAO.getDashboardConfigurationById(widgetId);
        if (Objects.nonNull((Object)dc)) {
            dhDTO.setNewValue(dc.getDashboardName());
        }
    }

    @Override
    @Transactional
    public void prepareSaveAndPublisheHistory(List<Integer> widgetIds, DashboardHistoryDTO dhDTO, boolean isEnabled) throws DomainException, ValidationException {
        List<Dashboardconfiguration> dcList;
        if (CollectionUtil.isNotEmpty(widgetIds) && CollectionUtil.isNotEmpty(dcList = this.dashboardconfigDAO.getDashboardconfigurationByIds(widgetIds))) {
            String value = dcList.stream().filter(Objects::nonNull).map(Dashboardconfiguration::getDashboardName).collect(Collectors.joining(","));
            if (isEnabled) {
                dhDTO.setNewValue(value.strip().isEmpty() ? "--" : value.strip());
            } else {
                dhDTO.setOldValue(value.strip().isEmpty() ? "--" : value.strip());
            }
        }
    }
}

