/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.service.impl;

import com.sapphire.dashboard.model.DashboardconfigurationAccessDetails;
import com.sapphire.itsm.mailrouting.model.SdProjectRoles;
import com.sapphire.itsm.mailrouting.model.UserMgmtMaster;
import com.sapphireims.cmdb.dao.IAssetrolesDAO;
import com.sapphireims.cmdb.model.Assetroles;
import com.sapphireims.dao.IUserMgmtDetailsRepository;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.ims.model.UserMgmtDetails;
import com.sapphireims.itsm.dao.ISdProjectRolesDAO;
import com.sapphireims.itsm.dao.IUserMgmtMasterDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardconfigurationAccessDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardHistoryDTO;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryFeatureWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryParameterWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardMasterService;
import com.sapphireims.util.CollectionUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardMasterService
implements IDashboardMasterService {
    @Autowired
    private IDashboardconfigurationAccessDetailsDAO dashboardconfigurationAccessDetailsDAO;
    @Autowired
    private IUserMgmtDetailsRepository userMgmtDetailsRepository;
    @Autowired
    private ISdProjectRolesDAO sdProjectRolesDAO;
    @Autowired
    private IAssetrolesDAO assetrolesDAO;
    @Autowired
    private IUserMgmtMasterDAO userMgmtMasterDAO;

    @Override
    @Transactional
    public void prepareDashboardHistory(DashboardHistoryDTO parent, String oldValue, String newValue, Integer parameter, List<Integer> users, List<String> roles, boolean isUpdate) throws DomainException, ValidationException {
        switch (DashboardHistoryParameterWiseENUM.getDashboardHistoryParameterWiseENUM(parameter)) {
            case DashboardName: {
                if (isUpdate) {
                    if (oldValue.strip().equals(newValue.strip())) break;
                    parent.setParameter(DashboardHistoryParameterWiseENUM.DashboardName);
                    parent.setOldValue(oldValue.strip());
                    parent.setNewValue(newValue.strip());
                    break;
                }
                parent.setParameter(DashboardHistoryParameterWiseENUM.DashboardName);
                parent.setOldValue("--");
                parent.setNewValue(newValue.strip());
                break;
            }
            case SuperSet: {
                if (isUpdate) {
                    if (oldValue.strip().equals(newValue.strip())) break;
                    parent.setParameter(DashboardHistoryParameterWiseENUM.SuperSet);
                    parent.setOldValue(oldValue.strip());
                    parent.setNewValue(newValue.strip());
                    break;
                }
                parent.setParameter(DashboardHistoryParameterWiseENUM.SuperSet);
                parent.setOldValue("--");
                parent.setNewValue(newValue.strip());
                break;
            }
            case DashboardSuperSetId: {
                if (isUpdate) {
                    if (oldValue.strip().equals(newValue.strip())) break;
                    parent.setParameter(DashboardHistoryParameterWiseENUM.DashboardSuperSetId);
                    parent.setOldValue(oldValue.strip());
                    parent.setNewValue(newValue.strip());
                    break;
                }
                parent.setParameter(DashboardHistoryParameterWiseENUM.DashboardSuperSetId);
                parent.setOldValue("--");
                parent.setNewValue(newValue.strip());
                break;
            }
            case TableauDashboardUrl: {
                if (isUpdate) {
                    if (oldValue.strip().equals(newValue.strip())) break;
                    parent.setParameter(DashboardHistoryParameterWiseENUM.TableauDashboardUrl);
                    parent.setOldValue(oldValue.strip());
                    parent.setNewValue(newValue.strip());
                    break;
                }
                parent.setParameter(DashboardHistoryParameterWiseENUM.TableauDashboardUrl);
                parent.setOldValue("--");
                parent.setNewValue(newValue.strip());
                break;
            }
            case DashboardUsers: {
                Object dcadList;
                LinkedList<String> userNames = new LinkedList<String>();
                String usersOldValue = "--";
                String usersNewValue = "--";
                if (isUpdate && CollectionUtil.isNotEmpty(dcadList = this.dashboardconfigurationAccessDetailsDAO.getDashboardconfigurationAccessDetailsByDashboardId(parent.getDashboardId()))) {
                    LinkedList existingUsersList = dcadList.stream().filter(Objects::nonNull).filter(obj -> obj.getAccessType() == 6).map(DashboardconfigurationAccessDetails::getAccessValue).collect(Collectors.toList());
                    LinkedList linkedList = existingUsersList = CollectionUtil.isEmpty(existingUsersList) ? new LinkedList() : existingUsersList;
                    if (CollectionUtil.isNotEmpty(existingUsersList)) {
                        for (Integer user : existingUsersList) {
                            UserMgmtMaster umm = this.userMgmtMasterDAO.getUserMgmtMasterByUserDetailsId(user);
                            if (!Objects.nonNull(umm)) continue;
                            userNames.add(umm.getFullName());
                        }
                        Collections.sort(userNames);
                        usersOldValue = userNames.stream().filter(Objects::nonNull).collect(Collectors.joining(","));
                        userNames.clear();
                    }
                }
                if (CollectionUtil.isNotEmpty(users)) {
                    for (Integer user : users) {
                        UserMgmtMaster umm = this.userMgmtMasterDAO.getUserMgmtMasterByUserDetailsId(user);
                        if (!Objects.nonNull(umm)) continue;
                        userNames.add(umm.getFullName());
                    }
                    Collections.sort(userNames);
                    usersNewValue = userNames.stream().filter(Objects::nonNull).collect(Collectors.joining(","));
                }
                if (usersNewValue.strip().equals(usersOldValue.strip())) break;
                DashboardHistoryDTO childDhDTO = DashboardHistoryDTO.builder().parameter(DashboardHistoryParameterWiseENUM.DashboardUsers).newValue(usersNewValue).oldValue(usersOldValue).currentTime(parent.getCurrentTime()).actionPerformedBy("--").natureOfChange(DashboardHistoryFeatureWiseENUM.Default).childOf(0).userid(parent.getUserid()).dashboardId(parent.getDashboardId()).projectId(parent.getProjectId()).build();
                parent.addHistory(childDhDTO);
                break;
            }
            case DashboardRoles: {
                LinkedList<String> roleNames = new LinkedList<String>();
                String rolesOldValue = "--";
                String rolesNewValue = "--";
                if (isUpdate) {
                    List<DashboardconfigurationAccessDetails> dcadList = this.dashboardconfigurationAccessDetailsDAO.getDashboardconfigurationAccessDetailsByDashboardId(parent.getDashboardId());
                    LinkedList existingGlobalRoles = dcadList.stream().filter(Objects::nonNull).filter(obj -> obj.getAccessType() == 7).map(DashboardconfigurationAccessDetails::getAccessValue).collect(Collectors.toList());
                    existingGlobalRoles = CollectionUtil.isEmpty(existingGlobalRoles) ? new LinkedList() : existingGlobalRoles;
                    LinkedList existingItsmRoles = dcadList.stream().filter(Objects::nonNull).filter(obj -> obj.getAccessType() == 3).map(DashboardconfigurationAccessDetails::getAccessValue).collect(Collectors.toList());
                    existingItsmRoles = CollectionUtil.isEmpty(existingItsmRoles) ? new LinkedList() : existingItsmRoles;
                    LinkedList existingCmdbRoles = dcadList.stream().filter(Objects::nonNull).filter(obj -> obj.getAccessType() == 8).map(DashboardconfigurationAccessDetails::getAccessValue).collect(Collectors.toList());
                    LinkedList linkedList = existingCmdbRoles = CollectionUtil.isEmpty(existingCmdbRoles) ? new LinkedList() : existingCmdbRoles;
                    if (CollectionUtil.isNotEmpty(existingGlobalRoles)) {
                        for (Integer role : existingGlobalRoles) {
                            UserMgmtDetails umd = this.userMgmtDetailsRepository.findByAccessId(role);
                            if (!Objects.nonNull(umd)) continue;
                            roleNames.add(umd.getAccessType());
                        }
                    }
                    if (CollectionUtil.isNotEmpty(existingItsmRoles)) {
                        for (Integer role : existingItsmRoles) {
                            SdProjectRoles spr = (SdProjectRoles)this.sdProjectRolesDAO.get(role);
                            if (!Objects.nonNull((Object)spr)) continue;
                            roleNames.add(spr.getRoleDisplayName());
                        }
                    }
                    if (CollectionUtil.isNotEmpty(existingCmdbRoles)) {
                        for (Integer role : existingCmdbRoles) {
                            Assetroles ar = (Assetroles)this.assetrolesDAO.get(role);
                            if (!Objects.nonNull((Object)ar)) continue;
                            roleNames.add(ar.getRoleName());
                        }
                    }
                    if (CollectionUtil.isNotEmpty(roleNames)) {
                        Collections.sort(roleNames);
                        rolesOldValue = roleNames.stream().filter(Objects::nonNull).collect(Collectors.joining(","));
                        roleNames.clear();
                    }
                }
                if (CollectionUtil.isNotEmpty(roles)) {
                    for (String role : roles) {
                        Assetroles ar;
                        String[] tempString = role.split("\\|@@\\|");
                        if (tempString[0].equals("2")) {
                            UserMgmtDetails umd = this.userMgmtDetailsRepository.findByAccessId(Integer.valueOf(NumberUtils.toInt((String)tempString[1])));
                            if (!Objects.nonNull(umd)) continue;
                            roleNames.add(umd.getAccessType());
                            continue;
                        }
                        if (tempString[0].equals("4")) {
                            SdProjectRoles spr = (SdProjectRoles)this.sdProjectRolesDAO.get(Integer.valueOf(NumberUtils.toInt((String)tempString[1])));
                            if (!Objects.nonNull((Object)spr)) continue;
                            roleNames.add(spr.getRoleDisplayName());
                            continue;
                        }
                        if (!tempString[0].equals("5") || !Objects.nonNull((Object)(ar = (Assetroles)this.assetrolesDAO.get(Integer.valueOf(NumberUtils.toInt((String)tempString[1])))))) continue;
                        roleNames.add(ar.getRoleName());
                    }
                    Collections.sort(roleNames);
                    rolesNewValue = roleNames.stream().filter(Objects::nonNull).collect(Collectors.joining(","));
                }
                if (rolesNewValue.strip().equals(rolesOldValue.strip())) break;
                DashboardHistoryDTO childDhDTO = DashboardHistoryDTO.builder().parameter(DashboardHistoryParameterWiseENUM.DashboardRoles).newValue(rolesNewValue).oldValue(rolesOldValue).currentTime(parent.getCurrentTime()).actionPerformedBy("--").natureOfChange(DashboardHistoryFeatureWiseENUM.Default).childOf(0).userid(parent.getUserid()).dashboardId(parent.getDashboardId()).projectId(parent.getProjectId()).build();
                parent.addHistory(childDhDTO);
            }
        }
    }
}

