/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.service.impl;

import com.sapphire.dashboard.model.Dashboardrepository;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.service.ICopyAndCompressFilesService;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardrepositoryDAO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardCopyDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardExportRequestDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardrepositoryDTO;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardRepositoryService;
import com.sapphireims.modulecopy.dto.ModuleCopyAttachmentsDTO;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardRepositoryService
implements IDashboardRepositoryService {
    @Autowired
    private IDashboardrepositoryDAO dashboardrepositoryDAO;
    @Autowired
    protected ICopyAndCompressFilesService copyAndCompressFilesService;

    @Override
    public List<Dashboardrepository> getDashboardRepositoryList(List<Dashboardrepository> drList, DashboardExportRequestDTO req) throws DomainException {
        Validate.notNull(drList);
        ModuleCopyAttachmentsDTO mcaDTO = req.getMcaDTO();
        LinkedList<Dashboardrepository> drListTemp = new LinkedList<Dashboardrepository>();
        if (CollectionUtil.isNotEmpty(drList) && mcaDTO != null) {
            String sourcePath = mcaDTO.getWarFilePath() + "\\assets\\images\\dashboard\\icons\\";
            String destinationPath = this.copyAndCompressFilesService.getDestinationDirectoryPath();
            HashMap<Integer, Dashboardrepository> drMap = new HashMap<Integer, Dashboardrepository>();
            for (Dashboardrepository dr : drList) {
                if (drMap.containsKey(dr.getRepositoryId())) continue;
                drListTemp.add(dr);
                drMap.put(dr.getRepositoryId(), dr);
                Object oldUIPath = "";
                oldUIPath = dr.isIsInbuilt() ? sourcePath + "\\default\\" + dr.getAttachmentName() : sourcePath + "\\" + dr.getAttachmentName();
                try {
                    File oldUIFile = new File((String)oldUIPath);
                    if (!oldUIFile.exists() || oldUIFile.isDirectory()) continue;
                    FileUtils.copyFile((File)oldUIFile, (File)FileUtils.getFile((String[])new String[]{destinationPath + "\\" + dr.getAttachmentName()}));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return drListTemp;
    }

    @Override
    public DashboardExportRequestDTO replaceAndUpdateDashboardRepository(DashboardExportRequestDTO req, IDashboardrepositoryDAO dashboardRepo) throws DomainException, ValidationException {
        ModuleCopyAttachmentsDTO mcaDTO = req.getMcaDTO();
        if (mcaDTO != null) {
            String sourcePath = mcaDTO.getWarFilePath() + "\\assets\\images\\dashboard\\icons\\";
            String fileLoc = mcaDTO.getModulePath();
            ArrayList<Dashboardrepository> drList = new ArrayList<Dashboardrepository>();
            DashboardCopyDTO dDTO = req.getDashbaordCopyDTO();
            if (CollectionUtil.isNotEmpty(dDTO.getDashboardrepositories())) {
                for (DashboardrepositoryDTO drDTO : dDTO.getDashboardrepositories()) {
                    Dashboardrepository dr = null;
                    if (drDTO.isIsInbuilt()) {
                        dr = dashboardRepo.getDashboardrepositoryByName(drDTO.getAttachmentName());
                    } else {
                        Dashboardrepository dashboardrepository = dr = req.getOldIdDashboardRepositoryMap().containsKey(drDTO.getRepositoryId()) ? req.getOldIdDashboardRepositoryMap().get(drDTO.getRepositoryId()) : null;
                        if (dr == null) {
                            String oldAttachment = drDTO.getAttachmentName();
                            String TimeInMilliSec = "" + Calendar.getInstance().getTimeInMillis();
                            File oldUIFromCopy = new File(fileLoc + "\\" + oldAttachment);
                            try {
                                if (oldUIFromCopy.exists() && !oldUIFromCopy.isDirectory()) {
                                    dr = new Dashboardrepository();
                                    dr.setComment(drDTO.getComment());
                                    dr.setIsInbuilt(drDTO.isIsInbuilt());
                                    dr.setTemplateId(drDTO.getTemplateId());
                                    String fileName = mcaDTO.getSessionId() + "_" + TimeInMilliSec + "_" + mcaDTO.getUserFullName() + "_" + drDTO.getAttachmentName().split("_")[3];
                                    FileUtils.copyFile((File)oldUIFromCopy, (File)FileUtils.getFile((String[])new String[]{sourcePath + "\\" + fileName}));
                                    dr.setAttachmentName(fileName);
                                    dr.setAttachment("assets/images/dashboard/icons/" + fileName);
                                }
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (dr == null) continue;
                    req.getOldIdDashboardRepositoryMap().put(drDTO.getRepositoryId(), dr);
                    drList.add(dr);
                }
            }
            req.setDashboardrepositorys(drList);
        }
        return req;
    }
}

