/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.modulecopy.dashboardcopy.service.impl;

import com.sapphire.dashboard.model.DashboardtemplateMacrodetails;
import com.sapphire.dashboard.model.DashboardtemplateQuicklinks;
import com.sapphire.dashboard.model.DashboardtemplateRedirectionparamDetails;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardtemplateMacrodetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardtemplateQuicklinksDAO;
import com.sapphireims.modulecopy.dashboardcopy.dao.IDashboardtemplateRedirectionparamDetailsDAO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardtemplateMacrodetailsDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardtemplateQuicklinksDTO;
import com.sapphireims.modulecopy.dashboardcopy.dto.DashboardtemplateRedirectionparamDetailsDTO;
import com.sapphireims.modulecopy.dashboardcopy.service.IDashboardTemplateMacroDetailsService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardTemplateMacroDetailsService
implements IDashboardTemplateMacroDetailsService {
    @Autowired
    private IDashboardtemplateMacrodetailsDAO dashboardtemplateMacrodetailsDAO;
    @Autowired
    private IDashboardtemplateQuicklinksDAO dashboardtemplateQuicklinksDAO;
    @Autowired
    private IDashboardtemplateRedirectionparamDetailsDAO dashboardtemplateRedirectionparamDetailsDAO;

    @Override
    @Transactional
    public DashboardtemplateMacrodetailsDTO prepareDashboardTemplateMacrodetailsDtoOnMacroId(int macroId) throws DomainException, ValidationException {
        List<DashboardtemplateRedirectionparamDetails> dtrpdList;
        DashboardtemplateMacrodetails dtmd = this.dashboardtemplateMacrodetailsDAO.getDashboardtemplateMacrodetailsByMacroId(macroId);
        Validate.notNull((Object)((Object)dtmd), (String)"MacroId is not correct", (Object[])new Object[0]);
        DashboardtemplateMacrodetailsDTO dtdmDTO = new DashboardtemplateMacrodetailsDTO(dtmd, null, null);
        List<DashboardtemplateQuicklinks> dtqlList = this.dashboardtemplateQuicklinksDAO.getDashboardtemplateQuicklinksByMacroId(macroId);
        if (CollectionUtil.isNotEmpty(dtqlList)) {
            for (DashboardtemplateQuicklinks dtql : dtqlList) {
                DashboardtemplateQuicklinksDTO dtqlDTO = DashboardtemplateQuicklinksDTO.builder().detailsId(dtql.getDetailsId()).displayName(dtql.getDisplayName()).macroId(dtql.getMacroId()).repositoryId(dtql.getRepositoryId()).clickFuncion(dtql.getClickFuncion()).build();
                if (Objects.isNull(dtdmDTO.getDashboardtemplateQuicklinks())) {
                    dtdmDTO.setDashboardtemplateQuicklinks(new LinkedList<DashboardtemplateQuicklinksDTO>());
                }
                dtdmDTO.getDashboardtemplateQuicklinks().add(dtqlDTO);
            }
        }
        if (CollectionUtil.isNotEmpty(dtrpdList = this.dashboardtemplateRedirectionparamDetailsDAO.getDashboardtemplateRedirectionparamDetailsByMacroId(dtmd.getMacroId()))) {
            for (DashboardtemplateRedirectionparamDetails dtrpd : dtrpdList) {
                DashboardtemplateRedirectionparamDetailsDTO dtrpdDTO = new DashboardtemplateRedirectionparamDetailsDTO(dtrpd);
                if (Objects.isNull(dtdmDTO.getDashboardtemplateRedirectionparamDetails())) {
                    dtdmDTO.setDashboardtemplateRedirectionparamDetails(new LinkedList<DashboardtemplateRedirectionparamDetailsDTO>());
                }
                dtdmDTO.getDashboardtemplateRedirectionparamDetails().add(dtrpdDTO);
            }
        }
        return dtdmDTO;
    }
}

