/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.react.dao.impl;

import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.react.dao.IReactNativeAPIDao;
import com.sapphireims.react.utils.NativeUtility;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class ReactNativeAPIDaoImpl
implements IReactNativeAPIDao {
    private final IHibernateRepositoryOperations hibernateRepositoryOperations;
    public static final String USER_DETAILS = "userDetails";

    public ReactNativeAPIDaoImpl(IHibernateRepositoryOperations hibernateRepositoryOperations) {
        this.hibernateRepositoryOperations = hibernateRepositoryOperations;
    }

    @Override
    public String executeQuery(String query) {
        String[] params = new String[]{};
        Object[] values = new String[]{};
        return this.hibernateRepositoryOperations.findByNamedParamUniqueResultUsingSQL(query, params, values).toString();
    }

    @Override
    public List<Object[]> executeSqlQuery(String query) {
        String[] params = new String[]{};
        Object[] values = new String[]{};
        return this.hibernateRepositoryOperations.findByNamedParamSql(query, params, values, Object[].class);
    }

    @Override
    public Map<String, Object> updateAdminAuditLog(String signInOutTime, Integer userId, Integer type) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        String sqlQuery = "insert into admin_auditlog(AdminID,SigninTime) values(:userId,:signInOutTime)";
        if (type == 0) {
            sqlQuery = "update admin_auditlog set SignoutTime= :signInOutTime where AdminID= :userId  and SignoutTime='0000-00-00 00:00:00'";
        }
        NativeQuery query = this.hibernateRepositoryOperations.getSessionFactory().getCurrentSession().createNativeQuery(sqlQuery, Integer.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("signInOutTime", (Object)signInOutTime);
        Integer status = query.executeUpdate();
        resultMap.put("status", status);
        return resultMap;
    }

    @Override
    public String getSignInDetails(Integer userId) {
        String sqlQuery = "SELECT SigninTime FROM admin_auditlog where AdminID= :userId order by SigninTime desc limit 1";
        String[] params = new String[]{"userId"};
        Object[] values = new Object[]{userId};
        Timestamp result = (Timestamp)this.hibernateRepositoryOperations.findByNamedParamUniqueResultUsingSQL(sqlQuery, params, values);
        return NativeUtility.getStandardFormattedDate(result);
    }

    @Override
    public List<Object[]> executeSQLQuery(String query, String[] params, Object[] values) {
        return this.hibernateRepositoryOperations.findByNamedParamSql(query, params, values, Object[].class);
    }

    @Override
    public List<Object[]> executeCallableStatements(String chartQuery) {
        ArrayList<Object[]> resultSet = new ArrayList<Object[]>(1);
        Session session = this.hibernateRepositoryOperations.getSessionFactory().getCurrentSession();
        String finalChartQuery = chartQuery;
        session.doWork(connection -> {
            try (CallableStatement statement = connection.prepareCall(finalChartQuery);
                 ResultSet rs = statement.executeQuery();){
                ResultSetMetaData metaData = rs.getMetaData();
                int columnSize = metaData.getColumnCount();
                while (rs.next()) {
                    Object[] result = new Object[columnSize];
                    for (int i = 0; i < columnSize; ++i) {
                        try {
                            result[i] = rs.getString(1);
                            continue;
                        }
                        catch (Exception ex) {
                            result[i] = rs.getInt(1);
                        }
                    }
                    resultSet.add(result);
                }
            }
        });
        return resultSet;
    }

    @Override
    public List<Object[]> executeSQLQueryWithPreparedStatements(String sqlQuery) {
        ArrayList<Object[]> resultSet = new ArrayList<Object[]>(1);
        Session session = this.hibernateRepositoryOperations.getSessionFactory().getCurrentSession();
        session.doWork(connection -> {
            try (PreparedStatement statement = connection.prepareStatement(sqlQuery);
                 ResultSet rs = statement.executeQuery();){
                ResultSetMetaData metaData = rs.getMetaData();
                int columnSize = metaData.getColumnCount();
                while (rs.next()) {
                    Object[] result = new Object[columnSize];
                    for (int i = 0; i < columnSize; ++i) {
                        try {
                            result[i] = rs.getString(1);
                            continue;
                        }
                        catch (Exception ex) {
                            result[i] = rs.getInt(1);
                        }
                    }
                    resultSet.add(result);
                }
            }
        });
        return resultSet;
    }

    @Override
    public List<Object[]> executeAdditionalFieldSqlQuery(String query) {
        try {
            return this.executeSqlQuery(query);
        }
        catch (Exception ex) {
            String updatedQuery = NativeUtility.replaceAliasNames(query);
            return this.executeSqlQuery(updatedQuery);
        }
    }

    @Override
    public String getSlaViolationTimeInfo(Integer problemId, Integer slaId) {
        String time = "";
        String query = "SELECT Sla_Violationinfo(:problemId,:slaId)";
        String[] params = new String[]{"problemId", "slaId"};
        Object[] values = new Object[]{problemId, slaId};
        time = this.hibernateRepositoryOperations.findByNamedParamUniqueResultUsingSQL(query, params, values).toString();
        return time;
    }
}

