/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.react.dao.impl;

import com.sapphire.itsm.mailrouting.model.UserMgmtMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.IUserMgmtMasterDAO;
import com.sapphireims.itsm.model.SdSearchprofilesDetails;
import com.sapphireims.react.dao.ISdSearchprofilesDetailsDAO;
import com.sapphireims.react.dto.UserFilterRequestBodyDTO;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SdSearchprofilesDetailsDaoImpl
extends GenericHibernateRepository<SdSearchprofilesDetails, Integer>
implements ISdSearchprofilesDetailsDAO {
    public static final String USER_DETAILS = "userDetails";
    IUserMgmtMasterDAO userMgmtMasterDAO;

    @Autowired
    public void setUserMgmtMasterDAO(IUserMgmtMasterDAO userMgmtMasterDAO) {
        this.userMgmtMasterDAO = userMgmtMasterDAO;
    }

    @Override
    public SdSearchprofilesDetails getDefaultSearchProfiles(Integer userId, Integer profileType, Integer projectId) {
        String query = " from SdSearchprofilesDetails where parameterId = 14 and sdSearchprofilesMaster.profileType = :profileType and sdSearchprofilesMaster.projectId=:projectId and (sdSearchprofilesMaster.userId=:userId or sdSearchprofilesMaster.access = 0) and parameterValue = :parameterValue ";
        String[] params = new String[]{"userId", "profileType", "projectId", "parameterValue"};
        Object[] values = new Object[]{userId, profileType, projectId, Integer.toString(userId)};
        return (SdSearchprofilesDetails)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, params, values, SdSearchprofilesDetails.class));
    }

    @Override
    public List<UserMgmtMaster> getUsersBySearch(UserFilterRequestBodyDTO dto, Set<Integer> userIds, int pageNo) {
        HibernateCriteriaBuilder builder = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(UserMgmtMaster.class);
        Root root = criteriaQuery.from(UserMgmtMaster.class);
        root.join(USER_DETAILS);
        Predicate predicate = builder.equal((Expression)root.get(USER_DETAILS).get("userStatus"), (Object)0);
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        predicateList.add(predicate);
        if (dto.getFilterByType() != null && dto.getFilterByType() == 2) {
            predicateList.add(builder.equal((Expression)root.get(USER_DETAILS).get("isAvailable"), (Object)1));
        }
        if (dto.getLocationId() != null && dto.getLocationId() != 0) {
            predicateList.add(builder.equal((Expression)root.get("locationId"), (Object)dto.getLocationId()));
        }
        if (dto.getDepartmentId() != null && dto.getDepartmentId() != 0) {
            predicateList.add(builder.equal((Expression)root.get("departmentId"), (Object)dto.getDepartmentId()));
        }
        predicateList.add(root.get(USER_DETAILS).get("userId").in(userIds));
        if (dto.getSearchString() != null) {
            Path departmentName = root.get("fullName");
            predicateList.add(builder.like((Expression)departmentName, "%" + dto.getSearchString() + "%"));
        }
        criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get("fullName"))});
        Predicate finalPredicate = builder.and(predicateList.toArray(new Predicate[0]));
        criteriaQuery.select((Selection)root).where((Expression)finalPredicate);
        return this.userMgmtMasterDAO.getUsersByCriteria(criteriaQuery, Integer.valueOf(pageNo));
    }
}

