/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.react.dto;

import com.sapphireims.itsm.dto.ValidationscriptCustommethodsDTO;
import com.sapphireims.itsm.dto.ValidationscriptDetailsDTO;
import com.sapphireims.itsm.dto.ValidationscriptMappingDTO;
import com.sapphireims.util.CollectionUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CustomScriptDTO {
    Integer scriptId;
    String content;
    Integer scriptType;
    String scriptName;
    boolean customMethodAvailable;
    Integer actionId;
    List<Map<String, Object>> customMethodMapping;

    public CustomScriptDTO(ValidationscriptDetailsDTO script) {
        this.scriptId = script.getId();
        this.includeCustomMethods(script);
        this.scriptType = script.getScripttype();
        this.content = script.getMobileAppContent();
        this.scriptName = script.getScriptname();
    }

    public void includeCustomMethods(ValidationscriptDetailsDTO script) {
        HashMap<Integer, Integer> methodMapping = new HashMap<Integer, Integer>(0);
        if (CollectionUtil.isNotEmpty(script.getValidationscriptMappings())) {
            for (ValidationscriptMappingDTO mapping : script.getValidationscriptMappings()) {
                if (mapping.getMethodMappingId() == null) continue;
                if (mapping.getCustommethod() != 0) {
                    methodMapping.put(mapping.getCustommethod(), mapping.getMethodMappingId());
                    continue;
                }
                this.actionId = mapping.getMethodMappingId();
                break;
            }
        }
        if (CollectionUtil.isNotEmpty(script.getValidationscriptCustommethodses())) {
            this.customMethodMapping = new LinkedList<Map<String, Object>>();
            for (ValidationscriptCustommethodsDTO customMethod : script.getValidationscriptCustommethodses()) {
                if (!methodMapping.containsKey(customMethod.getMethodId()) || customMethod.getMethodNames() == null || customMethod.getArguments() == null) continue;
                LinkedHashMap<String, Object> customMethodData = new LinkedHashMap<String, Object>();
                customMethodData.put("actionId", customMethod.getMethodId());
                customMethodData.put("content", customMethod.getMethodNames() + "(" + customMethod.getArguments() + ");");
                this.customMethodMapping.add(customMethodData);
            }
        }
    }

    public CustomScriptDTO() {
    }

    public Integer getScriptId() {
        return this.scriptId;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getScriptType() {
        return this.scriptType;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public boolean isCustomMethodAvailable() {
        return this.customMethodAvailable;
    }

    public Integer getActionId() {
        return this.actionId;
    }

    public List<Map<String, Object>> getCustomMethodMapping() {
        return this.customMethodMapping;
    }

    public void setScriptId(Integer scriptId) {
        this.scriptId = scriptId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setScriptType(Integer scriptType) {
        this.scriptType = scriptType;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setCustomMethodAvailable(boolean customMethodAvailable) {
        this.customMethodAvailable = customMethodAvailable;
    }

    public void setActionId(Integer actionId) {
        this.actionId = actionId;
    }

    public void setCustomMethodMapping(List<Map<String, Object>> customMethodMapping) {
        this.customMethodMapping = customMethodMapping;
    }
}

