/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.react.utils;

import com.sapphire.itsm.mailrouting.model.UserMgmtMaster;
import com.sapphireims.ims.model.DefaultHomepageOptions;
import com.sapphireims.itsm.dto.SdConfigSettingsDTO;
import com.sapphireims.itsm.dto.SdProjectRolesAccessDTO;
import com.sapphireims.itsm.dto.SdProjectRolesDTO;
import com.sapphireims.itsm.dto.SdProjectRolesDetailsDTO;
import com.sapphireims.itsm.dto.SdServiceDTO;
import com.sapphireims.itsm.dto.SdViewaccessDetailsDTO;
import com.sapphireims.itsm.dto.SdViewaccessMasterDTO;
import com.sapphireims.itsm.dto.SdWorkgroupDetailsDTO;
import com.sapphireims.itsm.dto.SdWorkgroupMasterDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.dto.ticket.TicketDTO;
import com.sapphireims.itsm.dto.user.UserDTO;
import com.sapphireims.itsm.model.SdQuicktemplateFieldvalues;
import com.sapphireims.itsm.model.SdViewaccessDetails;
import com.sapphireims.itsm.model.SdViewaccessMaster;
import com.sapphireims.react.dto.AdditionalParamsRequestBodyDTO;
import com.sapphireims.react.dto.DefaultHomepageOptionsDTO;
import com.sapphireims.react.dto.FieldValuesDTO;
import com.sapphireims.react.enummodel.ColorClassEnum;
import com.sapphireims.util.CollectionUtil;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.MethodInvocationException;

public class NativeUtility {
    public static Map<Integer, DefaultHomepageOptionsDTO> getDefaultHomepageOptionsDTOList(List<DefaultHomepageOptions> list) {
        HashMap<Integer, DefaultHomepageOptionsDTO> map = new HashMap<Integer, DefaultHomepageOptionsDTO>();
        List<Integer> sno = Arrays.asList(10, 11, 12, 13, 17, 18, 19);
        if (CollectionUtil.isNotEmpty(list)) {
            for (DefaultHomepageOptions defaultObject : list) {
                if (!sno.contains(defaultObject.getSno())) continue;
                map.put(defaultObject.getSno(), new DefaultHomepageOptionsDTO(defaultObject));
            }
        }
        return map;
    }

    public static String isProcedureGetQuery(String query, String schema) {
        if (query.startsWith("call") && query.endsWith(");")) {
            query = query.replaceAll("V_SCHEMA", schema);
            query = query.replaceAll("schema", schema);
        } else {
            query = query.replaceAll("schema.call\\(", "");
            query = query.replaceAll("schema", schema);
            query = query.replaceAll("\\);", "");
        }
        return query;
    }

    public static String getDashboardColorClass(String colour) {
        String colourClass = ColorClassEnum.AQUA.getColorCode();
        switch (colour) {
            case "bg-aqua": {
                colourClass = ColorClassEnum.AQUA.getColorCode();
                break;
            }
            case "bg-green": {
                colourClass = ColorClassEnum.GREEN.getColorCode();
                break;
            }
            case "bg-yellow": {
                colourClass = ColorClassEnum.YELLOW.getColorCode();
                break;
            }
            case "bg-red": {
                colourClass = ColorClassEnum.RED.getColorCode();
                break;
            }
            case "bg-light-blue": {
                colourClass = ColorClassEnum.LIGHT_BLUE.getColorCode();
                break;
            }
            case "bg-blue": {
                colourClass = ColorClassEnum.BLUE.getColorCode();
            }
        }
        return colourClass;
    }

    public static String getPrivilegeAccessQuery(UserDTO user, ProjectDTO project, Set<Integer> projectRoleIds) {
        String subCategoryPrivileges;
        String servicePrivileges;
        Object query = "";
        String locationPrivileges = "";
        ArrayList<String> locationViewAccess = new ArrayList<String>(1);
        ArrayList<String> departmentViewAccess = new ArrayList<String>(1);
        ArrayList<String> serviceViewAccess = new ArrayList<String>(1);
        ArrayList<String> subCategoryViewAccess = new ArrayList<String>(1);
        ArrayList viewAccessMasters = project.getViewaccessMasters() != null ? project.getViewaccessMasters() : new ArrayList(1);
        for (SdViewaccessMasterDTO viewAccessMaster : viewAccessMasters) {
            List<SdViewaccessDetailsDTO> viewAccessDetails = viewAccessMaster.getSdViewaccessDetailses();
            SdViewaccessDetailsDTO tempViewAccessDetails = viewAccessDetails.stream().filter(Objects::nonNull).filter(e -> e.getModuleType() == 1 && NumberUtils.isCreatable((String)e.getAccessValue()) && projectRoleIds.contains(Integer.parseInt(e.getAccessValue()))).findAny().orElse(null);
            if (tempViewAccessDetails == null) continue;
            switch (tempViewAccessDetails.getAccessType()) {
                case 1: {
                    locationViewAccess.add(tempViewAccessDetails.getAccessValue());
                    break;
                }
                case 2: {
                    departmentViewAccess.add(tempViewAccessDetails.getAccessValue());
                    break;
                }
                case 3: {
                    subCategoryViewAccess.add(tempViewAccessDetails.getAccessValue());
                    break;
                }
                case 4: {
                    serviceViewAccess.add(tempViewAccessDetails.getAccessValue());
                }
            }
        }
        if (!locationViewAccess.isEmpty() && !(locationPrivileges = locationViewAccess.size() == 1 && locationViewAccess.contains("0") ? Integer.toString(user.getLocation().getLocationId()) : StringUtils.join(locationViewAccess, (String)",")).trim().isEmpty()) {
            query = (String)query + " and LocationID in (" + locationPrivileges + ")";
        }
        if (!departmentViewAccess.isEmpty()) {
            String departmentPrivileges = departmentViewAccess.size() == 1 && departmentViewAccess.contains("0") ? Integer.toString(user.getDepartment().getDepartmentId()) : StringUtils.join(departmentViewAccess, (String)",");
            if (!locationPrivileges.trim().isEmpty()) {
                query = (String)query + " and DepartmentID in (" + departmentPrivileges + ")";
            }
        }
        if (!serviceViewAccess.isEmpty() && !(servicePrivileges = serviceViewAccess.size() == 1 && ((String)serviceViewAccess.get(0)).equals("All") ? "" : StringUtils.join(serviceViewAccess, (String)",")).trim().isEmpty()) {
            query = (String)query + " and ServiceID in (" + servicePrivileges + ")";
        }
        if (!subCategoryViewAccess.isEmpty() && !(subCategoryPrivileges = subCategoryViewAccess.size() == 1 && ((String)subCategoryViewAccess.get(0)).equals("All") ? "" : StringUtils.join(subCategoryViewAccess, (String)",")).trim().isEmpty()) {
            query = " and SubCategory in (" + subCategoryPrivileges + ")";
        }
        return query;
    }

    public static List<Integer> getAccessedFixedFields(ProjectDTO project, List<Integer> projectRoleIds, Integer fieldAccessType) {
        ArrayList<Integer> fieldIds = new ArrayList<Integer>(1);
        ArrayList viewAccessMasters = project.getViewaccessMasters() != null ? project.getViewaccessMasters() : new ArrayList(1);
        block0: for (SdViewaccessMasterDTO viewAccessMaster : viewAccessMasters) {
            List<SdViewaccessDetailsDTO> viewAccessDetails = viewAccessMaster.getSdViewaccessDetailses();
            if (!CollectionUtil.isNotEmpty(viewAccessDetails)) continue;
            for (SdViewaccessDetailsDTO detail : viewAccessDetails) {
                if (detail.getModuleType() != 1 || !detail.getAccessValue().equalsIgnoreCase("all") && !projectRoleIds.contains(Integer.parseInt(detail.getAccessValue()))) continue;
                if (!NumberUtils.isCreatable((String)detail.getAccessValue()) || detail.getAccessType() != fieldAccessType.intValue()) continue block0;
                fieldIds.add(Integer.parseInt(detail.getAccessValue()));
                continue block0;
            }
        }
        return fieldIds;
    }

    public static String replaceQueryMacros(String query, AdditionalParamsRequestBodyDTO queryParams) {
        query = query.replaceAll("QUERY::", "");
        query = query.replace("USERID_MACRO", queryParams.getUserId() != 0 ? Integer.toString(queryParams.getUserId()) : "");
        query = query.replace("ASSETID_MACRO", queryParams.getImpactedAssetId() != 0 ? Integer.toString(queryParams.getImpactedAssetId()) : "");
        query = query.replace("PROBLEMID_MACRO", queryParams.getProblemId() != 0 ? Integer.toString(queryParams.getProblemId()) : "");
        query = query.replace("PROJECT_MACRO", queryParams.getProjectId() != 0 ? Integer.toString(queryParams.getProjectId()) : "");
        query = query.replace("MACRO_PROJECT", queryParams.getProjectId() != 0 ? Integer.toString(queryParams.getProjectId()) : "");
        query = query.replace("SERVICE_MACRO", queryParams.getServiceId() != null ? Integer.toString(queryParams.getServiceId()) : "");
        query = query.replace("CATEGORY_MACRO", queryParams.getCategoryId() != null ? Integer.toString(queryParams.getCategoryId()) : "");
        query = query.replace("SUBCATEGORYID_MACRO", queryParams.getSubCategoryId() != null ? Integer.toString(queryParams.getSubCategoryId()) : "");
        query = query.replace("DERIVEDFIELD1_MACRO", queryParams.getDerivedField1() != 0 ? Integer.toString(queryParams.getDerivedField1()) : "");
        query = query.replace("DERIVEDFIELD2_MACRO", queryParams.getDerivedField2() != 0 ? Integer.toString(queryParams.getDerivedField2()) : "");
        query = query.replace("DERIVEDFIELD3_MACRO", queryParams.getDerivedField3() != 0 ? Integer.toString(queryParams.getDerivedField3()) : "");
        query = query.replace("STATE_MACRO", queryParams.getStateId() != 0 ? Integer.toString(queryParams.getStateId()) : "");
        query = query.replace("SUBMITTER_MACRO", queryParams.getSubmitterId() != 0 ? Integer.toString(queryParams.getSubmitterId()) : "");
        query = query.replace("LOCATION_MACRO", queryParams.getLocationId() != 0 ? Integer.toString(queryParams.getLocationId()) : "");
        query = query.replace("DEPARTMENT_MACRO", queryParams.getDepartmentId() != 0 ? Integer.toString(queryParams.getDepartmentId()) : "");
        query = query.replace("MACRO_PARENTFIELD_ID", queryParams.getDependentFieldId() != 0 ? Integer.toString(queryParams.getDependentFieldId()) : "");
        query = query.replaceAll("MACRO_PARENTFIELD_VALUE", queryParams.getParentFieldValue() != null ? queryParams.getParentFieldValue() : "");
        query = query.replaceAll("MACRO_SEARCHTEXT", queryParams.getSearchString() != null ? queryParams.getSearchString() : "");
        return query;
    }

    public static List<Integer> getInActiveServiceIds(ProjectDTO projectDetails) {
        List<SdServiceDTO> services = projectDetails.getServices();
        ArrayList<Integer> nonActiveServiceIds = new ArrayList<Integer>(1);
        if (services != null && !services.isEmpty()) {
            services.forEach(e -> {
                if (e.getStatus() == 1) {
                    nonActiveServiceIds.add(e.getServiceId());
                }
            });
        }
        return nonActiveServiceIds;
    }

    public static String getQuickTemplateFixedFieldValue(List<SdQuicktemplateFieldvalues> fieldValues, Integer fieldId) {
        String fieldVal = "";
        if (CollectionUtil.isNotEmpty(fieldValues)) {
            for (SdQuicktemplateFieldvalues value : fieldValues) {
                if (fieldId.intValue() != value.getFieldId()) continue;
                fieldVal = Integer.toString(value.getFieldValueId());
            }
        }
        return fieldVal;
    }

    public static SdQuicktemplateFieldvalues getQuickTemplateValue(List<SdQuicktemplateFieldvalues> fieldValues, Integer fieldId) {
        if (CollectionUtil.isNotEmpty(fieldValues)) {
            for (SdQuicktemplateFieldvalues value : fieldValues) {
                if (fieldId.intValue() != value.getFieldId()) continue;
                return value;
            }
        }
        return null;
    }

    public static List<String> getSlaInfoHeaders() {
        return Arrays.asList("metaData", "Title", "SLA Information", "Escalation Information", "Details of SLA Time Calculation");
    }

    public static String getFormattedTime(Integer time) {
        Object formattedTime = "N/A";
        if (time > 0) {
            int days = time / 60 / 24;
            int hours = time / 60 % 24;
            int mins = time % 60;
            formattedTime = (days > 0 ? Integer.toString(days) : "0") + " Day(s) ";
            formattedTime = (String)formattedTime + (hours > 0 ? Integer.toString(hours) : "0") + " Hour(s) ";
            formattedTime = (String)formattedTime + (mins > 0 ? Integer.toString(mins) : "0") + " Mins ";
        }
        return formattedTime;
    }

    public static String getFormattedDate(Date date, String timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (!timeZone.isEmpty()) {
            TimeZone formattedTimeZone = TimeZone.getTimeZone(timeZone);
            formatter.setTimeZone(formattedTimeZone);
        }
        return formatter.format(date);
    }

    public static String getFormattedDateForNotificationTable(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        return formatter.format(date);
    }

    public static String getSdConfigSettings(ProjectDTO projectDetails, String settingKey) {
        String settingValue = null;
        List<SdConfigSettingsDTO> configSettings = projectDetails.getSdConfigSettingses();
        if (CollectionUtil.isNotEmpty(configSettings)) {
            for (SdConfigSettingsDTO configSetting : configSettings) {
                if (!configSetting.getSettingKey().equalsIgnoreCase(settingKey)) continue;
                settingValue = configSetting.getSettingValue();
            }
        }
        return settingValue;
    }

    public static int workGroupCheck(SdWorkgroupMasterDTO workGroup, TicketDTO ticketDetails) {
        List<SdWorkgroupDetailsDTO> workGroupDetails;
        int parameterMatch = 0;
        int boolCount = 0;
        if (workGroup != null && CollectionUtil.isNotEmpty(workGroupDetails = workGroup.getWorkgroupDetails())) {
            ArrayList<Boolean> parameterMatchFlags = new ArrayList<Boolean>(workGroupDetails.size());
            for (SdWorkgroupDetailsDTO detail : workGroupDetails) {
                if (detail.getWorkGroupType() != 1) {
                    ++boolCount;
                } else if (ticketDetails.getService() != null && Integer.toString(ticketDetails.getService().getServiceId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (detail.getWorkGroupType() != 2) {
                    ++boolCount;
                } else if (ticketDetails.getCategory() != null && Integer.toString(ticketDetails.getCategory().getCategoryId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (detail.getWorkGroupType() != 3) {
                    ++boolCount;
                } else if (ticketDetails.getSubCategory() != null && Integer.toString(ticketDetails.getSubCategory().getId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (detail.getWorkGroupType() != 4) {
                    ++boolCount;
                } else if (ticketDetails.getLocation() != null && Integer.toString(ticketDetails.getLocation().getId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (detail.getWorkGroupType() != 5) {
                    ++boolCount;
                } else if (ticketDetails.getDepartment() != null && Integer.toString(ticketDetails.getDepartment().getId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (detail.getWorkGroupType() != 8) {
                    ++boolCount;
                } else if (ticketDetails.getDerivedField1() != null && Integer.toString(ticketDetails.getDerivedField1().getDerivedFieldId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (detail.getWorkGroupType() != 9) {
                    ++boolCount;
                } else if (ticketDetails.getDerivedField2() != null && Integer.toString(ticketDetails.getDerivedField2().getDerivedFieldId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (detail.getWorkGroupType() != 10) {
                    ++boolCount;
                } else if (ticketDetails.getDerivedField3() != null && Integer.toString(ticketDetails.getDerivedField3().getDerivedFieldId()).equals(detail.getWorkGroupValue())) {
                    ++boolCount;
                }
                if (boolCount == 8) {
                    parameterMatchFlags.add(true);
                } else {
                    parameterMatchFlags.add(false);
                }
                boolCount = 0;
            }
            if (parameterMatchFlags.stream().distinct().count() <= 1L) {
                parameterMatch = 1;
            }
        }
        return parameterMatch;
    }

    public static List<Integer> getAccessPrivilege(ProjectDTO project, List<Integer> projectRoleIds, int accessType) {
        ArrayList<Integer> accessibleIds = new ArrayList<Integer>(1);
        if (CollectionUtil.isNotEmpty(project.getViewaccessMasters())) {
            List<SdViewaccessMasterDTO> viewAccessMasters = project.getViewaccessMasters();
            block0: for (SdViewaccessMasterDTO viewAccessMaster : viewAccessMasters) {
                List<SdViewaccessDetailsDTO> viewAccessDetails = viewAccessMaster.getSdViewaccessDetailses();
                if (!CollectionUtil.isNotEmpty(viewAccessDetails)) continue;
                for (SdViewaccessDetailsDTO detail : viewAccessDetails) {
                    if (detail.getModuleType() != 1 || !detail.getAccessValue().equalsIgnoreCase("all") && !projectRoleIds.contains(Integer.parseInt(detail.getAccessValue()))) continue;
                    if (NumberUtils.isCreatable((String)detail.getAccessValue())) {
                        if (detail.getAccessType() != accessType) continue block0;
                        accessibleIds.add(Integer.parseInt(detail.getAccessValue()));
                        continue block0;
                    }
                    accessibleIds.add(0);
                    continue block0;
                }
            }
        } else {
            accessibleIds.add(0);
        }
        return accessibleIds;
    }

    public static List<Integer> getUsersBasedOnRoleName(ProjectDTO projectDetails, String roleName) {
        ArrayList users = null;
        HashSet<Integer> userIds = new HashSet<Integer>(1);
        List<SdProjectRolesDTO> roles = projectDetails.getRoles();
        if (CollectionUtil.isNotEmpty(roles)) {
            for (SdProjectRolesDTO role : roles) {
                List<SdProjectRolesDetailsDTO> roleDetails;
                if (!role.getRoleName().equalsIgnoreCase(roleName) || !CollectionUtil.isNotEmpty(roleDetails = role.getSdProjectRolesDetailses())) continue;
                for (SdProjectRolesDetailsDTO roleDetail : roleDetails) {
                    userIds.add(roleDetail.getUserId());
                }
            }
        }
        if (!userIds.isEmpty()) {
            users = new ArrayList(userIds);
        }
        return users;
    }

    public static List<Integer> getUsersBasedOnRoleId(ProjectDTO projectDetails, Integer roleId) {
        ArrayList users = null;
        HashSet<Integer> userIds = new HashSet<Integer>(1);
        List<SdProjectRolesDTO> roles = projectDetails.getRoles();
        if (CollectionUtil.isNotEmpty(roles)) {
            for (SdProjectRolesDTO role : roles) {
                List<SdProjectRolesDetailsDTO> roleDetails;
                if (!role.getProjectRoleId().equals(roleId) || !CollectionUtil.isNotEmpty(roleDetails = role.getSdProjectRolesDetailses())) continue;
                for (SdProjectRolesDetailsDTO roleDetail : roleDetails) {
                    userIds.add(roleDetail.getUserId());
                }
            }
        }
        if (!userIds.isEmpty()) {
            users = new ArrayList(userIds);
        }
        return users;
    }

    public static boolean getRoleAccess(ProjectDTO projectDetails, int accessValue, List<Integer> projectRoleIds) {
        boolean accessGiven = false;
        boolean valueFound = false;
        if (CollectionUtil.isNotEmpty(projectDetails.getRoles())) {
            for (SdProjectRolesDTO role : projectDetails.getRoles()) {
                if (!projectRoleIds.contains(role.getProjectRoleId())) continue;
                List<SdProjectRolesAccessDTO> accesses = role.getSdProjectRolesAccesses();
                if (CollectionUtil.isNotEmpty(accesses)) {
                    for (SdProjectRolesAccessDTO roleAccess : accesses) {
                        if (roleAccess.getAccessValue() != accessValue) continue;
                        accessGiven = true;
                        valueFound = true;
                        break;
                    }
                }
                if (!valueFound) continue;
                break;
            }
        }
        return accessGiven;
    }

    public static String getColumnValue(String columnName, Class classObject, Object object) {
        String columnValue;
        block3: {
            columnValue = "";
            Method[] methods = classObject.getMethods();
            try {
                if (methods.length <= 0) break block3;
                for (Method method : methods) {
                    String methodName = method.getName().replace("get", "");
                    if (!columnName.equalsIgnoreCase(methodName)) continue;
                    Object returnedValue = method.invoke(object, new Object[0]);
                    columnValue = returnedValue.toString();
                    break;
                }
            }
            catch (IllegalAccessException | InvocationTargetException | MethodInvocationException ex) {
                return columnValue;
            }
        }
        return columnValue;
    }

    public static List<Map<String, Object>> getUserDataMap(List<UserMgmtMaster> userMgmtMasters) {
        LinkedList<Map<String, Object>> userList = new LinkedList<Map<String, Object>>();
        if (CollectionUtil.isNotEmpty(userMgmtMasters)) {
            for (UserMgmtMaster user : userMgmtMasters) {
                HashMap<String, Object> userData = new HashMap<String, Object>(1);
                userData.put("id", user.getUserDetails().getUserId());
                userData.put("value", user.getFullName());
                userData.put("userName", user.getUserDetails().getUserName());
                userList.add(userData);
            }
        }
        return userList;
    }

    public static List<Integer> getAccessPrivilege(List<Integer> projectRoleIds, Integer projectId, Integer accessType, List<SdViewaccessMaster> accessMasters, Integer userId) {
        ArrayList<Integer> accessibleIds = new ArrayList<Integer>(1);
        if (CollectionUtil.isNotEmpty(accessMasters)) {
            ArrayList<Integer> detailsId = new ArrayList<Integer>(1);
            for (SdViewaccessMaster master : accessMasters) {
                if (!Objects.equals(master.getSdProjectMaster().getProjectId(), projectId)) continue;
                Set<SdViewaccessDetails> details = master.getSdViewaccessDetailses();
                for (SdViewaccessDetails detail : details) {
                    if ((detail.getModuleType() != 1 || detail.getAccessType() != 6 || !projectRoleIds.contains(detail.getAccessValue())) && (detail.getModuleType() != 2 || NumberUtils.toInt((String)detail.getAccessValue()) != userId)) continue;
                    detailsId.add(detail.getViewAccessDetailsId());
                }
                if (!CollectionUtil.isNotEmpty(detailsId)) continue;
                for (SdViewaccessDetails detail : details) {
                    if (!detailsId.contains(detail.getViewAccessDetailsId()) || detail.getModuleType() != 1 || detail.getAccessType() != accessType.intValue()) continue;
                    accessibleIds.add(NumberUtils.toInt((String)detail.getAccessValue()));
                }
            }
        }
        return accessibleIds;
    }

    public static String getStandardFormattedDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(date);
    }

    public static String getStandardFormattedDateWithNormalFormat(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return formatter.format(date);
    }

    public static String replaceAliasNames(String query) {
        query = query.replaceAll("(?i)select", "SELECT");
        query = query.replaceAll("(?i)distinct", "DISTINCT");
        String columnNames = StringUtils.containsIgnoreCase((CharSequence)(query = query.replaceAll("(?i)from", "FROM")), (CharSequence)"DISTINCT") ? query.substring(query.lastIndexOf("DISTINCT") + 9, query.indexOf("FROM")) : query.substring(query.lastIndexOf("SELECT") + 7, query.indexOf("FROM"));
        String updatedColumnNames = "";
        if (!columnNames.isEmpty()) {
            String[] columnNamesArray = columnNames.split(",");
            ArrayList<CallSite> columnNamesList = new ArrayList<CallSite>(1);
            int count = 1;
            for (String columnName : columnNamesArray) {
                String actualColumnName = columnName = columnName.trim();
                if (columnName.contains(".")) {
                    columnName = columnName.replace(".", "_");
                }
                columnNamesList.add((CallSite)((Object)(actualColumnName + " as " + columnName + count)));
                ++count;
            }
            if (!columnNamesList.isEmpty()) {
                updatedColumnNames = StringUtils.join(columnNamesList, (String)",");
            }
            if (!updatedColumnNames.isEmpty()) {
                query = query.replace(columnNames, " " + updatedColumnNames + " ");
            }
        }
        return query;
    }

    public static String replaceSpecialCharacters(String searchString) {
        return searchString.replaceAll("'", "''").replaceAll("%", "\\\\%");
    }

    public static List<FieldValuesDTO> sortFieldValues(List<FieldValuesDTO> selectValues) {
        Pattern p = Pattern.compile("^\\d+");
        Comparator selectValueComparator = (object1, object2) -> {
            Matcher m = p.matcher(object1.getValue());
            if (!m.find()) {
                return object1.getValue().compareTo(object2.getValue());
            }
            Integer number1 = Integer.parseInt(m.group());
            m = p.matcher(object2.getValue());
            if (!m.find()) {
                return object1.getValue().compareTo(object2.getValue());
            }
            Integer number2 = Integer.parseInt(m.group());
            int comparison = number1.compareTo(number2);
            if (comparison != 0) {
                return comparison;
            }
            return object1.getValue().compareTo(object2.getValue());
        };
        Collections.sort(selectValues, selectValueComparator);
        return selectValues;
    }

    public static List<Integer> getAccessibleWorkGroupIdsForProject(ProjectDTO projectDetails, Integer userId, Set<Integer> projectRoleIds) {
        ArrayList<Integer> workGroupIds = new ArrayList<Integer>(1);
        if (CollectionUtil.isNotEmpty(projectDetails.getWorkgroupMasters())) {
            List workgroups = projectDetails.getWorkgroupMasters().stream().filter(Objects::nonNull).filter(e -> e.getWorkGroupStatus() == 0).collect(Collectors.toList());
            ArrayList<SdWorkgroupDetailsDTO> workGroupDetails = new ArrayList<SdWorkgroupDetailsDTO>(1);
            if (CollectionUtil.isNotEmpty(workgroups)) {
                for (SdWorkgroupMasterDTO workGroup : workgroups) {
                    List<SdWorkgroupDetailsDTO> tempWorkGroupDetails = workGroup.getWorkgroupDetails();
                    if (tempWorkGroupDetails == null) continue;
                    for (SdWorkgroupDetailsDTO workGroupDetail : tempWorkGroupDetails) {
                        if (workGroupDetail.getWorkGroupType() == 6 && projectRoleIds.contains(Integer.parseInt(workGroupDetail.getWorkGroupValue()))) {
                            workGroupDetails.add(workGroupDetail);
                            continue;
                        }
                        if (workGroupDetail.getWorkGroupType() != 7 || !workGroupDetail.getWorkGroupValue().equals(Integer.toString(userId))) continue;
                        workGroupDetails.add(workGroupDetail);
                    }
                }
                if (CollectionUtil.isNotEmpty(workGroupDetails)) {
                    for (SdWorkgroupDetailsDTO workgroupDetailsDTO : workGroupDetails) {
                        workGroupIds.add(workgroupDetailsDTO.getWorkGroupId());
                    }
                }
            }
        }
        return workGroupIds;
    }
}

