/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.service.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.service.ICacheService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CacheService
implements ICacheService {
    private Logger logger = LoggerFactory.getLogger(CacheService.class);
    @Autowired
    private ISdProjectMasterDAO projectMasterDAO;

    @Override
    @Transactional
    @CacheEvict(value={"Project"})
    public void updateProjectCache(Integer projectId) {
        SdProjectMaster master = (SdProjectMaster)this.projectMasterDAO.get(projectId);
        this.projectMasterDAO.save(master);
        this.updateMacroCache();
        this.updateDepartmentByIdCache();
        this.updateDepartmentNameCache();
        this.updateLocationIdCache();
        this.updateLocationNameCache();
        this.updateUserConfigNameCache();
        this.updateQuickTemplate();
        this.updateKB();
        this.logger.debug(" Refreshing Project Cache for Project id {}  @ {}  ", (Object)projectId, (Object)new Date());
    }

    @Override
    @CacheEvict(value={"quick_template"}, allEntries=true)
    public void updateQuickTemplate() {
        this.logger.debug(" Refreshing QUICK_TEMPLATE_CACHE {}", (Object)new Date());
    }

    @Override
    @CacheEvict(value={"kb"}, allEntries=true)
    public void updateKB() {
        this.logger.debug(" Refreshing KB_CACHEfor Module id {} ", (Object)new Date());
    }

    @Override
    @CacheEvict(value={"asset_metadata"})
    public void updateAssetCache(Integer moduleId) {
        this.logger.debug(" Refreshing Asset Cache for Module id {}  @ {}  ", (Object)moduleId, (Object)new Date());
    }

    @Override
    @CacheEvict(value={"Macromaster"})
    public void updateMacroCache(Integer macroId) {
        this.logger.debug(" Refreshing Macro Cache for macro id {}  @ {}  ", (Object)macroId, (Object)new Date());
    }

    @CacheEvict(value={"Department"})
    public void updateDepartmentByIdCache(Integer departmentId) {
        this.logger.debug(" Refreshing department Cache for department id {}  @ {}  ", (Object)departmentId, (Object)new Date());
    }

    @CacheEvict(value={"DepartmentName"})
    public void updateDepartmentNameCache(String departmentName) {
        this.logger.debug(" Refreshing DepartmentName Cache for Department Name {}  @ {}  ", (Object)departmentName, (Object)new Date());
    }

    @CacheEvict(value={"Location"})
    public void updateLocationIdCache(Integer locationId) {
        this.logger.debug(" Refreshing location Cache for location id {}  @ {}  ", (Object)locationId, (Object)new Date());
    }

    @CacheEvict(value={"LocationName"})
    public void updateLocationNameCache(String locationName) {
        this.logger.debug(" Refreshing locationName Cache for Location Name {}  @ {}  ", (Object)locationName, (Object)new Date());
    }

    @CacheEvict(value={"user_additional_field_metadata"}, allEntries=true)
    public void updateUserConfigNameCache() {
        this.logger.debug(" RefreshingUserConfigName Cache for Location Name {} ", (Object)new Date());
    }

    @Override
    @CacheEvict(value={"Macromaster"}, allEntries=true)
    public void updateMacroCache() {
        this.logger.debug(" Refreshing Macro Cache for macro id {}  @ {}  ", (Object)" ALL ", (Object)new Date());
    }

    @CacheEvict(value={"Department"}, allEntries=true)
    public void updateDepartmentByIdCache() {
        this.logger.debug(" Refreshing DepartmentName Cache for Department Name {}  @ {}  ", (Object)" ALL ", (Object)new Date());
    }

    @CacheEvict(value={"DepartmentName"}, allEntries=true)
    public void updateDepartmentNameCache() {
        this.logger.debug(" Refreshing DepartmentName Cache for Department Name {}  @ {}  ", (Object)" ALL ", (Object)new Date());
    }

    @CacheEvict(value={"Location"}, allEntries=true)
    public void updateLocationIdCache() {
        this.logger.debug(" Refreshing locationName Cache for Location Name {}  @ {}  ", (Object)" ALL ", (Object)new Date());
    }

    @CacheEvict(value={"LocationName"}, allEntries=true)
    public void updateLocationNameCache() {
        this.logger.debug(" Refreshing locationName Cache for Location Name {}  @ {}  ", (Object)" ALL ", (Object)new Date());
    }

    @CacheEvict(value={"Rpa_Authentication"})
    public void updateRpaAuthenticationCache(String telantName) {
        this.logger.debug(" Refreshing RpaAuthentication Cache for Tenant Name {}  @ {}  ", (Object)telantName, (Object)new Date());
    }
}

