/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.service.impl;

import com.sapphire.itsm.mailrouting.model.SdAdditionalparams;
import com.sapphireims.dto.PattarenMatchedDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.SdEnclosureTemplate;
import com.sapphireims.itsm.model.SdNotificationTemplate;
import com.sapphireims.itsm.model.SdRequestnumberformat;
import com.sapphireims.itsm.model.SdSmsNotificationTemplate;
import com.sapphireims.model.PattarenMatchTypeEnum;
import com.sapphireims.service.IPattarenMatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pattarenMatchService")
public class PattarenMatchService
implements IPattarenMatchService {
    private static final String PATTAREN_MATCH_SERVICE_IMPORT_NOTIFICATION_TEMPLATE_DOMAIN_EXCEPTION_ERROR_CODE_S_ERROR_S = "PattarenMatchService:importNotificationTemplate : DomainException Error code %s   Error %s ";
    private Logger logger = LoggerFactory.getLogger(PattarenMatchService.class);

    @Override
    public void importNotificationTemplate(ProjectExportRequestDTO pReq, SdNotificationTemplate template) {
        String source = template.getTemplateBody();
        List<PattarenMatchedDTO> matched = this.getMatchedParterns(source, PattarenMatchTypeEnum.NOTIFICATION_TEMPLATE_CUSTOM);
        Map<Integer, SdAdditionalparams> oldIdAdditionalparams = pReq.getOldIdAdditionalparamsMap();
        int i = 1;
        for (PattarenMatchedDTO d : matched) {
            try {
                SdAdditionalparams add = oldIdAdditionalparams.get(Integer.parseInt(d.getOldKeyValue()));
                if (add == null) continue;
                String newvalue = d.getNewValue(Integer.toString(add.getFieldid()));
                source = this.replaceGroup(d.getPattarenMatchType().getRegExp(), source, 0, i++, newvalue);
            }
            catch (DomainException e) {
                this.logger.error(PATTAREN_MATCH_SERVICE_IMPORT_NOTIFICATION_TEMPLATE_DOMAIN_EXCEPTION_ERROR_CODE_S_ERROR_S, (Object)e.getErrorCodeEnum(), (Object)e.getMessage());
            }
        }
        template.setTemplateBody(source);
    }

    @Override
    public void importNotificationTemplate(ProjectExportRequestDTO pReq, SdSmsNotificationTemplate template) {
        String source = template.getTemplateBody();
        List<PattarenMatchedDTO> matched = this.getMatchedParterns(source, PattarenMatchTypeEnum.NOTIFICATION_TEMPLATE_CUSTOM);
        Map<Integer, SdAdditionalparams> oldIdAdditionalparams = pReq.getOldIdAdditionalparamsMap();
        int i = 1;
        for (PattarenMatchedDTO d : matched) {
            try {
                SdAdditionalparams add = oldIdAdditionalparams.get(Integer.parseInt(d.getOldKeyValue()));
                String newvalue = d.getNewValue(Integer.toString(add.getFieldid()));
                source = this.replaceGroup(d.getPattarenMatchType().getRegExp(), source, 0, i++, newvalue);
            }
            catch (DomainException e) {
                this.logger.error(PATTAREN_MATCH_SERVICE_IMPORT_NOTIFICATION_TEMPLATE_DOMAIN_EXCEPTION_ERROR_CODE_S_ERROR_S, (Object)e.getErrorCodeEnum(), (Object)e.getMessage());
            }
        }
        template.setTemplateBody(source);
    }

    @Override
    public void importNotificationTemplate(ProjectExportRequestDTO pReq, SdRequestnumberformat template) {
        String source = template.getPrefix();
        List<PattarenMatchedDTO> matched = this.getMatchedParterns(source, PattarenMatchTypeEnum.NOTIFICATION_TEMPLATE_CUSTOM);
        Map<Integer, SdAdditionalparams> oldIdAdditionalparams = pReq.getOldIdAdditionalparamsMap();
        int i = 1;
        for (PattarenMatchedDTO d : matched) {
            try {
                SdAdditionalparams add = oldIdAdditionalparams.get(Integer.parseInt(d.getOldKeyValue()));
                String newvalue = d.getNewValue(Integer.toString(add.getFieldid()));
                source = this.replaceGroup(d.getPattarenMatchType().getRegExp(), source, 0, i++, newvalue);
            }
            catch (DomainException e) {
                this.logger.error(PATTAREN_MATCH_SERVICE_IMPORT_NOTIFICATION_TEMPLATE_DOMAIN_EXCEPTION_ERROR_CODE_S_ERROR_S, (Object)e.getErrorCodeEnum(), (Object)e.getMessage());
            }
        }
        template.setPrefix(source);
    }

    @Override
    public void importEnclosureTemplate(ProjectExportRequestDTO pReq, SdEnclosureTemplate template) {
        String source = template.getTemplateBody();
        List<PattarenMatchedDTO> matched = this.getMatchedParterns(source, PattarenMatchTypeEnum.NOTIFICATION_TEMPLATE_CUSTOM);
        Map<Integer, SdAdditionalparams> oldIdAdditionalparams = pReq.getOldIdAdditionalparamsMap();
        int i = 1;
        for (PattarenMatchedDTO d : matched) {
            try {
                SdAdditionalparams add = oldIdAdditionalparams.get(Integer.parseInt(d.getOldKeyValue()));
                String newvalue = d.getNewValue(Integer.toString(add.getFieldid()));
                source = this.replaceGroup(d.getPattarenMatchType().getRegExp(), source, 0, i++, newvalue);
            }
            catch (DomainException e) {
                this.logger.error(PATTAREN_MATCH_SERVICE_IMPORT_NOTIFICATION_TEMPLATE_DOMAIN_EXCEPTION_ERROR_CODE_S_ERROR_S, (Object)e.getErrorCodeEnum(), (Object)e.getMessage());
            }
        }
        template.setTemplateBody(source);
    }

    @Override
    public String replaceQuery(String query) {
        return query;
    }

    private List<PattarenMatchedDTO> getMatchedParterns(String source, PattarenMatchTypeEnum pattarenMatchType) {
        Matcher m = Pattern.compile(pattarenMatchType.getRegExp()).matcher(source);
        ArrayList<PattarenMatchedDTO> lst = new ArrayList<PattarenMatchedDTO>();
        int i = 0;
        while (m.find()) {
            PattarenMatchedDTO d = new PattarenMatchedDTO(i++, m.start(), m.end(), source.substring(m.start(), m.end()), pattarenMatchType);
            lst.add(d);
        }
        return lst;
    }

    private String replaceGroup(String regex, String source, int groupToReplace, int groupOccurrence, String replacement) {
        Matcher m = Pattern.compile(regex).matcher(source);
        for (int i = 0; i < groupOccurrence; ++i) {
            if (m.find()) continue;
            return source;
        }
        return new StringBuilder(source).replace(m.start(groupToReplace), m.end(groupToReplace), replacement).toString();
    }
}

