/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.util;

import com.sapphire.dashboard.model.DashboardconfigurationAccessDetails;
import com.sapphire.dashboard.model.DashboardconfigurationDetails;
import com.sapphire.dashboard.model.DashboardtemplateQuicklinks;
import com.sapphire.dashboard.model.DashboardtemplateRedirectionparamDetails;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.DashboardHistoryParameterWiseENUM;
import com.sapphireims.modulecopy.dashboardcopy.enummodel.WidgetTemplateTypeENUM;
import com.sapphireims.util.CollectionUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DashboardCollectionUtil {
    private DashboardCollectionUtil() {
        throw new IllegalStateException("Dashboard Utility class");
    }

    public static <E> boolean isEmpty(Collection<E> collection) {
        return CollectionUtils.isEmpty(collection);
    }

    public static <E> boolean isNotEmpty(Collection<E> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static Map<Integer, List<DashboardconfigurationDetails>> getDashboardConfigurationDetails(List<DashboardconfigurationDetails> dcdList, boolean isProjectCopy) {
        LinkedHashMap<Integer, List<DashboardconfigurationDetails>> mps = new LinkedHashMap<Integer, List<DashboardconfigurationDetails>>();
        if (CollectionUtil.isNotEmpty(dcdList)) {
            for (DashboardconfigurationDetails dcd : dcdList) {
                if (!isProjectCopy && dcd.getIsProfileBased() == 1) continue;
                if (mps.containsKey(dcd.getDashboardconfiguration().getDashboardDetailsId())) {
                    ((List)mps.get(dcd.getDashboardconfiguration().getDashboardDetailsId())).add(dcd);
                    continue;
                }
                LinkedList<DashboardconfigurationDetails> dcdListObject = new LinkedList<DashboardconfigurationDetails>();
                dcdListObject.add(dcd);
                mps.put(dcd.getDashboardconfiguration().getDashboardDetailsId(), dcdListObject);
            }
        }
        return mps;
    }

    public static Map<Integer, List<DashboardconfigurationAccessDetails>> getDashboardConfigurationAccessDetails(List<DashboardconfigurationAccessDetails> dcdList) {
        LinkedHashMap<Integer, List<DashboardconfigurationAccessDetails>> mps = new LinkedHashMap<Integer, List<DashboardconfigurationAccessDetails>>();
        if (CollectionUtil.isNotEmpty(dcdList)) {
            for (DashboardconfigurationAccessDetails dcad : dcdList) {
                if (mps.containsKey(dcad.getDashboardconfiguration().getDashboardDetailsId())) {
                    ((List)mps.get(dcad.getDashboardconfiguration().getDashboardDetailsId())).add(dcad);
                    continue;
                }
                LinkedList<DashboardconfigurationAccessDetails> dcdListObject = new LinkedList<DashboardconfigurationAccessDetails>();
                dcdListObject.add(dcad);
                mps.put(dcad.getDashboardconfiguration().getDashboardDetailsId(), dcdListObject);
            }
        }
        return mps;
    }

    public static Map<Integer, List<DashboardtemplateQuicklinks>> getDashboardtemplateQuicklinks(List<DashboardtemplateQuicklinks> dtqlList) {
        LinkedHashMap<Integer, List<DashboardtemplateQuicklinks>> mps = new LinkedHashMap<Integer, List<DashboardtemplateQuicklinks>>();
        if (CollectionUtil.isNotEmpty(dtqlList)) {
            for (DashboardtemplateQuicklinks dtql : dtqlList) {
                if (mps.containsKey(dtql.getMacroId())) {
                    ((List)mps.get(dtql.getMacroId())).add(dtql);
                    continue;
                }
                LinkedList<DashboardtemplateQuicklinks> dtQlListObject = new LinkedList<DashboardtemplateQuicklinks>();
                dtQlListObject.add(dtql);
                mps.put(dtql.getMacroId(), dtQlListObject);
            }
        }
        return mps;
    }

    public static Map<Integer, List<DashboardtemplateRedirectionparamDetails>> getDashboardtemplateRedirectionparamDetails(List<DashboardtemplateRedirectionparamDetails> dtrpdList) {
        LinkedHashMap<Integer, List<DashboardtemplateRedirectionparamDetails>> mps = new LinkedHashMap<Integer, List<DashboardtemplateRedirectionparamDetails>>();
        if (CollectionUtil.isNotEmpty(dtrpdList)) {
            for (DashboardtemplateRedirectionparamDetails dtrpd : dtrpdList) {
                if (mps.containsKey(dtrpd.getDashboardtemplateMacrodetails().getMacroId())) {
                    ((List)mps.get(dtrpd.getDashboardtemplateMacrodetails().getMacroId())).add(dtrpd);
                    continue;
                }
                LinkedList<DashboardtemplateRedirectionparamDetails> dtrPdListObject = new LinkedList<DashboardtemplateRedirectionparamDetails>();
                dtrPdListObject.add(dtrpd);
                mps.put(dtrpd.getDashboardtemplateMacrodetails().getMacroId(), dtrPdListObject);
            }
        }
        return mps;
    }

    public static List<DashboardHistoryParameterWiseENUM> getFieldsOfDataTemplateOnTemplateType(Integer templateId) {
        LinkedList<DashboardHistoryParameterWiseENUM> lst = new LinkedList<DashboardHistoryParameterWiseENUM>();
        lst.add(DashboardHistoryParameterWiseENUM.TemplateName);
        switch (WidgetTemplateTypeENUM.getWidgetTemplateTypeENUM(templateId)) {
            case CardView: 
            case PercentageFill: 
            case IconizedView: 
            case PercentageAndValueBased: 
            case DetailedView: 
            case ThresholdMonitoring: {
                lst.add(DashboardHistoryParameterWiseENUM.DataTemplateQuery);
                lst.add(DashboardHistoryParameterWiseENUM.RedirectToUrl);
                lst.add(DashboardHistoryParameterWiseENUM.RedirectToTicketList);
                lst.add(DashboardHistoryParameterWiseENUM.NumberOfMacros);
                lst.add(DashboardHistoryParameterWiseENUM.MacroNameAndValues);
                lst.add(DashboardHistoryParameterWiseENUM.RedirectionQuery);
                break;
            }
            case QuickLinks: 
            case QuickView: {
                lst.add(DashboardHistoryParameterWiseENUM.QuickLinkName);
                lst.add(DashboardHistoryParameterWiseENUM.QuickLinkValue);
                break;
            }
            case QuickStats: 
            case ComparativeStatus: {
                lst.add(DashboardHistoryParameterWiseENUM.DataTemplateQuery);
                break;
            }
            case Charts: {
                lst.add(DashboardHistoryParameterWiseENUM.DataTemplateQuery);
                lst.add(DashboardHistoryParameterWiseENUM.RedirectToTicketList);
                lst.add(DashboardHistoryParameterWiseENUM.NumberOfMacros);
                lst.add(DashboardHistoryParameterWiseENUM.MacroNameAndValues);
                lst.add(DashboardHistoryParameterWiseENUM.RedirectionQuery);
            }
        }
        return lst;
    }
}

