/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.validationScripting.model;

import com.sapphireims.itsm.dto.MethodMappingDTO;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

@Entity
@Table(name="method_mapping")
public class MethodMapping
extends BaseModel {
    private static final long serialVersionUID = -4086212852336580867L;
    private Integer mappingId;
    private String methodName;
    private String description;
    private String displayname;
    private String newUIMethodName;

    public MethodMapping() {
    }

    public MethodMapping(String methodName, String description) {
        this.methodName = methodName;
        this.description = description;
    }

    public MethodMapping(String methodName, String description, String displayname, String newUIMethodName) {
        this.methodName = methodName;
        this.description = description;
        this.displayname = displayname;
        this.newUIMethodName = newUIMethodName;
    }

    public MethodMapping(MethodMappingDTO mmDTO) {
        this.mappingId = mmDTO.getMappingId();
        this.methodName = mmDTO.getMethodName();
        this.description = mmDTO.getDescription();
        this.displayname = mmDTO.getDisplayname();
        this.newUIMethodName = mmDTO.getNewUIMethodName();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="MappingID", unique=true, nullable=false)
    public Integer getMappingId() {
        return this.mappingId;
    }

    public void setMappingId(Integer mappingId) {
        this.mappingId = mappingId;
    }

    @Column(name="MethodName", nullable=false, length=500)
    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Column(name="Description", nullable=false, length=1000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="Displayname", length=250)
    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    @Column(name="NewUIMethodName", length=250)
    public String getNewUIMethodName() {
        return this.newUIMethodName;
    }

    public void setNewUIMethodName(String newUIMethodName) {
        this.newUIMethodName = newUIMethodName;
    }
}

