<!DOCTYPE HTML>
<html>
    <%@taglib prefix="security" uri="http://www.springframework.org/security/tags"%>
    <%@page contentType="text/html" pageEncoding="UTF-8"%>
    <%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
    <%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
    <%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
    <%@ taglib uri="http://jawr.net/tags" prefix="jwr" %>
    <c:set var="I18N_OBJECT" value="${applicationScope.LANGUAGE_MAP[LANGUAGE_UNICODE]}" />
    
    <head>
        <meta charset="UTF-8" /> 
        <c:if test="${IsOnlyCMDBAccess eq 1}">
        <script type="text/javascript" src="assets/js/i18n/i18n.js"></script>
        <script type="text/javascript" src="assets/js/i18n/messages_${LANGUAGE_UNICODE}.js"></script>
        </c:if>
        <security:csrfMetaTags/>
        <c:set var="customerTitle" value="CUSTOMER_TITLE"/>
        <title>${applicationScope.SAPPHIRE_CONFIG_SETTINGS.findBySettingKey('CUSTOMER_TITLE')}</title>
         <link rel="shortcut icon" href="${sessionScope.faveIconPath}" />
        <c:if test="${IsOnlyCMDBAccess eq 1}">
        <jwr:style src="/assets/css/variable.min.css"/>
            <jwr:style src="/assets/css/jquery.datetimepicker.min.css"/>
        <jwr:script src="/assets/js/jquery.min.js"/>
        <script type="text/javascript" src="ckeditor1/ckeditor.js"></script>
        </c:if>
    </head>
    <body id="${THEME}">
        <input type="hidden" name="themeVal" id="themeVal" value="${THEME}">
        <input type="hidden" name="hideCurrentPassAndPreferedContactMethod" id="hideCurrentPassAndPreferedContactMethod" value="${sessionScope.HIDE_CURRENT_PASS_PREFERRED_CONTACT}">
        <input type="hidden" id="sapphireContextPath" name="sapphireContextPath" value="<c:out value="${sapphireContextPath}"/>" />
        <c:if test="${IsOnlyCMDBAccess eq 1}">
        <jsp:include page="CMDBLeftPanelMenu.jsp">
              <jsp:param name="isSdEnable" value="${isSdEnable}" />
              <jsp:param name="treeViewIsVisible" value="${treeViewIsVisible}" />
        </jsp:include>
        </c:if>
        <div class="load" id="assetLoading"></div>
        <div class="mask" id="assetListMask" style="display: none;"></div>
        <div class="" id="addAssetMask" style="display: none;"></div>
        <div class="load" id="loading" style="display: none;"></div>
        <div class="overlayBg" style="display:none"></div>
        <a href="#" id="scroll-top" class="animated bounce" style="display: none;"></a>
            <div id="loader-wrapper">
                <div id="loader"></div>
                <div class="loader-section section-left"></div>
                <div class="loader-section section-right"></div>
            </div>
        <div id="mainAssetDiv">
            <c:if test="${IsOnlyCMDBAccess eq 1}">
            <header class="header">
                <div class="inner-header">
                    <div class="logo">
                        <a href="asset.do?pageRedirect=assetHome" title="Sapphire">
                            <img src="${not empty sessionScope.NEWUIHEADERLOGINPATH  ? sessionScope.NEWUIHEADERLOGINPATH : "assets/images/customer/sapphireims-logo.png"}" alt="" class="mainLogo"  onclick="" />
                        </a>
                    </div>
                    <div class="header-right">
                       
                        <div class="settings-list">
                            <nav>
                                <ul>
                                     <c:if test="${LICENSEEXPDATE ne '' && LICENSEEXPDATE ne null}">
                                        <li>
                                            <div class="expireAlertBox">
                                                <div class="innerExpireAlertBox">
                                                    <img src="assets/images/excIco001.png" alt="">
                                                    <strong>${LICENSEEXPDATE}</strong>
                                                </div>
                                            </div>
                                        </li>
                                        </c:if>
                                    <li id="assetGlobalSearch">
                                        <select id="assetSearchType" style="display: none;" onclick="getAssetCustomfieldList(1)">
                                        </select>
                                        <script>
                                            $("#assetSearchType").multipleSelect({single:true,
                                                filter:true,
                                                width:150,
                                                onOpen: function() {
                                                    $("#assetSearchType").click();
                                                }});
                                            $("#assetSearchType").click();
                                        </script>
                                        <input type="text" class="topSearch" placeHolder='${I18N_OBJECT.tr("Search...")}' id="topSearchValue" />
                                        <a href="javascript:void(0)" class="ico ico-search" id="assetTopSearch" onclick="setTopsearchFocus()"></a>
                                    </li>

                                    
                                    <c:if test="${assetRole eq 1 || assetRole eq 2}">
                                      <li id="assetImport">
                                          <a class="ico ico-assetImport" title="Asset Import" id="assetImpIcon" onclick="assetImport()" style="display:none;"></a>
                                    </li>
                                    </c:if>
                              
                                </ul>
                            </nav>
                        </div>
                        <div class="profile-action">
                            <a href="javascript:void(0)" >
                                <c:set var="signinstatus" value="red"/>
                                <c:if test="${sessionScope.isSignIn eq 1}">
                                    <c:set var="signinstatus" value="green"/>
                                </c:if>
                                <c:choose>
                                    <c:when test="${not empty sessionScope.UserImageName}">
                                        <img id="profilePictureLnk" src="<c:url value="downloadFile.do?fileName=${UserImageName}&fileNameOriginal=${UserImageName}"></c:url>" class="ico-profile" style="height: 36px;width: 36px;" alt="" data-from="0"/>
                                    </c:when>
                                    <c:otherwise>
                                        <span id="profilePictureLnk" class="profileInital" data-from="1" data-initials="${sessionScope.USERINITIALS}">${sessionScope.USERINITIALS}</span>
                                    </c:otherwise>
                                   </c:choose>
                                <c:if test="${sessionScope.isSignInOutAccess eq '1'}">
                                <span class="signInOutStatus ${signinstatus}"></span>
                                </c:if>
                            </a>
                        </div>
                        <div class="userNav" id="userNav">
                            <span class="topArrow"></span>
                            <div class="menuAll">
                                <div class="userMenu">
                                    <div class="profView">
                                        <div id="prof">
                                        </div>
                                        </div>
                                    </div>        
                            </div>
                                    <div class="logOutBlk">
                                        <c:choose>
                                            <c:when test="${ not empty sessionScope.SAMLGLOBALLOGOUT}">
                                                <a href="javascript:void(0)" onclick="logout(1, '${_csrf.parameterName}', '${_csrf.token}');">
                                                    <i class="logIco"></i>${I18N_OBJECT.tr("Logout")}
                                                </a>
                                                <input type ="hidden" name ="applicationLogoutTypeNewUI" id ="applicationLogoutTypeNewUI" value="1" />
                                            </c:when>
                                            <c:otherwise>
                                                <a href="javascript:void(0)" onclick="logout(0, '${_csrf.parameterName}', '${_csrf.token}');">
                                                    <i class="logIco"></i>${I18N_OBJECT.tr("Logout")}
                                                </a>
                                                <input type ="hidden" name ="applicationLogoutTypeNewUI" id ="applicationLogoutTypeNewUI" value="0" />
                                            </c:otherwise>
                                        </c:choose>
                                        <p class="lastLogin">${I18N_OBJECT.tr("Last Login:")} ${sessionScope.LAST_LOGIN_TIME}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
            </header>

            </c:if>
            <div id="ticketViewDiv" style="display: none"></div>
           
            <div id="preferences"> </div>
            <div class="page-nav assets-nav">
                <div class="navigateActionCMDB" id="navigateAction">

                </div>
            </div>

            <div class="overlay" id="overlayAsset">
                <div class="innerOverlay">
                    <div class="attachBlk">
                        <form id="uploadFileAsset" action="assetAttachUploadFile.do" method="post" enctype="multipart/form-data">
                            <security:csrfInput />
                        </form>
                    </div>
                </div>
            </div>
            <div class="overlay" id="overlayCreateRecord">
                <div class="innerOverlay">
                    <div class="attachBlk">
                        <form id="uploadFile" action="uploadFile.do" method="post" enctype="multipart/form-data">
                            <security:csrfInput />
                        </form>
                    </div>
                </div>
            </div>
                        <section class="container" id="assetMainContainer">
                <div class="main-wrapper" id="main-wrapper-details">
                    <div class="inner-wrapper">
                        <form id="uploadFileImport" action="assetAttachUploadFile.do" method="post" enctype="multipart/form-data">
                            <security:csrfInput/>
                            <div style="display: none" id="assetImportDivBlk">
                                <jsp:include page="AssetImport.jsp" />
                            </div>
                        </form>
                        <div id="cmdbMainContainer">
                            <div class="confirmBlk" style="display: none;">
                               <p>${I18N_OBJECT.tr("Are you sure want to delete the profile ?")}
                                   <a href="#" id="deleteAssetProfile" class="yesBtn">${I18N_OBJECT.tr("Yes")}</a>
                                   <a href="#" class="noBtn">${I18N_OBJECT.tr("No")}</a>
                               </p>
                           </div>
                                   <div class="errMsg" id="publicProfileDelete" style="display: none; margin-top: 15px; ">
                                       <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("You do not have permission to delete this public search profile")}</p>
                                   </div>
                        <div class="history-block cmdbBlk">
                            <div class="treeViewBlk" id="treeViewBlk">

                            </div>

                              <jsp:include page="CMDBFilters.jsp" />

                                <div id="gridAdditionalFldMaxView" class="createNewUserPopup cmdbGrid" style="display: none;">
                                <div class="inner-wrapper" style="position: relative;width: 100%;height: 100%;margin-bottom: 20px;padding-bottom: 20px;"> <div id="maxViewGridBlk" style="" data-gridFieldId="1" data-gridName="" data-gridFieldType=""><div class="maxAdditionalGridViewBlk">
                                        <div class="gridActionBtnBlk">
                                                                <h3>Additional Grid Field </h3>
                                                                <div class="gridActionLeftBlk">
                                                                    <a href="javascript:void(0)" onclick="addNewSlickGridMaxRow()" id="btnAddGridMax" class="newRowIco maxMode"><img src="assets/images/add_row.png" alt=""><span>Add</span></a>
                                                                    <a href="javascript:void(0)" onclick="deleteNewSlickGridMaxRow()" id="btnDeltGridMax" class="deleteRowIco maxMode"><img src="assets/images/delete_row.png" alt=""><span>Delete</span></a>
                                                                </div>
                                                                <div class="gridActionRightBlk">
                                                                    <!--<a href="exportTicketGridData.do?problemId=0&amp;gridControlFieldId=59&amp;projectId=2&amp;displayName=GRID 8 columns" style="display:none" title="Export Grid" class="exportIco"><img src="assets/images/exportIco.png" alt=""></a>
                                                                    <a href="javascript:void(0)" style="display:none" class="importGrid importIco" title="Import Grid" onclick="importGrid(this)"><img src="assets/images/importIco.png" alt=""></a>-->
                                                                    <a href="javascript:void(0)" class="maxMode maximizeIco" id="gridMinimizeViewIco" ><img src="assets/images/minimizeIco.png" alt="" /></a>
                                                                    <div class="gridDataImpBlk" style="top: 36px; right: -5px; z-index: 9998; display: none;">
                                                                        <div class="impFldBlk">
                                                                            <div class="impFld mb0 fileGridSelect">
                                                                                <label>Upload Grid File<span style="color:red;">*</span></label>
                                                                                <input type="file" name="importGridFile" id="importGridFile" onchange="getImportFileName()" class="inputfile inputfile-1" data-multiple-caption="{count} files selected" multiple="">
                                                                                <label for="importGridFile">
                                                                                    <img src="assets/images/file_upload.png" alt="">
                                                                                    <span class="choose uploaded">Choose a file...</span>
                                                                                </label>
                                                                                <div id="uploadStatus"></div><div id="validateSatus"></div><div class="errorMsgGrid"></div>
                                                                </div>
                                                                        </div>
                                                                        <div class="closeBlk" style="width: 100%;padding: 2% 0;box-shadow: 0px 1px 3px #B1B1B1;">
                                                                            <input type="button" value="Upload" id="impGridUpload" data-displayname="Grid131Columns41" data-gridproblemid="0" data-gridcontrolfieldid="41" data-gridprojectid="1" onclick="validateGridImport(this,true)" class="btn apply importGridBtn" style="margin-right: 2%;">
                                                                            <a href="javascript:void(0)" class="cancelImpGrid">Cancel</a>
                                                                       </div>

                                                                    </div>
                                                                </div>
                                                            </div> <div id="CUSTOMFIELDMAXGRIDTR"  data-gridFieldId="1" data-gridName="" data-gridFieldType=""></div></div>

                                 </div></div></div>
                                        <script>
                                            $("#gridAdditionalFldMaxView .inner-wrapper").perfectScrollbar();
                                        </script>
                            <form id="changeStatusForm">
                                <security:csrfInput/>
                                <div class="assetChangeState" id="allFeatureBtns">
                                    <div id="cmdbFeatureBtnBlk"></div>


                                    <div class="innerClkBlk" id="modifyTemplate" style="display: none;"> 
                                        <div class="innerFormBlk">
                                            <div class="row">
                                                <div class="formElem">
                                                    <label class="asstLabelFld">${I18N_OBJECT.tr("Selected Assets:")}</label>
                                                    <span id="selectAssetNames"></span>
                                                    <input type="hidden" id="selectedTemplateAssetIds" name="selectedTemplateAssetIds" value=""/>
                                                    <input type="hidden" id="selectedTemplateAssetItemType" name="selectedTemplateAssetItemType" value=""/>
                                                    <input type="hidden" id="selectedAssetIds" name="selectedAssetIds" value="0"/>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="formElem">
                                                    <label class="asstLabelFld">${I18N_OBJECT.tr("Template Name")}<sup>*</sup></label>
                                                    <select class="demo single" id="modifyTemplateSelect" onchange="getAssetTemplateFields()">
                                                        <option value="0">${I18N_OBJECT.tr("-- Choose --")}</option>
                                                    </select>
                                                    <script>
                                                        $("#modifyTemplateSelect").multipleSelect({
                                                            filter: true,
                                                            single: true,
                                                        });
                                                    </script>
                                                </div> 
                                            </div>
                                            <div id="assetTemplateFields"></div>
                                        </div>	
                                        <div class="closeBlk">
                                            <div id="" class="impBtm impCreate" style="position: static;">
                                                <a href="javascript:void(0)" id="createTemplate" class="btn apply"  onclick="updateAssetTemplateDetails()" style="margin-right: 2%;">Modify</a>
                                                <a href="#" id="cancelModifyTemplate" class="backBtnIc" onclick="closeModifyTemplateBlock()">Cancel</a>
                                            </div> 	
                                        </div>
                                    </div>
                                    <!---END MODIFY BLOCK-->

                                    <!---START IMPORT CONTENT BLOCK-->
                                        <div class="innerClkBlk" id="importTemplateBlk" style="display: none;"> 
                                        <div class="innerFormBlk"> 

                                            <div class="row">
                                                <div class="formElem fixedFiled">
                                                    <label id="assetImportAsstTypeLbl">${I18N_OBJECT.tr("Asset Type123")}<sup>*</sup></label>
                                                    <select class="" id="assetImportAssetType" name="assetItemType" onchange="getAssetImportTemplateDetails()">
                                                        <option value="0">${I18N_OBJECT.tr("-- Choose --")}</option>
                                                    </select>
                                                    <script>
                                                        $("#assetImportAssetType").multipleSelect({
                                                            filter: true,
                                                            single: true,
                                                        });
                                                    </script>
                                                </div>
                                                <div class="formElem fixedFiled">
                                                    <label>${I18N_OBJECT.tr("Template Name")}<sup>*</sup></label>
                                                    <select class="" id="importTemplatesList" onchange="getAssetImportDetails()" >
                                                        <option value="0">${I18N_OBJECT.tr("-- Choose --")}</option>
                                                    </select>
                                                    <script>
                                                        $("#importTemplatesList").multipleSelect({
                                                            filter: true,
                                                            single: true,
                                                        });
                                                    </script>
                                                </div>
                                                <div class="formElem fixedFiled" id="importAssetNumberBlk" style="padding-bottom: 0px!important;margin-bottom:0px!important;">
                                                    <label style="float: left; position: relative;min-width: 212px;"><span id="assetNumberImprtTemplt">${I18N_OBJECT.tr("Asset Number")}</span><sup style="position: absolute;margin: 0 4px;">*</sup><!-- span class="genIco" style="display: none;">?</span> -->
                                                        <div class="genBlk">
                                                            <a href="#" class="genBtn" id="asstImprtGenNumb" onclick="getGenAssetNumberValues('id', 'genBlkid')" >  ${I18N_OBJECT.tr("Generate")}</a>
                                                            <div class="impBlk" id="genAsstNoPopUp" style="display: none">
                                                                <div class="impFldBlk">
                                                                    <div id="genBlkid" class="genBlkid"></div>

                                                                </div>
                                                                <div class="closeBlk" id="appCls">
                                                                    <a href="javascript:void(0)" class="btn apply getGeneratedAssetNumber"  id="getGeneratedAssetNumber" onclick="getGeneratedAssetNumber('assetNumberForAssetImport', 'genAsstNoPopUp')" style="margin-right: 2%;">
                                                                        ${I18N_OBJECT.tr("OK")} 
                                                                    </a>
                                                                    <a href="#" class="backBtnIc">${I18N_OBJECT.tr("Cancel")}</a>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </label>

                                                    <input type="text" name="assetNo" id="assetNumberForAssetImport" autocomplete="off" onkeyup="removeErrortext('assetNumberForAssetImport', 'assetNumErrImport')" style="clear: left;" />
                                                    <div id="assetNumErrImport"></div>
                                                    <div class="nofityInfo wid100" style="float: left;">
                                                        <p style="margin-bottom:0px;">Restricted Special Characters are '% @ # [ ] \ " ' < > ? ; * & +'</p>
                                                    </div>
                                                </div>
                                                </div>
                                            <div id="assetImportDetails" ></div>
                                        </div>	
                                        <div class="closeBlk">
                                            <div id="" class="impBtm impCreate" style="position: static;">
                                                <a href="javascript:void(0)" id="assetImportTemplate" class="btn apply"  onclick="updateAssetImportValuesToDB('changeStatusForm')" style="margin-right: 2%;">${I18N_OBJECT.tr("Save")}</a>
                                                <a href="#" class="backBtnIc" id="assetImportTemplatecancel" onclick="closeAssetImportTemplateBlock()">${I18N_OBJECT.tr("Cancel")}</a>
                                            </div> 	
                                            <div id="assetNumb" ></div>
                                        </div>
                                    </div>
                                                                
                                     <div class="innerClkBlk" id="createRecordDivBlk" style="display: none;"> 
                                        <div class="innerFormBlk"> 

                                            <div class="row">
                                                <div class="formElem createProjType">
                                                    <label>${I18N_OBJECT.tr("Projects")}<sup>*</sup></label>
                                                    <select class="" id="project" name="project">
                                                        <option value="0">${I18N_OBJECT.tr("-- Choose --")}</option>
                                                    </select>
                                                    <script>
                                                        $("#project").multipleSelect({
                                                            filter: true,
                                                            single: true,
                                                        });
                                                    </script>
                                                </div>
                                            <div id="assetRecordsDetails" ></div>
                                        </div>	
                                        
                                    </div>
                                    </div>
                                    <!---END IMPORT CONTENT BLOCK-->
                                    <div id="statusSuccessMsg"></div>
                                    <div class="innerClkBlk" id="assetChangeStateBlk" style="display: none;"> 
                                       <input type="hidden" id="assetStatusPageLoadedTime" name="assetStatusPageLoadedTime" value="" />
                                        <div class="innerFormBlk">
                                            <div class="row">
                                                <div class="formElem">
                                                    <label class="asstLabelFld" id="changeStatusLabel" >${I18N_OBJECT.tr("Modify Asset")}<sup>*</sup></label>
                                                    <select class="demo single assetStatusList" id="FIXEDFIELDS9023" onchange="getAssetsStatusList()">
                                                        <option value="0">${I18N_OBJECT.tr("-- Choose --")}</option>
                                                    </select>
                                                    <script>
                                                        $("#FIXEDFIELDS9023").multipleSelect({
                                                            filter: true,
                                                            single: true,
                                                        });
                                                    </script>
                                                    <input type="hidden" id="selectedCSAssetIds" name="selectedCSAssetIds" value="0"/>
                                                </div>
                                            </div>
                                            <div id="dynOptions">
                                            </div>

                                        </div>	
                                        <div class="nofityInfo" id="assetChangeConfirm" style="display: none"> 
                                            <p>&nbsp;${I18N_OBJECT.tr("If we select more than one items for change status,already configured status value for the selected items will not be shown.")} </p>
                                        </div>
                                        <div class="closeBlk">
                                            <div id="" class="impBtm impCreate" style="position: static;">
                                                <a href="javascript:void(0)" id="createTemplate" onclick="modifyAssetStatus()" class="btn apply" style="margin-right: 2%;" >${I18N_OBJECT.tr("Modify")}</a>
                                                <a href="javascript:void(0)"  id="cancelAsset" onclick="closeDialog()" class="backBtnIc">${I18N_OBJECT.tr("Cancel")}</a>
                                            </div> 	
                                        </div>
                                        <div id="assetDynamicLoadScriptContent">
                                        </div>
                                        <div id="assetStatusFunctionDefinitionsDiv">
                                        </div>
                                        <div id="assetStatusTriggerMethodsDiv">
                                        </div>
                                        <div id="LCFHiddenElementsBlk"></div>
                                    </div>

                                    <div class="innerClkBlk" id="assetVerifyBarBlk" style="display: none;"> 
                                        <div class="innerFormBlk">
                                            <div class="row">
                                                <div class="formElem qrCodeFld" style="    margin-bottom: 10px;">
                                                    <label class="asstLabelFld" id="assetVerifyBarBlkBtnLbl">${I18N_OBJECT.tr("Barcode/QR Code")}<sup>*</sup></label>
                                                    <input type="text" name="assetNumberToVerify" id="assetNumberToVerify">	
                                                    <a href="javascript:void(0)" id="verifyCode" class="saveBtn" onclick="verifyQrCodeOrBarCode()">Verify</a></div>
                                                <div class="assetDiv" style="float: right;">
                                                    <a href="javascript:void(0)" class="changeStateLnk" onclick="changeVerifyAssetStatus()" id="changeStatusVerifyBarCode" style="float: right;    margin-top: 15px;    box-shadow: 0 0px 2px #afafaf;">
                                                        <i class="ico changeStateIco"></i>
                                                        <span>${I18N_OBJECT.tr("Change Status")}</span>
                                                    </a>
                                                    <div id="errChangeState"><p class="fldErr">${I18N_OBJECT.tr("Please select atleast one Asset")} </p></div>
                                                </div>
                                            </div>

                                        </div>	
                                        <div class="history-block cmdbBlk" style="display:none">
                                            <!--<h1>My Asset</h1>  -->
                                          
                                                            </div>
                                        <label for="radio000" class="radio">&nbsp;<span><span></span></span></label>
                                        <div id="assetReconSuccessblk"></div>
                                        <div  id="assetBarCodeGeneration" class="">
                                            <div class="history-block cmdbBlk"> 
                                                <ul class="mainAssets" id="assetBarCodeGeneration123" style="display:none">
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="innerClkBlk" id="assetBarcodeGenerateBlk" style="display: none;"> 
                                        <div class="innerFormBlk">
                                            <div class="row">
                                                <div class="formElem">
                                                    <label class="asstLabelFld" id="generateBarcodeLabel" >${I18N_OBJECT.tr("Barcode/QR Code Template")}<sup>*</sup></label>
                                                    <select class="demo single" id="assetBarcodeTemplateLst">
                                                        <option value="0">${I18N_OBJECT.tr("-- Choose --")}</option>
                                                    </select>
                                                    <script>
                                                        $("#assetBarcodeTemplateLst").multipleSelect({
                                                            filter: true,
                                                            single: true,
                                                        });
                                                    </script>                                                   
                                                </div>
                                            </div>
                                            <div id="dynOptions">
                                            </div>                                             
                                        </div>
                                                    <div class="closeBlk">
                                            <div id="" class="impBtm impCreate" style="position: static;">
                                                <a href="javascript:void(0)" id="c" onclick="generateBarcodePdf('${_csrf.parameterName}', '${_csrf.token}')" class="btn apply" style="margin-right: 2%;" >${I18N_OBJECT.tr("Generate")}</a>
                                                <a href="javascript:void(0)"  id="cancelAsset" onclick="closeDialog()" class="backBtnIc">${I18N_OBJECT.tr("Cancel")}</a>
                                            </div> 	
                                        </div>
                                    </div>
                                </div>
                                <a href="javascript:void(0)" title="Audit Log" class="ico-auditlog" data-moduleid="${moduleId}" onclick="loadAssetAuditGrid()" style="display:block;"></a>
                                <a href="javascript:void(0)" id="backToCMDBListing" class="backBtn" data-moduleid="" onclick="backToCMDBListing()" style="float: right;margin-top: 10px;line-height: 26px;padding-left: 30px;margin-right: 10px;display:none;">Back</a>
                            </form>
                            <div id="assetBtnPrivilege" class="assetArchiveBtn">

                            </div>
                           
                            <div id="lnksystmmsg"></div>
                            <div id="assetRecon"></div>
                            
                            <input type="hidden" id="gridReconModuleId" name="gridReconModuleId" value="${moduleId}"/>
                            <a href="javascript:void(0)" id="backToReconGridViewIco" class="backBtn" data-moduleid="${moduleId}" style="float:right!important;display:none;">Back</a>
                            <div id="assetReconGrid" class="assetReconGrid" style="display:none"></div>
                            <div id="assetReconGridDetails" style="display:none"></div>
                            <div id="assetReconGridPager"  style="display:none" data-pagetype="assetRecon" data-pageno="1" class="pager" data-totalrecords="1" data-totalpages="1"> </div>
                            <div class="rightPagn assetRecon" style="display:none;margin-right: 30px;">
							<div class="downoadOpt">  <a href="javascript:void(0)&quot;">  <img src="assets/images/excel.png" alt="" onclick="assetExcelExport('RECONadvanceview')">  <span class="hovOver"><i></i>Export as Excel  </span>  </a>  </div>
							<div class="dispRecords"><p id="slickGridRecordInfo">Displaying records 1 - 0 of 0</p></div></div>
                            
                            <div id="assetSuccesssMsg" style="display:none"></div>
                            <div class="createdTicket sucessMsg ticketCreation" style="display:${not empty NewTicketFromAssetStatus?'':'none;'}">
                                <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Thank You! Your ticket has been created and ")}${sessionScope.PROJECT_DETAILS.projectShortName}${I18N_OBJECT.tr(" details have been sent to your registered email ID")}</p>
                            </div>
                            <div class="createdTicket sucessMsg" style="display:none" id="assetPrivacySuccess">
                                <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Privacy Information Updated Successfully")}</p>
                            </div>
                            <div class="createdTicket sucessMsg" style="display:${not empty AssetProfileUpdateStatus?'':'none;'}">
                                  <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Profile Information Updated Successfully")}</p>
                            </div>
                            <div class="createdTicket sucessMsg" id="assetprofileCreateSuccess" name="assetprofileCreateSuccess" style="display:none">
                                <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Profile created successfully ")}</p>
                            </div>
                            <div class="createdTicket sucessMsg" id="assetprofileUpdateSuccess" name="assetprofileUpdateSuccess" style="display:none">
                                <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Profile updated successfully ")}</p>
                            </div>
                            <div class="createdTicket sucessMsg" id="cleardefaultProfileSuccess" style="display:none">
                                <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Default profile cleared successfully ")}</p>
                            </div>
                            <div class="createdTicket sucessMsg filter" style="display:none">
                                <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Default profile set successfully ")}</p>
                            </div>
                            <div class="createdTicket sucessMsg" id="assetprofileDeleteAccess" name="assetprofileDeleteAccess" style="display:none">
                                <i class="ico statusIco"></i><p>${I18N_OBJECT.tr("Profile deleted successfully ")}</p>
                            </div>
                            <div class="scheduleMainBlk" id="assets-add" style="display: none">
                                <jsp:include page="AssetDetails.jsp" />

                            </div>
                            <div id="assetMainContentDiv" class="mainTickets list">
                                <jsp:include page="MyAssetInclude.jsp" />
                            </div>
                            <div id="historyViewBlk" style="display:none">
                                <div class="detailHead">
                                    <h2 class="assetTitle" style="display:none">History</h2> 
                                    <div class="formElem m10" style="display:none;width: auto;" id="assetHistoryPagination"> </div>
                                </div>
                                <div id="assetGridHistory"> </div>
                            </div>
                        </div>
                        <!-- Right panel Filters -->
                        <div class="main-filter rightPanelFilter" id="assetRightPanelDiv"></div>
                        <!-- End of Right panel Filters -->
                    </div>
                </div>
                </div>
                <div id="myasset" class="cmdbmyasset">

                </div>
                            
            </section>
            <c:if test="${IsOnlyCMDBAccess eq 0}">
                <a href="javascript:void(0)" class="setIcLnkFilter" id="assetFilterSetIcLnk"><span>${I18N_OBJECT.tr("Filter")}</span></a>
            </c:if>
        </div>       
        <c:if test="${IsOnlyCMDBAccess eq 1}">
        <jsp:include page="ticketViewAjaxScript.jsp"/>
        </c:if>
        <jsp:include page="AssetAjaxScript.jsp"/>
        <script>
            getAssetModuleIdRoleBase('${assetModuleId}');
        </script>  
    </body>
    <input type="hidden" id="IsOnlyCMDBAccess" name="IsOnlyCMDBAccess" value="${IsOnlyCMDBAccess}">
    <input type="hidden" name="isRedirectCountCleared" id="isRedirectCountCleared" value="0">
    <input type="hidden" name="isFromOtherUrl" id="isFromOtherUrl" value="${isFromOtherUrl}"/>
    <input type="hidden" name="dashboardConfiguredProfileId" id="dashboardConfiguredProfileId" value="${dashboardConfiguredProfileId}">
    <input type="hidden" name="isFromRedirection" id="isFromRedirection" value="${isFromRedirection}"/>
    <c:if test="${openViewPage eq 'yes'}">
        <script>
            $(document).ready(function () {
                setTimeout(function(){                    
                    if($("#CMDBViewType").val()==undefined ||$("#CMDBViewType").val()=='' ||$("#CMDBViewType").val()=='0'){
                        openAssetDetails(${assetId});
                    }else{
                        $(".editableLnk.slickGridAssetIdLnk[data-attributeId='${assetId}']").click();                        
                    }
                }, 1000);
            });
        </script>
    </c:if>
    <c:if test="${createAssetFromInv eq 'yes'}">
        <script>
            $(document).ready(function () {
                var assetFromInvTypeId = "${assetFromInvTypeId}";
                var assetFromInvHostName = "${assetFromInvHostName}";
                var assetFromInvSystemID = "${assetFromInvSystemID}";
                var assetFromInvSiteID = "${assetFromInvSiteID}";

                if (
                    assetFromInvTypeId &&
                    assetFromInvHostName &&
                    assetFromInvSystemID &&
                    assetFromInvSiteID
                ) {
                    $("#closeAnnouncementBlk").click();
                    setTimeout(function () {
                        $("#add-btn").click();
                        setTimeout(function () {
                            $('#assetItemType').multipleSelect('setSelects', [assetFromInvTypeId]);
                            $("#assetItemType").multipleSelect("refresh");
                            getAssetTypeComnLabels(assetFromInvTypeId);
                            getAssetFiledsModule();
                            getAssetInvValues(assetFromInvHostName, assetFromInvSystemID + "," + assetFromInvSiteID);
                        }, 500);
                    }, 500);
                }
            });
        </script>
    </c:if>


</html>