<%@taglib prefix="security" uri="http://www.springframework.org/security/tags"%>
<%-- 
   Document   : RpaRegistration
   Created on : 24 Jul, 2020, 5:19:42 PM
   Author     : syed
--%>
<%@ page language="java" contentType="text/html;" pageEncoding="UTF-8"%>
<%@ page import="java.io.Serializable"%>
<%@page import="org.xnap.commons.i18n.I18n"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/ajaxtld/ajaxtags.tld" prefix="ajax" %>
<c:set var="I18N_OBJECT" value="${applicationScope.LANGUAGE_MAP[LANGUAGE_UNICODE]}" />
<%@ include file="topPane.jsp" %>
<style type="text/css">
    #text {margin:50px auto; width:500px}
    .hotspot {color:#900; padding-bottom:1px; cursor:pointer;}
    #tt {position:absolute;  display:block;  bgcolor : #666666;}
    #tttop {display:block; height:5px; margin-left:5px; background : #666666; overflow:hidden; border-top-left-radius: 15px; border-top-right-radius: 15px;}
    #ttcont {display:block; padding:2px 12px 3px 7px; margin-left:5px; background:#666; color:#FFF}
    #ttbot {display:block; height:5px; margin-left:5px; background : #666666; overflow:hidden; border-bottom-right-radius: 15px;}
</style> 
<%
    response.setDateHeader("Expires", 0);
%>
<div id="sample">
    <%
        I18n i18n = Sapphire.LANGUAGE_MAP.get((String) session.getAttribute("LANGUAGE_UNICODE"));
        String messageIn = "";
        String messageIn1 = "";
        String telantName = (String) session.getAttribute("TELANTNAME");
        String image_path = "";
    %>
    <html>
        <head>
            <script type="text/javascript" src="assets/js/jquery.min.js" ></script>
            <script language="JavaScript" type="text/JavaScript">
                $(function (){$(document).ajaxSend(function(e, xhr, options) {xhr.setRequestHeader("X-CSRF-TOKEN", "${_csrf.token}");});});
                var _csrfInputTag="<input type=\"hidden\" name=\"${_csrf.parameterName}\" value=\"${_csrf.token}\"/>";
            </script>
            <%@ include file="toptable.jsp"%>
            <jsp:include page="commonJs.jsp"/>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <link href="sapphire.css" rel="stylesheet" type="text/css">
            <link href="sap.css" rel="stylesheet" type="text/css">
            <%@ include file="AJAXPopup.jsp" %>
            <%    if (new Sapphire().checkModuleAccess((String) session.getAttribute("login"), "Settings", telantName) == 0) {
            %>
            <jsp:forward page="login_page.htm"></jsp:forward>
            <%}%>
            <style type="text/css">
                #formData .widgetInnerWrapper td.formtext[align=right] {
                    width: 35%;
                }
            </style>
            <script language="JavaScript" type="text/JavaScript">
                function pleaseConfirm(){
                    <%if(session.getAttribute("SERVICEDESK_NEWUI_PAGE")!= null){%>
                        customConfirm("Please click ok if installed RPA verion is 1.2 or higher, otherwise it leads to a problem","rpaRegistration","cancelButton");
                    <%}else{%>
                    if (confirm("Please click ok if installed RPA verion is 1.2 or higher, otherwise it leads to a problem") == true) {
                        rpaRegistration();
                    } else {
                        cancelButton();
                    }
                    <%}%>
                }
                function rpaRegistration(){
                    var rpaurltxt = document.getElementById("rpaurltxt").value;
                    var isValid = true;
                    if(rpaurltxt == ""){
                        alert("<%=i18n.tr("Url should not be empty")%>");
                        isValid = false;
                    } else if((!rpaurltxt.includes("http://")) && (!rpaurltxt.includes("https://"))){
                        var strFirstThree = str.substring(0,3);
                        alert("<%=i18n.tr("Url is invalid")%>");
                        isValid = false;
                    } else if((rpaurltxt.includes("http://")) || (rpaurltxt.includes("https://"))){
                        if(rpaurltxt.includes("http://")){
                            var str = rpaurltxt.substring(0,7);
                            if(str != "http://"){
                                alert("<%=i18n.tr("Url is invalid")%>");
                                isValid = false;
                            }
                        } else if(rpaurltxt.includes("https://")){
                            var str = rpaurltxt.substring(0,8);
                            if(str != "https://"){
                                alert("<%=i18n.tr("Url is invalid")%>");
                                isValid = false;
                            }
                        }
                    } else if(rpaurltxt.length < 16){
                        alert("<%=i18n.tr("Url is invalid")%>");
                        isValid = false;
                    }
                    var setupurltxt = document.getElementById("setupurltxt").value;
                    if(setupurltxt == ""){
                        alert("<%=i18n.tr("SapphireIMS Setup Url should not be empty")%>");
                        isValid = false;
                    } else if((!setupurltxt.includes("http://")) && (!setupurltxt.includes("https://"))){
                        var strFirstThree = str.substring(0,3);
                        alert("<%=i18n.tr("Url is invalid")%>");
                        isValid = false;
                    } else if((setupurltxt.includes("http://")) || (setupurltxt.includes("https://"))){
                        if(setupurltxt.includes("http://")){
                            var str = setupurltxt.substring(0,7);
                            if(str != "http://"){
                                alert("<%=i18n.tr("Url is invalid")%>");
                                isValid = false;
                            }
                        } else if(setupurltxt.includes("https://")){
                            var str = setupurltxt.substring(0,8);
                            if(str != "https://"){
                                alert("<%=i18n.tr("Url is invalid")%>");
                                isValid = false;
                            }
                        }
                    } else if(setupurltxt.length <= 60){
                        alert("<%=i18n.tr("Url is invalid")%>");
                        isValid = false;
                    }
                    if(!isValid){
                        return false;
                    }
                    var isRegistered = "0";
                    $.ajax({
                        url: "rpaHealthCheck.do",
                        type: "POST",
                        data: "rpaurl="+decodeURIComponent(rpaurltxt),
                        async: false,
                        beforeSend: function( xhr ) {
                            document.getElementById('progressMsg').style.display = 'block';
                        },
                        success: function(isEnable) {
                            if(isEnable === true || isEnable === 'true'){
                                $.ajax({
                                    url: "rpaRegister.do",
                                    type: "POST",
                                    data: "rpaurl="+decodeURIComponent(rpaurltxt)+"&setupurl="+decodeURIComponent(setupurltxt),
                                    success: function(data) {
                                        isRegistered = data;
                                    },complete:function(){
                                        if(isRegistered == "1"){
                                            alert("<%=i18n.tr("RPA Registered Successfully")%>");
                                            cancelButton();
                                        } else if(isRegistered == "0"){
                                            alert("<%=i18n.tr("RPA Registration failed")%>");
                                            cancelButton();
                                        }
                                    }
                                });
                            } else {
                                 <%if(session.getAttribute("SERVICEDESK_NEWUI_PAGE")!= null){%>
                                    getValueFromAlert("Unable to access the RPA Server. Please check if the server is up and the RPA plugin is installed").then(result => {
                                        cancelButton();
                                    });
                                <%}else{%>
                                alert("<%=i18n.tr("Unable to access the RPA Server. Please check if the server is up and the RPA plugin is installed")%>");
                                cancelButton();
                                <%}%>
                            }
                        },complete:function(){
                            document.getElementById('progressMsg').style.display = 'none';
                        }
                    });
                }
                function cancelButton(){
                    window.location.href="..<%=SapphireFilterUtil.sapphireContextPath%>/Settings.jsp?isNewUIAvailable=yes&isSettingsList=yes";
                }
                function initProgress() {
                    document.getElementById('progressMsg').style.display = 'block';
                }
                function resetProgress() {
                    document.getElementById('progressMsg').style.display = 'none';
                }
            </script>
        </head>
        <%
            response.setDateHeader("Expires", 0);
        %>
        <html>
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
                <title><%=i18n.tr("RPA Registration")%></title>
            </head>
            <body>
                <div id="mainContentArea1">
                    <div id="htmlContentForm">
                        <form name="AJAX" method="post" id="formData" action="rpaRegister.do">
                            <input type="hidden" name="_csrf" value="5830fb64-27ba-4c12-8c3c-7449eb053228">
                            <!--CHANGED TO NEW TEMPLATE-->
                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                <tbody>
                                    <tr>
                                        <td colspan="2" align="center" valign="top">
                                            <table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
                                                <tbody>
                                                    <tr>
                                                        <td align="center">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tbody>
                                                                    <tr>
                                                                        <td colspan="3">
                                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td>
                                                                                            <div style="width:99.5%">
                                                                                                <table width="100%" border="0" cellspacing="0" cellpadding="0" id="subTabNavigation">
                                                                                                    <tbody>
                                                                                                        <tr>
                                                                                                            <td height="24" valign="bottom">
                                                                                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                                                                    <tbody>
                                                                                                                        <tr>
                                                                                                                            <td width="100%" class="bottom10">
                                                                                                                                <ul>
                                                                                                                                    <li class="selected"><a href="#"><%=i18n.tr("RPA Registration")%></a><span></span></li>
                                                                                                                                </ul>
                                                                                                                            </td>
                                                                                                                        </tr>
                                                                                                                    </tbody>
                                                                                                                </table>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    </tbody>
                                                                                                </table>
                                                                                            </div>
                                                                                        </td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td width="100%" align="center" valign="top">
                                                                            <div class="contentBlock noMargin">
                                                                                <div class="widgetOuterWrapper">
                                                                                    <div class="widgetInnerWrapper">
                                                                                        <input type="hidden" id="rpaurl" name="rpaurl" value="">
                                                                                        <a href="" id="reloadUrl" style="display:block"></a>
                                                                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" valign="top">
                                                                                            <tbody>
                                                                                                <tr>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                        <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                                            <tbody>
                                                                                                <c:choose>
                                                                                                    <c:when test="${not isRpaRegistered}">
                                                                                                        <tr>
                                                                                                            <td colspan="2" class="wid100">
                                                                                                                <table width="100%" cellspacing="0" cellpadding="0">
                                                                                                                    <tbody>
                                                                                                                        <tr>
                                                                                                                            <td width="20%" align="right" class="formtext">
                                                                                                                                <%=i18n.tr("RPA Url ")%><font color="red">*</font>
                                                                                                                            </td>
                                                                                                                            <td width="80%" align="left" height="35" class="formfield">
                                                                                                                                <c:set var="rpaUrlData" value="" />
                                                                                                                                <c:set var="isServerFlag" value="" />
                                                                                                                                <input id="rpaurltxt" name="rpaurltxt" maxlength="100" type="text" class="mcopy" size="61" value="">
                                                                                                                                <span class="hotspot" onmouseover="mouseOverMessage('rpaurl')" onmouseout="tooltip.hide();"><img style="cursor:pointer;" src="help_small.gif" alt="Help" height="16" width="16"></span>
                                                                                                                            </td>
                                                                                                                        </tr>
                                                                                                                    </tbody>
                                                                                                                </table>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td colspan="2" class="wid100">
                                                                                                                <table width="100%" cellspacing="0" cellpadding="0">
                                                                                                                    <tbody>
                                                                                                                        <tr>
                                                                                                                            <td width="20%" align="right" class="formtext">
                                                                                                                                <%=i18n.tr("Base Url ")%><font color="red">*</font>
                                                                                                                            </td>
                                                                                                                            <td width="80%" align="left" height="35" class="formfield">
                                                                                                                                <input id="setupurltxt" name="setupurltxt" maxlength="100" type="text" class="mcopy" size="61" value="">
                                                                                                                                <span class="hotspot" onmouseover="mouseOverMessage('setupurl')" onmouseout="tooltip.hide();"><img style="cursor:pointer;" src="help_small.gif" alt="Help" height="16" width="16"></span>
                                                                                                                            </td>
                                                                                                                        </tr>
                                                                                                                    </tbody>
                                                                                                                </table>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    </c:when>
                                                                                                    <c:otherwise>
                                                                                                        <tr>
                                                                                                            <td colspan="2" class="wid100">
                                                                                                                <table width="100%" cellspacing="0" cellpadding="0">
                                                                                                                    <tbody>
                                                                                                                        <tr>
                                                                                                                            <td width="50%" align="right" class="formtext">
                                                                                                                                <%=i18n.tr("Auth Key : ")%>
                                                                                                                            </td>
                                                                                                                            <td width="50%" align="left" height="35" class="formfield"> 
                                                                                                                                <input id="authkey" name="authkey" maxlength="100" type="text" class="mcopy" size="40" value="${authKey}" readonly>
                                                                                                                            </td>
                                                                                                                        </tr>
                                                                                                                    </tbody>
                                                                                                                </table>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td colspan="2" class="wid100">
                                                                                                                <table width="100%" cellspacing="0" cellpadding="0">
                                                                                                                    <tbody>
                                                                                                                        <tr>
                                                                                                                            <td width="50%" align="right" class="formtext">
                                                                                                                                <%=i18n.tr("Auth Token : ")%>
                                                                                                                            </td>
                                                                                                                            <td width="50%" align="left" height="35" class="formfield"> 
                                                                                                                                <input id="authtoken" name="authtoken" maxlength="100" type="text" class="mcopy" size="40" value="${authToken}" readonly>
                                                                                                                            </td>
                                                                                                                        </tr>
                                                                                                                    </tbody>
                                                                                                                </table>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    </c:otherwise>
                                                                                                </c:choose>
                                                                                                <tr>
                                                                                                    <td height="5">
                                                                                                        &nbsp;
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr class="basicButtonFooter margin10">
                                                                                                    <td colspan="2" bgcolor="#FFFFFF" class="domains" align="center" >
                                                                                                        <c:choose>
                                                                                                            <c:when test="${not isRpaRegistered}">
                                                                                                                <input type="button" onclick="pleaseConfirm();" id="rpaRegister" value="<%=i18n.tr("Register")%>" class="addbuttons greenBtn" style="display:inline-block">
                                                                                                                <input type="button" onclick="cancelButton();" id="cancelRegistration" value="<%=i18n.tr("Cancel")%>" class="addbuttons" style="display:inline-block">
                                                                                                            </c:when>
                                                                                                            <c:otherwise>
                                                                                                                <input type="button" value="<%=i18n.tr("ok")%>" id="registered" class="addbuttons" onclick="cancelButton();" style="display:block">
                                                                                                            </c:otherwise>
                                                                                                        </c:choose>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <tr class="noTopMargin">
                                                                                                    <td align="center" bgcolor="#FFFFFF" class="domains" ><span id="progressMsg" style="display:none;">
                                                                                                            <img alt="Indicator" src="<%=request.getContextPath()%>/img/indicator.gif" /> <%=i18n.tr("Loading")%>...</span>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </form>
                    </div>
                </div>
                <%@ include file="Sapphire_Footer.jsp" %>
            </body>
        </html>
        <script type="text/javascript">
            var tooltip = function () {
                var id = 'tt';
                var top = 3;
                var left = 3;
                var maxw = 450;
                var speed = 10;
                var timer = 20;
                var endalpha = 100;
                var alpha = 0;
                var tt, t, c, b, h;
                var ie = document.all ? true : false;
                return{
                    show: function (v, w) {
                        if (tt == null) {
                            tt = document.createElement('div');
                            tt.setAttribute('id', id);
                            t = document.createElement('div');
                            t.setAttribute('id', id + 'top');
                            c = document.createElement('div');
                            c.setAttribute('id', id + 'cont');
                            b = document.createElement('div');
                            b.setAttribute('id', id + 'bot');
                            tt.appendChild(t);
                            tt.appendChild(c);
                            tt.appendChild(b);
                            document.body.appendChild(tt);
                            tt.style.opacity = 0;
                            tt.style.filter = 'alpha(opacity=0)';
                            document.onmousemove = this.pos;
                        }
                        tt.style.display = 'block';
                        c.innerHTML = v;
                        tt.style.width = w ? w + 'px' : 'auto';
                        if (!w && ie) {
                            t.style.display = 'none';
                            b.style.display = 'none';
                            tt.style.width = tt.offsetWidth;
                            t.style.display = 'block';
                            b.style.display = 'block';
                        }
                        if (tt.offsetWidth > maxw) {
                            tt.style.width = maxw + 'px'
                        }
                        h = parseInt(tt.offsetHeight) + top;
                        clearInterval(tt.timer);
                        tt.timer = setInterval(function () {
                            tooltip.fade(1)
                        }, timer);
                    },
                    pos: function (e) {
                        var u = ie ? event.clientY + document.documentElement.scrollTop : e.pageY;
                        var l = ie ? event.clientX + document.documentElement.scrollLeft : e.pageX;
                        tt.style.top = (u - h) + 'px';
                        tt.style.left = (l + left) + 'px';
                    },
                    fade: function (d) {
                        var a = alpha;
                        if ((a != endalpha && d == 1) || (a != 0 && d == -1)) {
                            var i = speed;
                            if (endalpha - a < speed && d == 1) {
                                i = endalpha - a;
                            } else if (alpha < speed && d == -1) {
                                i = a;
                            }
                            alpha = a + (i * d);
                            tt.style.opacity = alpha * .01;
                            tt.style.filter = 'alpha(opacity=' + alpha + ')';
                        } else {
                            clearInterval(tt.timer);
                            if (d == -1) {
                                tt.style.display = 'none'
                            }
                        }
                    },
                    hide: function () {
                        clearInterval(tt.timer);
                        tt.timer = setInterval(function () {
                            tooltip.fade(-1)
                        }, timer);
                    }
                };
            }();

            function mouseOverMessage(content) {
                var desc = "";
                if(content == 'rpaurl'){
                    desc = '<%= i18n.tr("Please check the RPA URL properly before registration.")%>';
                } else {
                    desc = '<%= i18n.tr("Please check the Base Url properly before registration, if its secured(https) then provide with public domain name. Ex: https://demo.sapphireims.com:8080/SapphireIMS, if domain name contains port no then no need to add explicitly")%>';
                }
                tooltip.show(' <strong>' + desc + '</strong>');
            }
        </script>