<%--
  Created by IntelliJ IDEA.
  User: abinaya.k
  Date: 08-05-2023
  Time: 06:41
  To change this template use File | Settings | File Templates.
--%>
<%@ taglib uri="http://jawr.net/tags" prefix="jwr" %>
<%@taglib prefix="security" uri="http://www.springframework.org/security/tags"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<c:set var="I18N_OBJECT" value="${applicationScope.LANGUAGE_MAP[LANGUAGE_UNICODE]}" />
<%@ page import="java.util.Map" %>
<c:set var="delegationValue" value="SERVICEDESK_USER_DELEGATION_${projectId}"/>
<c:set var="servicedeskcommentsize" value="${applicationScope.SAPPHIRE_CONFIG_SETTINGS.findBySettingKey('SERVICEDESK_COMMENT_SIZE')}"/>
<!DOCTYPE HTML>
<html>
<head>
    <link rel="shortcut icon" href="${sessionScope.faveIconPath}" />
    <jsp:include page="sapphireNewUXIncludes.jsp"></jsp:include>
	<%@ include file="AJAXPopup.jsp" %>
    <jwr:style src="/styles/settingsCsslib.css"/>
    <jwr:script src="/bundles/settingslib.js"/>
    <c:set var="customerTitle" value="CUSTOMER_TITLE"/>
    <title>${applicationScope.SAPPHIRE_CONFIG_SETTINGS.findBySettingKey('CUSTOMER_TITLE')}</title>

    <meta charset="UTF-8" />
    <security:csrfMetaTags/>
    <script type="text/javascript" src="ckeditor1/ckeditor.js"></script>
</head>
<body>
<div id="settingstd">
    <div class="widgetBlock" id="settingsdiv">
        <div class="widgetHeader"><h2>Settings</h2><span></span><a href="#" title="Collapse" onclick="collapseSettings()"><img src="updatedImages/widget_collapse.png" alt="Collapse" /></a></div>
        <div class="widgetOuterWrapper">
            <div class="widgetInnerWrapper">

                <jsp:include page="SDProjectSettingsLeftPanelMenu.jsp" >
                    <jsp:param name="project" value="${projectId}"></jsp:param>
                </jsp:include>
            </div>
        </div>
    </div>
</div>
<div class="page-nav" id="projectSelectionBar">
    <div class="navigateAction">
        <ul>
            <div class="mainNav">
                <c:forEach items="${SD_PROJECT_MAP}" var ="projectMap">
                    <c:choose>
                        <c:when test="${projectMap.key eq projectId}">
                            <div id="selectedSlick"><li id="test${projectMap.key}" title="${I18N_OBJECT.tr(projectMap.value)}"><a onclick="OpenProjectSettings('${projectMap.key}','${moduleId}')" style="cursor: pointer;" class="selected"><span>${I18N_OBJECT.tr(projectMap.value)}</span></a></li></div>
                        </c:when>
                        <c:otherwise>
                            <div><li id="test${projectMap.key}" title="${I18N_OBJECT.tr(projectMap.value)}"><a onclick="OpenProjectSettings('${projectMap.key}','${moduleId}')" style="cursor: pointer;" ><span>${I18N_OBJECT.tr(projectMap.value)}</span></a></li></div>
                        </c:otherwise>
                    </c:choose>
                </c:forEach>
            </div>
        </ul>
    </div>
    <script>
        $('.mainNav').slick({
            dots: true,
            slidesToShow: 5,
            infinite: false,
            speed: 500,
            slidesToScroll: 5
        });
        $('.mainNav').slick('goTo',$("#selectedSlick").attr("data-slick-index"),true);
    </script>
</div>
<div id="mainSdDiv">
    <div class="gridViewPort gridViewPort--main" id="${gridBlockName}">
        <div class="alertMsg marginB10" style="display: none" id="alertMsg${tuple.problemId}">
            <p>${I18N_OBJECT.tr("Are you sure, want to delete records ?")}</p>
            <a href="javascript:void(0)" class="yesBtn" id="yesBtn" data-moduleId="${moduleId}" data-projectId="${projectId}">${I18N_OBJECT.tr("YES")}</a>
            <a href="javascript:void(0)" class="noBtn" id="noBtn" >${I18N_OBJECT.tr("NO")}</a>
        </div>
        <div class="sucessMsg" style="display: none;" id="success">
            <i class="ico statusIco"></i>
            <p>${I18N_OBJECT.tr("Deleted successfully")} </p>
        </div>
        <header class="gridViewPort_header"><c:if test="${moduleId ne 7}"><h2>${title}</h2></c:if>
		<c:if test="${moduleId eq 7}">
		<div class="headerTab">
			<ul class="headerTab--ul">
                <li class="selected">
					<a href="javascript:void(0)">Sub Category</a>
				</li>
				<li onclick="loadDerivedFieldGrid(1)" id="derivedFieldTab1">
					<a href="javascript:void(0)">Derived Field 1</a>
				</li>
				<li onclick="loadDerivedFieldGrid(2)" id="derivedFieldTab2">
					<a href="javascript:void(0)">Derived Field 2</a>
				</li>
				<li onclick="loadDerivedFieldGrid(3)" id="derivedFieldTab3">
					<a href="javascript:void(0)">Derived Field 3</a>
				</li>
            </ul>
		</div>
		</c:if>
            <a class="auditLog" onclick="auditLog('${projectId}','${moduleId}')" ></a>
			<c:if test="${moduleId eq 10}">
			<a class="workflowViewer" title="Workflow Viewwer"></a>
			</c:if>
            <c:if test="${moduleId eq 2}">
            <a class="licenseIco" title="View Technician License Usage" onclick="showLicenseUser('${projectId}','${moduleId}')"></a>
            </c:if>
        </header>
        <div class="gridActionLeftBlk"  style="width:calc(100% - 80px);margin: 10px 0">
            <c:choose>
                <c:when test="${moduleId eq 4 || moduleId eq 11|| moduleId eq 12 || moduleId eq 13 || moduleId eq 14 || moduleId eq 25 || moduleId eq 8 || moduleId eq 3 || moduleId eq 10|| moduleId eq 9|| moduleId eq 7|| moduleId eq 42|| moduleId eq 39}">
                    <a href="javascript:void(0)"  onclick=addNewList("listingGrid") class="newRowIco" id="newGridRowAdd"><img src="assets/images/add_row.png" alt=""><span>Add</span></a>
                    <c:if test="${moduleId ne 7}">
                        <a class="deleteRowIco" id="deleteRowIco" data-moduleId="${moduleId}" data-projectId="${projectId}"><img src="assets/images/delete_row.png" alt=""><span>Delete</span></a>
                    </c:if>
                </c:when>
                <c:when test="${moduleId eq 5 || moduleId eq 6}">
                    <a href="javascript:void(0)"  onclick=addNewList("listingGrid") class="newRowIco" id="newGridRowAdd"><img src="assets/images/add_row.png" alt=""><span>Add</span></a>
                    <c:if test="${moduleId eq 5}">
                    <a href="javascript:void(0)"  class="deleteRowIco" id="deleteRowIco" data-moduleId="${moduleId}" data-projectId="${projectId}"><img src="assets/images/delete_row.png" alt=""><span>Delete</span></a>
                    </c:if>
                    <a href="javascript:void(0)"  class="activateRow" id="activateRow"><span>Activate</span></a>
                    <a href="javascript:void(0)"  class="activateRow deactive" id="deactivateRow"><span>Deactivate</span></a>
                </c:when>
                <c:when test="${moduleId eq 2}">
            <a href="javascript:void(0)" class="newRowIco" id="unallocate" data-moduleId="${moduleId}" data-projectId="${projectId}"><img src="assets/images/add_row.png" alt=""><span>UNALLOCATE</span></a>
            <a href="javascript:void(0)" class="newRowIco" id="allocateRoles" data-moduleId="${moduleId}" data-projectId="${projectId}"><img src="assets/images/add_row.png" alt=""><span>ALLOCATE ROLES</span></a>
            <a href="javascript:void(0)" style="display:none"  class="newRowIco" id="allocateUsers"><img src="assets/images/add_row.png" alt=""><span>ALLOCATE USERS</span></a>
            <div class="rolesContainer">
                <label class="abosluteLabel">Roles</label>
                <select style="display: none;" id="roles" onchange="changeRoles(${projectId},${moduleId})">
                    <option value="0">All</option>
                    <c:forEach var="entry" items="${roles}">
                        <option value="${entry.key}">${entry.value}</option>
                    </c:forEach>
                </select>
            </div>
            <script>
                $("#roles").multipleSelect({
                    single:true,
                    width:150,
                    onClick:function(data){
                        if(data.value==0){
                            $("#allocateUsers").hide();
                            $("#allocateRoles").show();
                        }else{
                            $("#allocateRoles").hide();
                            $("#allocateUsers").show();
                        }
                        $("#allocateRoles,#allocateUsers").removeClass("active");
                        $("#allocateRolesContainer").hide();
                        $(".relativeContainer--header").text("Allocate Roles");
                        $("#roleList").multipleSelect("enable");
                    }
                });
                </script>
                    <div class="searchContainer">
                        <select style="display: none;" id="userAttributes">
                            <c:forEach var="entry" items="${searchAttributes}">
                        <c:choose>
                            <c:when test="${defaultSearchAttributes eq entry.key}">
                                <option value="${entry.key}" selected>${entry.value}</option>
                            </c:when>
                            <c:otherwise>
                                <option value="${entry.key}">${entry.value}</option>
                            </c:otherwise>
                        </c:choose>
                            </c:forEach>
                        </select>
                        <input type="text" placeholder="Search..." id="userSearch" data-moduleId="${moduleId}" data-projectId="${projectId}">
                        <i class="userAttributeSearch" id="userAttributeSearch" data-moduleId="${moduleId}" data-projectId="${projectId}"></i>
                    </div>
                    <script>
                        $("#userAttributes").multipleSelect({
                            single:true,
                            width:150
                        })
                    </script>
                </c:when>
                <c:when test="${moduleId eq 1}">
                    <a href="javascript:void(0)"  onclick=addNewList("listingGrid") class="newRowIco" id="newGridRowAdd"><img src="assets/images/add_row.png" alt=""><span>Add</span></a>
                    <a href="javascript:void(0)"  class="newRowIco" id="deleteRowIco" data-moduleId="${moduleId}" data-projectId="${projectId}"><img src="assets/images/delete_row.png" alt=""><span>Delete</span></a>
                    <div class="switchBlk">
                        <input type="checkbox" id="roleToggleCheck">
                        <label class="switchBlk-label"id="rolesToggelebtn">
                            <span class="switchBlk-inner"><span id="delegatedTo">Delegation</span></span>
                            <span class="switchBlk-switch"></span>
                        </label>
                    </div>
                    <div class="enableDelegation">
                        <h2>Delegation
                            <div class="switchBlk">
                                <input type="checkbox" id="disableDelegation">
                                <label class="switchBlk-label" for="disableDelegation">
                                    <span class="switchBlk-inner"><span class="disableSpan">Disable</span><span class="enableSpan">Enable</span></span>
                                    <span class="switchBlk-switch"></span>
                                </label>
                            </div>
                        </h2>
                        <div>
                            <input type="radio" name="position"  value="Technician" id="technician"/>
                            <label class="customRadCheck" for="technician"><span><span></span></span>Enable for Technician</label>
                        </div>
                        <div>
                            <input type="radio" name="position"  value="Approval Manager" id="approvalManager" /><label class="customRadCheck" for="approvalManager"><span><span></span></span>Enable for Approval Manager</label></div><div><input type="radio" name="position"  value="Both" id="both"/>
                        <label class="customRadCheck" for="both"><span><span></span></span>Enable for Technician and Approval Manager</label>
                    </div>
                        <div class="closeBlk"><a class="saveDelegation">Save</a><a class="cancleDelegation">Cancel</a></div>
                    </div>
                </c:when>
                <c:otherwise>
                </c:otherwise>
            </c:choose>
			<c:if test="${moduleId eq 7}">
                <a href="javascript:void(0)" class="activateRow" id="activateRow"><span>Activate</span></a>
                    <a href="javascript:void(0)"  class="activateRow deactive" id="deactivateRow"><span>Deactivate</span></a>

			</c:if>
			<!-- sla Comment S -->
            <c:if test="${moduleId eq 25}">
                <a href="javascript:void(0)" class="updateAccess" id=""  data-moduleId="${moduleId}" data-projectId="${projectId}">
                    <img src="assets/images/updateAccess.png" alt=""><span>Update Access</span>
                    <div id="threeStateToggle">
                        <div class="wrapper">
                            <input type="range" name="points" onchange="changeSLAaccess(this.value);" min="1" step="1" id="custom-toggle" class="tgl-on tgl-def" max="3" value="${commentUpdateAccess}">
                            <datalist id="values">
                                <option value="0" label="Technician"></option>
                                <option value="50" label="Owner/Manager"></option>
                                <option value="100" label="All"></option>
                            </datalist>
                        </div>
                    </div>
                </a>
            </c:if>
			<!-- sla Comment E -->
			<c:if test="${moduleId eq 15}">
				
				<div class="toggleContainer"><div class="toggleBtn"><input type="checkbox" id="allowOverridePriority" class="checkbox" value="Yes"
                        <% if (request.getAttribute("allowOverridePriority") != null && (int) request.getAttribute("allowOverridePriority") == 1) { %>
                           checked
                        <% } %>>
                    <div class="btn-cover"><span></span></div><div class="layer"></div></div><label>Allow users to override the Priority</label></div>
				<div class="toggleContainer"><div class="toggleBtn"><input type="checkbox" id="applyConfigForAllService" class="checkbox" value="No"><div class="btn-cover"><span></span></div><div class="layer"></div></div><label>Apply this configuration for all the services</label></div>
                <div class="serviceContainer">
                    <label  class="abosluteLabel">Service</label>
                    <select id="serviceList" onchange="loadSdGridData(projectId, 15,'1','10');">
                        <c:forEach var="entry" items="${serviceList}">
                            <c:choose>
                                <c:when test="${defaultServiceList eq entry.value}">
                                    <option value="${entry.key}" selected>${entry.value}</option>
                                </c:when>
                                <c:otherwise>
                                    <option value="${entry.key}">${entry.value}</option>
                                </c:otherwise>
                            </c:choose>
                        </c:forEach>
                    </select>
                    <script type="text/javascript">
                        $("#serviceList").multipleSelect({
                            single:true,
                            width:300,
                            filter:true
                        })
                    </script>
        </div>
			</c:if>
        </div>
        <c:if test="${moduleId eq 5}">
        <div class="imageChooser">
            <ul id="imageListing">
                <c:forEach var="image" items="${imageList}">
                    <li><img src="${image}"></li>
                </c:forEach>
            </ul>
            <div class="uploadBlk">
                <form id="uploadFile" action="uploadServiceIcon.do" method="post" enctype="multipart/form-data">
                    <div class="frmFld">
                        <p>${I18N_OBJECT.tr('Upload Custom Image')}</p>
                        <input type="file" name="file-1[]" id="file-1" accept="image/*"  class="inputfile inputfile-1" data-multiple-caption="{count} files selected" multiple />
                        <label for="file-1">
                            <img src="assets/images/file_upload.png" alt="">
                            <span id="chooseIconSpan">${I18N_OBJECT.tr('Choose a Icon...')}</span>
                        </label>
                    </div>
                    <div class="attachSuccess" id="attachSuccess">
                    </div>
                    <div class="fldAction">
                        <input type="button" value="${I18N_OBJECT.tr('Upload')}" class="attachBtn" id="attachBtn"/>
                        <a href="javascript:void(0)" class="cancelLnk" id="cancelServiceIcon">${I18N_OBJECT.tr('Cancel')}</a>
                    </div>
                </form>
            </div>
            <script type="text/javascript">
                'use strict';
                (function(document, window, index)
                {
                    var inputs = document.querySelectorAll('.inputfile');
                    Array.prototype.forEach.call(inputs, function(input)
                    {
                        var label = input.nextElementSibling,
                            labelVal = label.innerHTML;

                        input.addEventListener('change', function(e)
                        {
                            var fileName = '';
                            if (this.files && this.files.length > 1)
                                fileName = (this.getAttribute('data-multiple-caption') || '').replace('{count}', this.files.length);
                            else
                                fileName = e.target.value.split('\\').pop();

                            if (fileName)
                                label.querySelector('span').innerHTML = fileName;
                            else
                                label.innerHTML = labelVal;
                        });


                        input.addEventListener('focus', function() {
                            input.classList.add('has-focus');
                        });
                        input.addEventListener('blur', function() {
                            input.classList.remove('has-focus');
                        });
                    });
                }(document, window, 0));
            </script>
        </div>
        </c:if>
        <c:if test="${moduleId ne 19 && moduleId ne 15}">
            <select class="demo singlePag recordLimit" id="recordLimit${moduleId}" name="recordLimit${moduleId}" onchange="changePagination('${projectId}','${moduleId}')">
                <c:forEach begin="10" end="100" step="10" varStatus="loop">
                    <option value="${loop.index}">${loop.index}</option>
                </c:forEach>
            </select>
            <script type="text/javascript">
                $("#recordLimit${moduleId}").multipleSelect({
                    single: true,
                    filter: false,
                    width:70
                });
                setSdGridPaginationCount(${NEWUI_PAGINATION_COUNT},"recordLimit${moduleId}[name='recordLimit${moduleId}']");
            </script>
        </c:if>
    <c:if test="${moduleId eq 2}">
        <div id="allocateRolesContainer" class="relativeContainer">
            <h2 class="relativeContainer--header">Allocate Roles</h2>
            <div class="relativeContainer--Blk">
                <div class="relativeContainer--Blk_formElem searchOpt">
                    <a href="javascript:void(0)" class="searchOptions" id="searchOptions" title="User Search options">
                        <span id="searchOptApplied"></span>
                        <i id="clearSearchOpt" title="Clear">X</i>
                    </a>
                    <ul id="searchOptionList">
                        <c:forEach var="entry" items="${searchAttributes}">
                            <li class="searchOptItem" data-key="${entry.key}">${entry.value}</li>
                        </c:forEach>
                    </ul>
                </div>
                <div class="relativeContainer--Blk_formElem">
                    <label>Users</label>
                    <select id="userList" onclick=""><option value="">--Choose--</option></select>
                    <select id="userListMultiple" multiple><option value="">--Choose--</option></select>
                </div>
                <div class="relativeContainer--Blk_formElem">
                    <label>Roles</label>
                    <select id="roleList" multiple>
                        <c:forEach var="entry" items="${roles}">
                            <option value="${entry.key}">${entry.value}</option>
                        </c:forEach>
                    </select>
                    <input type="hidden" name="existingRoles" id="existingRoles" value=""/>
                </div>
                <a class="saveBtn" id="allocateRolesToUsers">Save</a>
                <a class="cancelBtn" id="allocateRolesCancel">Cancel</a>
            </div>
        </div>
        <script type=text/javascript>
            $("#userList").multipleSelect({
                single:true,
                width:200,
                filter:true,
                onOpen:function(){
                    loadUserList("userList");
                }
            });
            $("#userListMultiple").multipleSelect({
                selectAll:false,
                width:200,
                filter:true,
                onOpen:function(){
                    loadUserList("userListMultiple");
                }
            });
            $("#roleList").multipleSelect({
                selectAll:false,
                filter:true,
                width:200
            });
            $("#roleList").multipleSelect('uncheckAll');
        </script>
    </c:if>
	<c:if test="${moduleId eq 15}">
		<div class="columnGroupHeader">Urgency</div>
	</c:if>
        <div id="listingGrid"></div>
        <c:if test="${moduleId ne 15}">
        <div id="listingGridPager" class="pager">
        </div>
    
        <div class="rightPagn" style="">
            <div class="downoadOpt"><a href="javascript:void(0);"onclick="downloadExcelReport('${projectId}','${moduleId}','Service')"><img src="assets/images/excel.png" alt="" ><span class="hovOver"><i></i>Export as Excel</span></a></div>
            <div class="dispRecords"><p id="slickGridRecordInfo">No record(s) to display</p></div>
        </div>
</c:if>
        <div class="descBlkOverlay"></div>
        <div class="descriptionBlk" style="display:none">
            <h2>${title} Description</h2>
        </div>

    <div class="specializationDetails">
        <h2 class="specializationDetails--header">User Specialization<i id="closeUserSpec" title="close" class="closeUserSpec">X</i></h2>
        <ul class="specializationDetails--detailList"></ul>
    </div>
	
	<c:if test="${moduleId eq 3}">
	<c:set var="blockId" value="workflowgroupDFPop"/>
	<c:set var="saveBtnID" value="saveDerivedFlds"/>
	</c:if>
	<c:if test="${moduleId eq 10}">
	<c:set var="blockId" value="workflowConfigDFPop"/>
	<c:set var="saveBtnID" value="saveWCDerivedFlds"/>
	</c:if>
        <div class="derivedFieldsDetails"  id="${blockId}">
            <h2 class="derivedFieldsDetails--header">Derived Fields
                <i id="closeDerivedFields" title="close" class="closeUserSpec">X</i>
            </h2>
            <ul class="derivedFieldsDetails--detailList">
                <li class="checkFld" style="flex-basis: 100%;">
                    <label>Consider Derived Fields</label>
                    <input type="checkbox" id="considerCheckBox"><label for="considerCheckBox"><span><span></span></span></label>
                </li>
                <li>
                    <label>Derived Field 1</label>
                    <select id="derivedField1" multiple></select>
                </li>
                <li>
                    <label>Derived Field 2</label>
                    <select id="derivedField2" multiple></select>
                </li>
                <li>
                    <label>Derived Field 3</label>
                    <select id="derivedField3" multiple></select>
                </li>
            </ul>
            <div class="closeBlk"><a class="saveBtn" id="${saveBtnID}">Save</a><a class="cancelBtn" id="cancelDerivedFlds">Cancel</a></div>
    </div>
        <script type=text/javascript>
            $("#derivedField1,#derivedField2,#derivedField3").multipleSelect({
                selectAll:false,
                width:200,
                filter:true,
                placeholder:'Choose'
            });
            $("#derivedField1,#derivedField2,#derivedField3").multipleSelect("disable");
        </script>
	<div class="cutomizeFieldsPop_Container">
        <div class="cutomizeFieldsPop">
        <h2 class="cutomizeFieldsPop--header">Customize Field</h2>
            <div class="customLst">
                <ul class="custHead">
                    <li>Parameter Name</li>
                    <li>Display Name</li>
                    <li>Is Visible</li>
				<li>Mandatory</li>
                </ul>
                <ul class="lstView">
                    <li>Location</li>
				<li><input type="text" value="Location"></li>
				<li class="checkFld"><input type="checkbox" id="isVisible"><label for="isVisible" class="radio"><span><span></span></span></label></li>
				<li class="checkFld"><input type="checkbox" id="isMandatory"><label for="isMandatory" class="radio"><span><span></span></span></label></li>
                </ul>
                <ul class="lstView">
                    <li>Department</li>
				<li><input type="text" value="Department"></li>
				<li class="checkFld"><input type="checkbox" id="isVisible"><label for="isVisible" class="radio"><span><span></span></span></label></li>
				<li class="checkFld"><input type="checkbox" id="isMandatory"><label for="isMandatory" class="radio"><span><span></span></span></label></li>
                </ul>
                <ul class="lstView">
                    <li>Filter By</li>
				<li><input type="text" value="Filter By"></li>
				<li class="checkFld"><input type="checkbox" id="isVisible"><label for="isVisible" class="radio"><span><span></span></span></label></li>
				<li class="checkFld"><input type="checkbox" id="isMandatory"><label for="isMandatory" class="radio"><span><span></span></span></label></li>
                </ul>
                <ul class="lstView">
                    <li>Role</li>
				<li><input type="text" value="Role"></li>
				<li class="checkFld"><input type="checkbox" id="isVisible"><label for="isVisible" class="radio"><span><span></span></span></label></li>
				<li class="checkFld"><input type="checkbox" id="isMandatory"><label for="isMandatory" class="radio"><span><span></span></span></label></li>
                </ul>
                <ul class="lstView">
				<li>Specializations</li>
				<li><input type="text" value="Specializations"></li>
				<li class="checkFld"><input type="checkbox" id="isVisible"><label for="isVisible" class="radio"><span><span></span></span></label></li>
				<li class="checkFld"><input type="checkbox" id="isMandatory"><label for="isMandatory" class="radio"><span><span></span></span></label></li>
                </ul>
			<ul class="lstView">
				<li>WorkGroup Filter</li>
				<li><input type="text" value="Work Group"></li>
				<li class="checkFld"><input type="checkbox" id="isVisible"><label for="isVisible" class="radio"><span><span></span></span></label></li>
				<li class="checkFld"><input type="checkbox" id="isMandatory"><label for="isMandatory" class="radio"><span><span></span></span></label></li>
			</ul>
			<ul class="lstView">
				<li>User ID</li>
				<li><input type="text" value="Select User"></li>
			</ul>
			<ul class="lstView oddColumnDetails">
				<li>Consider for functional escalation</li>
				<li class="checkFld"><input type="checkbox" id="functionalEscalation"><label for="functionalEscalation" class="radio"><span><span></span></span></label></li>				
				<li>Allow Escalation to Management</li>
				<li class="checkFld"><input type="checkbox" id="allowEscalation"><label for="allowEscalation" class="radio"><span><span></span></span></label></li>
			</ul>
			<ul class="lstView">
				<li>Roles to display in filter</li>
				<li><select id="userRoles">
						<option value="0" selected="">All</option>
						<option value="1">3rd Party</option>
                         <option value="4">L2 Team</option>
					</select>
					<script type="text/javascript">
						$("#userRoles").multipleSelect({
							selectAll:false,
							filter:true,
							width:170
						})
					</script>
				</li>
			</ul>
			<ul class="lstView">
				<li>Default FilterBy</li>
				<li><select id="userFilter">
						<option value="All">All Technicians</option>
                        <option value="1">Available Technicians</option>
					</select>
					<script type="text/javascript">
						$("#userFilter").multipleSelect({
							selectAll:false,
							filter:true,
							width:170
						})
					</script>
				</li>
			</ul>
			<!--Multi Approval-->
				<ul class="lstView">
				<li>Comment</li>
				<li><input type="text" value="Comment"></li>
				<li class="checkFld"><input type="checkbox" id="isVisible"><label for="isVisible" class="radio"><span><span></span></span></label></li>
				<li class="checkFld"><input type="checkbox" id="isMandatory"><label for="isMandatory" class="radio"><span><span></span></span></label></li>
			</ul>
				<ul class="lstView oddColumnDetails applyInnerFlex">
				<li>Approval Type</li>
				<li class="checkFld"><input type="radio" id="Sequential" name=apprType><label for="Sequential" class="radio"><span><span></span></span></label>Sequential</li>
				<li class="checkFld"><input type="radio" id="Parallel"  name=apprType><label for="Parallel" class="radio"><span><span></span></span></label>Parallel</li>
			</ul>
			<ul class="lstView">
				<li class="applyInlineBlock">No of Approvals <span class="red">*</span></li>
				<li><input type="text" value=""></li>
				<li>Override at State Transition</li>
				<li class="checkFld"><input type="checkbox" id="Override"><label for="Override" class="radio"><span><span></span></span></label></li>
			</ul>
			<ul class="approvalListBlock">
				<li>
					<h3 class="approvalNumber">Approval Manager 1</h3>
					<div class="formFieldBlk">
					<div class=formElem>
						<label>Role</label>
						<select id="appManager1Role">
							<option value="All">All Technicians</option>
							<option value="1">Available Technicians</option>
						</select>
						<script type="text/javascript">
							$("#appManager1Role").multipleSelect({
								selectAll:false,
								filter:true,
								width:170
							})
						</script>
</div>
					<div class=formElem>
						<label>Users</label>
						<select id="appManager1User">
							<option value="1">Administrator</option>
						</select>
						<script type="text/javascript">
							$("#appManager1User").multipleSelect({
								selectAll:false,
								filter:true,
								width:170
							})
						</script>
					</div>
					<div class=formElem>
						<label>Caption</label>
						<input type="text" value="">
					</div>
					<div class=formElem>
						<label>Approval Label</label>
						<input type="text" value="">
					</div>
					<div class=formElem>
						<label>Reject Label</label>
						<input type="text" value="">
					</div>
					<div class="formElem checkFld">
						<label>Is Editable</label>
						<input type="checkbox" id="isEditable"><label for="isEditable" class="radio"><span><span></span></span></label>
					</div>
					</div>
				</li>
			</ul>
			<ul class="lstView">
				<li class="applyInlineBlock">Minimum Approvals<span class="red">*</span></li>
				<li><input type="text" value=""></li>
				<li class="applyInlineBlock">Minimum Rejections<span class="red">*</span></li>
				<li><input type="text" value=""></li>
			</ul>
			<ul class="lstView">
				<li class="applyInlineBlock">On Approval<span class="red">*</span></li>
				<li><select id="onApproval">
						<option value="2">Assign</option>
<option value="3">Assign to L2</option>
<option value="4">Assign to onsite</option>
<option value="5">Assign to TM</option>
<option value="6">Cancel</option>
<option value="8">Categorise</option>
<option value="7">Close</option>

					</select>
					<script type="text/javascript">
						$("#onApproval").multipleSelect({
							selectAll:false,
							filter:true,
							width:170
						})
					</script>
				</li>
				<li class="applyInlineBlock">On Reject<span class="red">*</span></li>
				<li><select id="onReject">
						<option value="2">Assign</option>
<option value="3">Assign to L2</option>
<option value="4">Assign to onsite</option>
<option value="5">Assign to TM</option>
<option value="6">Cancel</option>
<option value="8">Categorise</option>
<option value="7">Close</option>
					</select>
					<script type="text/javascript">
						$("#onReject").multipleSelect({
							selectAll:false,
							filter:true,
							width:170
						})
					</script>
				</li>
			</ul>
			<div class="allocateStateBlock">
			<h3 class="expForm ">Automatic State Change</h3>
			<ul class="lstView">
				<li>On Approval</li>
				<li class="checkFld"><input type="checkbox" id="onApproved"><label for="onApproved" class="radio"><span><span></span></span></label></li>
				<li>Move to State</li>
				<li><select id="moveToStateOnApprove">
						<option value="2">Assign</option>
<option value="3">Assign to L2</option>
<option value="4">Assign to onsite</option>
<option value="5">Assign to TM</option>
<option value="6">Cancel</option>
<option value="8">Categorise</option>
<option value="7">Close</option>                                                          
					</select>
					<script type="text/javascript">
						$("#moveToStateOnApprove").multipleSelect({
							selectAll:false,
							filter:true,
							width:170
						})
					</script>
				</li>
				</ul>
				<ul class="lstView">
				<li>On Reject</li>
				<li class="checkFld"><input type="checkbox" id="onRejected"><label for="onApproved" class="radio"><span><span></span></span></label></li>
				<li>Move to State</li>
				<li><select id="moveToStateOnReject">
						<option value="2">Assign</option>
<option value="3">Assign to L2</option>
<option value="4">Assign to onsite</option>
<option value="5">Assign to TM</option>
<option value="6">Cancel</option>
<option value="8">Categorise</option>
<option value="7">Close</option>                                                          
					</select>
					<script type="text/javascript">
						$("#moveToStateOnReject").multipleSelect({
							selectAll:false,
							filter:true,
							width:170
						})
					</script>
				</li>
				</ul>
</div>
				<ul class="lstView oddColumnDetails">
				<li>Consider for functional escalation</li>
				<li class="checkFld"><input type="checkbox" id="functionalEscalation1"><label for="functionalEscalation1" class="radio"><span><span></span></span></label></li>				
				<li>Allow Escalation to Management</li>
				<li class="checkFld"><input type="checkbox" id="allowEscalation1"><label for="allowEscalation1" class="radio"><span><span></span></span></label></li>
			</ul>
			<ul class="lstView oddColumnDetails">
				<li>Allow Cancel Record</li>
				<li class="checkFld"><input type="checkbox" id="allowCancel"><label for="allowCancel" class="radio"><span><span></span></span></label></li>				
				<li>Allow Attachments in Email Communications</li>
				<li class="checkFld"><input type="checkbox" id="allowAttach"><label for="allowAttach" class="radio"><span><span></span></span></label></li>
			</ul>
			<ul class="lstView oddColumnDetails">
				<li>Allow Child Record Submission</li>
				<li class="checkFld"><input type="checkbox" id="allowChildRecord"><label for="allowChildRecord" class="radio"><span><span></span></span></label></li>				
				<li>Allow Enclosure Template</li>
				<li class="checkFld"><input type="checkbox" id="allowEnclosureTemp"><label for="allowEnclosureTemp" class="radio"><span><span></span></span></label></li>
			</ul>
			<!--Multi Approval-->
            </div>
		<div class="closeBlk"><a class="">Save</a><a class="cancelBtn">Cancel</a></div>
        </div>
    </div>
</div>
</div>
<c:if test="${moduleId eq 1}">
    <div class="scrollableContainer ps-container" style="display: none;">
        <div class="inheritFromDiv">
            <form name="roleForm" id="roleForm" method="post">
                <h2>Inherit From </h2>
                <div id="rolesPopUpcontainer">
                    <div class="content">
                        <div id="inheritRole" class="ctrlGroup">
                            <div><span class="rolesFormText">Inherit From<font color="red">*</font></span></div>
                            <select id="InheritRoleSelectBox" name="InheritRoleSelectBox" class="gen">
                                <option value="0" >--------choose----------</option>
                            </select>
                        </div>
                        <div id="copyRole" class="ctrlGroup marginB10">
                            <div><span class="rolesFormText">Copy From</span></div>
                            <select id="copyRoleSelectBox" name="copyRoleSelectBox" class="gen">
                                <option value="0" >--------choose----------</option>
                            </select>
                        </div>
                        <input type="hidden" name="copyRoleID" id="copyRoleID" value="0"/>
                        <div id="accessControlDiv" class="accessDisplayFlag">
                            <div><span class="rolesFormText">Access&nbsp;Permissions</span></div>
                            <div class="divWrap">
                                <div id="allRequestTd" class="isTechFlag"><span id="allRequestsDiv" class="isTechFlag"><input class="mcopy" type="checkbox" id="viewAllRequests" name="access" value="1"/><label class="customRadCheck" for="viewAllRequests"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="View&nbsp;All&nbsp;Records">&nbsp;View&nbsp;All&nbsp;Records</span></span></div>
                                <div id="changeWorkGroupTd" class="workGroupFlag"><span id="changeWorkGroupDiv" class="workGroupFlag"><input class="mcopy" type="checkbox" id="changeWorkGroup" name="access" value="2"/><label class="customRadCheck" for="changeWorkGroup"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Change&nbsp;Work&nbsp;Group">&nbsp;Change&nbsp;Work&nbsp;Group</span></span></div>
                                <div id="changeOwnerTd" class="isTechFlag"><span id="changeOwnerDiv" class="isTechFlag"><input class="mcopy" type="checkbox" id="changeOwner" name="access" value="3"/><label class="customRadCheck" for="changeOwner"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Change&nbsp;Owner">&nbsp;Change&nbsp;Owner</span></span></div>
                                <div id="changeAppManagerTd" class="isAppFlag"><span id="changeAppManagerDiv" class="isAppFlag"><input class="mcopy" type="checkbox" id="changeAppManager" name="access" value="4"/><label class="customRadCheck" for="changeAppManager"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Change&nbsp;Approval&nbsp;Manager">&nbsp;Change&nbsp;Approval&nbsp;Manager</span></span></div>
                                <div id="HierarchalEscTd" class="HierarchicalFlag"><span id="HierarchalEscDiv" class="HierarchicalFlag"><input class="mcopy" type="checkbox" id="HierarchalEsc" name="access" value="11"/><label class="customRadCheck" for="HierarchalEsc"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Hierarchical&nbsp;Escalation">&nbsp;Hierarchical&nbsp;Escalation</span></span></div>
                                <div><span id="archivedRequestsDiv"><input class="mcopy" type="checkbox" id="archivedRequests" name="access" value="10" /><label class="customRadCheck" for="archivedRequests"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Archived&nbsp;Records">&nbsp;Archived&nbsp;Records</span> </span></div>
                                <div><span id="requestSubmissionDiv" ><input class="mcopy" type="checkbox" id="requestSubmission" name="access" value="9" class="checkSubmissionAccess"/><label class="customRadCheck" for="requestSubmission"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Record&nbsp;Submission">&nbsp;Record&nbsp;Submission</span></span></div>
                                <div id="deleteAttachmentVisibilityTd" class="deleteAttachmentVisibility"><span id="deleteAttachmentDiv"><input class="mcopy" type="checkbox" id="deleteAttachment" name="access" value="12" class="checkDeleteAttachmentAccess"/><label class="customRadCheck" for="deleteAttachment"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Delete&nbsp;Attachment">&nbsp;Delete&nbsp;Attachment</span></span></div>
                                <div id="submitterTd" class="isSubmitterFlag"><span id="submitterDiv" class="isSubmitterFlag"><input class="mcopy" type="checkbox" id="changeSource" name="access" value="5" onclick="checkForbehalfOf()"/><label class="customRadCheck" for="changeSource"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Change&nbsp;Source">&nbsp;Change&nbsp;Source</span></span></div>
                                <div id="cancelRecordDiv"><span><input class="mcopy" type="checkbox" id="cancelRecord" name="access" value="17" class="checkCancelRecord"/><label class="customRadCheck" for="cancelRecord"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Cancel&nbsp;Record">&nbsp;Cancel&nbsp;Record</span></span></div>
                                <div id="slaViolatedRequestAccessTd" class="slaViolatedRequestAccess"><span><input class="mcopy" type="checkbox" id="slaViolatedRequestAccess" name="access"  value="18" class="slaViolatedRequestAccess"/><label class="customRadCheck" for="slaViolatedRequestAccess"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="View&nbsp;All&nbsp;SLA&nbsp;Violated&nbsp;Records">View&nbsp;All&nbsp;SLA&nbsp;Violated&nbsp;Records</span></span></div>
                                <div id="editEnclosureTd" class="isEditEnclosureFlag"> <span id="editEnclosureDiv" class="isEditEnclosureFalg"><input class="mcopy" type="checkbox" id="editEnclosureComment" name="access"  value="19" /><label class="customRadCheck" for="editEnclosureComment"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Edit&nbsp;Enclosure&nbsp;Comment">&nbsp;Edit&nbsp;Enclosure&nbsp;Comment</span></span></div>
                                <div id="copyRecordTd" class="isCopyRecordFlag"><span id="copyRecordDiv" class="isCopyRecordFlag"><input class="mcopy" type="checkbox" id="copyRecord" name="access"  value="20" class="checkCopyRecord"/><label class="customRadCheck" for="copyRecord"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Copy&nbsp;Record">&nbsp;Copy&nbsp;Record</span></span></div>
                                <div><span id="other_CIDiv"><input class="mcopy" type="checkbox" id="other_CI" name="access" value="21" class="checkOtherAccess"/><label class="customRadCheck" for="other_CI"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Show Other (CI)">&nbsp;Show Other (CI)</span></span></div>
                                <div><span id="sendMailDiv"><input class="mcopy" type="checkbox" id="sendMail" name="access" value="22" class="checkSendMail" /><label class="customRadCheck" for="sendMail"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Send Mail">&nbsp;Send Mail</span></span></div>
                                <div><span id="bulkStateTransitionDiv"><input class="mcopy" type="checkbox" id="bulkStateTransition" name="access" value="23" class="checkBulkStateTransition"/><label class="customRadCheck" for="bulkStateTransition"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Bulk State Transition">&nbsp;Bulk State Transition</span></span></div>
                                <div id="readOnlyDiv"><span><input class="mcopy" type="checkbox" id="readOnly" name="access" value="24" class="checkReadOnly"/><label class="customRadCheck" for="readOnly"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Read&nbsp;Only&nbsp;(Records)">&nbsp;Read&nbsp;Only&nbsp;(Records)</span></span></div>
                                <div id="escalateDiv"><span id="escalateToMgmtDiv"><input class="mcopy" type="checkbox" id="escalateToMgmt" name="access" value="25"/><label class="customRadCheck" for="escalateToMgmt"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Escalate&nbsp;To&nbsp;Management">&nbsp;Escalate&nbsp;To&nbsp;Management</span></span></div>
                                <div id="signInOutTd"><span id="signInOutDiv" ><input class="mcopy" type="checkbox" id="signInOut" name="access"  value="26" class="checkSignInOut"/><label class="customRadCheck" for="signInOut"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="SignIn & SignOut"> SignIn & SignOut</span></span></div>
                                <div id="calendarTabTd" class="calendarFlag"><span id="calendarTabDiv"  ><input class="mcopy" type="checkbox" id="calendar" name="access"  value="27" class="checkCalendar" onclick="checkCalendar();"/><label class="customRadCheck" for="calendar"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Calendar"> Calendar</span></span></div>
                                <div id="technicianTabTd" class="technicianChartFlag"><span id="technicianTabDiv"  ><input class="mcopy" type="checkbox" id="technicianChart" name="access"  value="28" class="checkTechnicianChart"/><label class="customRadCheck" for="technicianChart"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Technician Availability Chart"> Technician Availability Chart</span></span></div>
                                <div id="technicianAccessControlTabTd" class="enclosureAccessControl"><span id="technicianTabDiv"  ><input class="mcopy" type="checkbox" id="enclosureAccessControl" name="access"  value="32" class="checkTechnicianChart"/><label class="customRadCheck" for="enclosureAccessControl"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Enclosure Access Control"> Enclosure Access Control</span></span></div>
                                <div id="ameyoTd" class="ameYoToolbarFlag"><span id="ameyoToolDiv"><input class="mcopy" type="checkbox" id="ameyoTool" name="access" value="29" class="checkAmeYoToolbar"/><label class="customRadCheck" for="ameyoTool"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Ameyo&nbsp;Toolbar&nbsp;Access">&nbsp;Ameyo&nbsp;Toolbar&nbsp;Access</span></span></div>
                                <div id="locationAccessTd" class="locationAccessFlag"><span id="locationAccessDiv"  ><input class="mcopy" type="checkbox" id="locationAccess" name="access"  value="30" class="checkLocationAccess"/><label class="customRadCheck" for="locationAccess"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Access Based on Location(KB)"> Access Based on Location(KB)</span></span></div>
                                <div id="departmentAccessTd" class="departmentAccessFlag"><span id="departmentAccessDiv"  ><input class="mcopy" type="checkbox" id="departmentAccess" name="access"  value="31" class="checkDepartmentAccess"/><label class="customRadCheck" for="departmentAccess"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Access Based on Department(KB)"> Access Based on Department(KB)</span></span></div>
                            </div>
                        </div>
                        <div id="behalfOfDiv" class="behalfOfDiv">
                            <div class="margin10"><span class="rolesFormText">On Behalf Submission Filter</span></div>
                            <div class="divWrap">
                                <div><span><input class="mcopy" type="checkbox" id="allUsers" name="access" value="6"  onclick="checkforAllUsersSelection()"/><label class="customRadCheck" for="allUsers"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="All&nbsp;Users">&nbsp;&nbsp;All&nbsp;Users</span></span></div>
                                <div><span><input class="mcopy" type="checkbox" id="usersLocation" name="access" value="7"  onclick="checkforAllUsersSelection()"/><label class="customRadCheck" for="usersLocation"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Users&nbsp;Location">&nbsp;&nbsp;Users&nbsp;Location</span></span></div>
                                <div><span><input class="mcopy" type="checkbox" id="usersDepartment" name="access" value="8" onclick="checkforAllUsersSelection()"/><label class="customRadCheck" for="usersDepartment"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Users&nbsp;Department">&nbsp;Users&nbsp;Department</span></span></div>
                                <div><span><input class="mcopy" type="checkbox" id="createNewUserVis" name="access" value="33" /><label class="customRadCheck" for="createNewUserVis"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Create&nbsp;New&nbsp;User">&nbsp;Create&nbsp;New&nbsp;User</span></span></div>
                            </div>
                        </div>
                        <div id="reportsAccess" class="reportsAccess">
                            <div class="margin10"><span class="rolesFormText">Reports Access</span></div>
                            <div class="divWrap">
                                <div><span><input class="mcopy" type="checkbox" id="inbuiltReports" name="access"  value="13"/><label class="customRadCheck" for="inbuiltReports"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Inbuilt&nbsp;Reports">&nbsp;Inbuilt&nbsp;Reports</span></span></div>
                                <div><span><input class="mcopy" type="checkbox" id="customReports" name="access"  value="15" onclick="customReportsAddAccess()"/><label class="customRadCheck" for="customReports"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Custom&nbsp;Reports">&nbsp;Custom&nbsp;Reports</span></span></div>
                                <div><span><input class="mcopy" type="checkbox" id="scheduleReports" name="access"  value="14" onclick="scheduleReportsAccess()"/><label class="customRadCheck" for="scheduleReports"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Schedule&nbsp;Reports">&nbsp;Schedule&nbsp;Reports</span></span></div>
                                <div><span id="customReportsAddTd" class="customReportsAdd"><input class="mcopy" type="checkbox" id="customReportsAdd" name="access"  value="16"/><label class="customRadCheck" for="customReportsAdd"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Custom&nbsp;Reports&nbsp;Add">&nbsp;Custom&nbsp;Reports&nbsp;Add</span></span></div>
                            </div>
                        </div>
                        <div id="calenderAccess" class="calenderTr">
                            <div class="margin10"><span class="rolesFormText">Calendar Access</span></div>
                            <div class="divWrap">
                                <div id="SLATd" class="sLATd"><input class="mcopy" type="checkbox" id="SLA" name="access"  value="34"/><label class="customRadCheck" for="SLA"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="SLA">&nbsp;SLA</span></div>
                                <div><input class="mcopy" type="checkbox" id="survey" name="access"  value="35"/><label class="customRadCheck" for="survey"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Survey">&nbsp;Survey</span></div>
                                <div><input class="mcopy" type="checkbox" id="reminder" name="access"  value="36"/><label class="customRadCheck" for="reminder"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Reminder">&nbsp;Reminder</span></div>
                                <div><span><input class="mcopy" type="checkbox" id="events" name="access"  value="37"/><label class="customRadCheck" for="events"><span class="marginB0"><span></span></span></label><span class="labelcontent" title="Events">&nbsp;Events</span></span></div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="closeBlk"><a class="saveDelegation" id="saveInheritForm">Save</a><a class="cancelDes">Cancel</a></div>
                <script type="text/javascript">
                    $("#copyRoleSelectBox, #InheritRoleSelectBox").multipleSelect({
                        single: true,
                        filter: false,
                        width:350
                    });
                </script>
            </form>
        </div>
    </div>
    <script type="text/javascript">
        $(".scrollableContainer").perfectScrollbar("refresh");
    </script>
</c:if>
<div id="templatesDiv"></div>
</div>


<div class="gridViewPort gridViewPort--auditLog">
    <header class="gridViewPort_header"><h2>Audit Log</h2></header>
    <a href="javascript:void(0)" onclick="switchtoListing()" class="backBtn">Back</a>
    <select class="demo singlePag recordLimit" id="logRecordLimit${moduleId}" name="logRecordLimit${moduleId}" onchange="changeAuditPagination('${projectId}','${moduleId}')">
        <c:forEach begin="10" end="100" step="10" varStatus="loop">
            <option value="${loop.index}">${loop.index}</option>
        </c:forEach>
    </select>
    <script type="text/javascript">
        $("#logRecordLimit${moduleId}").multipleSelect({
            single: true,
            filter: false,
            width:70
        });
        setSdGridPaginationCount(${NEWUI_PAGINATION_COUNT},"logRecordLimit${moduleId}[name='logRecordLimit${moduleId}']");
    </script>
    <div id="auditLogListingGrid"></div>
    <div id="readMoreAuditBlk" class="readMoreAuditBlk"><div class="loadedData"></div></div>
    <div id="auditLogListingGridPager" class="pager"></div>
    <div class="rightPagn">
        <div class="downoadOpt"><a href="javascript:void(0);"><img src="assets/images/excel.png" onclick="downloadAuditLogExcelReport('${projectId}','${moduleId}')"><span class="hovOver"><i></i>Export as Excel</span></a></div>
        <div class="dispRecords"><p id="slickGridRecordInfo2">No record(s) to display</p></div>
    </div>
</div>
<c:if test="${moduleId eq 2}">
<div class="gridViewPort gridViewPort--licenUserList">
    <header class="gridViewPort_header"><h2>Technician(s) License</h2></header>
    <a href="javascript:void(0)" onclick="backToUsersListing('${projectId}','${moduleId}')" class="backBtn">Back</a>
    <select class="demo singlePag" id="licenUserListLimit" name="licenUserListLimit" onchange="changeLicenseUserPagination('${projectId}','${moduleId}')">
        <c:forEach begin="10" end="100" step="10" varStatus="loop">
            <option value="${loop.index}">${loop.index}</option>
        </c:forEach>
    </select>
    <script type="text/javascript">
        $("#licenUserListLimit").multipleSelect({
            single: true,
            filter: false,
            width:70
        });
        setSdGridPaginationCount(${NEWUI_PAGINATION_COUNT},"licenUserListLimit");
    </script>
    <div id="licenUserListingGrid"></div>
    <div id="licenUserListingGridPager" class="pager"></div>
    <div class="rightPagn">
        <div class="downoadOpt"><a href="javascript:void(0);"><img src="assets/images/excel.png" onclick="downloadExcelReport('${projectId}','0')"><span class="hovOver"><i></i>Export as Excel</span></a></div>
        <div class="dispRecords"><p id="slickGridRecordInfo2">No record(s) to display</p></div>
</div>
</div>
</c:if>
<c:if test="${moduleId eq 10}">
<div class="workFlowViewerBlock"  style="display: none;">
    <header class="workFlowViewerBlock_header"><h2>WorkFlow Viewer</h2></header>
    <a href="javascript:void(0)" onclick="backToListing()" class="backBtn">Back</a>
 <div class="flowChartBlk" id="WorkFlowViewChartBlk">
	<svg width="1024" height=300 id="workFlow"><g id="workFlow"><g/></svg>								
</div>
</div>
</c:if>
<c:if test="${moduleId eq 7}">
<div class="gridViewPort gridViewPort--derivedFieldConfiguration" id="DerivedFieldGridBlock">
    <header class="gridViewPort_header"><c:if test="${moduleId eq 7}">
		<div class="headerTab">
			<ul class="headerTab--ul">
                <li onclick="backToListing()">
					<a href="javascript:void(0)">Sub Category</a>
				</li>
				<li onclick="loadDerivedFieldGrid(1)" id="derivedFieldTab1">
					<a href="javascript:void(0)">Derived Field 1</a>
				</li>
				<li onclick="loadDerivedFieldGrid(2)" id="derivedFieldTab2">
					<a href="javascript:void(0)">Derived Field 2</a>
				</li>
				<li onclick="loadDerivedFieldGrid(3)" id="derivedFieldTab3">
					<a href="javascript:void(0)">Derived Field 3</a>
				</li>
            </ul>
		</div>
		</c:if></header>
	<div class="gridActionLeftBlk"  style="width:calc(100% - 80px);margin: 10px 0">
	    <a href="javascript:void(0)"  onclick=addNewList("derivedFieldListingGrid") class="newRowIco" id="newGridRowAdd"><img src="assets/images/add_row.png" alt=""><span>Add</span></a>
        <!--<a class="deleteRowIco" id="deleteRowIco" data-moduleId="${moduleId}" data-projectId="${projectId}"><img src="assets/images/delete_row.png" alt=""><span>Delete</span></a>-->
         <a href="javascript:void(0)" class="activateRow" id="activateDerivedFldRow"><span>Activate</span></a>
         <a href="javascript:void(0)"  class="activateRow deactive" id="deactivateDerivedDlfRow"><span>Deactivate</span></a>
	 </div>
    <select class="demo singlePag" id="derivedFldListLimit" name="derivedFldListLimit" onchange="changeDerivedFieldsPagination('${projectId}')">
        <c:forEach begin="10" end="100" step="10" varStatus="loop">
            <option value="${loop.index}">${loop.index}</option>
        </c:forEach>
    </select>
    <script type="text/javascript">
        function downloadExcelReportWithType(projectId,type) {
            var derivedFieldType = document.querySelector('#DerivedFieldGridBlock .headerTab--ul li.selected').id;
            if (derivedFieldType == "derivedFieldTab1") {
                type = 1;
            } else if (derivedFieldType == "derivedFieldTab2") {
                type = 2;
            } else {
                type = 3;
            }
            downloadExcelReportforDerivedFields(projectId, '0', type);
        }
        $("#derivedFldListLimit").multipleSelect({
            single: true,
            filter: false,
            width:70
        });
        setSdGridPaginationCount(${NEWUI_PAGINATION_COUNT},"derivedFldListLimit");
    </script>
    <div id="derivedFieldListingGrid"></div>
    <div id="derivedFieldListingGridPager" class="pager"></div>
    <div class="rightPagn">
        <div class="downoadOpt"><a href="javascript:void(0);"><img src="assets/images/excel.png" onclick="downloadExcelReportWithType('${projectId}','0')"><span class="hovOver"><i></i>Export as Excel</span></a></div>
        <div class="dispRecords"><p id="slickGridRecordInfo2">No record(s) to display</p></div>
</div>
</div>
</c:if>
<input type="hidden" id="projectId" name="projectId" value="${projectId}"/>
<input type="hidden" id="moduleId" name="moduleId" value="${moduleId}"/>
<input type="hidden" id="servicedeskcommentsize" name="servicedeskcommentsize" value="${servicedeskcommentsize}"/>
<input type="hidden" id="lastCreatedRoleRef" value="">
<input type="hidden" id="lastCreatedRoleNameRef" value="">
<div class="loadIco" id="loading"></div>
</body>
</html>